//
//  RTCBeautyFacePanelView.m
//  MinVideo
//
//  Created by gaobo01 on 2019/7/25.
//  Copyright © 2019 Baidu. All rights reserved.
//

#import "RTCBeautyFacePanelView.h"
#import "UIView+BBAUtility.h"
//#import "UIColor+BDHKUtil.h"
#import "UIColor+RtcCategory.h"
#import "RTCSettingsModel.h"

//#import "Masonry.h"

static NSString *kBgSegCaseName = @"case_bgseg";
static NSString *kBgBlurCaseName = @"case_bgblur";

@interface BDMVBeautyFacePanelView ()

@property(nonatomic, strong) UILabel *titleText;
@property(nonatomic, strong) CALayer *gradientLayer;

@property(nonatomic, strong) UILabel  *whiteText;       //美白
@property(nonatomic, strong) UISlider *whiteSlider;
@property(nonatomic, strong) UILabel  *whiteTextLevel;

@property(nonatomic, strong) UILabel  *blurText;        //磨皮
@property(nonatomic, strong) UISlider *blurSlider;
@property(nonatomic, strong) UILabel  *blurTextLevel;

@property(nonatomic, strong) UILabel  *bigEyeText;        //大眼
@property(nonatomic, strong) UISlider *bigEyeSlider;
@property(nonatomic, strong) UILabel  *bigEyeTextLevel;

@property(nonatomic, strong) UILabel  *thinFaceText;        //瘦脸
@property(nonatomic, strong) UISlider *thinFaceSlider;
@property(nonatomic, strong) UILabel  *thinFaceTextLevel;

@property(nonatomic, strong) UILabel *closeLabel;           //关闭
@property(nonatomic, strong) UISwitch *closeSwitch;
@property (nonatomic, assign) CGRect rectScroll;

@property (nonatomic, strong) UILabel *bgLabel;           // 背景
@property (nonatomic, strong) UISegmentedControl *bgSegmentControl;           // 背景

@end

@implementation BDMVBeautyFacePanelView

- (instancetype)initWithFrame:(CGRect)frame delegate:(id<BDMVBeautyFacePanelViewDelegate>)delegate {
    self = [super initWithFrame:frame];
    if (self) {
        [self buildUI];
        _delegate = delegate;
    }
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    CGFloat scrollViewW = self.frame.size.width;
    CGFloat scrollViewH = self.frame.size.height;
    CGFloat heightField       = scrollViewH/6;
    //title
    self.titleText.frame      = CGRectMake(scrollViewW/4, 5,scrollViewW/6 , heightField);
    self.closeLabel.frame     = CGRectMake(scrollViewW*5/9, 5 ,scrollViewW/8 , heightField);
    self.closeSwitch.frame    = CGRectMake(scrollViewW*3/4, 10 ,scrollViewW/8 , heightField);
    //美白
    self.whiteText.frame      = CGRectMake(10, heightField,scrollViewW/8 , heightField);
    self.whiteSlider.frame    = CGRectMake(scrollViewW/8+10 , heightField,scrollViewW*3/4-40 , heightField);
    self.whiteTextLevel.frame = CGRectMake(scrollViewW*7/8-20, heightField,scrollViewW/8 + 10 , heightField);
    //磨皮
    self.blurText.frame      = CGRectMake(10, heightField*2,scrollViewW/8 , heightField);
    self.blurSlider.frame    = CGRectMake(scrollViewW/8+10 , heightField*2,scrollViewW*3/4-40 , heightField);
    self.blurTextLevel.frame = CGRectMake(scrollViewW*7/8-20, heightField*2,scrollViewW/8 + 10 , heightField);
    //大眼
    self.bigEyeText.frame      = CGRectMake(10, heightField*3,scrollViewW/8 , heightField);
    self.bigEyeSlider.frame    = CGRectMake(scrollViewW/8+10 , heightField*3,scrollViewW*3/4-40 , heightField);
    self.bigEyeTextLevel.frame = CGRectMake(scrollViewW*7/8-20, heightField*3,scrollViewW/8 + 10 , heightField);
    //瘦脸
    self.thinFaceText.frame      = CGRectMake(10, heightField*4,scrollViewW/8 , heightField);
    self.thinFaceSlider.frame    = CGRectMake(scrollViewW/8+10 , heightField*4,scrollViewW*3/4-40 , heightField);
    self.thinFaceTextLevel.frame = CGRectMake(scrollViewW*7/8-20, heightField*4,scrollViewW/8 +10 , heightField);
    
    // 背景
    self.bgLabel.frame = CGRectMake(10, heightField*5, scrollViewW/7, heightField);
    self.bgSegmentControl.frame = CGRectMake(scrollViewW/8+20, heightField*5+5, scrollViewW-scrollViewW/8-30, heightField-10);
}

- (void)setHidden:(BOOL)hidden {
    BOOL changeFromHide = self.hidden && !hidden;
    [super setHidden:hidden];
    if (changeFromHide) {
        self.closeSwitch.on = [[RTCSettingsModel sharedInstance] currentVideoBeautyFromStore];
        [self callbackBeautyEnabled:self.closeSwitch.isOn];
        [self updateCloseLabel:self.closeSwitch.isOn];
    }
}

- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)buildUI {
    self.backgroundColor = [UIColor colorWithWhite:0.2 alpha:0.5];
    // 面板设置左上角和右下角圆角模式
    UIBezierPath *cornerRadiusPath = [UIBezierPath bezierPathWithRoundedRect:self.bounds byRoundingCorners:UIRectCornerTopRight | UIRectCornerTopLeft cornerRadii:CGSizeMake(13, 13)];
    CAShapeLayer *cornerRadiusLayer = [ [CAShapeLayer alloc ] init];
    cornerRadiusLayer.frame = self.bounds;
    cornerRadiusLayer.path = cornerRadiusPath.CGPath;
    self.layer.mask = cornerRadiusLayer;
    
    // 背景
    self.bgLabel = [UILabel brtc_labelWithTitle:@"背景" color:[UIColor whiteColor] fontSize:16];
    [self addSubview:self.bgLabel];
    [self addSubview:self.bgSegmentControl];
}

- (void)callbackBeautyEnabled:(BOOL)enabled {
    dispatch_async(dispatch_get_main_queue(), ^{
        if ([self.delegate respondsToSelector:@selector(beautyPanelView:setBeautyEnabled:)]) {
            [self.delegate beautyPanelView:self setBeautyEnabled:enabled];
        }
    });
}

- (void)callbackBeautyOper:(RtcBeautyOperation)oper valueChanged:(float)value {
    dispatch_async(dispatch_get_main_queue(), ^{
        if ([self.delegate respondsToSelector:@selector(beautyPanelView:operValueChanged:oper:)]) {
            [self.delegate beautyPanelView:self operValueChanged:value oper:oper];
        }
    });
}

- (void)whiteSliderValueChanged:(id)sender {
    float newValue = self.whiteSlider.value;
    [self callbackBeautyOper:RTC_VIDEO_WHITE valueChanged:newValue];
    _whiteTextLevel.text = [NSString stringWithFormat:@"%0.0f%@",newValue *  100 ,@"%"];
}

- (void)blurSliderValueChanged:(id)sender {
    float newValue = self.blurSlider.value;
    [self callbackBeautyOper:RTC_VIDEO_BLUR valueChanged:newValue];
    _blurTextLevel.text = [NSString stringWithFormat:@"%0.0f %@",newValue * 100,@"%"];
}

- (void)bigEyeSliderValueChanged:(id)sender {
    float newValue = self.bigEyeSlider.value;
    [self callbackBeautyOper:RTC_VIDEO_BIGEYE valueChanged:newValue];
    _bigEyeTextLevel.text = [NSString stringWithFormat:@"%0.0f%@",newValue * 100,@"%"];
}

- (void)thinFaceSliderValueChanged:(id)sender {
    float newValue = self.thinFaceSlider.value;
    [self callbackBeautyOper:RTC_VIDEO_THINFACE valueChanged:newValue];
    _thinFaceTextLevel.text = [NSString stringWithFormat:@"%0.0f%@",newValue * 100,@"%"];
}
- (void)closeValueChanged:(id)sender {
    BOOL isOn = self.closeSwitch.isOn;
    [[RTCSettingsModel sharedInstance] storeVideoBeauty:isOn];
    [self callbackBeautyEnabled:isOn];
    [self updateCloseLabel:isOn];
}

- (void)updateCloseLabel:(BOOL)isOn {
    self.closeLabel.text = isOn ? @"开启" : @"关闭";
}

- (void)bgSegmentControlValueChanged:(UISegmentedControl *)sender {
    NSUInteger index = sender.selectedSegmentIndex;
    dispatch_async(dispatch_get_main_queue(), ^{
        NSString *caseName = nil;
        if (index == 1) caseName = kBgSegCaseName;
        else if (index == 2) caseName = kBgBlurCaseName;
        if ([self.delegate respondsToSelector:@selector(beautyPanelView:humanSegCaseSelected:)]) {
            [self.delegate beautyPanelView:self humanSegCaseSelected:caseName];
        }
    });
}

- (CALayer *)gradientLayer {
    if (!_gradientLayer) {
        CAGradientLayer *layer = [CAGradientLayer layer];
        layer.frame = CGRectMake(0, 0, self.width, 20);
        layer.colors = @[(id)[UIColor colorWithWhite:0 alpha:0.75].CGColor,
                         (id)[UIColor colorWithWhite:0 alpha:0].CGColor];
        [self.layer addSublayer:layer];
        _gradientLayer = layer;
    }
    return _gradientLayer;
}

- (UILabel *)titleText {
    if (!_titleText) {
        _titleText = [[UILabel alloc] initWithFrame:CGRectMake(0, 23, 50, 16)];
        _titleText.text = @"美颜";
        _titleText.font = [UIFont systemFontOfSize:16];
        _titleText.textColor = UIColor.whiteColor;
        _titleText.textAlignment = NSTextAlignmentCenter;
        [self addSubview:_titleText];
    }
    return _titleText;
}

-(UILabel *)whiteText {
    if (!_whiteText) {
        _whiteText = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 21)];
        _whiteText.text = @"美白";
        _whiteText.font = [UIFont systemFontOfSize:15];
        _whiteText.textColor = UIColor.whiteColor;
        [self addSubview:_whiteText];
    }
    return _whiteText;
}

- (UISlider *)whiteSlider {
    if (!_whiteSlider) {
        _whiteSlider = [[UISlider alloc] init];
        _whiteSlider.minimumValue = .0f;
        _whiteSlider.maximumValue = 1.f;
        _whiteSlider.value = .5f;
        [_whiteSlider addTarget:self action:@selector(whiteSliderValueChanged:) forControlEvents:UIControlEventValueChanged];
        [self addSubview:_whiteSlider];
    }
    return _whiteSlider;
}

- (UILabel *)whiteTextLevel {
    if (!_whiteTextLevel) {
        _whiteTextLevel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 60, 21)];
        _whiteTextLevel.text = @"50%";
        _whiteTextLevel.font = [UIFont systemFontOfSize:16];
        _whiteTextLevel.textColor = [UIColor colorWithHex:0x0083ff];
        _whiteTextLevel.textAlignment = NSTextAlignmentRight;
        [self addSubview:_whiteTextLevel];
    }
    return _whiteTextLevel;
}

-(UILabel *)blurText {
    if (!_blurText) {
        _blurText = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 21)];
        _blurText.text = @"磨皮";
        _blurText.font = [UIFont systemFontOfSize:15];
        _blurText.textColor = UIColor.whiteColor;
        [self addSubview:_blurText];
    }
    return _blurText;
}

- (UISlider *)blurSlider {
    if (!_blurSlider) {
        _blurSlider = [[UISlider alloc] init];
        _blurSlider.minimumValue = .0f;
        _blurSlider.maximumValue = 1.f;
        _blurSlider.value = .4f;
        [_blurSlider addTarget:self action:@selector(blurSliderValueChanged:) forControlEvents:UIControlEventValueChanged];
        [self addSubview:_blurSlider];
    }
    return _blurSlider;
}

- (UILabel *)blurTextLevel {
    if (!_blurTextLevel) {
        _blurTextLevel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 60, 21)];
        _blurTextLevel.text = @"40%";
        _blurTextLevel.font = [UIFont systemFontOfSize:16];
        _blurTextLevel.textColor = [UIColor colorWithHex:0x0083ff];
        _blurTextLevel.textAlignment = NSTextAlignmentRight;
        [self addSubview:_blurTextLevel];
    }
    return _blurTextLevel;
}

-(UILabel *)bigEyeText {
    if (!_bigEyeText) {
        _bigEyeText = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 21)];
        _bigEyeText.text = @"大眼";
        _bigEyeText.font = [UIFont systemFontOfSize:15];
        _bigEyeText.textColor = UIColor.whiteColor;
        [self addSubview:_bigEyeText];
    }
    return _bigEyeText;
}

- (UISlider *)bigEyeSlider {
    if (!_bigEyeSlider) {
        _bigEyeSlider = [[UISlider alloc] init];
        _bigEyeSlider.minimumValue = .0f;
        _bigEyeSlider.maximumValue = 1.f;
        _bigEyeSlider.value = .35f;
        [_bigEyeSlider addTarget:self action:@selector(bigEyeSliderValueChanged:) forControlEvents:UIControlEventValueChanged];
        [self addSubview:_bigEyeSlider];
    }
    return _bigEyeSlider;
}

- (UILabel *)bigEyeTextLevel {
    if (!_bigEyeTextLevel) {
        _bigEyeTextLevel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 60, 21)];
        _bigEyeTextLevel.text = @"35%";
        _bigEyeTextLevel.font = [UIFont systemFontOfSize:16];
        _bigEyeTextLevel.textColor = [UIColor colorWithHex:0x0083ff];
        _bigEyeTextLevel.textAlignment = NSTextAlignmentRight;
        [self addSubview:_bigEyeTextLevel];
    }
    return _bigEyeTextLevel;
}

-(UILabel *)thinFaceText {
    if (!_thinFaceText) {
        _thinFaceText = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 21)];
        _thinFaceText.text = @"瘦脸";
        _thinFaceText.font = [UIFont systemFontOfSize:15];
        _thinFaceText.textColor = UIColor.whiteColor;
        [self addSubview:_thinFaceText];
    }
    return _thinFaceText;
}

- (UISlider *)thinFaceSlider {
    if (!_thinFaceSlider) {
        _thinFaceSlider = [[UISlider alloc] init];
        _thinFaceSlider.minimumValue = .0f;
        _thinFaceSlider.maximumValue = 1.f;
        _thinFaceSlider.value = .6f;
        [_thinFaceSlider addTarget:self action:@selector(thinFaceSliderValueChanged:) forControlEvents:UIControlEventValueChanged];
        [self addSubview:_thinFaceSlider];
    }
    return _thinFaceSlider;
}

- (UILabel *)thinFaceTextLevel {
    if (!_thinFaceTextLevel) {
        _thinFaceTextLevel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 60, 21)];
        _thinFaceTextLevel.text = @"60%";
        _thinFaceTextLevel.font = [UIFont systemFontOfSize:16];
        _thinFaceTextLevel.textColor = [UIColor colorWithHex:0x0083ff];
        _thinFaceTextLevel.textAlignment = NSTextAlignmentRight;
        [self addSubview:_thinFaceTextLevel];
    }
    return _thinFaceTextLevel;
}

-(UILabel *)closeLabel {
    if (!_closeLabel) {
        _closeLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 21)];
        _closeLabel.text = @"关闭";
        _closeLabel.font = [UIFont systemFontOfSize:15];
        _closeLabel.textColor = [UIColor colorWithHex:0xA7A9AD];
        [self addSubview:_closeLabel];
    }
    return _closeLabel;
}

- (UISwitch *)closeSwitch {
    if (!_closeSwitch) {
        _closeSwitch = [[UISwitch alloc] initWithFrame:CGRectMake(0, 0, 35, 22)];
        
        [_closeSwitch addTarget:self action:@selector(closeValueChanged:) forControlEvents:UIControlEventValueChanged];
        [self addSubview:_closeSwitch];
    }
    return _closeSwitch;
}

- (UISegmentedControl *)bgSegmentControl {
    if (!_bgSegmentControl) {
        UIColor *blueColor = [UIColor systemBlueColor];
        NSDictionary *colorAttr = [NSDictionary dictionaryWithObject:blueColor forKey:NSForegroundColorAttributeName];
        _bgSegmentControl = [[UISegmentedControl alloc] initWithItems:@[ @"无特效", @"分割", @"模糊" ]];
        _bgSegmentControl.backgroundColor = [UIColor whiteColor];
        _bgSegmentControl.selectedSegmentIndex = 0;
        _bgSegmentControl.tintColor = blueColor;
        [_bgSegmentControl addTarget:self action:@selector(bgSegmentControlValueChanged:) forControlEvents:UIControlEventValueChanged];
        [_bgSegmentControl setTitleTextAttributes:colorAttr forState:UIControlStateNormal];
    }
    return _bgSegmentControl;
}

@end
