//
//  RTCBeautyFaceOperator.m
//  rtc_sdk_ios
//
//  Created by 曹士谦 on 2022/10/12.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCBeautyFaceOperator.h"

@interface RTCBeautyFaceOperator ()

@property (nonatomic, assign) BOOL beautyEnabled;
@property (nonatomic, copy) NSString *humanSegCaseName;
@property (nonatomic, strong) NSMutableDictionary<NSNumber *, NSNumber *> *featureValueDict;

@end

@implementation RTCBeautyFaceOperator

- (instancetype)initWithBeautyManager:(id<BaiduRtcBeautyManager>)beautyManager {
    if (self = [super init]) {
        _beautyManager = beautyManager;
    }
    return self;
}

- (void)restoreOperations {
    [self beautyPanelView:nil setBeautyEnabled:self.beautyEnabled];
    [self.featureValueDict enumerateKeysAndObjectsUsingBlock:^(NSNumber *  _Nonnull key, NSNumber *  _Nonnull obj, BOOL * _Nonnull stop) {
        [self beautyPanelView:nil operValueChanged:obj.floatValue oper:(RtcBeautyOperation)key.integerValue];
    }];
    [self beautyPanelView:nil humanSegCaseSelected:self.humanSegCaseName];
}

- (NSMutableDictionary<NSNumber *, NSNumber *> *)featureValueDict {
    if (!_featureValueDict) {
        _featureValueDict = [NSMutableDictionary dictionary];
    }
    return _featureValueDict;
}

#pragma mark - BDMVBeautyFacePanelViewDelegate

- (void)beautyPanelView:(BDMVBeautyFacePanelView *)view setBeautyEnabled:(BOOL)enabled {
    self.beautyEnabled = enabled;
    if ([self.beautyManager respondsToSelector:@selector(setBeautyEnabled:)]) {
        [self.beautyManager setBeautyEnabled:enabled];
    }
}

- (void)beautyPanelView:(BDMVBeautyFacePanelView *)view operValueChanged:(float)value oper:(RtcBeautyOperation)oper {
    
    RtcBeautyFeatureType feature;
    switch (oper) {
        case RTC_VIDEO_WHITE:
            feature = RtcBeautyFeatureType_WhiteLevel;
            break;
        case RTC_VIDEO_BLUR:
            feature = RtcBeautyFeatureType_BlurLevel;
            break;
        case RTC_VIDEO_BIGEYE:
            feature = RtcBeautyFeatureType_EnlargingLevel;
            break;
        case RTC_VIDEO_THINFACE:
            feature = RtcBeautyFeatureType_ThinningLevel;
            break;
        default:
            return;
    }
    
    self.featureValueDict[@(oper)] = @(value);
    if ([self.beautyManager respondsToSelector:@selector(setBeautyFeature:value:)]) {
        [self.beautyManager setBeautyFeature:feature value:@(value)];
    }
}

- (void)beautyPanelView:(BDMVBeautyFacePanelView *)view humanSegCaseSelected:(NSString *)caseName {
    
    self.humanSegCaseName = caseName;
    BOOL enabled = caseName.length > 0;
    BRTCEffectParams *param = nil;
    
    if (enabled) {
        param = [BRTCEffectParams new];
        param.resourcePath = [[NSBundle mainBundle] pathForResource:caseName ofType:@"bundle"];
    }
    
    if ([self.beautyManager respondsToSelector:@selector(setHumanSegEnabled:effectParams:)]) {
        [self.beautyManager setHumanSegEnabled:enabled effectParams:param];
    }
}

@end
