//
//  BDUserListItermViewCell.m
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/10/25.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import "BDUserListItermViewCell.h"
#import "BDCloudRTCBaseDefine.pch"
#import "RTCViewLayoutMacro.h"
#import <BaiduRtcRoom/BaiduRtcRoomApiDefines.h>

@interface BDUserListItermViewCell ()
@property (nonatomic, strong) UIImageView *ImgVideoMute;
@property (nonatomic, strong) UIImageView *ImgAudioMute;
@property (nonatomic, strong) UIButton    *btnEnableAudio;
@property (nonatomic, strong) UIButton    *btnEnableVideo;
@property (nonatomic, strong) UIButton    *btnVolume;
@property (nonatomic, strong) UIButton    *btnEnableSubscribe;
@property (nonatomic, strong) NSString    *UserId;
@property (nonatomic, strong) UIImageView *UserPicture;

@property (nonatomic, strong) UILabel     *labelRoomName;
@property (nonatomic, strong) UILabel     *volumeLabel;
@property (nonatomic, strong) UISlider    *volumeSlider;
@property (nonatomic, strong) UILabel     *labelNickName;

@property (nonatomic, weak) RtcRoomUserInfo *userRoomInfo;

@property (nonatomic, strong) NSDate *preDate;

@property (nonatomic, assign) BOOL isEnableAudio;
@property (nonatomic, assign) BOOL isEnableVideo;
@property (nonatomic, assign) BOOL isEnableAudioVideo;
@property (nonatomic, assign) float volume;

@property(nonatomic, weak) id<RTCUserListsViewControllerDelegate> delegate;

@end

@implementation BDUserListItermViewCell

- (void)dealloc {
}
- (void)configBaseUI:(BOOL)remote {
    [super configBaseUI:remote];
    
    //TODO 1 需要根据配置判断初始值值
    _isEnableAudioVideo = YES;
    _isEnableAudio = YES;
    _isEnableVideo = YES;
    _volume = 1.f;

    self.backgroundColor = BDCloudBaseBgColor;

    _btnVolume = [UIButton buttonWithType:UIButtonTypeCustom];
    _btnVolume.layer.masksToBounds = YES;
    [_btnVolume addTarget:self action:@selector(onEventBtnChanged:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:_btnVolume];

    _btnEnableAudio = [UIButton buttonWithType:UIButtonTypeCustom];
    _btnEnableAudio.layer.masksToBounds = YES;
    [_btnEnableAudio addTarget:self action:@selector(onEventBtnChanged:) forControlEvents:UIControlEventTouchUpInside];
    if (self.mode == kSubscribeModeManual && remote) {
        [self addSubview:_btnEnableAudio];
    }
    
    _btnEnableVideo = [UIButton buttonWithType:UIButtonTypeCustom];
    _btnEnableVideo.layer.masksToBounds = YES;
    [_btnEnableVideo addTarget:self action:@selector(onEventBtnChanged:) forControlEvents:UIControlEventTouchUpInside];
    if ((self.mode == kSubscribeModeManual || self.mode == kSubscribeModeMeeting) && remote) {
        [self addSubview:_btnEnableVideo];
    }
    
    _btnEnableSubscribe = [UIButton buttonWithType:UIButtonTypeCustom];
    _btnEnableSubscribe.layer.masksToBounds = YES;
    [_btnEnableSubscribe addTarget:self action:@selector(onEventBtnChanged:) forControlEvents:UIControlEventTouchUpInside];
    if ((self.mode == kSubscribeModeManual || self.mode == kSubscribeModeMeeting) && remote) {
        [self addSubview:_btnEnableSubscribe];
    }
    
    _labelRoomName = [[UILabel alloc] initWithFrame:CGRectZero];
    _labelRoomName.text = @"roomId";
    _labelRoomName.font = [UIFont systemFontOfSize:18];
    _labelRoomName.textColor = [UIColor blackColor];
    [self addSubview:_labelRoomName];

    _labelNickName = [[UILabel alloc] initWithFrame:CGRectZero];
    _labelNickName.text = @"nickName";
    _labelNickName.font = [UIFont systemFontOfSize:18];
    _labelNickName.textColor = [UIColor blackColor];
    [self addSubview:_labelNickName];
    
    self.backgroundColor = [UIColor grayColor];
    
    self.height = BDCloudBaseSizeTranslate(BUTTON_HEIGHT);
    
    [self updateStatus];
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    CGRect frm = self.frame;
    
//    CGFloat muteMicX = 0;
//    CGFloat muteMicY = 0;
//    CGFloat muteMicW = SCREEN_WIDTH*160*kLayoutWidthScale;
//    CGFloat muteMicH = muteMicW;
//    if (![rtcSetting currentHasVideoSettingFromStore]) {
//        muteMicX = SCREEN_WIDTH*254*kLayoutWidthScale;
//        muteMicY = SCREEN_HEIGHT*1501*kLayoutHeightScale;
//    } else {
//        muteMicX = SCREEN_WIDTH*88*kLayoutWidthScale;
//        muteMicY = SCREEN_HEIGHT*1883*kLayoutHeightScale;
//    }
    _btnEnableAudio.layer.cornerRadius = IMAGE_HEIGHT/2.0;
    _btnEnableVideo.layer.cornerRadius = IMAGE_HEIGHT/2.0;
    _btnEnableSubscribe.layer.cornerRadius = IMAGE_HEIGHT/2.0;

//    CGRect audioRemoteFrame = CGRectMake(muteMicX, muteMicY, muteMicW, muteMicH);

    CGFloat btnMarginTop = (BUTTON_HEIGHT - IMAGE_HEIGHT) / 2;
    _labelNickName.frame      = CGRectMake(frm.size.width * 1 / 64, BUTTON_HEIGHT - IMAGE_HEIGHT, BUTTON_HEIGHT*2, BUTTON_HEIGHT);
    _labelRoomName.frame      = CGRectMake(frm.size.width * 13 / 64, BUTTON_HEIGHT - IMAGE_HEIGHT, BUTTON_HEIGHT*2, BUTTON_HEIGHT);
    _btnEnableSubscribe.frame = CGRectMake(frm.size.width * 25 / 64, BUTTON_HEIGHT - IMAGE_HEIGHT, IMAGE_HEIGHT, IMAGE_HEIGHT);
    _btnEnableVideo.frame     = CGRectMake(frm.size.width * 35 / 64, BUTTON_HEIGHT - IMAGE_HEIGHT, IMAGE_HEIGHT, IMAGE_HEIGHT);
    _btnEnableAudio.frame     = CGRectMake(frm.size.width * 45 / 64, BUTTON_HEIGHT - IMAGE_HEIGHT, IMAGE_HEIGHT, IMAGE_HEIGHT);
    _btnVolume.frame          = CGRectMake(frm.size.width * 55 / 64, btnMarginTop, IMAGE_HEIGHT, IMAGE_HEIGHT);
}

- (void)onEventBtnChanged:(id)sender {
    //TODO 2 添加业务代码
    UserListOperateType uerOperateType = USER_DEFAULT;
    
    // 单用户状态信息在回调后更新
    if (sender == _btnEnableAudio) {
        uerOperateType = _isEnableAudio ? USER_MUTE_AUDIO : USER_UNMUTE_AUDIO;
    } else if (sender == _btnEnableVideo) {
        uerOperateType = _isEnableVideo ? USER_MUTE_VIDEO : USER_UNMUTE_VIDEO;
    } else if (sender == _btnEnableSubscribe) {
        //TODO 频繁开启摄像头会有问题，
        NSDate *date = [NSDate date];
        if (self.preDate) {
            int requestInterval = (int)ceil([date timeIntervalSinceDate:self.preDate]);
            if (requestInterval <= 1) {
                return;
            } else {
                self.preDate = date;
            }
        } else {
            self.preDate = date;
        }
        
        if (_userRoomInfo.remote) {
            uerOperateType = _isEnableAudioVideo ? USER_UNSUBSCRIBE : USER_SUBSCRIBE;
        } else {
            uerOperateType = _isEnableAudioVideo ? USER_UNPUBLISH : USER_PUBLISH;
        }
    } else if (sender == _btnVolume) {
        [self showVolumeSlider];
        return;
    }
    
    if ([self.delegate respondsToSelector:@selector(userListOperationCallBack:arr:streamType:info:)]) {
        [self.delegate userListOperationCallBack:uerOperateType arr: [NSArray arrayWithObjects:self.userRoomInfo, nil] streamType:0 info:nil];
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
}

// 图标表示当前状态
- (void)updateStatus {
    NSString *imageName = @"";
    
    imageName = _isEnableAudioVideo ? @"lianjie_o.png" : @"quxiaolianjie_o.png";
    [_btnEnableSubscribe setImage:[UIImage imageNamed:imageName] forState:UIControlStateNormal];
    _btnEnableVideo.enabled = _isEnableAudioVideo;
    _btnEnableAudio.enabled = _isEnableAudioVideo;
    
    imageName = _isEnableVideo ? @"shexiangtou.png" : @"shexiangtou_guanbi.png";
    [_btnEnableVideo setImage:[UIImage imageNamed:imageName] forState:UIControlStateNormal];

    imageName = _isEnableAudio ? @"maikefeng.png" : @"maikefeng-2.png";
    [_btnEnableAudio setImage:[UIImage imageNamed:imageName] forState:UIControlStateNormal];
    
    imageName = @"loundspeaker_y.png";
    [_btnVolume setImage:[UIImage imageNamed:imageName] forState:UIControlStateNormal];
}

- (void)configPushType:(RtcRoomUserInfo *)userInfo index:(NSInteger)index
           userDelegte:(id<RTCUserListsViewControllerDelegate>)userDelegate {

    _userRoomInfo =(RtcRoomUserInfo*)userInfo;
    _delegate = userDelegate;

    NSString *prefix = _userRoomInfo.remote ? [NSString stringWithFormat:@"%ld", (long)index] : @"s";
    _labelRoomName.text = [NSString stringWithFormat:@"%@:%ld", prefix, [_userRoomInfo.userID longValue]];
    _labelNickName.text = [NSString stringWithFormat:@"%@", _userRoomInfo.userName ];

    _isEnableAudioVideo = _userRoomInfo.streaming;
    _isEnableVideo = _userRoomInfo.video;
    _isEnableAudio = _userRoomInfo.audio;
   
    [self updateStatus];
    
    NSLog(@"[csq] remotePushing: %@, user: %@, audio: %@, video: %@", @(_userRoomInfo.remotePushing), _userRoomInfo.userID, @(_userRoomInfo.audio), @(_userRoomInfo.video));
    if (_userRoomInfo.remotePushing) {
        [self.btnEnableSubscribe setEnabled:YES];
        [self.btnEnableAudio setEnabled:YES];
        [self.btnEnableVideo setEnabled:YES];
    } else {
        [self.btnEnableSubscribe setEnabled:NO];
        [self.btnEnableVideo setEnabled:NO];
        [self.btnEnableAudio setEnabled:NO];
    }
}

#pragma mark - Volume

- (void)showVolumeSlider {
    self.volumeSlider = [[UISlider alloc] initWithFrame:CGRectMake(0, 0, self.frame.size.width - 50, self.frame.size.height)];
    self.volumeSlider.backgroundColor = BDCloudBaseBgColor;
    self.volumeSlider.minimumValue = .0f;
    self.volumeSlider.maximumValue = 4.f;
    self.volumeSlider.value = self.volume;
    [self.volumeSlider addTarget:self action:@selector(volumeSliderValueChanged:) forControlEvents:UIControlEventValueChanged];
    [self.volumeSlider addTarget:self action:@selector(volumeSliderTouchedDown:) forControlEvents:UIControlEventTouchDown];
    [self.volumeSlider addTarget:self action:@selector(volumeSliderTouchedUp:) forControlEvents:UIControlEventTouchUpInside];
    [self.volumeSlider addTarget:self action:@selector(volumeSliderTouchedUp:) forControlEvents:UIControlEventTouchUpOutside];
    [self addSubview:self.volumeSlider];
    
    self.volumeLabel = [[UILabel alloc] initWithFrame:CGRectMake(CGRectGetMaxX(self.volumeSlider.frame), 0, 50, self.frame.size.height)];
    self.volumeLabel.backgroundColor = BDCloudBaseBgColor;
    self.volumeLabel.textAlignment = NSTextAlignmentCenter;
    self.volumeLabel.text = [NSString stringWithFormat:@"%.1f", self.volume];
    self.volumeLabel.font = [UIFont systemFontOfSize:18];
    self.volumeLabel.textColor = [UIColor whiteColor];
    [self addSubview:self.volumeLabel];
}

- (void)closeVolumeSlider {
    [self.volumeSlider removeFromSuperview];
    self.volumeSlider = nil;
    [self.volumeLabel removeFromSuperview];
    self.volumeLabel = nil;
}

- (void)volumeSliderTouchedDown:(id)sender {
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(closeVolumeSlider) object:nil];
}

- (void)volumeSliderTouchedUp:(id)sender {
    [self performSelector:@selector(closeVolumeSlider) withObject:nil afterDelay:1.f];
}

- (void)volumeSliderValueChanged:(UISlider *)slider {
    self.volume = slider.value;
    self.volumeLabel.text = [NSString stringWithFormat:@"%.1f", self.volume];
    if ([self.delegate respondsToSelector:@selector(userListOperationCallBack:arr:streamType:info:)]) {
        [self.delegate userListOperationCallBack:USER_VOLUME arr: [NSArray arrayWithObjects:self.userRoomInfo, nil] streamType:0 info:@(self.volume)];
    }
}

@end
