//
//  BDRtcUserListsViewController.m
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/10/25.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import "BDRtcUserListsViewController.h"
#import "BDCloudRTCBaseDefine.pch"
#import "BDUserListItermViewCell.h"
#import "UIView+BBAUtility.h"
#import <BaiduRtcRoom/BaiduRtcRoomApiDefines.h>

@implementation BRTCUserListViewConfig

- (instancetype)init {
    if (self = [super init]) {
        _isPlayAllVideo = YES;
        _isPlayAllAudio = YES;
        _isAllSubscribe = YES;
        _subscribeMode = 0;
    }
    return self;
}

- (id)copyWithZone:(NSZone *)zone {
    BRTCUserListViewConfig *config = [[BRTCUserListViewConfig allocWithZone:zone] init];
    config.isPlayAllVideo = self.isPlayAllVideo;
    config.isPlayAllAudio = self.isPlayAllAudio;
    config.isAllSubscribe = self.isAllSubscribe;
    config.subscribeMode = self.subscribeMode;
    return config;
}

@end

@interface BDRtcUserListsViewController () <UITableViewDelegate, UITableViewDataSource, RTCUserListsViewControllerDelegate>

@property (nonatomic, strong) UITableView *mainTableView;

@property (nonatomic, strong) UIButton *btnAudioMute;
@property (nonatomic, strong) UIButton *btnVideoMute;
@property (nonatomic, strong) UIButton *btnSubscrbeMute;

@property (nonatomic, strong) NSMutableDictionary *uersDic;

@property (nonatomic, strong) NSArray *arrsyUserLists;

@property(nonatomic, weak) id<RTCUserListsViewControllerDelegate> delegate;

@property (nonatomic, copy) BRTCUserListViewConfig *config;
@property (nonatomic, assign) int streamType; // 订阅操作的流类型，0: 音视频; 1: 仅音频; 2: 仅视频

@property (nonatomic, strong) NSDate *preDate;

@end

@implementation BDRtcUserListsViewController
@synthesize delegate = _delegate;

- (void)dealloc {
    
}

- (instancetype)initWithDelegate:(id<RTCUserListsViewControllerDelegate>)delegate config:(BRTCUserListViewConfig *)config {
    if (self = [super init]) {
        _delegate = delegate;
        _config = config;
        if (!_config) {
            _config = [BRTCUserListViewConfig new];
        }
    }
    return self;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
}

- (void)configBaseUI {
    [super configBaseUI];
    self.navigationItem.title = @"用户列表";
    self.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"取消"
                                                                             style:UIBarButtonItemStylePlain
                                                                            target:self
                                                                            action:@selector(popViewController)];
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"音视频"
                                                                              style:UIBarButtonItemStylePlain
                                                                             target:self
                                                                             action:@selector(rightBarButtonItemClicked:)];
    self.mainTableView = [[UITableView alloc] initWithFrame:CGRectZero
                                                      style:UITableViewStyleGrouped];
    
    self.mainTableView.delegate = self;
    self.mainTableView.dataSource = self;
    self.mainTableView.backgroundColor = BDCloudBaseBgColor2;
    self.mainTableView.showsVerticalScrollIndicator = NO;
    [self.mainTableView setSeparatorColor:BDCloudBaseCellSepColor];
    [self.view addSubview:self.mainTableView];
    
    _btnAudioMute = [UIButton buttonWithType:UIButtonTypeCustom];
    _btnAudioMute.layer.masksToBounds = YES;
    [_btnAudioMute addTarget:self action:@selector(onBtnUserListsEvent:)
                   forControlEvents:UIControlEventTouchDown];
    [self.view addSubview:_btnAudioMute];
    
    _btnVideoMute = [UIButton buttonWithType:UIButtonTypeCustom];
    _btnVideoMute.layer.masksToBounds = YES;
    [_btnVideoMute addTarget:self action:@selector(onBtnUserListsEvent:)
                   forControlEvents:UIControlEventTouchDown];
    [self.view addSubview:_btnVideoMute];
    
    
    _btnSubscrbeMute = [UIButton buttonWithType:UIButtonTypeCustom];
    _btnSubscrbeMute.layer.masksToBounds = YES;
    [_btnSubscrbeMute addTarget:self action:@selector(onBtnUserListsEvent:)
                   forControlEvents:UIControlEventTouchDown];
    [self.view addSubview:_btnSubscrbeMute];
    
    [self setTitleForButtonsWithConfig:self.config];
}

- (void)onBtnUserListsEvent:(id)sender {
    //TODO 所有用户 进行操作
    UserListOperateType uerOperateType = USER_DEFAULT;
    
    if (sender == _btnAudioMute) {
        
        uerOperateType = self.config.isPlayAllAudio ? USER_MUTE_AUDIO_ALL : USER_UNMUTE_AUDIO_ALL;
        self.config.isPlayAllAudio = !self.config.isPlayAllAudio;
        
    } else if (sender == _btnVideoMute) {
        
        uerOperateType = self.config.isPlayAllVideo ? USER_MUTE_VIDEO_ALL : USER_UNMUTE_VIDEO_ALL;
        self.config.isPlayAllVideo = !self.config.isPlayAllVideo;
        
    } else  if (sender == _btnSubscrbeMute) {
        //TODO 频繁开启摄像头会有问题，
        NSDate *date = [NSDate date];
        if (self.preDate) {
            int requestInterval = (int)ceil([date timeIntervalSinceDate:self.preDate]);
            if (requestInterval <= 1) {
                return;
            } else {
                self.preDate = date;
            }
        } else {
            self.preDate = date;
        }
        uerOperateType = self.config.isAllSubscribe ? USER_UNSUBSCRIBE_ALL : USER_SUBSCRIBE_ALL;
        self.config.isAllSubscribe  = !self.config.isAllSubscribe;
    }
    
    [self setTitleForButtonsWithConfig:self.config];
    [self callbackOper:uerOperateType arr:nil info:nil];
}

// 文案表示将要切换到某状态的操作，该状态和当前状态相反
- (void)setTitleForButtonsWithConfig:(BRTCUserListViewConfig *)config {
    NSString *title = @"";
    
    title = config.isPlayAllAudio ? @"全员静音" : @"全员连麦";
    [_btnAudioMute setTitle:title forState:UIControlStateNormal];
    
    title = config.isPlayAllVideo ? @"全员禁画" : @"全员开画";
    [_btnVideoMute setTitle:title forState:UIControlStateNormal];
    
    title = config.isAllSubscribe ? @"全员停订" : @"全员订阅";
    [_btnSubscrbeMute setTitle:title forState:UIControlStateNormal];
}

- (void)popViewController {
//    [self.navigationController popViewControllerAnimated:YES];
    [_delegate viewControllerDidFinish:self];
}

- (void)rightBarButtonItemClicked:(UIBarButtonItem *)sender {
    int type = (self.streamType + 1) % 3;
    NSString *title = @"音视频";
    if (type == 1) title = @"仅音频";
    else if (type == 2) title = @"仅视频";
    self.streamType = type;
    sender.title = title;
}

- (void)viewWillLayoutSubviews {
    [super viewWillLayoutSubviews];
    
//    [self.mainTableView mas_remakeConstraints:^(MASConstraintMaker *make) {
//        make.top.mas_equalTo(self.view);
//        make.left.mas_equalTo(self.view);
//        make.right.mas_equalTo(self.view);
//        make.height.mas_equalTo(self.view);
//    }]
    CGRect frm = self.view.frame;
    frm.size.height -= ([UIView brtc_safeAreaInsets].bottom + BUTTON_HEIGHT);
    self.mainTableView.frame = frm;
    
    _btnAudioMute.frame = CGRectMake(frm.size.width*7/18, frm.size.height, BUTTON_HEIGHT * 2, BUTTON_HEIGHT);
    _btnVideoMute.frame = CGRectMake(frm.size.width * 13/18, frm.size.height, BUTTON_HEIGHT * 2, BUTTON_HEIGHT);
    _btnSubscrbeMute.frame = CGRectMake(frm.size.width * 1/18, frm.size.height, BUTTON_HEIGHT * 2, BUTTON_HEIGHT);
}

#pragma mark -- updata user list --
-(void)UserListOfRoomChanged:(NSArray *)userInfo {
    //reload data
        __weak BDRtcUserListsViewController *weakSelf = self;
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.2 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            NSLog(@"vocs updateUserList count:%d", (int)userInfo.count);
            self->_arrsyUserLists = userInfo;
            [weakSelf.mainTableView reloadData];
        });
    
}

#pragma mark --UITableViewDelegate and UITableViewDataSource--
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _arrsyUserLists.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    BDUserListItermViewCell *cell = nil;
    NSInteger idx = indexPath.row;
    if (idx >= 0 && idx < _arrsyUserLists.count) {
        RtcRoomUserInfo *user = [_arrsyUserLists objectAtIndex:idx];
        // NSLog(@"vocs cell index:%d, userId:%@, remote:%@", idx, user.userID, (user.remote ? @"yes" : @"no"));
        cell = [BDUserListItermViewCell cellFromTableView:tableView mode:_config.subscribeMode remote:user.remote index:(int)idx];
        [cell configPushType:user index:idx userDelegte:self];
    }
    return  cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    NSInteger idx = indexPath.row;
    BOOL isRemote = false;
    if (idx >= 0 && idx < _arrsyUserLists.count) {
        RtcRoomUserInfo *user = [_arrsyUserLists objectAtIndex:idx];
        isRemote = user.remote;
    }
    BDUserListItermViewCell *cell = [BDUserListItermViewCell cellFromTableView:tableView mode:_config.subscribeMode remote:isRemote index:(int)idx];
    return cell.height;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [[UIApplication sharedApplication].keyWindow endEditing:true];
}

#pragma mark - RTCUserListsViewControllerDelegate

- (void)viewControllerDidFinish:(BDRtcUserListsViewController *)viewController {
    // noop
}

- (void)userListOperationCallBack:(UserListOperateType)userOP arr:(NSArray *)userInfo streamType:(int)streamType info:(id)info {
    [self callbackOper:userOP arr:userInfo info:info];
}

- (void)callbackOper:(UserListOperateType)userOP arr:(NSArray *)userInfo info:(id)info {
    dispatch_async(dispatch_get_main_queue(), ^{
        if ([self.delegate respondsToSelector:@selector(userListOperationCallBack:arr:streamType:info:)]) {
            [self.delegate userListOperationCallBack:userOP arr:userInfo streamType:self.streamType info:info];
        }
    });
}

@end
