//
//  BDCloudBaseTableViewCell.m
//  BDCloudLive
//
//  Created by fusheng on 2020/2/25.
//  Copyright © 2020 Baidu. All rights reserved.
//

#import "BDCloudBaseTableViewCell.h"

@implementation BDCloudBaseTableViewCell

+ (instancetype)cellFromTableView:(UITableView *)tableView mode:(int)mode remote:(BOOL)remote index:(int)index {
    return [self cellFromTableView:tableView style:UITableViewCellStyleDefault mode:mode remote:remote index:index];
}

+ (instancetype)cellFromTableView:(UITableView *)tableView style:(UITableViewCellStyle)style mode:(int)mode remote:(BOOL)remote index:(int)index {
    NSString *className = [NSString stringWithFormat:@"%@%d", NSStringFromClass([self class]), index];
    BDCloudBaseTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:className];
    if (!cell) {
        cell = [[[self class] alloc] initWithStyle:style
                                   reuseIdentifier:className];
        cell.mode = mode;
        [cell configBaseUI:remote];
    }
    return cell;
}

- (void)configBaseUI:(BOOL)remote {
    // 子类重写
    self.selectionStyle = UITableViewCellSelectionStyleNone;
    self.contentView.backgroundColor = [UIColor clearColor];
    self.backgroundColor = [UIColor clearColor];
}

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end

@implementation BDCloudBaseTableViewHeader

+ (instancetype)headerFromTableView:(UITableView *)tableView {
    NSString *className = NSStringFromClass([self class]);
    BDCloudBaseTableViewHeader *headerView = [tableView dequeueReusableHeaderFooterViewWithIdentifier:className];
    if (!headerView) {
        headerView = [[[self class] alloc] initWithReuseIdentifier:className];
        [headerView configBaseUI];
    }
    return headerView;
}

- (void)configBaseUI {
    self.contentView.backgroundColor = [UIColor clearColor];
    self.backgroundView.backgroundColor = [UIColor clearColor];
}
@end

@implementation BDCloudBaseTableViewFooter

+ (instancetype)footerFromTableView:(UITableView *)tableView {
    NSString *className = NSStringFromClass([self class]);
    BDCloudBaseTableViewFooter *footerView = [tableView dequeueReusableHeaderFooterViewWithIdentifier:className];
    if (!footerView) {
        footerView = [[[self class] alloc] initWithReuseIdentifier:className];
        [footerView configBaseUI];
    }
    return footerView;
}

- (void)configBaseUI {
    self.contentView.backgroundColor = [UIColor clearColor];
    self.backgroundView.backgroundColor = [UIColor clearColor];
}
@end
