//
//  BDCloudBaseTableViewCell.h
//  BDCloudLive
//
//  Created by fusheng on 2020/2/25.
//  Copyright © 2020 Baidu. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface BDCloudBaseTableViewCell : UITableViewCell

@property (nonatomic, assign) CGFloat height;

@property (nonatomic, copy) void(^updateAllCallback)(void);

@property (nonatomic, copy) void(^updateGroupsCallback)(NSArray<NSIndexPath *> *groups);

@property (nonatomic, copy) void(^scrollToRowCallback)(NSIndexPath *indexPath);

@property (nonatomic, assign) int mode;

+ (instancetype)cellFromTableView:(UITableView *)tableView mode:(int)mode remote:(BOOL)remote index:(int)index;

+ (instancetype)cellFromTableView:(UITableView *)tableView style:(UITableViewCellStyle)style mode:(int)mode remote:(BOOL)remote index:(int)index;

// 子类重写
- (void)configBaseUI:(BOOL)remote;
@end

@interface BDCloudBaseTableViewHeader : UITableViewHeaderFooterView

@property (nonatomic, assign) CGFloat height;

+ (instancetype)headerFromTableView:(UITableView *)tableView;

// 子类重写
- (void)configBaseUI;
@end

@interface BDCloudBaseTableViewFooter : UITableViewHeaderFooterView

@property (nonatomic, assign) CGFloat height;

+ (instancetype)footerFromTableView:(UITableView *)tableView;

// 子类重写
- (void)configBaseUI;
@end

NS_ASSUME_NONNULL_END
