//
//  RTCShareScreenController.m
//  rtc_sdk_ios
//
//  Created by 曹士谦 on 2022/2/23.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCShareScreenController.h"

@implementation RTCShareScreenController

+ (void)showShareScreenLauncherInVC:(UIViewController *)vc completion:(RTCShareScreenLauncherBlock)completion {
    if (!vc) return;
    UIAlertController *alert = [[self class] shareScreenAlertControllerWithActionBlock:completion];
    [vc presentViewController:alert animated:YES completion:^{
       // noop
    }];
}

+ (UIAlertController *)shareScreenAlertControllerWithActionBlock:(RTCShareScreenLauncherBlock)block {
    
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"选择屏幕共享方式"
                                                                   message:@""
                                                            preferredStyle:UIAlertControllerStyleActionSheet];
    
    [alert addAction:[self shareScreenActionWithType:RTCShareScreenTypeInApp actionBlock:block]];
    [alert addAction:[self shareScreenActionWithType:RTCShareScreenTypeSystem actionBlock:block]];
    [alert addAction:[self shareScreenActionWithType:RTCShareScreenTypeNone actionBlock:block]];
    
    return alert;
}

+ (UIAlertAction *)shareScreenActionWithType:(RTCShareScreenType)type actionBlock:(RTCShareScreenLauncherBlock)actionBlock {
    
    UIAlertAction *action = [UIAlertAction actionWithTitle:[self strForShareScreenType:type]
                                                     style:[self styleForShareScreenType:type]
                                                   handler:^(UIAlertAction * _Nonnull action) {
        if (actionBlock) {
            actionBlock(type);
        }
    }];
    return action;
}

+ (NSString *)strForShareScreenType:(RTCShareScreenType)type {
    switch (type) {
        case RTCShareScreenTypeNone: return @"取消";
        case RTCShareScreenTypeInApp: return @"应用内共享";
        case RTCShareScreenTypeSystem: return @"系统共享";
        default: return @"";
    }
}

+ (UIAlertActionStyle)styleForShareScreenType:(RTCShareScreenType)type {
    switch (type) {
        case RTCShareScreenTypeNone: return UIAlertActionStyleCancel;
        default: return UIAlertActionStyleDefault;
    }
}

@end
