//
//  SampleHandler.m
//  com.csq.rtcapp2.ScreenShare
//
//  Created by 曹士谦 on 2022/4/11.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//


#import "SampleHandler.h"
#import <BaiduRtcReplayKit/BaiduRtcRoomReplayKitExt.h>

static NSString *const AppGroup = @"group.com.baidu.rtc.ReplayKit";

@interface SampleHandler ()<BaiduRtcRoomReplayKitExtDelegate>
@end

API_AVAILABLE(ios(11.0))
@implementation SampleHandler

- (void)broadcastStartedWithSetupInfo:(NSDictionary<NSString *, NSObject *> *)setupInfo {
    NSLog(@"[RTC] broadcastStartedWithSetupInfo: %@", setupInfo);
    [[BaiduRtcRoomReplayKitExt sharedInstance] broadcastStartedWithAppGroup:AppGroup delegate:self];
}

- (void)broadcastPaused {
    NSLog(@"[RTC] broadcastPaused");
    [[BaiduRtcRoomReplayKitExt sharedInstance] broadcastPaused];
}

- (void)broadcastResumed {
    NSLog(@"[RTC] broadcastResumed");
    [[BaiduRtcRoomReplayKitExt sharedInstance] broadcastResumed];
}

- (void)broadcastFinished {
    NSLog(@"[RTC] broadcastFinished");
    [[BaiduRtcRoomReplayKitExt sharedInstance] broadcastFinished];
}

- (void)processSampleBuffer:(CMSampleBufferRef)sampleBuffer withType:(RPSampleBufferType)sampleBufferType {
    [[BaiduRtcRoomReplayKitExt sharedInstance] processSampleBuffer:sampleBuffer bufferType:sampleBufferType];
}

#pragma mark - BaiduRtcRoomReplayKitExtDelegate

- (void)replayKitScreenShareStopped:(BaiduRtcRoomReplayKitExt *)replayKit reason:(BaiduRtcReplayKitStopReason)reason {
    NSError *error = [NSError errorWithDomain:NSCocoaErrorDomain code:0 userInfo:nil];
    NSString *desc = [self descForStopReason:reason];
    if (desc.length) {
        error = [NSError errorWithDomain:NSCocoaErrorDomain code:reason userInfo:@{ NSLocalizedDescriptionKey: desc }];
    }
    [self finishBroadcastWithError:error];
}

- (NSString *)descForStopReason:(BaiduRtcReplayKitStopReason)reason {
    switch (reason) {
        case BaiduRtcReplayKitStopReasonStartError:
            return @"启动发生错误";
        case BaiduRtcReplayKitStopReasonIncorrectStart:
            return @"不能从主程序外启动屏幕分享";
        default:
            return nil;
    }
}

@end
