//
//  RTCBroadcastExtensionLauncher.m
//  rtc_sdk_ios
//
//  Created by 曹士谦 on 2022/4/11.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCBroadcastExtensionLauncher.h"
#import <UIKit/UIKit.h>
#import <ReplayKit/ReplayKit.h>

@interface RTCBroadcastExtensionLauncher ()
@property (nonatomic, strong) RPSystemBroadcastPickerView *pickerView API_AVAILABLE(ios(12.0));
@end

@implementation RTCBroadcastExtensionLauncher

+ (instancetype)sharedInstance {
    static RTCBroadcastExtensionLauncher *_sharedSingleton = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _sharedSingleton = [[super allocWithZone:NULL] init];
    });
    return _sharedSingleton;
}

- (instancetype)init {
    self = [super init];
    if (self) {
        if (@available(iOS 12.0, *)) {
            RPSystemBroadcastPickerView *picker =
                    [[RPSystemBroadcastPickerView alloc] initWithFrame:CGRectMake(0, 0, 44, 44)];
            picker.showsMicrophoneButton = false;
            picker.autoresizingMask = UIViewAutoresizingFlexibleTopMargin | UIViewAutoresizingFlexibleRightMargin;
            _pickerView = picker;
            
            NSString *plugInPath = NSBundle.mainBundle.builtInPlugInsPath;
            if (!plugInPath) {
                return self;
            }
            
            NSArray *contents = [NSFileManager.defaultManager contentsOfDirectoryAtPath:plugInPath error:nil];
            for (NSString *content in contents) {
                NSURL *url = [NSURL fileURLWithPath:plugInPath];
                NSBundle *bundle = [NSBundle bundleWithPath:[url URLByAppendingPathComponent:content].path];
                
                NSDictionary *extension = [bundle.infoDictionary objectForKey:@"NSExtension"];
                if (extension == nil) {
                    continue;
                }
                NSString *identifier = [extension objectForKey:@"NSExtensionPointIdentifier"];
                if ([identifier isEqualToString:@"com.apple.broadcast-services-upload"]) {
                    picker.preferredExtension = bundle.bundleIdentifier;
                    break;
                }
            }
        }
    }
    return self;
}

+ (void)launch {
    [[self sharedInstance] launch];
}

- (void)launch {
    for (UIView *view in _pickerView.subviews) {
        UIButton *button = (UIButton *)view;
        [button sendActionsForControlEvents:UIControlEventAllTouchEvents];
    }
}

@end
