//
//  RTCVideoUserInfoView.m
//  rtc_sdk_ios
//
//  Created by v_liyingna on 10/25/21.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCVideoUserInfoView.h"
@interface RTCVideoUserInfoView ()
@property (nonatomic, strong) UILabel *nameLabel;
@property (nonatomic, strong) UIImageView *volumeImageView;
@end

@implementation RTCVideoUserInfoView

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self setupViews];
    }
    return self;
}

- (void)setupViews {
    self.nameLabel = [[UILabel alloc] initWithFrame:CGRectZero];
    self.nameLabel.font = [UIFont systemFontOfSize:14];
    self.nameLabel.textColor = [UIColor whiteColor];
    [self addSubview:self.nameLabel];
    
    self.volumeImageView = [[UIImageView alloc] initWithFrame:CGRectZero];
    self.volumeImageView.contentMode = UIViewContentModeScaleAspectFit;
    [self addSubview:self.volumeImageView];
}

- (void)layoutSubviews {
    self.nameLabel.frame = CGRectMake(0, 0, self.bounds.size.width, 30);
//    self.volumeImageView.frame = CGRectMake(self.nameLabel.text.length, 0, 30, 30);
    
}

- (void)setupUserId:(NSInteger)userId volume:(NSInteger)volume {
    if (volume < 0) {
        self.nameLabel.text = [NSString stringWithFormat:@"%ld", userId];
    } else {
        self.nameLabel.text = [NSString stringWithFormat:@"%ld %lddb", userId, volume];
    }
//    self.volumeImageView.image = [UIImage imageNamed:@"monitor"];
    [self setNeedsLayout];
}
@end
