//
//  RTCVideoCallView.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCVideoCallView.h"
#import <AVFoundation/AVFoundation.h>
#import "UIImage+RTCUtilities.h"

static CGFloat const kButtonPadding = 16;
static CGFloat const kButtonSize = 48;
static CGFloat const kLocalVideoViewSize = 120;
static CGFloat const kLocalVideoViewPadding = 8;
static CGFloat const kStatusBarHeight = 20;

@interface RTCVideoCallView () <RTCRemoteVideoViewDelegate ,VideoCallViewDelegate>
@property (nonatomic, strong) UIView *cameraFocusView;
@end

@implementation RTCVideoCallView {
    UIButton *_engineStatesInfoShow;
    UIButton *_muteCamera;
    UIButton *_muteMicPhone;
    UIButton *_routeChangeButton;
    UIButton *_cameraSwitchButton;
    UIButton *_hangupButton;
    CGSize _remoteVideoSize;
}

@synthesize statusLabel = _statusLabel;
@synthesize statsView = _statsView;
@synthesize delegate = _delegate;

- (instancetype)initWithFrame:(CGRect)frame andOption:(BOOL)isMultiPersonsMode {
    if (self = [super initWithFrame:frame]) {
        self.cameraFocusView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 80, 80)];
        self.cameraFocusView.layer.borderWidth = 1.0;
        self.cameraFocusView.layer.borderColor = [UIColor greenColor].CGColor;
        self.cameraFocusView.layer.backgroundColor = [UIColor clearColor].CGColor;
        //[self addSubview:self.cameraFocusView];
        self.cameraFocusView.hidden = YES;
        self.isMultiPersons = isMultiPersonsMode;
        if (self.isMultiPersons) {
            RTCRemoteVideoView * remoteVideoView1 = [[RTCRemoteVideoView alloc] initWithDelegate:self];
            [self addSubview:remoteVideoView1.videoView];
            RTCRemoteVideoView * remoteVideoView2 = [[RTCRemoteVideoView alloc] initWithDelegate:self];
            [self addSubview:remoteVideoView2.videoView];
            RTCRemoteVideoView * remoteVideoView3 = [[RTCRemoteVideoView alloc] initWithDelegate:self];
            [self addSubview:remoteVideoView3.videoView];
            RTCRemoteVideoView * remoteVideoView4 = [[RTCRemoteVideoView alloc] initWithDelegate:self];
            [self addSubview:remoteVideoView4.videoView];
            self.remoteVideoViewGroup = @[remoteVideoView1, remoteVideoView2,
                                          remoteVideoView3, remoteVideoView4];
        } else {
            self.remoteVideoView = [[RTCRemoteVideoView alloc] initWithDelegate:self];
            [self addSubview:self.remoteVideoView.videoView];
            
        }
        
        self.localVideoView = [[RTCLocalVideoView alloc] initWithDelegate:nil];
        [self addSubview:self.localVideoView.videoView];
        [self addSubview:self.cameraFocusView];
        
        _statsView = [[RTCStatsView alloc] initWithFrame:CGRectZero];
        _statsView.videoCallViewDelegate = self;
        _statsView.hidden = YES;
        [self addSubview:_statsView];
        
        _routeChangeButton = [UIButton buttonWithType:UIButtonTypeCustom];
        _routeChangeButton.backgroundColor = [UIColor whiteColor];
        _routeChangeButton.layer.cornerRadius = kButtonSize / 2;
        _routeChangeButton.layer.masksToBounds = YES;
        UIImage *image = [UIImage imageNamed:@"ic_surround_sound_black_24dp.png"];
        [_routeChangeButton setImage:image forState:UIControlStateNormal];
        [_routeChangeButton addTarget:self
                               action:@selector(onRouteChange:)
                     forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_routeChangeButton];
        
        _muteMicPhone = [UIButton buttonWithType:UIButtonTypeCustom];
        _muteMicPhone.backgroundColor = [UIColor whiteColor];
        _muteMicPhone.layer.cornerRadius = kButtonSize / 2;
        _muteMicPhone.layer.masksToBounds = YES;
        UIImage *micImage = [UIImage imageNamed:@"micphone_microphone_24px_1132504_easyicon.net.png"];
        [_muteMicPhone setImage:micImage forState:UIControlStateNormal];
        [_muteMicPhone addTarget:self action:@selector(onMicphoneChange:)
                forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_muteMicPhone];
        
        _muteCamera = [UIButton buttonWithType:UIButtonTypeCustom];
        _muteCamera.backgroundColor = [UIColor whiteColor];
        _muteCamera.layer.cornerRadius = kButtonSize / 2;
        _muteCamera.layer.masksToBounds = YES;
        UIImage *cameraImage = [UIImage imageNamed:@"close_camera_1132_504.png"];
        [_muteCamera setImage:cameraImage forState:UIControlStateNormal];
        [_muteCamera addTarget:self action:@selector(onCameraChange:)
              forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_muteCamera];
        
        _engineStatesInfoShow = [UIButton buttonWithType:UIButtonTypeCustom];
        _engineStatesInfoShow.backgroundColor = [UIColor whiteColor];
        _engineStatesInfoShow.layer.cornerRadius = kButtonSize / 2;
        _engineStatesInfoShow.layer.masksToBounds = YES;
        [_engineStatesInfoShow setAttributedTitle:[[NSAttributedString alloc] initWithString:@"..."] forState:UIControlStateNormal];
        _engineStatesInfoShow.alpha = 0.2;
        _engineStatesInfoShow.titleLabel.textColor = [UIColor redColor];
        [_engineStatesInfoShow addTarget:self action:@selector(onShowEngineStates:)
                        forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_engineStatesInfoShow];
        
        // TODO(tkchin): don't display this if we can't actually do camera switch.
        _cameraSwitchButton = [UIButton buttonWithType:UIButtonTypeCustom];
        _cameraSwitchButton.backgroundColor = [UIColor whiteColor];
        _cameraSwitchButton.layer.cornerRadius = kButtonSize / 2;
        _cameraSwitchButton.layer.masksToBounds = YES;
        image = [UIImage imageNamed:@"ic_switch_video_black_24dp.png"];
        [_cameraSwitchButton setImage:image forState:UIControlStateNormal];
        [_cameraSwitchButton addTarget:self
                                action:@selector(onCameraSwitch:)
                      forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_cameraSwitchButton];
        
        _hangupButton = [UIButton buttonWithType:UIButtonTypeCustom];
        _hangupButton.backgroundColor = [UIColor redColor];
        _hangupButton.layer.cornerRadius = kButtonSize / 2;
        _hangupButton.layer.masksToBounds = YES;
        image = [UIImage imageForName:@"ic_call_end_black_24dp.png"
                                color:[UIColor whiteColor]];
        [_hangupButton setImage:image forState:UIControlStateNormal];
        [_hangupButton addTarget:self
                          action:@selector(onHangup:)
                forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_hangupButton];
        
        _statusLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _statusLabel.font = [UIFont fontWithName:@"Roboto" size:16];
        _statusLabel.textColor = [UIColor whiteColor];
        [self addSubview:_statusLabel];
        
        UITapGestureRecognizer *tapRecognizer =
        [[UITapGestureRecognizer alloc]
         initWithTarget:self
         action:@selector(onTapScreen:)];
        tapRecognizer.numberOfTapsRequired = 1;
        [self addGestureRecognizer:tapRecognizer];
    }
    return self;
}

- (void)layoutSubviews {
    CGRect bounds = self.bounds;
    if (_remoteVideoSize.width > 0 && _remoteVideoSize.height > 0) {
        if (self.isMultiPersons) {
            
        } else  {
            // Aspect fill remote video into bounds.
            CGRect remoteVideoFrame =
            AVMakeRectWithAspectRatioInsideRect(_remoteVideoSize, bounds);
            CGFloat scale = 1;
            if (remoteVideoFrame.size.width > remoteVideoFrame.size.height) {
                // Scale by height.
                scale = bounds.size.height / remoteVideoFrame.size.height;
            } else {
                // Scale by width.
                scale = bounds.size.width / remoteVideoFrame.size.width;
            }
            remoteVideoFrame.size.height *= scale;
            remoteVideoFrame.size.width *= scale;
            self.remoteVideoView.videoView.frame = remoteVideoFrame;
            self.remoteVideoView.videoView.center =
            CGPointMake(CGRectGetMidX(bounds), CGRectGetMidY(bounds));
        }
    } else {
        if (self.isMultiPersons) {
            CGFloat width = self.bounds.size.width;
            CGFloat height = self.bounds.size.height;
            CGFloat viewFrameWidth = width/2;
            CGFloat viewFrameHeight = height/3;
            CGRect viewFrame;
            for (int i = 0; i < [self.remoteVideoViewGroup count]; i++) {
                switch (i) {
                    case 0:
                        viewFrame = CGRectMake(0, 0, viewFrameWidth, viewFrameHeight);
                        self.remoteVideoViewGroup[0].videoView.frame = viewFrame;
                        break;
                    case 1:
                        viewFrame = CGRectMake(viewFrameWidth, 0, viewFrameWidth,viewFrameHeight);
                        self.remoteVideoViewGroup[1].videoView.frame = viewFrame;
                        break;
                    case 2:
                        viewFrame = CGRectMake(0, viewFrameHeight, viewFrameWidth, viewFrameHeight);
                        self.remoteVideoViewGroup[2].videoView.frame = viewFrame;
                        break;
                    case 3:
                        viewFrame = CGRectMake(viewFrameWidth, viewFrameHeight, viewFrameWidth, viewFrameHeight);
                        self.remoteVideoViewGroup[3].videoView.frame = viewFrame;
                        break;
                    default:
                        break;
                }
            }
        } else {
            //self.remoteVideoView.videoView.frame = CGRectZero;
            self.remoteVideoView.videoView.frame = bounds;
        }
    }

    // Aspect fit local video view into a square box.
    CGRect localVideoFrame =
    CGRectMake(0, 0, kLocalVideoViewSize, kLocalVideoViewSize);
    if (self.isMultiPersons) {
        // Place the view in the bottom right.
        localVideoFrame.origin.x = CGRectGetMaxX(bounds)
        - localVideoFrame.size.width - kLocalVideoViewPadding;
        localVideoFrame.origin.y = CGRectGetMaxY(bounds)
        - localVideoFrame.size.height - kLocalVideoViewPadding*10;
        self.localVideoView.videoView.frame = localVideoFrame;
    } else {
        if (_remoteVideoSize.width > 0 && _remoteVideoSize.height > 0) {
            // Place the view in the top right.
            localVideoFrame.origin.x = CGRectGetMaxX(bounds)
            - localVideoFrame.size.width - kLocalVideoViewPadding;
            localVideoFrame.origin.y = CGRectGetMinY(bounds) + kLocalVideoViewPadding*2;
            self.localVideoView.videoView.frame = localVideoFrame;
        } else {
            // The remote video streaming don't still arrive.
//            float videoWidth = [UIScreen mainScreen].bounds.size.width;
//            float videoHeight = [UIScreen mainScreen].bounds.size.height;
//            CGRect localFrame = CGRectMake(0, 0, videoWidth, videoHeight);
//            localFrame.origin.x = CGRectGetMinX(bounds);
//            localFrame.origin.y = CGRectGetMinY(bounds);
//            AVMakeRectWithAspectRatioInsideRect(localFrame.size, bounds);
//            CGFloat scale = 1;
//            if (localFrame.size.width > localFrame.size.height) {
//                // Scale by height.
//                scale = bounds.size.height / localFrame.size.height;
//            } else {
//                // Scale by width.
//                scale = bounds.size.width / localFrame.size.width;
//            }
//            localFrame.size.height *= scale;
//            localFrame.size.width *= scale;
            self.localVideoView.videoView.frame = self.bounds;
        }
    }

    // Place stats at the top.
    CGSize statsSize = [_statsView sizeThatFits:bounds.size];
    _statsView.frame = CGRectMake(CGRectGetMinX(bounds),
                                  CGRectGetMinY(bounds) + kStatusBarHeight,
                                  statsSize.width, statsSize.height);

    // Place hangup button in the bottom left.
    _hangupButton.frame =
    CGRectMake(CGRectGetMinX(bounds) + kButtonPadding,
               CGRectGetMaxY(bounds) - kButtonPadding -
               kButtonSize,
               kButtonSize,
               kButtonSize);

    // Place button to the right of hangup button.
    CGRect cameraSwitchFrame = _hangupButton.frame;
    cameraSwitchFrame.origin.x =
    CGRectGetMaxX(cameraSwitchFrame) + kButtonPadding;
    _cameraSwitchButton.frame = cameraSwitchFrame;
    
    // Place route button to the right of camera button.
    CGRect routeChangeFrame = _cameraSwitchButton.frame;
    routeChangeFrame.origin.x =
    CGRectGetMaxX(routeChangeFrame) + kButtonPadding;
    _routeChangeButton.frame = routeChangeFrame;

    // Place mute micphone button to the right of route button.
    CGRect micPhoneFrame = _routeChangeButton.frame;
    micPhoneFrame.origin.x = CGRectGetMaxX(micPhoneFrame) + kButtonPadding;
    _muteMicPhone.frame = micPhoneFrame;
    
    // Place mute camera button to the right of mute micphone button.
    CGRect muteCameraFrame = _muteMicPhone.frame;
    muteCameraFrame.origin.x = CGRectGetMaxX(muteCameraFrame) + kButtonPadding;
    _muteCamera.frame = muteCameraFrame;

    // Place the show engine states button to the right of mute camera button.
    CGRect showEngineStatesFrame = _muteCamera.frame;
    showEngineStatesFrame.origin.x = CGRectGetMaxX(showEngineStatesFrame) + kButtonPadding;
    _engineStatesInfoShow.frame = showEngineStatesFrame;

    [_statusLabel sizeToFit];
    _statusLabel.center =
    CGPointMake(CGRectGetMidX(bounds), CGRectGetMidY(bounds));
}

#pragma mark - RTCEAGLVideoViewDelegate
- (void)remoteVideoView:(RTCRemoteVideoView *)videoView didChangeVideoSize:(CGSize)size {
    if (videoView == _remoteVideoView) {
        _remoteVideoSize = size;
    }
    [self setNeedsLayout];
}

#pragma mark - Private
- (void)onMicphoneChange:(id)sender {
    [_delegate videoCallViewDidMuteMicphone:self];
}

- (void)onCameraSwitch:(id)sender {
    [_delegate videoCallViewDidSwitchCamera:self];
}

- (void)onCameraChange:(id)sender {
    [_delegate videoCallViewDidMuteCamera:self];
}

- (void)onShowEngineStates:(id)sender {
    [_delegate videoCallViewDidEnableStats:self];
}

- (void)onRouteChange:(id)sender {
    [_delegate videoCallViewDidChangeRoute:self];
}

- (void)onHangup:(id)sender {
    [_delegate videoCallViewDidHangup:self];
}

- (void)onTapScreen:(UITapGestureRecognizer*)gesture {
    CGPoint point = [gesture locationInView:gesture.view];
    CGSize size = self.bounds.size;
    [_delegate videoCallViewDidTapScreen:point andPlaneSize:size];
    //[self setCameraFocusEffectWithPoint:point];
}

- (void)didTripleTap:(UITapGestureRecognizer *)recognizer {
    [_delegate videoCallViewDidEnableStats:self];
}

-(void)setCameraFocusEffectWithPoint:(CGPoint)point{
    self.cameraFocusView.center = point;
    self.cameraFocusView.hidden = NO;
    [UIView animateWithDuration:0.3 animations:^{
        self.cameraFocusView.transform = CGAffineTransformMakeScale(1.25, 1.25);
    }completion:^(BOOL finished) {
        [UIView animateWithDuration:0.5 animations:^{
            self.cameraFocusView.transform = CGAffineTransformIdentity;
        } completion:^(BOOL finished) {
            self.cameraFocusView.hidden = YES;
        }];
    }];
}

@end

