//
//  RTCVideoCallViewController.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/6.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RTCVideoCallViewController.h"
#import "RTCVideoCallView.h"
#import <BaiduRtcRoom/BaiduRtcRoomApiAudioSession.h>
#import <BaiduRtcRoom/RTCCameraVideoCapturer.h>

#include "BDCloudRTCBaseDefine.pch"
#import "RTCVideoUserInfoView.h"
#import "BDRtcUserListsViewController.h"
#import "RTCShareScreenController.h"
#import "RTCBroadcastExtensionLauncher.h"
#import "MBProgressHUD.h"
#import "RTCBoardCallViewController.h"

#import "UserRemoteManager.h"
#import "RTCSettingsModel.h"
#import <CoreTelephony/CTCall.h>
#import <CoreTelephony/CTCallCenter.h>
#import <GLKit/GLKit.h>

@interface RTCVideoCallViewController () <
    RTCVideoCallViewDelegate, RTCUserListsViewControllerDelegate,
    BaiduRtcRoomDelegate, BaiduRtcRoomApiAudioSessionDelegate,
    BaiduRtcApiAudioFrameDelegate,
    BRTCMediaRecorderDelegate,
    BaiduRtcAudioProcessDelegate
>
@property (nonatomic, readonly) RTCVideoCallView *videoCallView;
@property (nonatomic, copy) NSString *roomName;
@property (nonatomic, assign)  NSInteger userId;
@property (nonatomic, copy) NSString *appId;
@property (nonatomic, copy) NSString *tokenStr;
@property (nonatomic, strong) NSArray<NSNumber *> *streamingIds;
@property (nonatomic, assign) BOOL isSubscribedStreaming;
@property (nonatomic, strong) BaiduRtcRoomApi *rtcRoomApi;
@property (nonatomic, assign) BOOL isMultiPersons;
@property (nonatomic, copy) NSString *signalServerUrl;
@property (nonatomic, copy) NSString *mediaServerIp;
@property (nonatomic, assign) BOOL ismuteMicphone;
@property (nonatomic, assign) BOOL isSwitchSpeaker;
@property (nonatomic, assign) BOOL isScreenSharing;
@property (nonatomic, assign) RtcVoiceChangeType voiceChangeType;
@property (nonatomic, strong) NSMutableArray<RtcRoomAudioLevel *> *audioLevelArray;
@property (nonatomic, strong) RTCVideoUserInfoView *localUserInfoView;
@property (nonatomic, strong) UIImageView *localAudioBgView;
@property (nonatomic, strong) BDRtcUserListsViewController *userListController;
@property (nonatomic, copy) BRTCUserListViewConfig *userListConfig;
@property (nonatomic, assign) BOOL isNotRecall;
@property (nonatomic, assign) BOOL reCalling;
@property (nonatomic, assign) int reCallingCount;
@property (nonatomic, assign) BOOL hasDemoteAudio;
@property (nonatomic, strong) NSMutableDictionary *subscribeUserCtrol;
@property (nonatomic, assign) NSInteger updatePosCount;
@property (nonatomic, assign) NSInteger stressTestSequence;
@property (nonatomic, copy) NSString *stressTestString;
@property (nonatomic, assign) BOOL isDataChannelStressTesting;
@property (nonatomic, assign) int customMessageIndex;
@property (nonatomic, assign) BRTCRoleType currentRoleType;
@property (nonatomic, copy) NSNumber * currentRoomId;

/// 是否启用音频动态启停（当前 Demo 多场景耦合，部分功能需要结合房间当前状态决定是否启用）
@property (nonatomic, assign, readonly) BOOL shouldEnableForegroundAudioOnly;

@property (nonatomic, strong) BRTC_TYPE(RTCCameraVideoCapturer) *customVideoCapturer;

@property (strong, nonatomic) CTCallCenter *callCenter;
@property (nonatomic, strong) id<BaiduRtcVideoProcessManager> videoProcesssManager;
@property (nonatomic, strong) BRTCMediaRecorder *mediaRecorder;

@property (nonatomic, assign) uint64_t tsStartJoinTime;
@property (nonatomic, assign) uint64_t tsWebsocketOpenedElapseMs;
@property (nonatomic, copy) NSString *filePath;
@property (nonatomic, assign) BOOL isSubscribedScreen; //标记是否订阅屏幕流

// 录制
@property (nonatomic, assign) BRTCMediaRecorderType mediaRecordType;
@property (nonatomic, assign) BRTCMediaMixType      mediaRecordMixLayout;

// 超分
@property (nonatomic, assign) SrEnabledReason lastSrFailedReason;
@end

static int const userScreenShareUserId = 11221122;

@implementation RTCVideoCallViewController {
}

@synthesize videoCallView = _videoCallView;
@synthesize delegate = _delegate;

- (instancetype)initForRoom:(NSString *)room
                     userId:(NSString *)userId
                   delegate:(id<RTCVideoCallViewControllerDelegate>)delegate {
    if (self = [super init]) {
        _delegate = delegate;
        self.isSwitchSpeaker = YES;
        self.reCalling = false;
        self.reCallingCount = 0;
        self.isDataChannelStressTesting = false;
        self.stressTestSequence = 0;
        self.customMessageIndex = 0;
        self.stressTestString = nil;
        self.subscribeUserCtrol  =  [NSMutableDictionary dictionary];
        //判断用设置读取参数登陆房间
        if ([[RTCSettingsModel sharedInstance] currentServerHostSettingFromStore].length > 0 ) {
            self.signalServerUrl = [[RTCSettingsModel sharedInstance] currentServerHostSettingFromStore];
        }
        if ([[RTCSettingsModel sharedInstance] currentServerUserIdSettingFromStore].length > 0) {
            self.userId = [[[RTCSettingsModel sharedInstance] currentServerUserIdSettingFromStore] integerValue];
        } else {
            self.userId = [userId integerValue];
            [[RTCSettingsModel sharedInstance] storeServerUserIdSetting:userId];
        }
        NSLog(@"Login room with userID: %ld", (long)self.userId);
        self.roomName = room;
        self.isMultiPersons = YES;
        if ([[RTCSettingsModel sharedInstance] currentServerAppIdSettingFromStore].length > 0) {
            self.appId = [[RTCSettingsModel sharedInstance] currentServerAppIdSettingFromStore];
        } else {
            self.appId = BDCloudDefaultRTCAppID;
        }
        
        if ([[RTCSettingsModel sharedInstance] currentServerTokenSettingFromStore].length > 0 ) {
            self.tokenStr = [[RTCSettingsModel sharedInstance] currentServerTokenSettingFromStore];
        } else {
            self.tokenStr = BDCloudDefaultRTCAppToken;
        }
        self.currentRoleType = BRTC_ROLE_ANCHOR;
        //initialize sdk
        self.mediaServerIp = [[RTCSettingsModel sharedInstance] currentMediaServerIpSettingFromStore];
    }
    return self;
}
- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [[UserRemoteManager instance] remoteAllRemove];
    [self.rtcRoomApi logoutRtcRoom];
    self.rtcRoomApi = nil;
    NSLog(@"RTCViewCallViewController dealloc!");
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    [[UIApplication sharedApplication] setIdleTimerDisabled:YES];

    // app从后台进入前台都会调用这个方法
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationBecomeActive) name:UIApplicationDidBecomeActiveNotification object:nil];
    // 添加检测app进入后台的观察者
//    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationEnterBackground) name: UIApplicationDidEnterBackgroundNotification object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationWillResignActive) name:UIApplicationWillResignActiveNotification object:nil];

    self.callCenter = [[CTCallCenter alloc] init];
    __weak typeof(self) weakSelf = self;
    self.callCenter.callEventHandler = ^(CTCall *call) {
        dispatch_async(dispatch_get_main_queue(), ^{
            if ([call.callState isEqualToString:CTCallStateDisconnected]) {
                NSLog(@"CTCallCenter:Call has been disconnected");
                
            } else if ([call.callState isEqualToString:CTCallStateConnected]) {
                NSLog(@"CTCallCenter:Callhasjustbeen connected");
                if (weakSelf.isScreenSharing) {
                    [weakSelf stopShareScreen];
                }
                
            } else if ([call.callState isEqualToString:CTCallStateIncoming]) {
                NSLog(@"CTCallCenter:Call is incoming");
                if (weakSelf.isScreenSharing) {
                    [weakSelf stopShareScreen];
                }
                
            } else if ([call.callState isEqualToString:CTCallStateDialing]) {
                NSLog(@"CTCallCenter:Call is Dialing");
                
            } else {
                NSLog(@"CTCallCenter:Nothing is done");
                
            }
            
        });
   };
}

- (void)applicationBecomeActive {
    if (!self.shouldEnableForegroundAudioOnly) {
        return;
    }
    [self.rtcRoomApi enableLocalAudio:YES];
    [self.rtcRoomApi muteMicphone:_ismuteMicphone];
}

//- (void)applicationEnterBackground {
//    if (!self.shouldEnableForegroundAudioOnly) {
//        return;
//    }
//    [self.rtcRoomApi enableLocalAudio:NO];
//    [self.rtcRoomApi muteMicphone:YES];
//    [self.rtcRoomApi muteCamera];
//}

- (void)applicationWillResignActive {
    if (!self.shouldEnableForegroundAudioOnly) {
        return;
    }
    [self.rtcRoomApi enableLocalAudio:NO];
    [self.rtcRoomApi muteMicphone:YES];
}

- (void)viewDidDisappear:(BOOL)animated {
    [super viewDidDisappear:animated];
}

- (void)call {
    //enable log info
    BOOL enableVerbose = [[RTCSettingsModel sharedInstance] currentLogEnableVerboseSetting];
    [BaiduRtcRoomApi setVerbose:enableVerbose];
    //config parameters settings

    self.hasDemoteAudio = false;
    
    // reset vc states
    self.isScreenSharing = NO;
    
    self.rtcRoomApi = [[BaiduRtcRoomApi alloc] initSDKWithAppID:self.appId
                                                       tokenStr:self.tokenStr
                                                       delegate:self];
    
    RtcParameterSettings *rps = [[RtcParameterSettings alloc] init];
    rps.hasData = YES;
    
    rps.hasVideo = [[RTCSettingsModel sharedInstance] currentHasVideoSettingFromStore];
    rps.subscribeCount = [[[RTCSettingsModel sharedInstance] currentSubscribeCountSettingFromStore] intValue];
    rps.subscribeMode = kSubscribeModeManual;
    NSString* nsSubscribeMode = [[RTCSettingsModel sharedInstance] currentSubscribeModeSettingFromStore];
    if ([nsSubscribeMode isEqualToString:@"auto"]) {
        rps.subscribeMode = kSubscribeModeAuto;
    } else if ([nsSubscribeMode isEqualToString:@"meeting"]) {
        rps.subscribeMode = kSubscribeModeMeeting;
    }
    // 开启重构模式且开启1v1, 强制设置为手动订阅模式, 订阅人数设置为1
    if ([[RTCSettingsModel sharedInstance] currentCallMode1v1SettingFromStore]
        && [[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore]) {
        rps.subscribeMode = kSubscribeModeManual;
        rps.subscribeCount = 2;
    }
    rps.enableAutoReconnect = [[RTCSettingsModel sharedInstance] currentAutoReconnectFromStore];
    rps.isEnableFixedResolution = [[RTCSettingsModel sharedInstance] currentIsFixedResolutionSettingFromStore];
//    rps.enableThreadOptimize = YES;

    // 密钥交换方式
    NSString* nsEncryptMode = [[RTCSettingsModel sharedInstance] currentEncryptModeSettingFromStore];
    rps.keyExchangeMethod = kRTCKeyExchangeDTLS;
    if ([nsEncryptMode isEqualToString:@"KeyExchangeSDES"]) {
        rps.keyExchangeMethod = kRTCKeyExchangeSDES;
    } else if ([nsEncryptMode isEqualToString:@"KeyExchangeNONE"]) {
        rps.keyExchangeMethod = kRTCKeyExchangeNONE;
    }

    NSString* nsAudioCodec = [[RTCSettingsModel sharedInstance] currentAudioCodecSettingFromStore];
    rps.audioCodecType = RTC_AUDIO_ENCODE_TYPE_OPUS;
    if ([nsAudioCodec isEqualToString:@"amr-wb"]) {
        rps.audioCodecType = RTC_AUDIO_ENCODE_TYPE_AMRWB;
    } else if ([nsAudioCodec isEqualToString:@"pcmu"]) {
        rps.audioCodecType = RTC_AUDIO_ENCODE_TYPE_PCMU;
    } else if ([nsAudioCodec isEqualToString:@"pcma"]) {
        rps.audioCodecType = RTC_AUDIO_ENCODE_TYPE_PCMA;
    } else if ([nsAudioCodec isEqualToString:@"g722"]) {
        rps.audioCodecType = RTC_AUDIO_ENCODE_TYPE_G722;
    }

    rps.isAutoPublish = [[RTCSettingsModel sharedInstance] currentIsAutoPublishSettingFromStore];
    rps.isAutoSubscribe = [[RTCSettingsModel sharedInstance] currentIsAutoSubscribeSettingFromStore];

    rps.isEnableVideoPullDemote = [[RTCSettingsModel sharedInstance] currentIsVideoPullDemoteFromStore];

    // setting signal-channel mode
    NSNumber *signalMode = [[RTCSettingsModel sharedInstance] currentSignalModeFromStore];
    rps.signalChannelMode = (RtcSignalChannelMode)[signalMode integerValue];
    // 信令精简模式
    rps.enablePruneSignal = [[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore];
    if (rps.enablePruneSignal) {
        // 设置屏幕共享UserId
        rps.systemScreenShareUserId = userScreenShareUserId;
    }

        
    // 美颜。此处的 YES 仅表示该 BRTC 会话需要使用美颜能力
    rps.enableBeauty = YES;
    
    // 音频处理。此处的 YES 仅表示该 BRTC 会话需要使用音频处理能力
    rps.enableAudioProcess = YES;
    
    // 视频处理。此处的 YES 仅表示该 BRTC 会话需要使用视频水印处理能力
    rps.enableVideoProcess = YES;

    // 设置屏幕共享流的userName
    rps.systemScreenShareDisplayName = @"video_screen";
    
    // 是否自动订阅远端流
    rps.hasRemoteAudio = [[RTCSettingsModel sharedInstance] currentHasRemoteAudioSettingFromStore];
    rps.hasRemoteVideo = [[RTCSettingsModel sharedInstance] currentHasRemoteVideoSettingFromStore];

    // h263 sandbox report watch sli env setting
    rps.isEnableReportWatchSli = [[RTCSettingsModel sharedInstance] currentIsReportWatchSliFromStore];
//    if ([[[RTCSettingsModel sharedInstance] currentVideoCodecSettingFromStore] isEqualToString:@"H263"]
//        && rps.isEnableReportWatchSli) {
//        if (![[RTCSettingsModel sharedInstance] currentIsOnlineModeFromStore]) {
//            self.mediaServerIp = @"182.61.201.102";
//        }
//    }


    
//    rps.audioBitrate = 12;
    rps.audioBitrateMode = RTC_AUDIO_BITRATE_CBR;
    rps.enableMultiStream = [[RTCSettingsModel sharedInstance] currentIsMultiStreamModeFromStore];
    
    // video capture source
    if ([[RTCSettingsModel sharedInstance] currentCaptureExternalModeSettingFromStore]) {
        self.customVideoCapturer = [[BRTC_TYPE(RTCCameraVideoCapturer) alloc] init];
        [self.rtcRoomApi setVideoCapturer:self.customVideoCapturer];
    }
//    rps.isExportAudioRecord = YES;

    // audio capture sourece
    rps.isEnableExternalAudioDevice = NO;
    if (enableVerbose) {
        rps.enableLogPost = YES;
    }

    
    // 视频采集参数
    RtcVideoBaseParams *captureParams = [[RtcVideoBaseParams alloc] init];
    captureParams.videoFps = [[[RTCSettingsModel sharedInstance] currentVideoFpsSettingFromStore] intValue];
    captureParams.videoWidth = [[RTCSettingsModel sharedInstance] currentCaptureVideoResolutionWidthFromStore];
    captureParams.videoHeight = [[RTCSettingsModel sharedInstance] currentCaptureVideoResolutionHeightFromStore];
    rps.videoCaptureParams = captureParams;
    
    // 视频采集参数 - 前置摄像头
    BOOL frontCamera = [[RTCSettingsModel sharedInstance] currentUsingFrontCameraSettingFromStore];
    [self.rtcRoomApi setCameraFace:frontCamera];
    BOOL enableAutoUpdate = ![[RTCSettingsModel sharedInstance] currentLockCameraOrient];
    [self.rtcRoomApi enableCameraAutoUpdateOrientation:enableAutoUpdate];
    
    // 视频编码参数
    RtcVideoEncodeParams *videoParams = [[RtcVideoEncodeParams alloc] init];
    RtcVideoEncodeParams *screenVideoParams = [[RtcVideoEncodeParams alloc] init];
    videoParams.videoFps = [[[RTCSettingsModel sharedInstance] currentVideoFpsSettingFromStore] intValue]; //10;
    videoParams.videoWidth = [[RTCSettingsModel sharedInstance] currentVideoResolutionWidthFromStore];
    videoParams.videoHeight = [[RTCSettingsModel sharedInstance] currentVideoResolutionHeightFromStore];
    videoParams.gopSize = videoParams.videoFps * 2;

    videoParams.videoBitrate = [[[RTCSettingsModel sharedInstance] currentMaxBitrateSettingFromStore] intValue];
    videoParams.videoMinBitrate = [[[RTCSettingsModel sharedInstance] currentMinBitrateSettingFromStore] intValue];

    // setting codec
    if ([[[RTCSettingsModel sharedInstance] currentVideoCodecSettingFromStore] isEqualToString:@"H263"]) {
        videoParams.videoCodecType = RTC_VIDEO_ENCODE_TYPE_H263;
        captureParams.videoFps = 15;
        rps.videoCaptureParams = captureParams;
        rps.netEqMaxDelay = 400;
        rps.isEnableFec = false;
    } else if ([[[RTCSettingsModel sharedInstance] currentVideoCodecSettingFromStore] isEqualToString:@"JPEG"]) {
        videoParams.videoCodecType = RTC_VIDEO_ENCODE_TYPE_JPEG;
        captureParams.videoFps = 15;
        rps.videoCaptureParams = captureParams;
        rps.isEnableFec = false;
    } else if ([[[RTCSettingsModel sharedInstance] currentVideoCodecSettingFromStore] isEqualToString:@"H265"]) {
        videoParams.videoCodecType = RTC_VIDEO_ENCODE_TYPE_HEVC;
        screenVideoParams.videoCodecType = RTC_VIDEO_ENCODE_TYPE_HEVC;
    }
    // 屏幕分享视频参数
    screenVideoParams.videoFps = [RTCSettingsModel sharedInstance].currentScreenShareVideoFpsSettingFromStore.intValue;
    screenVideoParams.videoBitrate = [RTCSettingsModel sharedInstance].currentScreenShareMaxBitrateSettingFromStore.intValue;
    screenVideoParams.videoMinBitrate = [RTCSettingsModel sharedInstance].currentScreenShareMinBitrateSettingFromStore.intValue;
    screenVideoParams.videoWidth = [RTCSettingsModel sharedInstance].currentScreenShareVideoResolutionWidthFromStore;
    screenVideoParams.videoHeight = [RTCSettingsModel sharedInstance].currentScreenShareVideoResolutionHeightFromStore;
    screenVideoParams.gopSize = screenVideoParams.videoFps * 2;

    // 视频编码参数设置
    rps.videoEncodeParams = @{
        RTC_MEDIA_TARGET_VIDEO_DEFAULT: videoParams,
        RTC_MEDIA_TARGET_VIDEO_SCREEN: screenVideoParams
    };
//    rps.isExportAudioPlayout = YES;
//    [self.rtcRoomApi setAudioFrameDelegate:self];
    [self.rtcRoomApi setParamSettings:rps paramType:RTC_VIDEO_PARAM_SETTINGS_TARGET_ENCODE_DICT];
    
    // 视频上行降级策略
    {
        int val = [[RTCSettingsModel sharedInstance] currentVideoDegradationFromStore];
        RtcVideoDegradationPreference pref = nil;
        if (val == 0) pref = RTC_VIDEO_DEGRADATION_PREFERENCE_MAINTAIN_FRAMERATE;
        else if (val == 1) pref = RTC_VIDEO_DEGRADATION_PREFERENCE_MAINTAIN_RESOLUTION;
        else if (val == 2) pref = RTC_VIDEO_DEGRADATION_PREFERENCE_BALANCED;
        if (pref) {
            rps.degradationPreference = pref;
        }
    }
    
    //设置切后台视频流推流模式
    NSNumber *bgModeNum = [[RTCSettingsModel sharedInstance] currentCaptureVideoBgPushModeSettingFromStore];
    rps.videoBgPushMode = (RtcVideoBgPushMode)bgModeNum.integerValue;
    
    // 音频场景
    NSInteger audioProfile  = [RTCSettingsModel sharedInstance].currentAudioProfileSettingFromStore.integerValue;
    NSInteger audioScenario = [RTCSettingsModel sharedInstance].currentAudioScenarioSettingFromStore.integerValue;
    [self.rtcRoomApi setAudioProfile:(BRTCAudioProfileType)audioProfile
                             scenrio:(BRTCAudioScenario)audioScenario];
        
    //是否开启水印
    [self videoCallViewEnableWatermark:[[RTCSettingsModel sharedInstance] currentWaterMarkFromStore]];
    
    // 小度手表与APP偶现音频滋滋声
//    [self.rtcRoomApi muteMicphone:YES];
//    if (!_ismuteMicphone) {
//        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1.0 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
//            [self.rtcRoomApi muteMicphone:NO];
//        });
//    }
    
    // 质量监控上报
    rps.enableLogQualityMonitor = [[RTCSettingsModel sharedInstance] currentLogQualityMonitorSetting];
    rps.enableLogWeakNetQuality = [[RTCSettingsModel sharedInstance] currentLogWeakNetQualityReportSetting];
    [self.rtcRoomApi enableStatsToServer:YES qualityMonitorEnv:@"online"];
    if (self.mediaServerIp.length > 0) {
        [self.rtcRoomApi setMediaServerIp:self.mediaServerIp];
    }
    [self.rtcRoomApi setLocalDisplay:_videoCallView.localVideoView];
    [_videoCallView.localVideoView.videoView addSubview:self.localUserInfoView];
    _videoCallView.localVideoView.videoView.hidden = NO;
    
    if ([[RTCSettingsModel sharedInstance] currentHasVideoSettingFromStore]) {
        if (self.isMultiPersons) {
            NSLog(@"enable multi persions chat mode!");
            // [self.rtcRoomApi setRemoteDisplayGroup:_videoCallView.remoteVideoViewGroup];
        } else {
            NSLog(@"enable two persions chat mode!");
//            [self.rtcRoomApi setRemoteDisplay:_videoCallView.remoteVideoView];
        }
    }
    //configure live server(rtmp)
    RtcLiveAuidoVideoParameters* avParam = [RtcLiveAuidoVideoParameters new];
    avParam.sampleRate = 48000;
    //NSString *template = @"side_by_side_primary_720p_16_9";
    NSString *rtmpUrl = [[RTCSettingsModel sharedInstance] currentLiveUrlSettingFromStore];
    BOOL isMix = [[RTCSettingsModel sharedInstance] currentLiveMixSettingFromStore];
    BOOL isRecord = [[RTCSettingsModel sharedInstance] currentLiveRecordSettingFromStore];
    NSString *mixTemplate = [[RTCSettingsModel sharedInstance] currentLiveMixTemplateSettingFromStore];
    RtcLiveTransferMode transferMode;
    if ([[[RTCSettingsModel sharedInstance] currentLiveTransferModSettingFromStore]  isEqual:@"主播转推"]) {
        transferMode = RTC_LIVE_TRANSFER_MODE_ANCHOR_TRASNSMISSION;
    } else {
        transferMode = RTC_LIVE_TRANSFER_MODE_ROOM_TRANSMISSION;
    }
    [self.rtcRoomApi configLiveServerWithUrl:rtmpUrl
                                       isMix:isMix
                                 isRecording:isRecord
                                 mixTemplate:mixTemplate
                                transferMode:transferMode
                                     avParam:avParam];
    
    //Using random number as userId to be convenient for test
    //setting audio sessionsr
    [self.rtcRoomApi setAudioSessionDelegate:self];
    if ([self.signalServerUrl length] > 0) {
        [self.rtcRoomApi setSignalServerWithUrl:self.signalServerUrl];
    }
    BOOL isCompulsive = [[RTCSettingsModel sharedInstance] currentCompulsiveModeSettingFromStore];
    self.tsStartJoinTime = [[self currentTime] unsignedLongLongValue];
    [self.rtcRoomApi presetLoudSpeaker:YES];
    [self.rtcRoomApi setEngineStateStatistics:true];
    [self.rtcRoomApi setParamSettings:rps paramType:RTC_PARAM_SETTINGS_ALL];

//    [self.rtcRoomApi setRemoteMediainfo:@"v=BRTC.RTOS.SDK V3.0.4B02 ASR&vc=h263&vp=176x144&ac=amr-wb"];
//    [self.rtcRoomApi setRemoteMediainfo:@"v=BRTC.RTOS.SDK V3.0.6B02 ESP32S3&ac=pcmu"];
    LoginOptions *options = [[LoginOptions alloc] init];
    options.isCompulsive = isCompulsive;
    options.roleType = self.currentRoleType;
    [self.rtcRoomApi loginRtcRoomWithRoomName:self.roomName
                                           userID:self.userId
                                      displayName:@"James"
                                      options:options];
    if (rps.enableBeauty) {
        self.videoCallView.beautyManager = [self.rtcRoomApi getRtcBeautyManager];
    }
    if (rps.enableAudioProcess) {
        [self videoCallViewDidSelectVoiceChangeType:(int)self.voiceChangeType];
    }
    
}

- (void)onAudioSessionDidBeginInterruption {
    NSLog(@"onAudioSessionDidBeginInterruption");
}

- (void)onAudioSessionDidEndInterruption {
    NSLog(@"onAudioSessionDidEndInterruption");
}

- (void)loadView {
    _videoCallView = [[RTCVideoCallView alloc] initWithFrame:CGRectZero uid:self.userId sdkVersion:[BaiduRtcRoomApi version]];
    _videoCallView.delegate = self;
    _videoCallView.statusLabel.text = [self statusTextForState:RTC_CONNECTION_STATE_CONNECTING];
//    [_videoCallView updateRouteChangeStatus:self.isSwitchSpeaker];

    self.view = _videoCallView;
    self.videoCallView.statsView.hidden = NO;
    [self call];
}

- (RTCVideoUserInfoView *)localUserInfoView {
    if (!_localUserInfoView) {
        _localUserInfoView = [[RTCVideoUserInfoView alloc] initWithFrame:CGRectMake(5, 0, 200, 40)];
    }
    return _localUserInfoView;
}

- (UIImageView *)localAudioBgView {
    if (!_localAudioBgView) {
        _localAudioBgView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"default_photo.png"]];
    }
    return  _localAudioBgView;
}

- (void)setupVolume:(NSArray<RtcRoomAudioLevel *> *)audioLevels {
    if (!audioLevels.count) return;
    if (!self.audioLevelArray) {
        _audioLevelArray = [NSMutableArray arrayWithCapacity:4];
    }
    [self.audioLevelArray removeAllObjects];
    [self.audioLevelArray addObjectsFromArray:audioLevels];
    
    for (RtcRoomAudioLevel *audioLevel in self.audioLevelArray) {
        if (self.userId == [audioLevel.userID integerValue]) {
            [self.localUserInfoView setupUserId:self.userId volume:audioLevel.volumeLevel];
        }
    }
    
    NSArray *arr = [[UserRemoteManager instance] remoteSubScribedUsers];
    for (RTCRemoteVideoViewInfo *videoInfo  in arr) {
         if (videoInfo.videoView) {
             NSInteger userId = videoInfo.videoView.userId;
             for (RtcRoomAudioLevel *audioLevel in self.audioLevelArray) {
                 if (userId == [audioLevel.userID integerValue]) {
                     [videoInfo.userInfoView setupUserId:userId volume:audioLevel.volumeLevel];
                 }
             }
         }
    }
}

- (void)setupUserID {
    [self.localUserInfoView setupUserId:self.userId volume:-1];
    
    NSArray *arr = [[UserRemoteManager instance] remoteSubScribedUsers];
    for (RTCRemoteVideoViewInfo *videoInfo in arr) {
        if (!videoInfo.videoView) continue;
        [videoInfo.userInfoView setupUserId:videoInfo.videoView.userId volume:-1];
    }
}

- (BOOL)shouldEnableForegroundAudioOnly {
    // 如果有业务在后台时需要持续推音频，在这里添加判断逻辑
    return YES;
}

#pragma mark - RTCVideoCallViewDelegate
- (void)videoCallViewDidRemoteviewDisappear:(BOOL)disappear remoteUid:(NSString*)userId {
    [self.rtcRoomApi setRemoteVideoPlayState:!disappear userId:[userId longLongValue]];
}

- (void)videoCallAudoDidRemoteviewDisappear:(BOOL)disappear remoteUid:(NSString*)userId {
    [self.rtcRoomApi setRemoteAudioPlayState:!disappear userId:[userId longLongValue]];
}

- (void)videoCallViewDidMuteMicphone:(RTCVideoCallView *)view {
    _ismuteMicphone = !_ismuteMicphone;
    [self.rtcRoomApi muteMicphone:_ismuteMicphone];
}

- (void)videoCallViewDidHangup:(RTCVideoCallView *)view {
    NSLog(@"Click hangup botton!");
    [self hangup];
}

- (void)videoCallViewDidSwitchCamera:(RTCVideoCallView *)view {
    [self.rtcRoomApi switchCamera];
}

- (void)videoCallViewDidMuteCamera:(RTCVideoCallView *)view mute:(BOOL)mute {
    [self.rtcRoomApi muteCamera:mute];
}

- (void)onShowEngineStates:(id)sender {
    [self.rtcRoomApi setEngineStateStatistics:YES];
}

- (void)videoCallViewDidChangeRoute:(RTCVideoCallView *)view {
    _isSwitchSpeaker = !_isSwitchSpeaker;
    BRTCAudioScenario audioScenario = [self.rtcRoomApi getParamSettings].audioScenario;
    if (audioScenario == BRTC_AUDIO_SCENARIO_MUSIC ||
        audioScenario == BRTC_AUDIO_SCENARIO_METAVERSE) {
        [self showToastMessage:@"媒体场景不支持切换扬声器"];
    } else {
        [self.rtcRoomApi switchLoundSpeaker];
    }
}

- (void)videoCallViewDidEnableStats:(RTCVideoCallView *)view show:(BOOL)show {
    [self.rtcRoomApi setEngineStateStatistics:show];
    self.videoCallView.statsView.hidden = !show;
}

- (void)videoCallViewDidTapScreen:(CGPoint)point andPlaneSize:(CGSize)size {
    [self.rtcRoomApi cameraFocusWithPoint:point andPlaneSize:size];
}

- (void)videoCallViewDidShareScreenClicked:(RTCVideoCallView *)view {
    if (self.isScreenSharing) {
        [self stopShareScreen];
    } else {
        [RTCShareScreenController showShareScreenLauncherInVC:self completion:^(RTCShareScreenType type) {
            if (type == RTCShareScreenTypeNone) return;
            if (type == RTCShareScreenTypeInApp) {
                [self startShareAppScreen];
            } else {
                [self startShareSystemScreen];
            }
        }];
    }
}

- (void)stopShareScreen {
    [self.rtcRoomApi stopShareScreen];
}

- (void)startShareAppScreen {
    if (@available(iOS 11.0, *)) {
        [self.rtcRoomApi startShareAppScreen];
    } else {
        [self showToastMessage:@"系统版本不支持应用内共享"];
    }
}

- (void)startShareSystemScreen {
    if (@available(iOS 11.0, *)) {
        
        // You can set custom system screen share userid before starting
//        RtcParameterSettings *rps = [[RtcParameterSettings alloc] init];
//        rps.systemScreenShareUserId = 11221122;
        
        // App Group is not used by now, but we keep it as a parameter for later version using
        NSString *appGroup = @"group.com.baidu.rtcapp.ReplayKit";
        [self.rtcRoomApi startShareSystemScreenWithAppGroup:appGroup];
        
        if (@available(iOS 12.0, *)) {
            // Launch system broadcast extension
            [RTCBroadcastExtensionLauncher launch];
        } else {
            // prompt user to launch in Control Center
        }
    }
}

//called when room relay
- (void) videoCallViewRoomDelayRoomStart:(NSString*)newRoom userRelay:(NSInteger)userId relay:(RelayOperateType)rot {

    NSInteger realId = userId == 0 ? self.userId : userId;
    switch (rot) {
        case RELAY_START:
            [self.rtcRoomApi startRoomMediaRelay:newRoom userId:realId token:@""];
            break;
        case RELAY_STOP:
            [self.rtcRoomApi stopRoomMediaRelay:newRoom userId:realId];
            break;
        case RELAY_STOP_ALL:
            [self.rtcRoomApi stopRoomMediaRelayAll];
        default:
            break;
    }
}

//called when room relay
- (void) videoCallViewRoomDelayRoomEnd:(NSString*)newRoom {
    [self.rtcRoomApi stopRoomMediaRelay:newRoom userId:self.userId];
}

//禁言某人
- (void)videoCallViewShutUpUserWithId:(NSString *)userId isDisable:(BOOL)isDisable {
    NSString *title = isDisable ? @"解除禁言" : @"禁言";
    NSString *message = [NSString stringWithFormat:@"您确定要将用户%@%@吗", userId, title];
    [self showAlertWithMessage:message title:title confirmHandler:^(UIAlertAction *action) {
        [self.rtcRoomApi shutUpUserWithId:[userId integerValue] isDisable:isDisable];
    }];
}

//移出某人
- (void)videoCallViewKickOffUserWithId:(NSString *)userId {
    NSString *message = [NSString stringWithFormat:@"您确定要将用户%@移出此房间吗", userId];
    [self showAlertWithMessage:message title:@"移出" confirmHandler:^(UIAlertAction *action) {
        [self.rtcRoomApi kickOffUserWithId:[userId integerValue]];
    }];
}

//全部禁言
- (void)videoCallViewShutupAllUser {
    [self showAlertWithMessage:@"您确定要将此房间所有用户禁言吗" title:@"移出" confirmHandler:^(UIAlertAction *action) {
        NSArray *arr = [self.rtcRoomApi queryMessageUserListOfRoom];
        for (RtcRoomUserInfo *user in arr) {
            [self.rtcRoomApi shutUpUserWithId:[user.userID integerValue] isDisable:NO];
        }
    }];
}

//解散房间
- (void)videoCallViewDisbandRoom {
    [self showAlertWithMessage:@"您确定要将此房间解散吗" title:@"移出" confirmHandler:^(UIAlertAction *action) {
        [self.rtcRoomApi disbandRoom];
    }];
}

- (void)videoCallViewShowSpeakerStatus {
    BOOL isOn = [self.rtcRoomApi isSpeakerOn];
    NSString *msg = [NSString stringWithFormat:@"扬声器状态: %@", (isOn ? @"开启" : @"关闭")];
    [self showToastMessage:msg];
}

- (void)videoCallViewSwitchRole {
    if (!self.rtcRoomApi) {
        return;
    }
    if (self.currentRoomId == nil) {
        return;
    }
    
    if (self.currentRoleType == BRTC_ROLE_ANCHOR) {
        /** 切换观众 */
        [self.rtcRoomApi switchRole:BRTC_ROLE_AUDIENCE];
        self.currentRoleType = BRTC_ROLE_AUDIENCE;
    } else {
        /** 切换主播 */
        [self.rtcRoomApi switchRole:BRTC_ROLE_ANCHOR];
        self.currentRoleType = BRTC_ROLE_ANCHOR;
    }
}


//发送消息给某人
- (void)videoCallViewSendMessage:(NSString *)message toUser:(NSString *)userId {
    int result = -1;
    if ([[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore]) {
        result = [self.rtcRoomApi sendMessage:message withUserId:[NSNumber numberWithInteger:[userId integerValue]]];
    } else if ([[RTCSettingsModel sharedInstance] currentIsMessageModeChannelDataFromStore]) {
        result = [self.rtcRoomApi sendMessage:message];
    } else {
        result = [self.rtcRoomApi sendMessage2WithUserId:message userId:[NSNumber numberWithInteger:[userId integerValue]]];
    }
    NSLog(@"发送消息给某人结果：%d", result);
    if (result == 0) {
        [self.videoCallView displayLogMessage:[NSString stringWithFormat:@"[signalChannnel] 我 to %@：%@", userId, message]];
    }
}

//发送消息
- (void)videoCallViewSendMessage:(NSString *)message {
    int result = -1;
    if ([[RTCSettingsModel sharedInstance] currentIsMessageModeChannelDataFromStore]) {
        result = [self.rtcRoomApi sendMessage:message];
    } else {
        result = [self.rtcRoomApi sendMessage2:message];
    }
    NSLog(@"发送消息结果：%d", result);
    if (result == 0) {
        [self.videoCallView displayLogMessage:[NSString stringWithFormat:@"[signalChannnel] 我：%@", message]];
    }
}

// DataChannel压力测试
- (void)videoCallViewSendStressDataChannel:(BOOL)isStart frequency:(int)frequency bps:(int)bps reliable:(BOOL)reliable {
    if ([[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore]) {
        self.isDataChannelStressTesting = isStart;
        if (isStart) {
            if (bps <= 8 || bps > 1024) {
                bps = 200;
            }
            if (self.stressTestString == nil) {
                self.stressTestString = [self getRandStringWithLength:(bps / 8)];
            }
            if (frequency <= 0 || frequency > 10000) {
                frequency = 1000;
            }
            float ffrequency = 1.0f / frequency;
            NSLog(@"vocs datachannel stress test:开始, reliable:%@, %dbps, frequency:(%d, %.3f), sequence:%d", reliable ? @"yes" : @"no", bps, frequency, ffrequency, (int)self.stressTestSequence);
            [self sendStressDataChannel:ffrequency frequency:frequency isReliable:reliable];
        } else {
            NSLog(@"vocs datachannel stress test:停止");
            self.stressTestSequence = 0;
        }
    }
}

- (void)sendStressDataChannel:(float)ffrequency frequency:(int)frequency isReliable:(BOOL)isReliable {
    if (self.isDataChannelStressTesting) {
        NSString *message = [NSString stringWithFormat:@"{sequence:%ld, time:%@, data:%@}", self.stressTestSequence, [self currentDateStr], self.stressTestString];
        if (isReliable) {
            [self.rtcRoomApi sendMessage2:message];
        } else {
            [self.rtcRoomApi sendMessage:message];
        }
        self.stressTestSequence++;
        if (self.stressTestSequence % frequency == 0) {
            NSLog(@"vocs datachannel stress sequence:%d", (int)self.stressTestSequence);
        }
        __weak typeof(self) weakSelf = self;
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(ffrequency * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            __strong typeof(self) strongSelf = weakSelf;
            [strongSelf sendStressDataChannel:ffrequency frequency:frequency isReliable:isReliable];
        });
    } else {
        self.stressTestSequence = 0;
    }
}

- (NSString *)getRandStringWithLength:(int)length {
    NSString *sourceStr = @"0123456789abcdefghijklmnopqrstuvwxyz";
    NSMutableString *resultStr = [[NSMutableString alloc] init];

    for (int i = 0; i < length; i++) {
        unsigned index = arc4random() % [sourceStr length];
        NSString *oneStr = [sourceStr substringWithRange:NSMakeRange(index, 1)];
        [resultStr appendString:oneStr];
    }
    return resultStr;
}

//获取当前时间
- (NSString *)currentDateStr {
    NSDate *currentDate = [NSDate date];//获取当前时间，日期
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];// 创建一个时间格式化对象
    [dateFormatter setDateFormat:@"YYYY/MM/dd hh:mm:ss SS "];//设定时间格式,这里可以设置成自己需要的格式
    NSString *dateString = [dateFormatter stringFromDate:currentDate];//将时间转化成字符串
    return dateString;
}

- (NSArray *)queryStreamUserList {
    NSArray *userArr = [self.rtcRoomApi queryMessageUserListOfRoom];
    NSMutableArray *userStreamArr = [NSMutableArray arrayWithCapacity:2];
    for (RtcRoomUserInfo *userInfo in userArr) {
        if (userInfo.streaming && (userInfo.userID.integerValue != kDefaultSystemScreenShareUserId
        && userInfo.userID.integerValue != userScreenShareUserId)) {
            [userStreamArr addObject:userInfo];
        }
    }
    return userStreamArr;
}

- (void)videoCallViewSubribeStream:(NSString *)streamId {
    
    NSArray *userStreamArr = [self queryStreamUserList];
    if ([[RTCSettingsModel sharedInstance] currentCallMode1v1SettingFromStore]) {
        if (userStreamArr.count >= 2) {
            NSLog(@"此房间为1V1通话，不能订阅");
            return;
        }
    }
   NSInteger number = [[RTCSettingsModel sharedInstance] currentCallMode1v1SettingFromStore] ? 2 :BDSiglePageNumber;
    if (userStreamArr.count >= number) {
        if ([[RTCSettingsModel sharedInstance] currentCallMode1v1SettingFromStore]) {
            NSLog(@"此房间为1V1通话，不能订阅");
        } else {
            NSLog(@"此房间已经超过9人，不能订阅");
        }
        return;
    }
    NSArray<NSString *> *streamIds = [streamId componentsSeparatedByString:@","];
    if (streamIds.count > (number - userStreamArr.count)) {
        streamIds = [streamIds subarrayWithRange:NSMakeRange(0, number - userStreamArr.count)];
    }
    NSMutableArray *arr = [NSMutableArray arrayWithCapacity:2];
    for (NSString *userId in streamIds) {
        [arr addObject:[NSNumber numberWithInteger:[userId integerValue]]];
    }
    [self innerStartSubscribestring:arr];
}

- (void)videoCallViewUpdateSubribeStream:(NSString *)streamId {
    NSArray<NSString *> *streamIds = [streamId componentsSeparatedByString:@","];
    NSMutableArray *arr = [NSMutableArray arrayWithCapacity:2];
    for (NSString *userId in streamIds) {
        [arr addObject:[NSNumber numberWithInteger:[userId integerValue]]];
    }
    [self innerUpdateSubscribestring:arr];
}

- (void)innerStartSubscribestring:(NSArray *)arr {
    [self.rtcRoomApi subsribeStreaming:arr];
}

- (void)innerUpdateSubscribestring:(NSArray *)arr {
    int position = self.updatePosCount++ % 4;
    float horiAngle;
    float vertAngle;
    float distance = 0.5f;
    switch (position) {
        case 0:  //正右方
            horiAngle = 0.0f;
            vertAngle = 0.0f;
            break;
        case 1:  //正前方
            horiAngle = 90.0f;
            vertAngle = 0.0f;
            break;
        case 2:  //正左方
            horiAngle = 180.0f;
            vertAngle = 0.0f;
            break;
        case 3:  //正后方
            horiAngle = 270.0f;
            vertAngle = 0.0f;
            break;
        default:  //正右方
            horiAngle = 0.0f;
            vertAngle = 0.0f;
            break;
    }
    NSLog(@"更新订阅流位置 hori_angle:%f, vert_angle:%f, distance:%f", horiAngle, vertAngle, distance);
//    [self.rtcRoomApi updateSubsribeStreaming:arr hori_angle:horiAngle vert_angle:vertAngle distance:distance near_vol:2 mixer_vol:1];
}

- (void)innerStopSubscribestreaming:(NSArray *)arr {
    [self.rtcRoomApi stopSubscribeStreaming:arr];
}

//取消订阅流
- (void)videoCallViewCancelSubribeStream:(NSString *)streamId {
    NSArray<NSString *> *streamIds = [streamId componentsSeparatedByString:@","];
    NSMutableArray *arr = [NSMutableArray arrayWithCapacity:2];
    for (NSString *userId in streamIds) {
        [arr addObject:[NSNumber numberWithInteger:[userId integerValue]]];
    }
    [self innerStopSubscribestreaming:arr];
}

- (void)videocallViewNotifyKickoff {
    [self hangup];
}

- (void)videoCallViewScreenParamsUpdated:(BRTCScreenShareParams *)params {
    if (!params) return;
    int ret = [self.rtcRoomApi updateScreenShareParams:params];
    if (ret == -1) {
        [self showToastMessage:@"当前没有屏幕分享"];
    }
}

- (void)videoCallViewScreenSnapshot {
    RTCRemoteVideoViewInfo *videoInfo = [[UserRemoteManager instance] shareScreenVideoViewInfo];
    if (videoInfo) {
        [self rtcRoomSnapshot:videoInfo.userId mediaTarget:RTC_MEDIA_TARGET_VIDEO_SCREEN];
    } else {
        [self showToastMessage:@"当前没有屏幕分享"];
    }
}

- (void)videoCallViewEnableSuperResolution:(BOOL)enableSR {
    NSArray *arr = [[UserRemoteManager instance] remoteSubScribedUsers];
    for (RTCRemoteVideoViewInfo *videoInfo  in arr) {
         if (videoInfo.videoView) {
             videoInfo.videoView.enableSR = enableSR;
             videoInfo.videoView.srTargetFps = [[[RTCSettingsModel sharedInstance] currentVideoFpsSettingFromStore] floatValue];
         }
    }
}

- (void)videoCallViewEnableManualPushStream:(BOOL)enablePush {
    NSLog(@"videoCallViewEnableManualPushStream, %d", enablePush);
    if ([[RTCSettingsModel sharedInstance] currentIsAutoPublishSettingFromStore]) {
        return;
    }
    
    if (enablePush) {
        [self.rtcRoomApi publishStreaming];
    } else {
        BOOL enablePruneSignal = [[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore];
        [self.rtcRoomApi stopPublishStreaming:!enablePruneSignal];
    }
}

- (void)videoCallViewSuperResolutionEnabled:(BOOL)enabled reason:(SrEnabledReason)reason {
    if (!enabled && reason != _lastSrFailedReason) {
        if (reason == SrReasonFpsTooLow) {
            [self showToastMessage:@"超分未开启,原因：预期帧率过低"];
        } else {
            [self showToastMessage:@"超分未开启,原因：系统错误"];
        }
    }
    _lastSrFailedReason = reason;
}

- (void)videoCallViewEnableWatermark:(BOOL)enableWatermark {
    BRTCWatermarkParam *imageParam = [[BRTCWatermarkParam alloc] init];
    imageParam.watermarkType = BRTCWatermarkTypeImage;
    NSString *path = [[NSBundle mainBundle] pathForResource:@"Logo_180_180" ofType:@"png"];
    imageParam.watermarkResource = path;
    imageParam.rect = CGRectMake(10, 10, 180, 180);
    
    BRTCWatermarkParam *textParam = [[BRTCWatermarkParam alloc] init];
    textParam.watermarkType = BRTCWatermarkTypeText;
    textParam.watermarkResource = @"百度音视频通话!";
    textParam.textColor = [UIColor redColor];
    textParam.rect = CGRectMake(10, 200, 500, 40);
    
    BRTCWatermarkParam *timeParam = [[BRTCWatermarkParam alloc] init];
    timeParam.watermarkType = BRTCWatermarkTypeTime;
    timeParam.watermarkResource = @"yyyy-MM-dd\nHH:mm:ss";
    timeParam.textColor = [UIColor greenColor];
    timeParam.rect = CGRectMake(10, 360, 500, 40);
    
    self.videoProcesssManager = [self.rtcRoomApi getRtcVideoProcessManager];
    BRTCWatermarkParams *params = [[BRTCWatermarkParams alloc] init];
    params.params = @[imageParam, textParam, timeParam];
    
    [self.videoProcesssManager enableWatermark:enableWatermark watermarkParams:params];
}

- (void)videoCallViewLockCameraOrient:(BOOL)lock {
    BOOL enableAutoUpdate = !lock;
    [self.rtcRoomApi enableCameraAutoUpdateOrientation:enableAutoUpdate];
    [self.rtcRoomApi setCameraOutputOrientation:UIDeviceOrientationPortrait];
}

- (void)videoCallViewEnableAudioVolumeIndication:(BOOL)enable interval:(int)interval {
    [self.rtcRoomApi enableAudioVolumeIndication:enable interval:interval];
    if (!enable) {
        [self setupUserID];
    }
}

- (void)videoCallViewRecordTypeDidChange:(int)type {
    self.mediaRecordType = (BRTCMediaRecorderType)type;
}

- (void)videoCallViewRecordMixLayoutDidChange:(int)layout {
    self.mediaRecordMixLayout = (BRTCMediaMixType)layout;
}

- (void)videoCallViewStartRecorderMedia {
    
    BRTCVideoRecordParam *videoParam = [[BRTCVideoRecordParam alloc] init];
    videoParam.videoFps = [[[RTCSettingsModel sharedInstance] currentVideoFpsSettingFromStore] intValue];
    videoParam.videoWidth = [[RTCSettingsModel sharedInstance] currentVideoResolutionWidthFromStore];
    videoParam.videoHeight = [[RTCSettingsModel sharedInstance] currentVideoResolutionHeightFromStore];
    videoParam.videoBitrate = 1.5 * 1024; //[[[RTCSettingsModel sharedInstance] currentMaxBitrateSettingFromStore] intValue];
    
    BRTCAudioRecordParam *audioParam = [[BRTCAudioRecordParam alloc] init];
    audioParam.sampleRate = 48000;
    
    self.mediaRecorder = [self.rtcRoomApi getRtcMediaRecorder];
    [self.mediaRecorder setMediaRecorderDelegate:self];
    BRTCMediaRecordParam *param = [[BRTCMediaRecordParam alloc] init];
    
    NSString *path = [[NSSearchPathForDirectoriesInDomains(NSCachesDirectory, NSUserDomainMask, YES) firstObject] stringByAppendingPathComponent:@"LocalRecord.mp4"];
    self.filePath = path;
    
    if (!self.mediaRecordType) {
        self.mediaRecordType = BRTCMediaRecorderTypeBoth;
    }
    
    param.savePath = path;
    param.type = self.mediaRecordType;
    param.mixType = self.mediaRecordMixLayout;
    param.format = BRTCMediaRecorderContainerFormat_MP4;
    
    param.videoParam = videoParam;
    param.audioParam = audioParam;
    [self.mediaRecorder startRecordWithParam:param];
}

- (void)videoCallViewStopRecorderMedia {
    if (self.mediaRecorder) {
        [self.mediaRecorder stopRecord];
    }
}

- (void)videoCallViewStartPlayerMediaWithLoopback:(BOOL)loopback cycle:(NSUInteger)cycle {
    BRTCAudioMixingParams *params = [BRTCAudioMixingParams new];
    params.filePath = [[NSBundle mainBundle] pathForResource:@"mozart" ofType:@".mp3"];
    params.loopback = loopback;
    params.cycle = cycle;
    
    id<BaiduRtcAudioProcessManager> audioProcess = self.rtcRoomApi.getRtcAudioProcessManager;
    [audioProcess setAudioProcessDelegate:self];
    int ret = [audioProcess startAudioMixing:params];
    if (ret) {
        NSLog(@"[AudioMix] start err: %@", @(ret));
    }
}

- (void)videoCallViewPausePlayerMedia {
    id<BaiduRtcAudioProcessManager> audioProcess = self.rtcRoomApi.getRtcAudioProcessManager;
    int ret = [audioProcess pauseAudioMixing];
    if (ret) {
        NSLog(@"[AudioMix] pause err: %@", @(ret));
    }
}

- (void)videoCallViewResumePlayerMedia {
    id<BaiduRtcAudioProcessManager> audioProcess = self.rtcRoomApi.getRtcAudioProcessManager;
    int ret = [audioProcess resumeAudioMixing];
    if (ret) {
        NSLog(@"[AudioMix] resume err: %@", @(ret));
    }
}

- (void)videoCallViewStopPlayerMedia {
    id<BaiduRtcAudioProcessManager> audioProcess = self.rtcRoomApi.getRtcAudioProcessManager;
    int ret = [audioProcess stopAudioMixing];
    if (ret) {
        NSLog(@"[AudioMix] stop err: %@", @(ret));
    }
}

#pragma mark - User List

- (NSArray *)rtcViewQueryUserListOfRoom {
    return [self.rtcRoomApi queryMessageUserListOfRoom];
}

- (NSArray<NSNumber *> *)userIDsFromUsers:(NSArray<RtcRoomUserInfo *> *)users excludeSelf:(BOOL)excludeSelf {
    if (!users) return @[];
    NSMutableArray *userIDs = [NSMutableArray array];
    for (RtcRoomUserInfo *user in users) {
        if (excludeSelf && user.userID.integerValue == self.userId) {
            continue;
        }
        [userIDs addObject:user.userID];
    }
    return userIDs;
}

#pragma mark RTCUserListsViewControllerDelegate
- (void)userListOperationCallBack:(UserListOperateType) userOP arr:(NSArray *_Nullable)userInfo streamType:(int)streamType info:(id)info {
    NSLog(@"user operation: %@", @(userOP));
    NSArray<NSNumber *> *userIDs = [self userIDsFromUsers:userInfo excludeSelf:YES];
  
    switch (userOP) {
        case USER_MUTE_VIDEO:
            [self muteUsers:userIDs isAudio:NO isVideo:YES isMute:YES];
            break;
        case USER_UNMUTE_VIDEO:
            [self muteUsers:userIDs isAudio:NO isVideo:YES isMute:NO];
            break;
        case USER_MUTE_AUDIO:
            [self muteUsers:userIDs isAudio:YES isVideo:NO isMute:YES];
            break;
        case USER_UNMUTE_AUDIO:
            [self muteUsers:userIDs isAudio:YES isVideo:NO isMute:NO];
            break;
        case USER_MUTE_VIDEO_ALL:
            [self muteAllUsersIsAudio:NO isVideo:YES isMute:YES];
            break;
        case USER_UNMUTE_VIDEO_ALL:
            [self muteAllUsersIsAudio:NO isVideo:YES isMute:NO];
            break;
        case USER_MUTE_AUDIO_ALL:
            [self muteAllUsersIsAudio:YES isVideo:NO isMute:YES];
            break;
        case USER_UNMUTE_AUDIO_ALL:
            [self muteAllUsersIsAudio:YES isVideo:NO isMute:NO];
            break;
        case USER_SUBSCRIBE_ALL:
            [self subscribeAllUsers:YES streamType:streamType];
            break;
        case USER_UNSUBSCRIBE_ALL:
            [self subscribeAllUsers:NO streamType:streamType];
            break;
        case USER_PUBLISH:
            [self.rtcRoomApi publishStreaming];
            break;
        case USER_UNPUBLISH: {
            BOOL enablePruneSignal = [[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore];
            [self.rtcRoomApi stopPublishStreaming:!enablePruneSignal];
            break;
        }
        case USER_SUBSCRIBE:
            [self.rtcRoomApi subsribeStreaming:userIDs];
            break;
        case USER_UNSUBSCRIBE:
            [self.rtcRoomApi stopSubscribeStreaming:userIDs];
            break;
        case USER_VOLUME: {
            NSArray<NSNumber *> *volumeUserIDs = [self userIDsFromUsers:userInfo excludeSelf:NO];
            [self setUserVolume:volumeUserIDs.firstObject volume:((NSNumber *)info).floatValue];
            return;
        }
        default:
            NSLog(@"on operation");
    }
    
    [self updateUserList];
}

- (void)updateUserList {
    NSMutableArray *arrOrig = [[self rtcViewQueryUserListOfRoom] mutableCopy];
    NSMutableArray *arrCopy = [[self rtcViewQueryUserListOfRoom] mutableCopy];
    if ([arrOrig count] > 0) {
        [arrOrig removeObjectAtIndex:0];
    }
    if ([arrOrig count] > 0) {
        NSSortDescriptor * desc = [[NSSortDescriptor alloc] initWithKey:@"streaming" ascending:NO];
        NSMutableArray *arrSort = [[arrOrig sortedArrayUsingDescriptors:@[desc]] mutableCopy];
        [arrSort insertObject:arrCopy[0] atIndex:0];
        [_userListController UserListOfRoomChanged:arrSort];
    } else {
        [_userListController UserListOfRoomChanged:arrCopy];
    }
}

- (void)setUserVolume:(NSNumber *)userID volume:(float)volume {
    if (userID.integerValue == self.userId) {
        [self.rtcRoomApi setLocalAudioCaptureVolume:volume];
    } else {
        [self.rtcRoomApi setRemoteAudioPlayVolume:volume userId:userID.integerValue];
    }
}

- (void)muteUsers:(NSArray<NSNumber *> *)userIDs isAudio:(BOOL)isAudio isVideo:(BOOL)isVideo isMute:(BOOL)isMute {
    for (NSNumber *userID in userIDs) {
        if (isAudio) {
            [self videoCallAudoDidRemoteviewDisappear:isMute remoteUid:userID.stringValue];
        }
        if (isVideo) {
            [self videoCallViewDidRemoteviewDisappear:isMute remoteUid:userID.stringValue];
        }
    }
}

- (void)muteAllUsersIsAudio:(BOOL)isAudio isVideo:(BOOL)isVideo isMute:(BOOL)isMute {
    NSArray *users = [self rtcViewQueryUserListOfRoom];
    NSArray<NSNumber *> *userIDs = [self userIDsFromUsers:users excludeSelf:YES];
    [self muteUsers:userIDs isAudio:isAudio isVideo:isVideo isMute:isMute];
}

- (void)subscribeAllUsers:(BOOL)isSubscribe streamType:(int)type {
    if (type == 1) { // 仅音频
        if (isSubscribe) {
            [self.rtcRoomApi subscribeAllRemoteAudioStreams];
        } else {
            [self.rtcRoomApi stopSubscribeAllRemoteAudioStreams];
        }
    } else if (type == 2) { // 仅视频
        if (isSubscribe) {
            [self.rtcRoomApi subscribeAllRemoteVideoStreams];
        } else {
            [self.rtcRoomApi stopSubscribeAllRemoteVideoStreams];
        }
    } else { // 音视频
        NSArray *arr = [self rtcViewQueryUserListOfRoom];
        NSArray<NSNumber *> *allUserIDs = [self userIDsFromUsers:arr excludeSelf:YES];
        if (isSubscribe) {
            [self.rtcRoomApi subsribeStreaming:allUserIDs];
        } else {
            [self.rtcRoomApi stopSubscribeStreaming:allUserIDs];
        }
    }
}

- (void)createUserList {
    if (!self.userListConfig) {
        self.userListConfig = [BRTCUserListViewConfig new];
        self.userListConfig.subscribeMode = kSubscribeModeManual;
        if ([[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore]) {
            NSString* nsSubscribeMode = [[RTCSettingsModel sharedInstance] currentSubscribeModeSettingFromStore];
            if ([nsSubscribeMode isEqualToString:@"auto"]) {
                self.userListConfig.subscribeMode = kSubscribeModeAuto;
            } else if ([nsSubscribeMode isEqualToString:@"meeting"]) {
                self.userListConfig.subscribeMode = kSubscribeModeMeeting;
            }
        }
    }
}

- (void)userListInvoke {
    [self createUserList];
    _userListController = [[BDRtcUserListsViewController alloc] initWithDelegate:self config:self.userListConfig];
    [self updateUserList];
    
    UINavigationController *navigationController = [[UINavigationController alloc] initWithRootViewController:_userListController];

    //UIModalPresentationStyle
    navigationController.modalPresentationStyle = UIModalPresentationCustom;
    //UIModalTransitionStyleCoverVertical
    navigationController.modalTransitionStyle = UIModalTransitionStyleCrossDissolve;
    [self presentViewControllerAsModal:navigationController];
}

- (void)whiteBoardInvoke {
    RTCBoardParam *param = [[RTCBoardParam alloc] init];
    param.channelName = self.roomName;
    param.appId = self.appId;
    param.token = self.tokenStr;
    param.uid = self.userId;
    param.audience = [[RTCSettingsModel sharedInstance] currentBoardAudienceFromStore];
    param.url = BDCloudDefaultRTCBoardUrl;

    RTCBoardCallViewController *whiteBoardVC = [[RTCBoardCallViewController alloc] initWithRTCBoardParam:param];
    [self presentViewController:whiteBoardVC animated:YES completion:nil];
}

- (void)presentViewControllerAsModal:(UIViewController *)viewController {
    [self presentViewController:viewController animated:YES completion:nil];
}

- (void)videoCallViewNotifyShutup:(BOOL)isShutuped {
    
}

- (void)image:(UIImage *)image didFinishSavingWithError:(NSError *)error contextInfo:(void *)contextInfo{
    if (error) {
        [self showToastMessage:[NSString stringWithFormat:@"截图失败: %ld", error.code]];
    } else {
        [self showToastMessage:@"截图成功"];
    }
}

- (void)videoCallSnapShotStart:(NSInteger)userId {
    [self rtcRoomSnapshot:userId mediaTarget:RTC_MEDIA_TARGET_VIDEO_DEFAULT];
}

- (void)videoCallViewDidSelectVoiceChangeType:(int)type {
    id<BaiduRtcAudioProcessManager> audioProcess = self.rtcRoomApi.getRtcAudioProcessManager;
    [audioProcess setVoiceChangeEnabled:(type != 0)];
    [audioProcess setVoiceChangeType:(RtcVoiceChangeType)type];
    self.voiceChangeType = (RtcVoiceChangeType)type;
}

- (NSNumber *)currentTime {
    NSTimeInterval time = [[NSDate date] timeIntervalSince1970] * 1000;
    return [NSNumber numberWithUnsignedLongLong:(uint64_t) time];
}

#pragma mark - Private

- (void)rtcRoomSnapshot:(NSInteger)userId mediaTarget:(RtcMediaTarget)mediaTarget {
    __weak id weakSelf = self;
    [self.rtcRoomApi takeVideoSnapshot:userId mediaTarget:mediaTarget completionBlock:^(UIImage *image, RtcErrorCodes errCode) {
        dispatch_async(dispatch_get_main_queue(), ^{
            if (image && !errCode) {
                UIImageWriteToSavedPhotosAlbum(image, weakSelf, @selector(image:didFinishSavingWithError:contextInfo:), NULL);
            } else {
                [self image:nil didFinishSavingWithError:[NSError errorWithDomain:NSCocoaErrorDomain code:errCode userInfo:nil] contextInfo:nil];
            }
        });
    }];
}

- (void)hangup {
    [self.rtcRoomApi stopPublishStreaming:true];
    [self.rtcRoomApi logoutRtcRoom];
    //self.rtcRoomApi = nil;
    [_delegate viewControllerDidFinish:self];
}

- (NSString *)statusTextForState:(NSInteger)state {
    switch (state) {
        case RTC_CONNECTION_STATE_CONNECTING:
            return @"Connecting...";
        case RTC_CONNECTION_STATE_CONNECTED:
            break;
        case RTC_CONNECTION_STATE_DISCONNECTED:
            return @"Failed...";
        default:
            break;
    }
    return nil;
}

- (MBProgressHUD *)showToastMessage:(NSString *)message {
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    hud.detailsLabel.text = message;
    hud.mode = MBProgressHUDModeText;
    hud.removeFromSuperViewOnHide = YES;
    [hud hideAnimated:YES afterDelay:1];
    return hud;
}

- (void)showErrorMessageAndExit:(NSString*)message {
    MBProgressHUD *hud = [self showToastMessage:message];
    hud.completionBlock = ^{
        [self dismissViewControllerAnimated:YES completion:^{
            NSLog(@"dismissViewControllerAnimated =");
        }];
    };
}

- (void)showAlertWithMessage:(NSString *)message title:(NSString *)title confirmHandler:(void (^ __nullable)(UIAlertAction *action))handler {
    UIAlertController *vc = [UIAlertController alertControllerWithTitle:@"提示" message:message preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *cancel = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
    }];
    UIAlertAction *confirm = [UIAlertAction actionWithTitle:title style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        if (handler) {
            handler(action);
        }
    }];
    
    [vc addAction:cancel];
    [vc addAction:confirm];
    [self presentViewController:vc animated:YES completion:nil];
}

#pragma mark -- reCall
- (void) releaseStats {
    [self.videoCallView.statsView resetResource];
}
- (void) reCall {
 
    BOOL autoReconnect = [[RTCSettingsModel sharedInstance] currentAutoReconnectFromStore];
    if (autoReconnect) {
        NSLog(@"SDK internal reconnect!");
        return;
    }
    
    if (self.isNotRecall || self.reCalling) {
        return;
    }
    self.reCalling = YES;
    dispatch_async(dispatch_get_main_queue(), ^{
        NSLog(@"start recall --------------");
        self.reCallingCount++;
        [self releaseStats];
        [self.rtcRoomApi logoutRtcRoom];
        //sleep(5);
        [[UserRemoteManager instance] remoteAllRemove];
        [self call];
        [self.videoCallView recall];
        NSLog(@"end  recall  --------------");
        self.reCalling = NO;
    });
   
}

- (void)onNotifyRenderStepEvent:(int)stepId {
    // NSLog(@"onNotifyRenderStepEvent: %d", stepId);
    uint64_t elapseMs = [[self currentTime] unsignedLongLongValue] - self.tsStartJoinTime;
    [_videoCallView.statsView setRenderStepTs:stepId result:0 time:elapseMs];
//    if (stepId == RTC_RENDER_STEP_BRTCUP) {
//        [_videoCallView.statsView setRenderStepTs:RTC_RENDER_STEP_WEBSOCKET_OPENED
//                                           result:0
//                                             time:self.tsWebsocketOpenedElapseMs];
//    }
}

- (void)destroyRtcVideoRoom {
    if (self.rtcRoomApi) {
        [self.rtcRoomApi logoutRtcRoom];
        self.rtcRoomApi = nil;
        NSLog(@"destroyRtcVideoRoom");
    }
}
#pragma mark -- baidu rtc room elegate
- (void)onLoginSuccess:(NSNumber *)roomId uid:(long)uid elapsed:(int)elapsed {
    NSLog(@"onLoginSuccess, roomID:%@, uid:%ld, elapsed:%d", roomId, uid, elapsed);
    self.currentRoomId = roomId;
    [self onNotifyRenderStepEvent:RTC_RENDER_STEP_USER_JOINED];

    if ([[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore]) {
        NSString* nsEncryptMode = [[RTCSettingsModel sharedInstance] currentEncryptModeSettingFromStore];
        BOOL is1v1 = [[RTCSettingsModel sharedInstance] currentCallMode1v1SettingFromStore];
        _videoCallView.statsView.roomAttribute = [NSString stringWithFormat:@"%@, %@, %d, %@, %@, reset:%d", roomId,
                                    [[RTCSettingsModel sharedInstance] currentSubscribeModeSettingFromStore],
                                    [[[RTCSettingsModel sharedInstance] currentSubscribeCountSettingFromStore] intValue],
                                    [nsEncryptMode substringFromIndex:11], is1v1 ? @"1v1" : @"1vN", self.reCallingCount];
    } else {
        _videoCallView.statsView.roomAttribute = [NSString stringWithFormat:@"%@", roomId];
    }
}

- (void)onUserDisShutUp:(NSInteger)uid {
    NSLog(@"onUserDisShutUp, uid:%ld", uid);
    if (self.userId == uid) {
        [self showToastMessage:@"您已被解除禁言"];
    }
}

- (void)onUserShutUp:(NSInteger)uid {
    NSLog(@"onUserShutUp, uid:%ld", uid);
    if (self.userId == uid) {
        [self showToastMessage:@"您已被禁言"];
    }
}

- (void)onRoomDisbanded {
    NSLog(@"onRoomDisbanded");
    [self.rtcRoomApi logoutRtcRoom];
    [self showErrorMessageAndExit:@"disband room"];
}

- (void)onUserKickOff:(NSInteger)uid {
    NSLog(@"onUserKickOff, uid:%ld", uid);
    if (self.userId == uid) {
        self.isNotRecall = YES;
        [self showErrorMessageAndExit:@"您已被移出房间"];
        [self destroyRtcVideoRoom];
    }
    NSLog(@"kick off");
}

- (void)onRemoteUserJoinRoom:(NSInteger)uid userName:(NSString *)userName {
    NSLog(@"onRemoteUserJoinRoom user joined: %ld, name:%@", uid, userName);
    if (![[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore]) {
        //动态分配显示的view 按照id分配显示
        [[UserRemoteManager instance] remoteUserJoin:uid];

        //如果有用户列表后台更新
        if (_userListController) {
            [self updateUserList];
        }
    }
    [_videoCallView.statsView startRecvStats];
}

- (void)onRemoteUserLeaveRoom:(NSInteger)uid userName:(NSString *)userName {
    NSLog(@"onRemoteUserLeaveRoom user leaving: %ld, name:%@", uid, userName);

    RTCRemoteVideoViewInfo *videoInfo = [[UserRemoteManager instance] remoteUserQuery:uid];
    if (!videoInfo) {
        return;
    }
    if (videoInfo.videoView) {
        [videoInfo.videoView.videoView removeFromSuperview]; //从主页面移除
    }
    [[UserRemoteManager instance] remoteUserSubStatus:uid subscribe:NO];
    [self.videoCallView updateSubView:nil  uid:uid add:NO];

    
    [_videoCallView.statsView resetRecvStats];
    [[UserRemoteManager instance] remoteUserLeave:uid];

}

- (void)onConnectionStateChanged:(NSInteger)state reason:(NSInteger)reason {
    NSLog(@"onConnectionStateChanged, state:%ld, reason:%ld", state, reason);
    __weak RTCVideoCallViewController *weakSelf = self;
    dispatch_async(dispatch_get_main_queue(), ^{
        RTCVideoCallViewController *strongSelf = weakSelf;
        strongSelf.videoCallView.statusLabel.text =
        [strongSelf statusTextForState:state];
    });
    
    if (state == RTC_CONNECTION_STATE_CONNECTED) {
        NSLog(@"onConnectionStateChanged connected!");
    }
}

- (void)onMediaStreamStateChange:(BOOL)uplink state:(NSInteger)state {
    NSLog(@"onMediaStreamStateChange, uplink:%d, state:%d", uplink, (int)state);

    if (state == RTC_MEDIA_STREAM_CONNECTED_STATE) {
        NSLog(@"onMediaStreamStateChange, uplink:%d RTC_MEDIA_STREAM_CONNECTED_STATE", uplink);
        if (!uplink) {
            [self onNotifyRenderStepEvent:RTC_RENDER_STEP_BRTCUP];
 
        }
    } else if (state == RTC_MEDIA_STREAM_DISCONNECTED_STATE) {
        NSLog(@"onMediaStreamStateChange, uplink:%d RTC_MEDIA_STREAM_DISCONNECTED_STATE", uplink);
    }
}

- (void)onRemoteUserVideoAvailable:(NSInteger)uid desc:(NSString *)desc available:(BOOL)available {
    NSLog(@"onRemoteUserVideoAvailable, uid:%ld, desc:%@, available:%d", uid, desc, available);
}

- (void)onRemoteUserAudioAvailable:(NSInteger)uid desc:(NSString *)desc available:(BOOL)available {
    NSLog(@"onRemoteUserAudioAvailable, uid:%ld, desc:%@, available:%d", uid, desc, available);
}

- (void)onSendMediaState:(BRTCMediaType)type state:(int)state {
    NSLog(@"onSendMediaState, type:%ld, state:%d", type, state);
}

- (void)onPullRemoteState:(NSInteger)uid netState:(int)netState demoteState:(int)demoteState {
    if ([[RTCSettingsModel sharedInstance] currentIsVideoPullDemoteFromStore]) {
        if (demoteState == DEMOTE_AUDIO) {
            self.hasDemoteAudio = true;
        } else if (demoteState == DEMOTE_SRC_VIDEO) {
            self.hasDemoteAudio = false;
        }
        NSString *networkState;
        if (self.hasDemoteAudio) {
            networkState = [NSString stringWithFormat:@"当前下行网络状态： %d, 已降级音频", netState];
        } else {
            networkState = [NSString stringWithFormat:@"当前下行网络状态： %d", netState];
        }
        [_videoCallView.statsView setNetworkDemoteState:networkState];
    }
}

- (void)onError:(NSInteger)errCode errMsg:(NSString *)errMsg extInfo:(nullable NSDictionary*)extInfo {
    NSLog(@"onError, code:%d, msg:%@, %@", (int)errCode, errMsg, extInfo);
    [self showErrorMessageAndExit:errMsg];
}
- (void)onWarning:(NSInteger)warningCode warningMsg:(NSString *)warnMsg extInfo:(nullable NSDictionary*)extInfo {
    NSLog(@"onWarning, code:%d, msg:%@, %@", (int)warningCode, warnMsg, extInfo);
}
- (void)onFirstVideoFrame:(NSInteger)uid width:(int)width height:(int)height {
    NSLog(@"onFirstVideoFrame, uid:%ld ,%dx%d", uid, width, height);
    [self onNotifyRenderStepEvent:RTC_RENDER_STEP_FIRST_FRAME];
}

- (void)onVideoStreamChangedState:(NSInteger)uid userName:(NSString *)userName desc:(NSString *)desc state:(NSInteger)state {
    NSLog(@"onVideoStreamChangedState, uid:%ld, name:%@, desc:%@, state:%d", uid, userName, desc, (int)state);
    if (state == RTC_STREAM_ADD) {
        NSLog(@"onVideoStreamChangedState, add_stream uid:%ld, name:%@, desc:%@, state:%d", uid, userName, desc, (int)state);
        [self onAddStream:uid userName:userName desc:desc];
    } else if (state == RTC_STREAM_REMOVE) {
        NSLog(@"onVideoStreamChangedState, remove_stream uid:%ld, name:%@, desc:%@, state:%d", uid, userName, desc, (int)state);
        [self onRemoveStream:uid userName:userName desc:desc];
    }
    if (_userListController) {
        [self updateUserList];
    }
}

- (void)onAudioStreamChangedState:(NSInteger)uid userName:(NSString *)userName desc:(NSString *)desc state:(NSInteger)state {
    NSLog(@"onAudioStreamChangedState, uid:%ld, name:%@, desc:%@, state:%d", uid, userName, desc, (int)state);
}
    
- (void)onAddStream:(NSInteger)uid userName:(NSString *)userName desc:(NSString *)desc {
    // 屏幕流在流到达状态变化时独立处理视图
    if ([desc isEqualToString:RTC_MEDIA_TARGET_AUDIO_SCREEN]) {
    } else if ([desc isEqualToString:RTC_MEDIA_TARGET_VIDEO_SCREEN]) {
        
        [[UserRemoteManager instance] remoteUserScreenVideoArrived:YES userId:uid];
        RTCRemoteVideoViewInfo *videoInfo = [[UserRemoteManager instance] shareScreenVideoViewInfo];
        [self.rtcRoomApi setRemoteDisplay:videoInfo.videoView userId:uid mediaTarget:desc];
//                [self.videoCallView updateShareScreenView:videoInfo.videoView uid:videoInfo.videoView.userId add:YES];
        [self.videoCallView updateSubView:videoInfo.videoView uid:[[NSString stringWithFormat:@"6666%ld", uid] integerValue] add:YES];
        [self.videoCallView enableShareScreenBtn:NO];
        
    } else {
        // reconstruct mode: setup remote view from RTC_ROOM_EVENTS_USEREVENTS_USER_JOINED to here
        if ([[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore]) {
            [[UserRemoteManager instance] remoteUserJoin:uid];
        }
        RTCRemoteVideoViewInfo *videoInfo = [[UserRemoteManager instance] remoteUserQuery:uid];
        if (videoInfo) {
            [self.rtcRoomApi setRemoteDisplay:videoInfo.videoView userId:uid];
            videoInfo.videoView.userId = uid;
        }
        // 更新视图 uid
        [self setupUserID];
        [[UserRemoteManager instance] remoteUserSubStatus:uid subscribe:YES];
        
        //重新布局UI 在 videoCallView中实现的
        [self.videoCallView updateSubView:videoInfo.videoView uid:videoInfo.videoView.userId add:YES];
        
        //是否开启超分
        [self videoCallViewEnableSuperResolution:[[RTCSettingsModel sharedInstance] currentSuperResolutionFromStore]];
    }
}

- (void)onRemoveStream:(NSInteger)uid userName:(NSString *)userName desc:(NSString *)desc {
    // 屏幕流在流到达状态变化时独立处理视图
    if ([desc isEqualToString:RTC_MEDIA_TARGET_AUDIO_SCREEN]) {
    } else if ([desc isEqualToString:RTC_MEDIA_TARGET_VIDEO_SCREEN]) {
        
        RTCRemoteVideoViewInfo *videoInfo = [[UserRemoteManager instance] shareScreenVideoViewInfo];
        [[UserRemoteManager instance] remoteUserScreenVideoArrived:NO userId:uid];
        [self.rtcRoomApi setRemoteDisplay:nil userId:uid mediaTarget:desc];
//                [self.videoCallView updateShareScreenView:videoInfo.videoView uid:videoInfo.videoView.userId add:NO];
        [self.videoCallView enableShareScreenBtn:YES];
        [self.videoCallView updateSubView:videoInfo.videoView uid:[[NSString stringWithFormat:@"6666%ld", uid] integerValue] add:NO];
        
    } else {
        RTCRemoteVideoViewInfo *videoInfo = [[UserRemoteManager instance] remoteUserQuery:uid];
        if (!videoInfo) {
            return;
        }
        if (videoInfo.videoView) {
            [videoInfo.videoView.videoView removeFromSuperview]; //从主页面移除
        }
        [[UserRemoteManager instance] remoteUserSubStatus:uid subscribe:NO];
        [self.videoCallView updateSubView:videoInfo.videoView  uid:uid add:NO];

        // reconstruct mode: remove remote view
        if ([[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore]) {
            [[UserRemoteManager instance] remoteUserLeave:uid];
        }
    }
}

- (void)onEngineStatisticsInfo:(NSArray *)statistacs {
    _videoCallView.statsView.stats = statistacs;
    [_videoCallView setNeedsLayout];
}

- (void)onNetworkQuality:(NSUInteger)uid txQuality:(RtcNetworkQuality)txQuality rxQuality:(RtcNetworkQuality)rxQuality {
    if ([[RTCSettingsModel sharedInstance] currentIsVideoPullDemoteFromStore]) {
        NSLog(@"onNetworkQuality:%lu txQuality:%d, rxQuality:%d", uid, (int)txQuality, (int)rxQuality);
    }
}

- (void)onTextMessageArrival:(RtcMessageInfo *)msg {
    if ([[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore]) {
        // data channel压力测试开启,默认不开启,开启日志打印太多会导致发送到接收延时加大
        if ([[RTCSettingsModel sharedInstance] currentIsVideoPullDemoteFromStore]) {
            if (self.customMessageIndex % 200 == 0) {
                NSLog(@"vocs The demo receiving text message(%d): %@ from user", self.customMessageIndex, msg.message);
            }
            self.customMessageIndex++;
        } else {
            // data channel压力测试不开启view展示
            NSLog(@"The demo receiving text message: %@ from user", msg.message);
            [self.videoCallView displayLogMessage:[NSString stringWithFormat:@"[datachannel] %@：%@", msg.userId, msg.message]];
        }
    } else {
        NSLog(@"The demo receiving text message: %@ from user", msg.message);
        [self.videoCallView displayLogMessage:[NSString stringWithFormat:@"[datachannel] %@：%@", msg.userId, msg.message]];
    }
}

- (void)onTextMessageArrival2:(RtcMessageInfo *)msg {
    NSLog(@"The demo receiving text message2: %@ from user %@", msg.message, msg.userId);
//    NSArray *array = [self.rtcRoomApi queryMessageUserListOfRoom];
//    int count = 0;
//    for (RtcRoomUserInfo *userInfo in array) {
//        NSString *str = [NSString stringWithFormat:@"testing data channel, sending text data. %d", count];
//            [self.rtcRoomApi sendMessage2WithUserId:str userId:userInfo.userID];
//        count++;
//    }
//    [self.rtcRoomApi sendMessage2:@"testing data channel, sending text data !!!"];
    [self.videoCallView displayLogMessage:[NSString stringWithFormat:@"[signalChannnel] %@：%@", msg.userId, msg.message]];
}

- (void)onTextMessageAttribute:(NSNumber *)userID attribute:(NSString *)attribute {
    NSLog(@"onTextMessageAttribute, userID: %@, attribute: %@", userID, attribute);
}

- (void)onShareScreenStartComplete:(int)errCode {
    NSLog(@"csq | onShareScreenStartComplete: err %@", @(errCode));
    if (!errCode) {
        self.isScreenSharing = YES;
    }
}

- (void)onShareScreenStopped:(int)reason {
    NSLog(@"csq | onShareScreenStopped: reason %@", @(reason));
    self.isScreenSharing = NO;
}

- (void)onAudioVolumeIndication:(NSArray<RtcRoomAudioLevel *> *)audioLevels {
    [self setupVolume:audioLevels];
}

- (int)getRandomNumber:(int)from to:(int)to {
    return (int)(from + (arc4random() % (to - from + 1)));
}

- (void)onRecvSEIMsg:(NSInteger)uid message:(NSData *)message {
    NSString *str = [[NSString alloc] initWithData:message encoding:NSUTF8StringEncoding];
    NSLog(@"onRecvSEIMsg uid:%lu, message:%@", uid, str);
}

- (void)onSwitchRole:(NSInteger)error errMsg:(NSString *)errMsg {
    NSLog(@"onSwitchRole error:%lu, errMsg:%@", error, errMsg);
    if (error == NO_ERR) {
        if (self.currentRoleType == BRTC_ROLE_AUDIENCE) {
            // 观众角色
            _videoCallView.localVideoView.videoView.hidden = YES;
            [self showToastMessage:@"onSwitchRole audience succ"];
        } else {
            // 观众角色
            _videoCallView.localVideoView.videoView.hidden = NO;
            [self showToastMessage:@"onSwitchRole anchor succ"];
        }
    } else {
        if (errMsg) {
            [self showToastMessage:errMsg];
        } else {
            [self showToastMessage:@"onSwitchRole fail"];
        }
    }
}

- (void)onVideoRenderStuckStart:(NSInteger)userId {
    NSLog(@"onVideoRenderStuckStart userId: %lu", userId);
}

- (void)onVideoRenderStuckEnd:(NSInteger)userId duration:(NSInteger)duration {
    NSLog(@"onVideoRenderStuckEnd userId: %lu, duration: %lums", userId, duration);
}

#pragma mark -- BDRtcUserListsViewControllerdelegate
- (void)viewControllerDidFinish:(BDRtcUserListsViewController *)viewController {
    if (![viewController isBeingDismissed]) {
        NSLog(@"Dismissing VC");
        [self dismissViewControllerAnimated:YES completion:^{
            //[self restartAudioPlayerIfNeeded];
            self.userListConfig = self.userListController.config;
            self.userListController = nil;
        }];
    }
}

#pragma mark - BaiduRtcAudioProcessDelegate

- (void)brtcAudioProcess:(BaiduRtcAudioProcessManager *)manager audioMixingStateChanged:(BRTCAudioMixingState)state error:(BRTCAudioMixingErrorCode)error {
    NSLog(@"[AudioMix] state changed: %@, error: %@", @(state), @(error));
}

#pragma mark -- BaiduRtcRoomApiAudioSessionDelegate
- (void)onAudioSessionDidStartPlayOrRecord {
    //NSLog(@"Audio session start play or record.");
}

- (void)onAudioSessionDidStopPlayOrRecord {
    //NSLog(@"Audio session stop play or record.");
}

#pragma mark -- BaiduRtcApiAudioFrameDelegate
/**
 音频录制回调
 
 @param audioData SDK 录制的音频源数据
 @param sampleRate 音频采样率
 @param numOfChannels 通道数量，单通道
 @param bitDepth 位深度，16 bit
 @param type 音源类型，参考 BaiduAPIAudioRecordMask
 @discussion 开启音频录制并设置成功代理对象后，用户调用此 API 获取 SDK 录制的音频数据。用户可自行对数据进行处理，例如：存储等。SDK 发送音频数据的周期为 20ms。存储数据时注意取 sampleRate、numOfChannels、bitDepth 参数写包头信息。退出房间后或停止录制后，该回调不再被调用
 */
- (void)onAudioFrame:(NSData *)audioData
           sampleRate:(int)sampleRate
        numOfChannels:(int)numOfChannels
             bitDepth:(int)bitDepth
            timeStamp:(uint64_t)timeStamp
                 type:(int)type {
    if (type == BRTC_AUDIO_PLAYOUT_FRAME_TYPE) {
        NSLog(@"onAudioFrame type:%d, data:%@, %d %d %d, timestamp:%llu", type, audioData, sampleRate, numOfChannels, bitDepth, timeStamp);
    }
}

//录制状态回调
- (void)brtcMediaRecorder:(BRTCMediaRecorder* _Nonnull)recorder stateDidChanged:(BRTCMediaRecorderState)state error:(BRTCMediaRecorderErrorCode)error {
    if (state == BRTCMediaRecorderStateStart) {
        self.videoCallView.settingPanel.mediaRecordState = 1;
        return;
    }
    
    if (state == BRTCMediaRecorderStateStop) {
        if (error == BRTCMediaRecorderErrorCode_Success) {
            [self shareMediaRecordCompletedFile:self.filePath];
        } else {
            NSString *errStr = [NSString stringWithFormat:@"录制结束出错: %@", @(error)];
            if (error == BRTCMediaRecorderErrorCode_OverTime) {
                [self shareMediaRecordCompletedFile:self.filePath];
                NSLog(@"[Recorder] %@", errStr);
                return;
            }
            dispatch_async(dispatch_get_main_queue(), ^{
                [self showToastMessage:errStr];
            });
            NSLog(@"[Recorder] %@", errStr);
        }
        self.videoCallView.settingPanel.mediaRecordState = 0;
        return;
    }
    
    if (state == BRTCMediaRecorderStateError) {
        NSString *errStr = [NSString stringWithFormat:@"录制出错: %@", @(error)];
        [self showToastMessage:errStr];
        self.videoCallView.settingPanel.mediaRecordState = 0;
    }
}

//录制信息更新
- (void)brtcMediaRecorder:(BRTCMediaRecorder* _Nonnull)recorder informationDidUpdated:(BRTCMediaRecorderInfo* _Nonnull)info {
    NSLog(@"录制信息更新: durationMs = %ld; fileSize = %f", info.durationMs, info.fileSize);
}

- (void)shareMediaRecordCompletedFile:(NSString *)filePath {
    if (!filePath.length) return;
    NSURL *url = [NSURL fileURLWithPath:filePath];
    NSArray *objects = @[url];
    [self presentActivityItemViewController:objects];
}

- (void)presentActivityItemViewController:(NSArray *)objects {
    if (!objects.count) return;
    dispatch_async(dispatch_get_main_queue(), ^{
        UIActivityViewController *controller = [[UIActivityViewController alloc] initWithActivityItems:objects applicationActivities:nil];
        NSArray *excludedActivities = @[UIActivityTypePostToTwitter, UIActivityTypePostToFacebook, UIActivityTypePostToWeibo, UIActivityTypeMessage, UIActivityTypeMail, UIActivityTypePrint, UIActivityTypeCopyToPasteboard, UIActivityTypeAssignToContact, UIActivityTypeSaveToCameraRoll, UIActivityTypeAddToReadingList, UIActivityTypePostToFlickr, UIActivityTypePostToVimeo, UIActivityTypePostToTencentWeibo];
        controller.excludedActivityTypes = excludedActivities;
        [self presentViewController:controller animated:YES completion:nil];
    });
}

@end
