//
//  RTCVideoCallViewController.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/6.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RTCVideoCallViewController.h"
#import "RTCVideoCallView.h"
#import <BaiduRtcRoom/BaiduRtcRoomApiAudioSession.h>
#import <sys/utsname.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "BDCloudRTCBaseDefine.pch"


@interface RTCVideoCallViewController () <RTCVideoCallViewDelegate, BaiduRtcRoomDelegate, BaiduRtcRoomApiAudioSessionDelegate>
@property (nonatomic, readonly) RTCVideoCallView *videoCallView;
@property (nonatomic, copy) NSString *roomName;
@property (nonatomic, copy) NSString *userId;
@property (nonatomic, copy) NSString *appId;
@property (nonatomic, copy) NSString *tokenStr;
@property (nonatomic, strong) NSArray<NSNumber *> *streamingIds;
@property (nonatomic, assign) BOOL isLoopBack;
@property (nonatomic, assign) BOOL isSubscribedStreaming;
@property (nonatomic, strong) BaiduRtcRoomApi *rtcRoomApi;
@property (nonatomic, assign) BOOL isMultiPersons;
@property (nonatomic, assign) BOOL bShowStates;
@property (nonatomic, copy) NSString *mediaServerUrl;
@property (nonatomic, copy) NSString *mediaServerIp;
@property (nonatomic, assign) BOOL alertNotice;

@end

@implementation RTCVideoCallViewController {
}

@synthesize videoCallView = _videoCallView;
@synthesize delegate = _delegate;

- (instancetype)initForRoom:(NSString *)room
                     userId:(NSString *)userId
                 isLoopback:(BOOL)isLoopback
             isMultiPersons:(BOOL)isMultiPersons
                   delegate:(id<RTCVideoCallViewControllerDelegate>)delegate {
    if (self = [super init]) {
        _delegate = delegate;
        self.bShowStates = YES;
        //判断用设置读取参数登陆房间

        if ([[RTCSettingsModel sharedInstance] currentServerHostSettingFromStore].length > 0 ) {
            self.mediaServerUrl = [[RTCSettingsModel sharedInstance] currentServerHostSettingFromStore];
        }
        if ([[RTCSettingsModel sharedInstance] currentServerUserIdSettingFromStore].length > 0) {
            self.userId = [[RTCSettingsModel sharedInstance] currentServerUserIdSettingFromStore];
        } else {
            
            uint32_t tempUserId = [self getRandomNumber:1000 to:9000];
            NSLog(@"Login room with userID:%d", tempUserId);
            self.userId =  [NSString stringWithFormat:@"%d", tempUserId];
        }
        self.roomName = room;
        self.isLoopBack = isLoopback;
        self.isMultiPersons = isMultiPersons;
        if ([[RTCSettingsModel sharedInstance] currentServerAppIdSettingFromStore].length > 0) {
            self.appId = [[RTCSettingsModel sharedInstance] currentServerAppIdSettingFromStore];
        } else {
            self.appId = BDCloudDefaultRTCAppID; //appjfkryqbzyns5
        }
        
        if ([[RTCSettingsModel sharedInstance] currentServerTokenSettingFromStore].length > 0 ) {
            self.tokenStr = [[RTCSettingsModel sharedInstance] currentServerTokenSettingFromStore];
        } else {
            self.tokenStr = BDCloudDefaultRTCAppToken;

        }
        //initialize sdk
//        self.mediaServerUrl = @"r.e.bcelive.com";
//        self.mediaServerIp = [self getIpFromDomain:self.mediaServerUrl];
    }
    return self;
}

- (void)call {
    //enable log info
    [BaiduRtcRoomApi setVerbose:true];
    //config parameters settings
    self.rtcRoomApi = [[BaiduRtcRoomApi alloc] initSDKWithAppID:self.appId
                                                       tokenStr:self.tokenStr
                                                       delegate:self];
    
    RtcParameterSettings *rps = [[RtcParameterSettings alloc] init];
    rps.isEnableDataChannel = YES;
    rps.videoFps = 10;
    // 从本地获取采集分辨率
    rps.videoWidth = [[RTCSettingsModel sharedInstance] currentVideoResolutionWidthFromStore];
    rps.videoHeight = [[RTCSettingsModel sharedInstance] currentVideoResolutionHeightFromStore];
    
    rps.isEnableFixedResolution = YES;
    [self.rtcRoomApi setParamSettings:rps paramType:RTC_VIDEO_PARAM_SETTINGS_RESOLUTION];
    [self.rtcRoomApi setParamSettings:rps paramType:RTC_VIDEO_PARAM_SETTINGS_FPS];
    [self.rtcRoomApi setParamSettings:rps paramType:RTC_VIDEO_PARAM_SETTINGS_ENABLE_FIXEDRESOLUTION];
    
    // 设置码率
    rps.videoBitrate = 1024;
    [self.rtcRoomApi setParamSettings:rps paramType:RTC_VIDEO_PARAM_SETTINGS_BITRATE];
    
    // setting codec
    if ([[[RTCSettingsModel sharedInstance] currentVideoCodecSettingFromStore] isEqualToString:@"H263"]) {
        rps.videoCodecType = [NSString stringWithFormat:@"%ld", (long)RTC_VIDEO_ENCODE_TYPE_H263];
        [self.rtcRoomApi setParamSettings:rps paramType:RTC_VIDEO_PARAM_SETTINGS_CODECTYPE];
    }
    
    [self.rtcRoomApi enableStatsToServer:YES qualityMonitorEnv:@"online"];
//    RTC_VIDEO_PARAM_SETTINGS_CODEC_MODE
    
    //rps.isAutoPublish = true;
    //[self.rtcRoomApi setParamSettings:rps paramType:RTC_PARAM_SETTINGS_AUTO_PUBLISH];
    
    //rps.isAutoSubscribe = true;
    //[self.rtcRoomApi setParamSettings:rps paramType:RTC_PARAM_SETTINGS_AUTO_SUBSCRIBE];
    
//    rps.hasAudio = false;
//    [self.rtcRoomApi setParamSettings:rps paramType:RTC_AUDIO_PARAM_SETTINGS_HAS_AUDIO];
    
    //rps.hasVideo = true;
    //[self.rtcRoomApi setParamSettings:rps paramType:RTC_VIDEO_PARAM_SETTINGS_HAS_VIDEO];
    
    //rps.isOnlyAudio = true;
    //[self.rtcRoomApi setParamSettings:rps paramType:RTC_PARAM_SETTINGS_ALL];
    //rps.videoFps = 29;
    //rps.videoWidth = 960;
    //rps.videoHeight = 540;
    //rps.videoBitrate = 300;
    //rps.isEnableExternalRender = YES;
    //rps.isEnableExternalCapturer = YES;
    //[self.rtcRoomApi setParamSettings:rps paramType:RTC_VIDEO_PARAM_SETTINGS_RENDER_MODE];
    //[self.rtcRoomApi setParamSettings:rps paramType:RTC_VIDEO_PARAM_SETTINGS_CAPTURE_MODE];
    
    //creating local and remote displaying view.
    //setting display view
    
    NSURL *url = [NSURL URLWithString:self.mediaServerUrl];
    
    
    if (url) {
        NSLog(@"%@, %@,%@ ", url.host, url.port, [url scheme]);
        BOOL enableSSL = [[url scheme] isEqualToString:@"wss"];
        NSString* userPort = @"";
        if (url.port > 0) {
            userPort = [NSString stringWithFormat:@"%d", [url.port intValue]];
        }
        [self.rtcRoomApi setSignalServerUrlWithSSL:url.host port:userPort  enableSSL:enableSSL];
    }
//    [self.rtcRoomApi setMediaServerIp:self.mediaServerIp];
    [self.rtcRoomApi setLocalDisplay:_videoCallView.localVideoView];
    
    if ([[RTCSettingsModel sharedInstance] currentHasVideoSettingFromStore]) {
        if (self.isMultiPersons) {
            NSLog(@"enable multi persions chat mode!");
            // [self.rtcRoomApi setRemoteDisplayGroup:_videoCallView.remoteVideoViewGroup];
        } else {
            NSLog(@"enable two persions chat mode!");
            [self.rtcRoomApi setRemoteDisplay:_videoCallView.remoteVideoView];
        }
    }
    
    //configure live server(rtmp)
    RtcLiveAuidoVideoParameters* avParam = [RtcLiveAuidoVideoParameters new];
    avParam.sampleRate = 48000;
    //NSString *template = @"side_by_side_primary_720p_16_9";
    NSString *rtmpUrl = [[RTCSettingsModel sharedInstance] currentLiveUrlSettingFromStore];
    BOOL isMix = [[RTCSettingsModel sharedInstance] currentLiveMixSettingFromStore];
    BOOL isRecord = [[RTCSettingsModel sharedInstance] currentLiveRecordSettingFromStore];
    NSString *mixTemplate = [[RTCSettingsModel sharedInstance] currentLiveMixTemplateSettingFromStore];
    RtcLiveTransferMode transferMode;
    if ([[[RTCSettingsModel sharedInstance] currentLiveTransferModSettingFromStore]  isEqual:@"主播转推"]) {
        transferMode = RTC_LIVE_TRANSFER_MODE_ANCHOR_TRASNSMISSION;
    } else {
        transferMode = RTC_LIVE_TRANSFER_MODE_ROOM_TRANSMISSION;
    }
    [self.rtcRoomApi configLiveServerWithUrl:rtmpUrl
                                       isMix:isMix
                                 isRecording:isRecord
                                 mixTemplate:mixTemplate
                                transferMode:transferMode
                                     avParam:avParam];
    
    //Using random number as userId to be convenient for test
    
  
    //setting audio sessionsr
    [self.rtcRoomApi setAudioSessionDelegate:self];

    //[self.rtcRoomApi presetLoudSpeaker:true];
    [self.rtcRoomApi setEngineStateStatistics:true];
    [self.rtcRoomApi loginRtcRoomWithRoomName:self.roomName
                                           userID:[self.userId integerValue]
                                      displayName:@"James"];
    //[self.rtcRoomApi publishStreaming];
    


    
    
    
    
    

    
    
    
}

- (void)loadView {
    _videoCallView = [[RTCVideoCallView alloc]
                      initWithFrame:CGRectZero
                          andOption:self.isMultiPersons
                         sdkVersion:[BaiduRtcRoomApi version]];
    _videoCallView.delegate = self;
    _videoCallView.statusLabel.text = [self statusTextForState:RTCIceConnectionStateNew];
    _videoCallView.isMultiPersons = self.isMultiPersons;
    self.view = _videoCallView;
    self.videoCallView.statsView.hidden = NO;
    [self call];
}

#pragma mark - RTCVideoCallViewDelegate
- (void)videoCallViewDidMuteMicphone:(RTCVideoCallView *)view {
    [self.rtcRoomApi muteMicphone];
}

- (void)videoCallViewDidHangup:(RTCVideoCallView *)view {
    NSLog(@"Click hangup botton!");
    [self hangup];
}

- (void)videoCallViewDidSwitchCamera:(RTCVideoCallView *)view {
    [self.rtcRoomApi switchCamera];
}

- (void)videoCallViewDidMuteCamera:(RTCVideoCallView *)view {
    [self.rtcRoomApi muteCamera];
}

- (void)onShowEngineStates:(id)sender {
    [self.rtcRoomApi setEngineStateStatistics:YES];
}

- (void)videoCallViewDidChangeRoute:(RTCVideoCallView *)view {
    [self.rtcRoomApi switchLoundSpeaker];
}

- (void)videoCallViewDidEnableStats:(RTCVideoCallView *)view {
    BOOL isOpenStates = !self.bShowStates;
    [self.rtcRoomApi setEngineStateStatistics:isOpenStates];
    self.bShowStates = isOpenStates;
    if (!isOpenStates) {
        self.videoCallView.statsView.hidden = YES;
    }else{
        self.videoCallView.statsView.hidden = NO;
    }
}

- (void)videoCallViewDidTapScreen:(CGPoint)point andPlaneSize:(CGSize)size {
    [self.rtcRoomApi cameraFocusWithPoint:point andPlaneSize:size];
}

#pragma mark - Private
- (void)hangup {
    [self.rtcRoomApi stopPublishStreaming:true];
    [self.rtcRoomApi logoutRtcRoom];
    //self.rtcRoomApi = nil;
    [_delegate viewControllerDidFinish:self];
}

- (NSString *)statusTextForState:(int)state {
    switch (state) {
        case RTC_SIGNAL_CHANNEL_STATS_ESTABLISHING:
        case RTC_SIGNAL_CHANNEL_STATS_ESTABLISHED:
        case RTC_SIGNAL_CHANNEL_STATS_FAILED:
        case RTC_MEDIA_CHANNEL_STATS_CONNECTING:
            return @"Connecting...";
        case RTC_MEDIA_CHANNEL_STATS_CONNECTED:
            break;
        case RTC_MEDIA_CHANNEL_STATS_FAILED:
            return @"Failed...";
        default:
            break;
    }
    return nil;
}

- (void)showAlertWithMessage:(NSString*)message {
    UIAlertController *alert =
    [UIAlertController alertControllerWithTitle:nil
                                        message:message
                                 preferredStyle:UIAlertControllerStyleAlert];
    
    UIAlertAction *defaultAction = [UIAlertAction actionWithTitle:@"OK"
                                                            style:UIAlertActionStyleDefault
                                                          handler:^(UIAlertAction *action){
                                                          }];
    [alert addAction:defaultAction];
    [self presentViewController:alert animated:YES completion:nil];
}

#pragma mark -- reCall
- (void)reCall {
    dispatch_async(dispatch_get_main_queue(), ^{
        NSLog(@"start recall --------------");
        [self.rtcRoomApi logoutRtcRoom];
        sleep(5);
        [self call];
        NSLog(@"end  recall  --------------");
    });
}

#pragma mark -- baidu rtc room elegate
- (void)onRoomEventUpdate:(RtcRoomEvents *)roomEvents {
    NSInteger eventType = roomEvents.rtcRoomEventType;
    NSLog(@"onRoomEventUpdate: %ld", (long)eventType);
    switch (eventType) {
        case RTC_ROOM_EVENTS_USEREVENTS_USER_LEAVING:
            NSLog(@"Userevents user leaving: %ld", [roomEvents.rtcRoomUserInfo.userID longValue]);
            break;
        case RTC_ROOM_EVENTS_USEREVENTS_USER_JOINED:
            NSLog(@"Userevents user joined: %ld", [roomEvents.rtcRoomUserInfo.userID longValue]);
            break;
        case RTC_ROOM_EVENTS_ROOM_CREATED:
            NSLog(@"Creating successfully room.");
            break;
        case RTC_ROOM_EVENTS_ROOM_JOINED: {
            break;
        }
        case RTC_ROOM_EVENTS_USER_JOINED: {
            break;
        }
        case RTC_ROOM_EVENTS_USER_LEAVING:
            NSLog(@"user:%ld leaving", [roomEvents.rtcRoomUserInfo.userID longValue]);
            if (!self.isMultiPersons) {
                //dispatch_async(dispatch_get_main_queue(), ^{
                self.videoCallView.remoteVideoSize = CGRectZero.size;
                [self.view setNeedsLayout];
                //});
            }
            break;
        case RTC_ROOM_EVENTS_RECEIVED_HANGUP:
            NSLog(@"Received server hangup notification!!!");
            // [self reCall];
            break;
        case RTC_ROOM_EVENTS_RECEIVED_TIMEOUT:
            NSLog(@"Received server timeout notification!!!");
            [self reCall];
            break;
        case RTC_ROOM_EVENTS_SENT_TIMEOUT:
            //[self reCall];
            NSLog(@"Sent signal timeout!!!");
            break;
        case RTC_ROOM_EVENTS_SOMEBODY_KICKOFFED:
            NSLog(@"somebody is kickoffed %ld", [roomEvents.rtcRoomUserInfo.userID longValue]);
            if ([self.userId integerValue] == [roomEvents.rtcRoomUserInfo.userID longValue]) {
                [self showAlertWithMessage:@"用户被提出房间"];
            }
            break;
        case RTC_ROOM_EVENTS_SUBSRIBE_DUPLICATE_FAIL:
            NSLog(@"RTC_ROOM_EVENTS_SUBSRIBE_DUPLICATE_FAIL");
            break;
        default:
            break;
    }
}

- (void)onPeerConnectStateUpdateWithType:(RtcPeerConnectionType)type stats:(int)connecStats {
    __weak RTCVideoCallViewController *weakSelf = self;
    dispatch_async(dispatch_get_main_queue(), ^{
        RTCVideoCallViewController *strongSelf = weakSelf;
        strongSelf.videoCallView.statusLabel.text =
        [strongSelf statusTextForState:connecStats];
    });
    switch (type) {
        case RTC_PEER_CONNECTION_TYPE_DATA_CHANNEL:
            //
            break;
        case RTC_PEER_CONNECTION_TYPE_MEDIA_CHANNEL:
        {
            switch (connecStats) {
                case RTC_MEDIA_CHANNEL_STATS_CONNECTING:
                    NSLog(@"Media channel connection stats: connecting!");
                    break;
                case RTC_MEDIA_CHANNEL_STATS_CONNECTED:
                    NSLog(@"Media channel connection stats: connected!");
                    break;
                case RTC_MEDIA_CHANNEL_STATS_DISCONNECTED:
                    NSLog(@"Media channel connection stats: disconnected!");
                    //[self reCall];
                    break;
                case RTC_MEDIA_CHANNEL_STATS_FAILED:
                    NSLog(@"Media channel connection stats: failed!");
                    [self reCall];
                    break;
                default:
                    break;
            }
        }
        case RTC_PEER_CONNECTION_TYPE_SIGNAL_CHANNEL:
        {
            switch (connecStats) {
                case RTC_SIGNAL_CHANNEL_STATS_ESTABLISHING:
                    NSLog(@"Signal channel stats: establishing!");
                    break;
                case RTC_SIGNAL_CHANNEL_STATS_ESTABLISHED:
                    NSLog(@"Signal channel stats: Established!");
                    break;
                case RTC_SIGNAL_CHANNEL_STATS_CLOSED:
                    NSLog(@"Signal channel stats: closed!");
                    break;
                case RTC_SIGNAL_CHANNEL_STATS_FAILED:
                    NSLog(@"Signal channel stats: Failed!");
                    [self reCall];
                    break;
                default:
                    break;
            }
            break;
        }
        default:
            break;
    }
}

- (void)onStreamInfoUpdate:(RtcStreamInfo *)rtcStreamInfo {
    _videoCallView.statusLabel.hidden = YES;
    NSLog(@"onStreamInfoUpdate userID %ld, streamID %@, attribute %@", rtcStreamInfo.userId, rtcStreamInfo.streamId, rtcStreamInfo.attribute);
    switch (rtcStreamInfo.streamState) {
        case RTC_AUDIO_ONLY_STREAMING_STATES_ARRIVAL: {
            NSLog(@"Audio stream arrival!!!");
            break;
        }
        case RTC_AUDIO_ONLY_STREAMING_STATES_REMOVE:
            NSLog(@"Audio stream removed");
            break;
        case RTC_VIDEO_STREAMING_STATES_ARRIVAL:
            NSLog(@"New streaming arrival!!!");
            if (self.isMultiPersons) {
                BOOL isFind = false;
                for (int i = 0; i < self.videoCallView.remoteVideoViewGroup.count; i++) {
                    RTCRemoteVideoViewInfo *videoInfo = self.videoCallView.remoteVideoViewGroup[i];
                    if (videoInfo.isUsed == false) {
                        [self.rtcRoomApi setRemoteDisplay:videoInfo.videoView userId:rtcStreamInfo.userId];
                        videoInfo.isUsed = true;
                        videoInfo.videoView.userId = rtcStreamInfo.userId;
                        isFind = true;
                        break;
                    }
                }
                if (!isFind) {
                    NSLog(@"no view can use");
                }
            }
            break;
        case RTC_VIDEO_STREAMING_STATES_REMOVE:
            for (NSInteger i = 0; i < self.videoCallView.remoteVideoViewLayoutRecord.count; i++) {
                if (rtcStreamInfo.remoteView == self.videoCallView.remoteVideoViewLayoutRecord[i].remoteVideoView) {
                    self.videoCallView.remoteVideoViewLayoutRecord[i].isRemoved = YES;
                    self.videoCallView.remoteVideoViewLayoutRecord[i].isUesed = NO;
                    self.videoCallView.remoteVideoViewLayoutRecord[i].remoteVideoView = nil;
                    [rtcStreamInfo.remoteView.videoView removeFromSuperview];
                    break;
                }
            }
            for (int i = 0; i < self.videoCallView.remoteVideoViewGroup.count; i++) {
                RTCRemoteVideoViewInfo *videoInfo = self.videoCallView.remoteVideoViewGroup[i];
                if (videoInfo.videoView == rtcStreamInfo.remoteView) {
                    videoInfo.isUsed = NO;
                    videoInfo.videoView.userId = 0;
                    [self.videoCallView updateSubView:videoInfo.videoView uid:videoInfo.videoView.userId add:NO];
                    break;
                }
            }
            NSLog(@"stream remove");
            break;
        case RTC_VIDEO_STREAMING_STATES_OTHERS:
            break;
    }
}

- (void)onErrorInfoUpdate:(RtcErrorCodes)errorInfo {
    NSString *errorMessage;
    switch (errorInfo) {
        case RTC_NO_SUCH_ROOM_ERROR:
            errorMessage = @"该房间不存！";
            break;
        case RTC_USERID_ALREADY_EXIST_ERROR:
            errorMessage = @"该用户ID已经存在！";
            break;
        case RTC_ROOM_ALREADY_EXIST_ERROR:
            errorMessage = @"创建房间失败！！";
        default:
            errorMessage = @"未知错误！！！";
            break;
    }
    __weak RTCVideoCallViewController *weakSelf = self;
    dispatch_async(dispatch_get_main_queue(), ^{
        RTCVideoCallViewController *strongSelf = weakSelf;
        strongSelf.videoCallView.statusLabel.text =
        [strongSelf statusTextForState:RTC_MEDIA_CHANNEL_STATS_FAILED];
    });
    [self showAlertWithMessage:errorMessage];
}

- (void)onEngineStatisticsInfo:(NSArray *)statistacs {
    _videoCallView.statsView.stats = statistacs;
    [_videoCallView setNeedsLayout];
}

- (void)onTextMessageArrival:(RtcMessageInfo *)msg {
    NSLog(@"The demo receiving text message: %@ from user", msg.message);
    [self.rtcRoomApi sendMessage:@"testing data channel, sending text data."];
}

- (void)onTextMessageArrival2:(RtcMessageInfo *)msg {
    NSLog(@"The demo receiving text message2: %@ from user %@", msg.message, msg.userId);
    NSArray *array = [self.rtcRoomApi queryMessageUserListOfRoom];
    int count = 0;
    for (RtcRoomUserInfo *userInfo in array) {
        NSString * str = [NSString stringWithFormat:@"testing data channel, sending text data. %d", count];
        [self.rtcRoomApi sendMessage2WithUserId:str userId:userInfo.userID];
        count++;
        //break;
    }
    [self.rtcRoomApi sendMessage2:@"testing data channel, sending text data !!!"];
}

- (void)onTextMessageAttribute:(NSNumber *)userID attribute:(NSString *)attribute {
    NSLog(@"onTextMessageAttribute, userID: %@, attribute: %@", userID, attribute);
}

- (int)getRandomNumber:(int)from to:(int)to {
    return (int)(from + (arc4random() % (to - from + 1)));
}

- (NSString *) getIpFromDomain:(NSString *)domain {
    struct hostent *hs = NULL;
    struct sockaddr_in server;
    @try {
        if ((hs = gethostbyname([domain UTF8String])) != NULL) {
            server.sin_addr = *((struct in_addr*)hs->h_addr_list[0]);
            return [NSString stringWithUTF8String:inet_ntoa(server.sin_addr)];
        }
        return nil;
    } @catch (NSException *e) {
        return nil;
    }
}

#pragma mark -- Audio session
- (void)onAudioSessionDidStartPlayOrRecord {
    //NSLog(@"Audio session start play or record.");
}

- (void)onAudioSessionDidStopPlayOrRecord {
    //NSLog(@"Audio session stop play or record.");
}
@end
