//
//  RTCVideoCallView.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCVideoCallView.h"
#import <AVFoundation/AVFoundation.h>
#import "UIImage+RTCUtilities.h"
#import "RTCViewLayoutMacro.h"
#import "BDCloudRTCBaseDefine.pch"
#import "RTCScrollSubView.h"
#import "RTCBeautyFacePanelView.h"
#import "RTCBeautyFaceOperator.h"
#import "RTCVoiceChangePanelView.h"
#import "RTCVideoUserInfoView.h"
#import "UserRemoteManager.h"
#import "RTCSettingsModel.h"
#import "RTC1V1CallView.h"
#import "RTCSiglePageCallView.h"
#import "BDCloudRTCBaseDefine.pch"

#define angle2Rad(angle) ((angle) / 180.0 * M_PI)

static CGFloat const kButtonPadding = 82;
#define pageControlHeight 70

//static CGFloat const kButtonSize = 48;
//static CGFloat const kLocalVideoViewSize = 120;
//static CGFloat const kLocalVideoViewPadding = 8;
//static CGFloat const kStatusBarHeight = 20;
@implementation RtcViewLayoutInfo
@end

@implementation RTCRemoteVideoViewInfo
@end

@interface RTCVideoCallView () <RTCRemoteVideoViewDelegate, VideoCallViewDelegate, SettingPanelViewDelegate, UIScrollViewDelegate>
@property (nonatomic, strong) UIView *cameraFocusView;
@property (nonatomic, assign) BOOL isMuteMic;
@property (nonatomic, assign) BOOL isLoundSpeaker;
@property (nonatomic, assign) BOOL isSwitchVoice;
@property (nonatomic, assign) BOOL isSwitchCamear;
@property (nonatomic, assign) BOOL isOpeningMonitor;

@property (nonatomic, assign) CGFloat kLocalVideoViewW;
@property (nonatomic, assign) CGFloat kLocalVideoViewH;

//@property (strong, nonatomic) UIScrollView *viewScrollView;
//@property (strong, nonatomic) NSArray *contentList;
//@property (strong, nonatomic) UIPageControl *pageControl;

//for subViewShown parameters
@property (nonatomic, assign) BOOL shownMeetingMode;
@property (nonatomic, assign) int  nNumShownPage;   //
@property (nonatomic, strong) RTCScrollSubView* currentRtcSubview;

@property (nonatomic, assign) BOOL isOpenSetingPanel;
@property (nonatomic, strong) RTCCallingSettingsPanelView* rtcCallingSettingPanel;
@property (nonatomic, assign) BOOL isOpenBeautyFacePanel;
@property (nonatomic, strong) BDMVBeautyFacePanelView *rtcBeautyFacePanel;
@property (nonatomic, strong) RTCBeautyFaceOperator *beautyFaceOperator;
@property (nonatomic, strong) RTCVoiceChangePanelView *rtcVoiceChangePanel;
@property(nonatomic, copy) NSString *sdkVersion;
@property (nonatomic, assign) NSInteger uid;

@property (nonatomic, assign) BOOL isRemoteSubscribeOpt;

@property (nonatomic, strong) UITextView *receiveMessageView;
//@property (nonatomic, strong) UIView *tipView;
//@property (nonatomic, strong) UILabel *tipLabel;
//@property (nonatomic, strong) UIButton *tipButton;

@property (nonatomic, assign) BOOL is1v1;
@property (nonatomic, strong) RTC1V1CallView * twoPersonCallView;
@property (nonatomic, strong) RTCSiglePageCallView *siglePageCallView;
@end

@implementation RTCVideoCallView {
    UIButton *_engineStatesInfoShow;
    UILabel* _muteCameraLabel;
    UIButton *_muteCamera;
    UILabel* _muteMicPhoneLabel;
    UIButton *_muteMicPhone;
    UILabel* _routChangeLabel;
    UIButton *_routeChangeButton;
    UILabel* _cameraSwitchLabel;
    UIButton *_cameraSwitchButton;
    UILabel* _hangupLabel;
    UIButton *_hangupButton;
    //display time label
    UILabel* _timeDisplayLabel;

    //display defaulty person photo
    UIImageView* _personPhotoImgView;
    
    UIButton *_settingRoomInterconnection;
//    UIButton *_showVideoPattern;
    UIButton *_settingBeauty;
    UIButton *_btnVoiceChange;
    
    UIButton *_whiteBoardBtn;
    UIButton *_shareScreenBtn;
    UIButton *_btnUserLists;
}

@synthesize statusLabel = _statusLabel;
@synthesize statsView = _statsView;
@synthesize delegate = _delegate;
@synthesize remoteVideoViewLayoutRecord = _remoteVideoViewLayoutRecord;
//@synthesize remoteVideoViewGroup = _remoteVideoViewGroup;

- (instancetype)initWithFrame:(CGRect)frame
                          uid:(NSInteger)uid
                   sdkVersion:(NSString*)sdkVersion {
    if (self = [super initWithFrame:frame]) {
        self.is1v1 = [[RTCSettingsModel sharedInstance] currentCallMode1v1SettingFromStore];
        self.isOpeningMonitor = YES;
        self.sdkVersion = sdkVersion;
        self.uid = uid;
        self.kLocalVideoViewW = SCREEN_WIDTH*450*kLayoutWidthScale;
        self.kLocalVideoViewH = SCREEN_HEIGHT*800*kLayoutHeightScale;
        self.cameraFocusView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 80, 80)];
        self.cameraFocusView.layer.borderWidth = 1.0;
        self.cameraFocusView.layer.borderColor = [UIColor greenColor].CGColor;
        self.cameraFocusView.layer.backgroundColor = [UIColor clearColor].CGColor;
        //[self addSubview:self.cameraFocusView];
        self.cameraFocusView.hidden = YES;
        self.shownMeetingMode = [[RTCSettingsModel sharedInstance] currentShownMeetingModeFromStore]; //默认NO 布局
        self.isRemoteSubscribeOpt = [[RTCSettingsModel sharedInstance] currentRemoteSubscribeSettingFromStore];  //设置：拉流会议模式
        

        self.localVideoView = [[RTCLocalVideoView alloc] initWithDelegate:nil];
//        [self updateSubViewLocal:_localVideoView];

        CGSize LocalView = CGSizeMake([[RTCSettingsModel sharedInstance] currentVideoResolutionWidthFromStore], [[RTCSettingsModel sharedInstance] currentVideoResolutionHeightFromStore]);
        if (self.is1v1) {
            self.twoPersonCallView = [[RTC1V1CallView alloc] initWithFrame:CGRectZero];
            [self.twoPersonCallView addRTCsubView:[NSString stringWithFormat:@"%@", @(self.uid)]
                                            local:YES
                                             view:self.localVideoView.videoView
                                             size:LocalView];
            self.twoPersonCallView.localView = self.localVideoView;
            [self addSubview:self.twoPersonCallView];
        } else {
            self.siglePageCallView = [[RTCSiglePageCallView alloc] initWithFrame:CGRectZero];
            [self.siglePageCallView addRTCsubView:[NSString stringWithFormat:@"%@", @(self.uid)]
                                            local:YES 
                                             view:self.localVideoView.videoView
                                             size:LocalView
                                             show:YES];
            [self addSubview:self.siglePageCallView];
        }
        
        [self addSubview:self.cameraFocusView];

        _muteMicPhone = [UIButton buttonWithType:UIButtonTypeCustom];
        _muteMicPhone.layer.masksToBounds = YES;
        UIImage *micImage = [UIImage imageNamed:@"mute_mic_two_n.png"];
        [_muteMicPhone setImage:micImage forState:UIControlStateNormal];
        [_muteMicPhone addTarget:self action:@selector(onMicphoneChange:)
                forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_muteMicPhone];
        _muteMicPhoneLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _muteMicPhoneLabel.adjustsFontSizeToFitWidth = YES;
        _muteMicPhoneLabel.textColor = [UIColor whiteColor];
        _muteMicPhoneLabel.text = @"静音";
        [self addSubview:_muteMicPhoneLabel];

        _routeChangeButton = [UIButton buttonWithType:UIButtonTypeCustom];
        [_routeChangeButton setImage:[UIImage imageNamed:@"loundspeaker_n.png"] forState:UIControlStateNormal];
        [_routeChangeButton setImage:[UIImage imageNamed:@"loundspeaker_y.png"] forState:UIControlStateSelected];
        [_routeChangeButton addTarget:self
                               action:@selector(onRouteChange:)
                     forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_routeChangeButton];
        _routChangeLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _routChangeLabel.adjustsFontSizeToFitWidth = YES;
        _routChangeLabel.textColor = [UIColor whiteColor];
        _routChangeLabel.text = @"扬声器";
        [self addSubview:_routChangeLabel];

        _hangupButton = [UIButton buttonWithType:UIButtonTypeCustom];
        _hangupButton.layer.masksToBounds = YES;
        UIImage *image = [UIImage imageNamed:@"cancel_call.png"];
        [_hangupButton setImage:image forState:UIControlStateNormal];
        [_hangupButton addTarget:self
                          action:@selector(onHangup:)
                forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_hangupButton];
        _hangupLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _hangupLabel.adjustsFontSizeToFitWidth = YES;
        _hangupLabel.textColor = [UIColor whiteColor];
        _hangupLabel.text = @"取消";
        [self addSubview:_hangupLabel];

        _muteCamera = [UIButton buttonWithType:UIButtonTypeCustom];
        _muteCamera.layer.masksToBounds = YES;
        UIImage *cameraImage = [UIImage imageNamed:@"switch_voice_n.png"];
        [_muteCamera setImage:cameraImage forState:UIControlStateNormal];
        [_muteCamera addTarget:self action:@selector(onCameraChange:)
              forControlEvents:UIControlEventTouchUpInside];
        _muteCameraLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _muteCameraLabel.adjustsFontSizeToFitWidth = YES;
        _muteCameraLabel.textColor = [UIColor whiteColor];
        _muteCameraLabel.text = @"切到音频通话";
        if ([[RTCSettingsModel sharedInstance] currentHasVideoSettingFromStore]) {
            [self addSubview:_muteCamera];
            [self addSubview:_muteCameraLabel];
        }

        // TODO(tkchin): don't display this if we can't actually do camera switch.
        _cameraSwitchButton = [UIButton buttonWithType:UIButtonTypeCustom];
        _cameraSwitchButton.layer.masksToBounds = YES;
        image = [UIImage imageNamed:@"switch_camera_n.png"];
        [_cameraSwitchButton setImage:image forState:UIControlStateNormal];
        [_cameraSwitchButton addTarget:self
                                action:@selector(onCameraSwitch:)
                      forControlEvents:UIControlEventTouchUpInside];
        
        _cameraSwitchLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _cameraSwitchLabel.adjustsFontSizeToFitWidth = YES;
        _cameraSwitchLabel.textColor = [UIColor whiteColor];
        _cameraSwitchLabel.text = @"切换摄像头";
        if ([[RTCSettingsModel sharedInstance] currentHasVideoSettingFromStore]) {
            [self addSubview:_cameraSwitchButton];
            [self addSubview:_cameraSwitchLabel];
        }

        _engineStatesInfoShow = [UIButton buttonWithType:UIButtonTypeCustom];
        _engineStatesInfoShow.layer.masksToBounds = YES;
        UIImage *monitImg = [UIImage imageNamed:@"monitor_y.png"];
        [_engineStatesInfoShow setImage:monitImg forState:UIControlStateNormal];
        [_engineStatesInfoShow addTarget:self action:@selector(onShowEngineStates:)
                        forControlEvents:UIControlEventTouchDown];
        [self addSubview:_engineStatesInfoShow];
        
        _settingRoomInterconnection = [UIButton buttonWithType:UIButtonTypeCustom];
        _settingRoomInterconnection.layer.masksToBounds = YES;
        UIImage * roomConnectImg = [UIImage imageNamed:@"baiducloud_camera_setting_btn_icon"];
        [_settingRoomInterconnection setImage:roomConnectImg forState:UIControlStateNormal];
        [_settingRoomInterconnection addTarget:self action:@selector(onRoomInterconnection:)
                        forControlEvents:UIControlEventTouchDown];
        [self addSubview:_settingRoomInterconnection];
        
        _whiteBoardBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        _whiteBoardBtn.layer.masksToBounds = YES;
        UIImage *whiteBoardImg = [UIImage imageNamed:@"wbogo.png"];
        [_whiteBoardBtn setImage:whiteBoardImg forState:UIControlStateNormal];
        [_whiteBoardBtn addTarget:self action:@selector(onWhiteBoardBtnClicked:)
                       forControlEvents:UIControlEventTouchDown];
        [self addSubview:_whiteBoardBtn];

        _shareScreenBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        _shareScreenBtn.layer.masksToBounds = YES;
        UIImage *shareScreenImg = [UIImage imageNamed:@"screen_share.png"];
        [_shareScreenBtn setImage:shareScreenImg forState:UIControlStateNormal];
        [_shareScreenBtn addTarget:self action:@selector(onShareScreenBtnClicked:)
                       forControlEvents:UIControlEventTouchDown];
        [self addSubview:_shareScreenBtn];
        
        _btnUserLists = [UIButton buttonWithType:UIButtonTypeCustom];
        _btnUserLists.layer.masksToBounds = YES;
        UIImage * userListImg = [UIImage imageNamed:@"yonghuliebiao.png"];
        [_btnUserLists setImage:userListImg forState:UIControlStateNormal];
        [_btnUserLists addTarget:self action:@selector(onBtnUserListsEvent:)
                       forControlEvents:UIControlEventTouchDown];
        [self addSubview:_btnUserLists];
        
//        _showVideoPattern = [UIButton buttonWithType:UIButtonTypeCustom];
//        _showVideoPattern.layer.masksToBounds = YES;
//        UIImage *videoPatternImg = [UIImage imageNamed:@"split-screen-compare-2"];
//        UIImage *videoPatternFullImg = [UIImage imageNamed:@"split-screen-compare-full-2.png"];
//        [_showVideoPattern setImage:videoPatternImg forState:UIControlStateNormal];
//        [_showVideoPattern setImage:videoPatternFullImg forState:UIControlStateSelected];
//        [_showVideoPattern addTarget:self action:@selector(onVideoShownPattern:)
//                       forControlEvents:UIControlEventTouchDown];
//        _showVideoPattern.selected = !self.shownMeetingMode;
//        [self addSubview:_showVideoPattern];

        _settingBeauty = [UIButton buttonWithType:UIButtonTypeCustom];
        _settingBeauty.layer.masksToBounds = YES;
        UIImage * beautyImg = [UIImage imageNamed:@"baiducloud_camera_beautyface_btn_icon"];
        [_settingBeauty setImage:beautyImg forState:UIControlStateNormal];
        [_settingBeauty addTarget:self action:@selector(onBeautySetting:)
                       forControlEvents:UIControlEventTouchDown];
        [self addSubview:_settingBeauty];
        
        _btnVoiceChange = [UIButton buttonWithType:UIButtonTypeCustom];
        _btnVoiceChange.layer.masksToBounds = YES;
        UIImage *voiceChangeImg = [UIImage imageNamed:@"baiducloud_voicechange_btn_icon"];
        [_btnVoiceChange setImage:voiceChangeImg forState:UIControlStateNormal];
        [_btnVoiceChange addTarget:self action:@selector(onBtnVoiceChangeClicked:)
                       forControlEvents:UIControlEventTouchDown];
        [self addSubview:_btnVoiceChange];

        _statusLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _statusLabel.font = [UIFont fontWithName:@"Roboto" size:16];
        _statusLabel.textColor = [UIColor whiteColor];
        [self addSubview:_statusLabel];

        _timeDisplayLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _timeDisplayLabel.adjustsFontSizeToFitWidth = YES;
        _timeDisplayLabel.textColor = [UIColor whiteColor];
        [self addSubview:_timeDisplayLabel];

        _personPhotoImgView = [[UIImageView alloc] init];
        UIImage *img = [UIImage imageNamed:@"first_page_logo.png"];
        [_personPhotoImgView setImage:img];
        [self addSubview:_personPhotoImgView];

        _statsView = [[RTCStatsView alloc] initWithFrame:CGRectZero];
        _statsView.videoCallViewDelegate = self;
        _statsView.hidden = YES;
        _statsView.sdkVerion = self.sdkVersion;
        [self addSubview:_statsView];
        
        self.receiveMessageView = [[UITextView alloc] initWithFrame:CGRectZero];
        self.receiveMessageView.editable = NO;
        self.receiveMessageView.backgroundColor = [UIColor clearColor];
        self.receiveMessageView.textColor = [UIColor whiteColor];
        self.receiveMessageView.font = [UIFont systemFontOfSize:14];
        [self addSubview:self.receiveMessageView];

        UITapGestureRecognizer *tapRecognizer =
        [[UITapGestureRecognizer alloc]
         initWithTarget:self
         action:@selector(onTapScreen:)];
        tapRecognizer.numberOfTapsRequired = 1;
        [self addGestureRecognizer:tapRecognizer];
        //self.contentList = @[@"one", @"two", @"three", @"four", @"five"];

//        [self addSubview:self.viewScrollView];
//        [self addSubview:self.pageControl];
//        [self sendSubviewToBack:self.viewScrollView];
//        [self sendSubviewToBack:self.pageControl];
        [self sendSubviewToBack:_personPhotoImgView];
        self.backgroundColor =[UIColor blackColor];

    }
    [UserRemoteManager instance].videoViewDelegate = self;
    return self;
}
- (void)dealloc {
    if (_rtcCallingSettingPanel) {
        [_rtcCallingSettingPanel stopScheduler];
        _rtcCallingSettingPanel = nil;
    }
    if (_rtcBeautyFacePanel) {
        _rtcBeautyFacePanel = nil;
    }
    _currentRtcSubview = nil;
}

#pragma mark - Video shown

- (CGRect)frameAtPosition:(int)postion {
    
//    CGRect bounds = self.bounds;
    CGFloat maginH = SCREEN_WIDTH*350*kLayoutWidthScale;
    CGFloat width = SCREEN_WIDTH*414*kLayoutWidthScale;
    CGFloat height = SCREEN_WIDTH*414*kLayoutWidthScale;
    
    CGFloat x = (postion%3) * width;
    CGFloat y = (postion/3) * height;
    
    CGRect frame = CGRectMake(x, y+maginH, width, height);
    
    return frame;
}

- (NSMutableArray *) remoteVideoViewLayoutRecord {
    if( !_remoteVideoViewLayoutRecord) {
        _remoteVideoViewLayoutRecord = [[NSMutableArray alloc]initWithCapacity:RemotePeers];
    }
    return _remoteVideoViewLayoutRecord;
}
//- (UIScrollView *)viewScrollView {
//    if (!_viewScrollView) {
//
//        CGFloat videoViewFrameX = SCREEN_WIDTH*0*kLayoutWidthScale;
//        CGFloat videoViewFrameY = SCREEN_HEIGHT*368*kLayoutHeightScale;
//        CGFloat videoViewFrameW = SCREEN_WIDTH*1242*kLayoutWidthScale;
//        CGFloat videoViewFrameH = videoViewFrameW*1.2;
//
//        _viewScrollView = [[UIScrollView alloc] initWithFrame:CGRectMake(0, videoViewFrameY,videoViewFrameW, videoViewFrameW)];
//        _viewScrollView.contentSize = CGSizeMake(videoViewFrameW* 1, videoViewFrameH - 2*pageControlHeight);
//        _viewScrollView.backgroundColor = [UIColor whiteColor];
//        _viewScrollView.pagingEnabled = YES;
//        _viewScrollView.delegate = self;
//        _viewScrollView.showsHorizontalScrollIndicator = NO;
//    }
//    return _viewScrollView;
//}

//- (UIPageControl *)pageControl {
//    if (!_pageControl) {
//
//        CGFloat videoViewFrameX = SCREEN_WIDTH*29*kLayoutWidthScale;
//        CGFloat videoViewFrameY = SCREEN_HEIGHT*210*kLayoutHeightScale;
//        CGFloat videoViewFrameW = SCREEN_WIDTH*414*kLayoutWidthScale;
//        CGFloat videoViewFrameH = videoViewFrameW;
//        //CGRectGetWidth(self.view.frame)
//        _pageControl = [[UIPageControl alloc] initWithFrame:CGRectMake(0, videoViewFrameY- pageControlHeight,videoViewFrameW , pageControlHeight)];
//        _pageControl.numberOfPages = 1;
//        _pageControl.currentPage = 0;
//        [_pageControl addTarget:self action:@selector(changePage:) forControlEvents:UIControlEventValueChanged];
//    }
//    return _pageControl;
//}


#pragma mark - UIScrollViewDelegate

//- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView {
//    CGFloat pageWidth = CGRectGetWidth(self.viewScrollView.frame);
//    NSUInteger page = floor((scrollView.contentOffset.x - pageWidth/2)/pageWidth) + 1;
//
//    NSUInteger frontPage= self.pageControl.currentPage;
//    self.pageControl.currentPage = page;
//
//    if (self.isRemoteSubscribeOpt) {
//        [self noticeStutusRemoteView:(page+1) front:(frontPage+1)];
//    }
//}

#pragma mark - IBAction

//- (void)changePage:(id)sener {
//    NSUInteger page = self.pageControl.currentPage;
//    CGRect bounds = self.viewScrollView.bounds;
//    bounds.origin.x = CGRectGetWidth(bounds) * page;
//    bounds.origin.y = self.viewScrollView.frame.origin.y;
//    [self.viewScrollView scrollRectToVisible:bounds animated:YES];
//}
//

- (void)layoutSubviews {
    CGRect bounds = self.bounds;
    CGRect localVideoFrame = CGRectMake(0, 0, self.kLocalVideoViewW, self.kLocalVideoViewH);

    
    CGFloat localVideoViewFrameX = SCREEN_WIDTH*29*kLayoutWidthScale;
    CGFloat localVideoViewFrameY = SCREEN_HEIGHT*210*kLayoutHeightScale;
    CGFloat localVideoViewFrameW = SCREEN_WIDTH*450*kLayoutWidthScale;
    CGFloat localVideoViewFrameH = SCREEN_HEIGHT*600*kLayoutHeightScale;
    localVideoFrame = CGRectMake(localVideoViewFrameX, localVideoViewFrameY, localVideoViewFrameW, localVideoViewFrameH);

    CGFloat viewScrollViewX = SCREEN_WIDTH*0*kLayoutWidthScale;
    CGFloat viewScrollViewY = SCREEN_HEIGHT*300*kLayoutHeightScale;
    CGFloat viewScrollViewW = SCREEN_WIDTH*1242*kLayoutWidthScale;
    CGFloat viewScrollViewH = SCREEN_HEIGHT*1430*kLayoutHeightScale;
    if (self.is1v1) {
        self.twoPersonCallView.frame = CGRectMake(viewScrollViewX, viewScrollViewY, viewScrollViewW, viewScrollViewH);
    } else {
        self.siglePageCallView.frame = CGRectMake(viewScrollViewX, viewScrollViewY, viewScrollViewW, viewScrollViewH);
    }
    // Aspect fit local video view into a square box.
    if (self.is1v1) {
        [self.twoPersonCallView updateLayoutSubviews];
    } else {
        self.localVideoView.videoView.frame = localVideoFrame;
    }
    
    [self layoutShareScreenViewWithBounds:bounds];

    RTCSettingsModel *rtcSetting = [RTCSettingsModel sharedInstance];
    CGFloat stateViewYoffset = SCREEN_HEIGHT*267*kLayoutHeightScale;
    if ([rtcSetting currentHasVideoSettingFromStore]) {
        stateViewYoffset = SCREEN_HEIGHT*800*kLayoutHeightScale;
    }
    CGSize statsSize = [_statsView sizeThatFits:bounds.size];
    if (![rtcSetting currentHasVideoSettingFromStore]) {
        _statsView.frame = CGRectMake(CGRectGetMinX(bounds),
                                      CGRectGetMinY(bounds) + stateViewYoffset*2.2,
                                      statsSize.width, statsSize.height);
    } else {
        _statsView.frame = CGRectMake(CGRectGetMinX(bounds),
                                      CGRectGetMinY(bounds) == 0 ? SCREEN_HEIGHT * 200 * kLayoutHeightScale : CGRectGetMinY(bounds),
                                      statsSize.width, statsSize.height);
    }
    //mute micphone btn and label
    CGFloat muteMicX = 0;
    CGFloat muteMicY = 0;
    CGFloat muteMicW = SCREEN_WIDTH*160*kLayoutWidthScale;
    CGFloat muteMicH = muteMicW;
    if (![rtcSetting currentHasVideoSettingFromStore]) {
        muteMicX = SCREEN_WIDTH*254*kLayoutWidthScale;
        muteMicY = SCREEN_HEIGHT*1883*kLayoutHeightScale;
    } else {
        muteMicX = SCREEN_WIDTH*88*kLayoutWidthScale;
        muteMicY = SCREEN_HEIGHT*1883*kLayoutHeightScale;
    }
    _muteMicPhone.layer.cornerRadius = muteMicW/2.0;
    CGRect micPhoneFrame = CGRectMake(muteMicX, muteMicY, muteMicW, muteMicH);
    _muteMicPhone.frame = micPhoneFrame;
    CGFloat muteMicLabelX = 0;
    CGFloat muteMicLabelY = 0;
    if (![rtcSetting currentHasVideoSettingFromStore]) {
        muteMicLabelX = SCREEN_WIDTH*304*kLayoutWidthScale;
        muteMicLabelY = muteMicY + muteMicH - SCREEN_HEIGHT*23*kLayoutHeightScale;
    } else {
        muteMicLabelX = SCREEN_WIDTH*140*kLayoutWidthScale;
        muteMicLabelY = muteMicY + muteMicH - SCREEN_HEIGHT*23*kLayoutHeightScale;
    }
    CGFloat muteMicLabelW = SCREEN_WIDTH*60*kLayoutWidthScale;
    CGFloat muteMicLabelH = muteMicW*42/60;
    _muteMicPhoneLabel.frame = CGRectMake(muteMicLabelX,
                                          muteMicLabelY,
                                          muteMicLabelW,
                                          muteMicLabelH);

    CGRect routeChangeFrame = _muteMicPhone.frame;
    routeChangeFrame.origin.x = CGRectGetMaxX(routeChangeFrame)
                                + SCREEN_WIDTH*kButtonPadding*kLayoutWidthScale;
    if (![rtcSetting currentHasVideoSettingFromStore]) {
        routeChangeFrame.origin.x = CGRectGetMaxX(micPhoneFrame)
                                    + SCREEN_WIDTH*472*kLayoutWidthScale;
    }
    _routeChangeButton.layer.cornerRadius = muteMicW/2.0;
    _routeChangeButton.frame = routeChangeFrame;
    CGFloat routeChangeLabelX = SCREEN_WIDTH*368*kLayoutWidthScale;
    CGFloat routeChangeLabelY = muteMicLabelY;
    CGFloat routeChangeLabelW = SCREEN_WIDTH*90*kLayoutWidthScale;
    CGFloat routeChangeLabelH = muteMicLabelH;
    if (![rtcSetting currentHasVideoSettingFromStore]) {
        routeChangeLabelX = SCREEN_WIDTH*920*kLayoutWidthScale;
    }
    _routChangeLabel.frame = CGRectMake(routeChangeLabelX,
                                        routeChangeLabelY,
                                        routeChangeLabelW,
                                        routeChangeLabelH);

    CGFloat hangupBtnX = CGRectGetMaxX(routeChangeFrame) + SCREEN_WIDTH*83*kLayoutWidthScale;
    CGFloat hangupBtnY = SCREEN_HEIGHT*1886*kLayoutHeightScale;
    CGFloat hangupBtnW = SCREEN_WIDTH*155*kLayoutWidthScale;
    CGFloat hangupBtnH = hangupBtnW;
    if (![rtcSetting currentHasVideoSettingFromStore]) {
        hangupBtnX = CGRectGetMaxX(micPhoneFrame) + SCREEN_WIDTH*156*kLayoutWidthScale;
//        hangupBtnY = muteMicY;
    }
    _hangupButton.layer.cornerRadius = hangupBtnW/2.0;
    _hangupButton.frame = CGRectMake(hangupBtnX, hangupBtnY, hangupBtnW, hangupBtnH);
    CGFloat hungupLabelX = SCREEN_WIDTH*623*kLayoutWidthScale;
    CGFloat hungupLabelY = muteMicLabelY;
    CGFloat hungupLabelW = SCREEN_WIDTH*60*kLayoutWidthScale;
    CGFloat hungupLabelH = muteMicLabelH;
    if (![rtcSetting currentHasVideoSettingFromStore]) {
        hungupLabelX = SCREEN_WIDTH*607*kLayoutWidthScale;
    }
    _hangupLabel.frame = CGRectMake(hungupLabelX,
                                    hungupLabelY,
                                    hungupLabelW,
                                    hungupLabelH);

    CGFloat muteCameraX = CGRectGetMaxX(_hangupButton.frame) + SCREEN_WIDTH*83*kLayoutWidthScale;
    CGFloat muteCameraY = muteMicY;
    CGFloat muteCameraW = muteMicW;
    CGFloat muteCameraH = muteMicH;
    CGRect muteCameraFrame = CGRectMake(muteCameraX, muteCameraY, muteCameraW, muteCameraH);
    _muteCamera.layer.cornerRadius = muteCameraW/2.0;
    _muteCamera.frame = muteCameraFrame;
    CGFloat muteCameraLabelX = SCREEN_WIDTH*806*kLayoutWidthScale;
    CGFloat muteCameraLabelY = muteMicLabelY;
    CGFloat muteCameraLabelW = SCREEN_WIDTH*180*kLayoutWidthScale;
    CGFloat muteCameraLabelH = muteMicLabelH;
    _muteCameraLabel.frame = CGRectMake(muteCameraLabelX,
                                        muteCameraLabelY,
                                        muteCameraLabelW,
                                        muteCameraLabelH);

    CGFloat switchCameraX = CGRectGetMaxX(_muteCamera.frame) + SCREEN_WIDTH*kButtonPadding*kLayoutWidthScale;
    CGFloat switchCameraY = muteMicY;
    CGFloat switchCameraW = muteMicW;
    CGFloat switchCameraH = muteMicH;
    CGRect cameraSwitchFrame = CGRectMake(switchCameraX, switchCameraY, switchCameraW, switchCameraH);
    _cameraSwitchButton.layer.cornerRadius = muteCameraW/2.0;
    _cameraSwitchButton.frame = cameraSwitchFrame;
    CGFloat switchCameraLabelX = SCREEN_WIDTH*1062*kLayoutWidthScale;
    CGFloat switchCameraLabelY = muteMicLabelY;
    CGFloat switchCameraLabelW = SCREEN_WIDTH*150*kLayoutWidthScale;
    CGFloat switchCameraLabelH = muteMicLabelH;
    _cameraSwitchLabel.frame = CGRectMake(switchCameraLabelX,
                                          switchCameraLabelY,
                                          switchCameraLabelW,
                                          switchCameraLabelH);
    
    [self layoutTopLeftSubView];
    [self layoutTopRightSubView];
    [self layoutBaseContentSubView:bounds];
}

- (void)layoutShareScreenViewWithBounds:(CGRect)bounds {
    UIView *shareScreenView = [self viewWithTag:kShareScreenViewTag];
    if (bounds.size.width > bounds.size.height) {
        shareScreenView.frame = CGRectMake(SCREEN_WIDTH * 0.1, 0, SCREEN_WIDTH * 0.8, SCREEN_HEIGHT);
    } else {
        shareScreenView.frame = CGRectMake(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT * 0.8);
    }
}

- (void)layoutTopLeftSubView {
    
    // Place the show engine states button to the right of mute camera button.
    CGFloat engineStatesInfoX = SCREEN_WIDTH*109*kLayoutWidthScale;
    CGFloat engineStatesInfoY = SCREEN_HEIGHT*80*kLayoutHeightScale;
    CGFloat engineStatesInfoW = SCREEN_WIDTH*80*kLayoutWidthScale;
    CGFloat engineStatesInfoH = engineStatesInfoW*75/80;
    CGRect showEngineStatesFrame = CGRectMake(engineStatesInfoX,
                                              engineStatesInfoY,
                                              engineStatesInfoW,
                                              engineStatesInfoH);
    _engineStatesInfoShow.frame = showEngineStatesFrame;
}

- (void)layoutTopRightSubView {
    
    CGFloat pad = self.frame.size.width * 150 * kLayoutWidthScale;
    CGFloat baseX = self.frame.size.width * 1050 * kLayoutWidthScale;
    CGFloat baseY = self.frame.size.height * 80 * kLayoutHeightScale;
    CGFloat baseWidth = self.frame.size.width * 120 * kLayoutWidthScale;
    CGRect baseFrame = CGRectMake(baseX, baseY, baseWidth, baseWidth * 75 / 80);
    
    _settingRoomInterconnection.frame = CGRectMake(baseX, baseY, baseWidth, baseWidth * 75 / 80);

    baseFrame.origin.x -= pad;
    _btnVoiceChange.frame = baseFrame;

    baseFrame.origin.x -= pad;
    _settingBeauty.frame = baseFrame;

//    baseFrame.origin.x -= pad;
//    _showVideoPattern.frame = baseFrame; // width 100
    
    baseFrame.origin.x -= pad;
    _btnUserLists.frame = baseFrame; // height 100/80

    baseFrame.origin.x -= pad;
    _whiteBoardBtn.frame = baseFrame;

    baseFrame.origin.x -= pad;
    _shareScreenBtn.frame = baseFrame; // height 100/80
}

- (void)layoutBaseContentSubView:(CGRect)bounds {
    [_statusLabel sizeToFit];
    _statusLabel.center = CGPointMake(CGRectGetMidX(bounds), CGRectGetMidY(bounds));

    // adding time display
    CGFloat timeDisplayLabelX = SCREEN_WIDTH*580*kLayoutWidthScale;
    CGFloat timeDisplayLabelY = SCREEN_HEIGHT*1728*kLayoutHeightScale;
    CGFloat timeDisplayLabelW = SCREEN_WIDTH*100*kLayoutWidthScale;
    CGFloat timeDisplayLabelH = timeDisplayLabelW*56/100;
    RTCSettingsModel *rtcSetting = [RTCSettingsModel sharedInstance];
    if (![rtcSetting currentHasVideoSettingFromStore]) {
        timeDisplayLabelX = SCREEN_WIDTH*600*kLayoutWidthScale;
        timeDisplayLabelY = SCREEN_HEIGHT*1337*kLayoutHeightScale;
    }
    _timeDisplayLabel.frame = CGRectMake(timeDisplayLabelX,
                                         timeDisplayLabelY,
                                         timeDisplayLabelW,
                                         timeDisplayLabelH);
    _timeDisplayLabel.text = [self getCurrentTime];
    
    _receiveMessageView.frame = CGRectMake(20, timeDisplayLabelY - 120, SCREEN_WIDTH / 2.0, 120);
    
//    if (_viewScrollView && _pageControl) {
//        CGFloat viewScrollViewX = SCREEN_WIDTH*0*kLayoutWidthScale;
//        CGFloat viewScrollViewY = SCREEN_HEIGHT*368*kLayoutHeightScale;
//        CGFloat viewScrollViewW = SCREEN_WIDTH*1242*kLayoutWidthScale;
//        CGFloat viewScrollViewH = SCREEN_HEIGHT*1326*kLayoutHeightScale;
//
//        _viewScrollView.frame = CGRectMake(viewScrollViewX,
//                                           viewScrollViewY,
//                                           viewScrollViewW,
//                                           viewScrollViewH);
//
//
//        _viewScrollView.contentSize = CGSizeMake(viewScrollViewW* self.nNumShownPage, viewScrollViewH - 2*pageControlHeight);
//        _viewScrollView.backgroundColor = [UIColor clearColor];
//        _viewScrollView.pagingEnabled = YES;
//
//        _pageControl.frame = CGRectMake(viewScrollViewX,viewScrollViewY +viewScrollViewH,viewScrollViewW,pageControlHeight);
//    }
    

    if (![rtcSetting currentHasVideoSettingFromStore]) {
        CGFloat personPhotoViewX = SCREEN_WIDTH*371*kLayoutWidthScale;
        CGFloat personPhotoViewY = SCREEN_HEIGHT*403*kLayoutHeightScale;
        CGFloat personPhotoViewW = SCREEN_WIDTH*500*kLayoutWidthScale;
        CGFloat personPhotoViewH = personPhotoViewW;
        CGRect personPhotoViewFrame = CGRectMake(personPhotoViewX,
                                                 personPhotoViewY,
                                                 personPhotoViewW,
                                                 personPhotoViewH);
        _personPhotoImgView.frame = personPhotoViewFrame;
    }
}

#pragma mark - settingPannel

- (RTCCallingSettingsPanelView *)settingPanel {
    return _rtcCallingSettingPanel;
}

- (RTCCallingSettingsPanelView *) rtcCallingSettingPanel{
    if (!_rtcCallingSettingPanel) {
        
        CGRect frame = self.bounds;
        CGFloat scrollViewW = self.frame.size.width*828*kLayoutWidthScale;
        CGFloat scrollViewH = self.frame.size.height*552*kLayoutHeightScale + 60;
        CGFloat scrollViewX = frame.size.width/2 - scrollViewW / 2;
        CGFloat scrollViewY = frame.size.height/2 - scrollViewH / 2 - 30;
        
        _rtcCallingSettingPanel = [[RTCCallingSettingsPanelView alloc] initWithFrame:CGRectMake(scrollViewX,scrollViewY,scrollViewW,scrollViewH)];
        _rtcCallingSettingPanel.delegate = self;
        
        [self addSubview:_rtcCallingSettingPanel];
    }
    return _rtcCallingSettingPanel;
}
//
//- (UIView *)tipView{
//    if (!_tipView) {
//        CGRect frame = self.bounds;
//        CGFloat scrollViewW = self.frame.size.width*828*kLayoutWidthScale;
//        CGFloat scrollViewH = self.frame.size.height*552*kLayoutHeightScale;
//        CGFloat scrollViewX = frame.size.width/2 - scrollViewW / 2;
//        CGFloat scrollViewY = frame.size.height/2 - scrollViewH / 2;
//        _tipView = [[UIView alloc] initWithFrame:CGRectMake(scrollViewX, scrollViewY, scrollViewW, scrollViewH)];
//        _tipView.backgroundColor = [UIColor whiteColor];
//        [self addSubview:_tipView];
//
//        _tipLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, scrollViewH / 3 - 20, scrollViewW, scrollViewH / 3)];
//        _tipLabel.numberOfLines = 0;
//        _tipLabel.text = @"您已被移出房间";
//        _tipLabel.font = [UIFont systemFontOfSize:14];
//        _tipLabel.textAlignment = NSTextAlignmentCenter;
//        _tipLabel.textColor = [UIColor blackColor];
//        [_tipView addSubview:_tipLabel];
//
//        _tipButton = [UIButton buttonWithType:UIButtonTypeCustom];
//        _tipButton.frame = CGRectMake((scrollViewW - scrollViewW / 5)/2, scrollViewH - scrollViewH / 6 - 20, scrollViewW / 5, scrollViewH / 6);
//        [_tipButton setTitle:@"确定" forState:UIControlStateNormal];
//        _tipButton.titleLabel.font = [UIFont systemFontOfSize:14];
//        [_tipButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
//        _tipButton.backgroundColor = [UIColor systemBlueColor];
//        [_tipButton addTarget:self action:@selector(confirmAction:) forControlEvents:UIControlEventTouchUpInside];
//        [_tipView addSubview:_tipButton];
//        _tipButton.layer.cornerRadius = 3;
//        _tipButton.layer.masksToBounds = YES;
//
//    }
//    return _tipView;
//}

#pragma mark - beautyFacePanel
- (BDMVBeautyFacePanelView *) rtcBeautyFacePanel{
    if (!_rtcBeautyFacePanel) {
        CGRect frame = self.bounds;
        CGFloat scrollViewW = self.frame.size.width*828*kLayoutWidthScale;
        CGFloat scrollViewH = self.frame.size.height*700*kLayoutHeightScale;
        CGFloat scrollViewX = frame.size.width/2 - scrollViewW / 2;
        CGFloat scrollViewY = frame.size.height/2 - scrollViewH / 2;
        
        CGRect rect = CGRectMake(scrollViewX, scrollViewY, scrollViewW, scrollViewH);
        _beautyFaceOperator = [[RTCBeautyFaceOperator alloc] initWithBeautyManager:self.beautyManager];
        _rtcBeautyFacePanel = [[BDMVBeautyFacePanelView alloc] initWithFrame:rect delegate:_beautyFaceOperator];
        _rtcBeautyFacePanel.hidden = YES;
        [self addSubview:_rtcBeautyFacePanel];
    }
    return _rtcBeautyFacePanel;
}

#pragma mark - RTCEAGLVideoViewDelegate
- (void)remoteVideoView:(RTCRemoteVideoView *)videoView didChangeVideoSize:(CGSize)size {
    //TODO changeVideoSize info
    NSLog(@"didChangeVideoSize : size width:%f, height:%f", size.width, size.height);
    
//    if (self.isMultiPersons && size.width > 0 && size.height > 0) {
        
        //TODO 考虑聊天室模式和1v1模式 --更新UI大小
//        RTCRemoteVideoViewInfo * rrvvInfo =  [[UserRemoteManager instance] remoteUserQuery:videoView.userId];
//        rrvvInfo.videoView.videoResolution = size;
//        [self updateSubView:videoView uid:videoView.userId add:NO];
        
        
//        RtcViewLayoutInfo *rvli = nil;
//        RTCRemoteVideoViewInfo *remote = nil;
//        for (NSInteger i = 0; i < _remoteVideoViewLayoutRecord.count; i++) {
//            rvli = [_remoteVideoViewLayoutRecord objectAtIndex:i];
//            remote = [_remoteVideoViewGroup objectAtIndex:i];
//            if (rvli.remoteVideoView == videoView) {
//                break;
//            }
//            if (!rvli.isUesed) {
//                rvli.isUesed = YES;
//                //挂到speakingMode渲染 还是挂到meeting模式渲染
//                rvli.remoteVideoView = videoView;
//
//                rvli.remoteVideoView.videoResolution = size;
////                CGRect videoViewFrame = AVMakeRectWithAspectRatioInsideRect(size, rvli.viewFrame);
////                videoView.videoView.frame = videoViewFrame;
//
//                [self updateSubView:videoView uid:videoView.userId add:YES];
//
////                NSLog(@"updateSubView:videoView  width:%f height:%f", size.width, size.height);
//
//                break;
//            }
//        }
//
////        rvli.remoteVideoView.videoResolution = size;
////        CGRect videoViewFrame = AVMakeRectWithAspectRatioInsideRect(size, rvli.viewFrame);
////        videoView.videoView.frame = videoViewFrame;
//        if (rvli.isRemoved) {
//            [self addSubview:videoView.videoView];
//            [self bringSubviewToFront:_statsView];
//        }
//    } else {
//        if (videoView == _remoteVideoView) {
//            _remoteVideoSize = size;
//        }
//    }
    // TODO(liminglu)后续有信令可以通过远端进行旋转
//    if(size.width > size.height) {
//        // 352*288 -> 288*352
//        // rotation_90
//        videoView.videoView.transform = CGAffineTransformMakeRotation((angle2Rad(90)));
//    }
    
//    [self setNeedsLayout];
}
- (void)remoteVideoView:(RTCRemoteVideoView *)videoView videoRenderStuck:(NSInteger)duration {
    
}

- (void)remoteVideoView:(RTCRemoteVideoView *)videoView superResolutionEnabled:(BOOL)enabled reason:(SrEnabledReason)reason {
    [_delegate videoCallViewSuperResolutionEnabled:enabled reason:reason];
}

#pragma mark - Private
- (void)onMicphoneChange:(id)sender {
    if (!self.isMuteMic) {
        self.isMuteMic = YES;
        UIImage *img = [UIImage imageNamed:@"mute_mic_two_y.png"];
        [_muteMicPhone setImage:img forState:UIControlStateNormal];
    } else {
        self.isMuteMic = NO;
        UIImage *img = [UIImage imageNamed:@"mute_mic_two_n.png"];
        [_muteMicPhone setImage:img forState:UIControlStateNormal];
    }
    [_delegate videoCallViewDidMuteMicphone:self];
}

int nswitch = 0;
- (void)onCameraSwitch:(id)sender {
    
    if (!self.isSwitchCamear) {
        self.isSwitchCamear = YES;
        UIImage* img = [UIImage imageNamed:@"switch_camera_y.png"];
        [_cameraSwitchButton setImage:img forState:UIControlStateNormal];
    } else {
        self.isSwitchCamear = NO;
        UIImage* img = [UIImage imageNamed:@"switch_camera_n.png"];
        [_cameraSwitchButton setImage:img forState:UIControlStateNormal];
    }
    [_delegate videoCallViewDidSwitchCamera:self];
}

- (void)onCameraChange:(id)sender {
    if (!self.isSwitchVoice) {
        self.isSwitchVoice = YES;
        UIImage* img = [UIImage imageNamed:@"switch_voice_y.png"];
        [_muteCamera setImage:img forState:UIControlStateNormal];
    } else {
        self.isSwitchVoice = NO;
        UIImage* img = [UIImage imageNamed:@"switch_voice_n.png"];
        [_muteCamera setImage:img forState:UIControlStateNormal];
    }
    [_delegate videoCallViewDidMuteCamera:self mute:!self.isSwitchVoice];
}

- (void)onShowEngineStates:(id)sender {
    if (!self.isOpeningMonitor) {
        self.isOpeningMonitor = YES;
        UIImage* img = [UIImage imageNamed:@"monitor_y.png"];
        [_engineStatesInfoShow setImage:img forState:UIControlStateNormal];
    } else {
        self.isOpeningMonitor = NO;
        UIImage* img = [UIImage imageNamed:@"monitor.png"];
        [_engineStatesInfoShow setImage:img forState:UIControlStateNormal];
    }
    [_delegate videoCallViewDidEnableStats:self show:self.isOpeningMonitor];
}

- (void)onRoomInterconnection:(id)sender {
    
    NSLog(@"onRoomInterconnection test");
    _isOpenSetingPanel = !_isOpenSetingPanel;
    if (_isOpenSetingPanel) {
        if (self.rtcCallingSettingPanel) {
            self.rtcCallingSettingPanel.hidden = NO;
        }
        if (self.rtcBeautyFacePanel){
            self.rtcBeautyFacePanel.hidden = YES;
            self.isOpenBeautyFacePanel = NO;
        }
        [self.rtcCallingSettingPanel setNeedsLayout];
    } else {
        if (self.rtcCallingSettingPanel) {
            self.rtcCallingSettingPanel.hidden = YES;
            [self.rtcCallingSettingPanel removeFromSuperview];
            self.rtcCallingSettingPanel = nil;
        }
    }
}

//- (void)changedNeedLayoutView {
//
//    if (_shownMeetingMode) {
//        NSUInteger countViews = [[UserRemoteManager instance] remoteSubscribeNumers];
//        NSUInteger pageNum = (countViews + 1) / 4 + ((countViews + 1) % 4 > 0 ? 1 : 0);
//
//        CGFloat viewScrollViewW = SCREEN_WIDTH*1242*kLayoutWidthScale;
//        CGFloat viewScrollViewH = viewScrollViewW*1.2;
//
//        self.viewScrollView.contentSize = CGSizeMake(self.viewScrollView.frame.size.width * pageNum, viewScrollViewH - 2*pageControlHeight);
//
//        [self  speakingToMeetingMode];
//
//        self.viewScrollView.pagingEnabled = YES;
//        self.viewScrollView.hidden = NO;
//
//        self.pageControl.numberOfPages = pageNum > 0 ? pageNum : 1;
////        self.pageControl.currentPage = 0;
//        self.pageControl.hidden = NO;
//
//    } else {
//        //回收样式
//        [self meetingModeToSpeaking];
//    }
//
//    if (_rtcCallingSettingPanel) {
//        [self bringSubviewToFront:_rtcCallingSettingPanel];
//    }
//
//    [self setNeedsLayout];
//}

- (void)onWhiteBoardBtnClicked:(UIButton *)btn {
    if (!btn.enabled) {
        return;
    }
    if ([self.delegate respondsToSelector:@selector(whiteBoardInvoke)]) {
        [self.delegate whiteBoardInvoke];
    }
}

- (void)onShareScreenBtnClicked:(UIButton *)btn {
    if (!btn.enabled) {
        return;
    }
    if ([self.delegate respondsToSelector:@selector(videoCallViewDidShareScreenClicked:)]) {
        [self.delegate videoCallViewDidShareScreenClicked:self];
    }
}

- (void)onBtnUserListsEvent:(id)sender {
    if ([self.delegate
         respondsToSelector:@selector(userListInvoke)]) {
        [self.delegate userListInvoke];
    }
}

//- (void)onVideoShownPattern:(id)sender {
//    // 多人模式下不能切换
//    NSArray *arr = [[UserRemoteManager instance] remoteAllUsers];
//    if (arr.count >= 2 && self.shownMeetingMode) return;
//
//    BOOL newMode = !self.shownMeetingMode;
//    [self __updateVideoShownPatternMode:newMode];
//    [[RTCSettingsModel sharedInstance] storeShownMeetingMode:newMode];
//
//    NSLog(@"onVideoShownPattern to mode: %@", @(newMode));
//}
//
//- (void)__updateVideoShownPatternMode:(BOOL)isShownMeetingMode {
//    NSLog(@"__updateVideoShownPatternMode to mode: %@", @(isShownMeetingMode));
//
//    self.shownMeetingMode = isShownMeetingMode;
//    _showVideoPattern.selected = !isShownMeetingMode;
//    [self changedNeedLayoutView];
//}

- (void)onBeautySetting:(id)sender {
    
    NSLog(@"onBeautySetting test");
    _isOpenBeautyFacePanel = !_isOpenBeautyFacePanel;
    
    if ( _isOpenBeautyFacePanel){
    
        self.rtcBeautyFacePanel.hidden = NO;
        self.rtcCallingSettingPanel.hidden = YES;
        _isOpenSetingPanel = NO;
        
    } else {
        self.rtcBeautyFacePanel.hidden = YES;
    }
    [self bringSubviewToFront:self.rtcBeautyFacePanel];
    [self.rtcBeautyFacePanel setNeedsLayout];

    NSLog(@"onBeautySetting test");
}

- (void)onBtnVoiceChangeClicked:(id)sender {
    NSLog(@"onBtnVoiceChangeClicked");
    
    if (!self.rtcVoiceChangePanel) {
        CGFloat height = 250;
        CGRect frame = CGRectMake(0, self.frame.size.height - height, self.frame.size.width, height);
        self.rtcVoiceChangePanel = [[RTCVoiceChangePanelView alloc] initWithFrame:frame];
        self.rtcVoiceChangePanel.hidden = YES;
        [self addSubview:self.rtcVoiceChangePanel];
        
        __weak typeof(self) weakSelf = self;
        self.rtcVoiceChangePanel.selectedVoiceChangeTypeChanged = ^(int type) {
            __strong typeof(self) strongSelf = weakSelf;
            if ([strongSelf.delegate respondsToSelector:@selector(videoCallViewDidSelectVoiceChangeType:)]) {
                [strongSelf.delegate videoCallViewDidSelectVoiceChangeType:type];
            }
        };
    }
    
    self.rtcVoiceChangePanel.hidden = !self.rtcVoiceChangePanel.hidden;
}

- (void)onRouteChange:(id)sender {
    [self updateRouteChangeStatus:!self.isLoundSpeaker];
    [_delegate videoCallViewDidChangeRoute:self];
}

- (void)updateRouteChangeStatus:(BOOL)isLoundSpeaker {
    if (isLoundSpeaker) {
        self.isLoundSpeaker = YES;
        _routeChangeButton.selected = YES;
    } else {
        self.isLoundSpeaker = NO;
        _routeChangeButton.selected = NO;
    }
}

- (void)onHangup:(id)sender {
    [_delegate videoCallViewDidHangup:self];
}

- (void)onTapScreen:(UITapGestureRecognizer*)gesture {
    CGPoint point = [gesture locationInView:gesture.view];
    CGSize size = self.bounds.size;
    [_delegate videoCallViewDidTapScreen:point andPlaneSize:size];
    //[self setCameraFocusEffectWithPoint:point];
}
- (void)onTapScreenRight:(UITapGestureRecognizer*)gesture {
    NSLog(@"onTapScreenRight");
}

- (void)didTripleTap:(UITapGestureRecognizer *)recognizer {
    self.isOpeningMonitor = !self.isOpeningMonitor;
    [_delegate videoCallViewDidEnableStats:self show:self.isOpeningMonitor];
}

- (void)setCameraFocusEffectWithPoint:(CGPoint)point{
    self.cameraFocusView.center = point;
    self.cameraFocusView.hidden = NO;
    [UIView animateWithDuration:0.3 animations:^{
        self.cameraFocusView.transform = CGAffineTransformMakeScale(1.25, 1.25);
    }completion:^(BOOL finished) {
        [UIView animateWithDuration:0.5 animations:^{
            self.cameraFocusView.transform = CGAffineTransformIdentity;
        } completion:^(BOOL finished) {
            self.cameraFocusView.hidden = YES;
        }];
    }];
}

- (NSString*)getCurrentTime {
    NSDate *date=[NSDate date];
    NSDateFormatter* dft=[[NSDateFormatter alloc] init];
    [dft setDateFormat:@"hh:mm"];
    NSString *dateStr;
    dateStr = [dft stringFromDate:date];
    return dateStr;
}

#pragma  mark ViewGroups manager view shown in two mode

//- (void)meetingModeToSpeaking {
//    //将本地和远端的再接回来显示
//
//    [self.localVideoView.videoView removeFromSuperview];
//    [self addSubview:self.localVideoView.videoView];
//
//    [self flushScrollView:self.viewScrollView];
//
//    [self unbindMeetModeLayoutAll];
//
//    NSArray * arr = [[UserRemoteManager instance] remoteSubScribedUsers];
//    for (RTCRemoteVideoViewInfo *videoInfo  in arr) {
//        [videoInfo.videoView.videoView  removeFromSuperview]; //解绑定
////
//        [self addSubview:videoInfo.videoView.videoView];      //绑定
//        [self sendSubviewToBack:videoInfo.videoView.videoView];
//        [self bindSpeakLayout:videoInfo.videoView]; //位置
//    }
//
////    for (int i = 0; i < self.remoteVideoViewGroup.count; i++) {
////        RTCRemoteVideoViewInfo *videoInfo = self.remoteVideoViewGroup[i];
////        if (videoInfo.isUsed == true) {
////            //找一个free的样式，布局就好
////            [videoInfo.videoView.videoView  removeFromSuperview]; //解绑定
////
////            [self addSubview:videoInfo.videoView.videoView];      //绑定
////            [self sendSubviewToBack:videoInfo.videoView.videoView];
////            [self bindSpeakLayout:videoInfo.videoView]; //位置
////
////        }
////    }
//
//    self.viewScrollView.hidden = YES;
//    self.pageControl.hidden = YES;
//
//    //[self bringSubviewToFront:self.localVideoView.videoView];
////    [self bringSubviewToFront:_statsView];
//
//}

//TODO speak模式需要调整
- (void)bindSpeakLayout:(RTCRemoteVideoView *)videoView {
//    RtcViewLayoutInfo *rvli = nil;
//    for (NSInteger i = 0; i < _remoteVideoViewLayoutRecord.count; i++) {
//        rvli = [_remoteVideoViewLayoutRecord objectAtIndex:i];
//        RTCRemoteVideoViewInfo *rvInfo = [_remoteVideoViewGroup objectAtIndex:i];
//        if (rvli.isUesed == NO) {
//           //can user
//            rvli.isUesed = YES;
//            rvli.remoteVideoView = videoView;
//
//            CGRect videoViewFrame = AVMakeRectWithAspectRatioInsideRect(videoView.videoView.frame.size, rvli.viewFrame);
//            videoView.videoView.frame = videoViewFrame;
//            rvInfo.userInfoView.frame = CGRectMake(0, videoViewFrame.size.height - 40, videoViewFrame.size.width, 40);
//            break;
//        }
//    }
    CGRect rectMid = CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height);
    
    CGSize dest = videoView.videoResolution;
    if (dest.width > 0 && dest.height > 0) {
        CGRect videoViewFrame = AVMakeRectWithAspectRatioInsideRect(dest, rectMid);
        videoView.videoView.frame = videoViewFrame;
    } else {
        videoView.videoView.frame = rectMid;
    }
}
- (void)unbindMeetModeLayoutAll {
    RtcViewLayoutInfo *rvli = nil;
    for (NSInteger i = 0; i < _remoteVideoViewLayoutRecord.count; i++) {
        rvli = [_remoteVideoViewLayoutRecord objectAtIndex:i];
        if (rvli.isUesed) {
            rvli.isUesed = NO;
            rvli.remoteVideoView = nil;
        }
    }
}

- (void)unbindSpeakLayout:(RTCRemoteVideoView *)remoteVideo {
    
//    RtcViewLayoutInfo *rvli = nil;
//    for (NSInteger i = 0; i < _remoteVideoViewLayoutRecord.count; i++) {
//        rvli = [_remoteVideoViewLayoutRecord objectAtIndex:i];
//        if (rvli.remoteVideoView && (rvli.remoteVideoView.videoView == remoteVideo.videoView)) {
//            rvli.isUesed = NO;
//            rvli.remoteVideoView = nil;
//            break;
//        }
//    }
}

//- (void)speakingToMeetingMode {
//    [self flushScrollView:self.viewScrollView];
//    _nNumShownPage = 1;
//    _currentRtcSubview = [[RTCScrollSubView alloc] initWithFrame:CGRectMake(0, 0, CGRectGetWidth(self.viewScrollView.frame), CGRectGetHeight(self.viewScrollView.frame))];
//    _currentRtcSubview.tag = _nNumShownPage;
//    [self.viewScrollView  addSubview:_currentRtcSubview];
//
//    [self.localVideoView.videoView removeFromSuperview];
//    CGSize LocalView = CGSizeMake([[RTCSettingsModel sharedInstance] currentVideoResolutionWidthFromStore], [[RTCSettingsModel sharedInstance] currentVideoResolutionHeightFromStore]);
//    [_currentRtcSubview addRTCsubView:@"8888" local:YES view:self.localVideoView.videoView size:LocalView];
//
//    int validViewNumber = 0;
//    NSArray *arr = [[UserRemoteManager instance] remoteSubScribedUsers];
//    for (RTCRemoteVideoViewInfo *videoInfo in arr) {
//         if ((0 == (validViewNumber + 1) % 4) && (validViewNumber > 0)) {
//             _currentRtcSubview = [[RTCScrollSubView alloc] initWithFrame:CGRectMake(CGRectGetWidth(self.viewScrollView.frame) * _nNumShownPage, 0, CGRectGetWidth(self.viewScrollView.frame), CGRectGetHeight(self.viewScrollView.frame))];
//             _nNumShownPage++;
//             _currentRtcSubview.tag =_nNumShownPage;
//             [self.viewScrollView  addSubview:_currentRtcSubview ];
//
//         }
//         [videoInfo.videoView.videoView  removeFromSuperview];
//         //[self unbindSpeakLayout:videoInfo.videoView]; //与通话模式样式布局脱离
//         [_currentRtcSubview addRTCsubView:[NSString stringWithFormat:@"%ld", (long)videoInfo.videoView.userId] local:NO view:videoInfo.videoView.videoView size:videoInfo.videoView.videoResolution];
//         validViewNumber++;
//    }
////    for (int i = 0; i < self.remoteVideoViewGroup.count; i++) {
////        RTCRemoteVideoViewInfo *videoInfo = self.remoteVideoViewGroup[i];
////        if (videoInfo.isUsed) {
////            if ((0 == (validViewNumber + 1) % 4) && (validViewNumber > 0)) {
////                _currentRtcSubview = [[RTCScrollSubView alloc] initWithFrame:CGRectMake(CGRectGetWidth(self.viewScrollView.frame) * _nNumShownPage, 0, CGRectGetWidth(self.viewScrollView.frame), CGRectGetHeight(self.viewScrollView.frame))];
////                _nNumShownPage++;
////                _currentRtcSubview.tag =_nNumShownPage;
////                [self.viewScrollView  addSubview:_currentRtcSubview ];
////
////            }
////            [videoInfo.videoView.videoView  removeFromSuperview];
////            [self unbindSpeakLayout:videoInfo.videoView]; //与通话模式样式布局脱离
////            [_currentRtcSubview addRTCsubView:[NSString stringWithFormat:@"%ld", (long)videoInfo.videoView.userId] local:NO view:videoInfo.videoView.videoView size:videoInfo.videoView.videoResolution];
////            validViewNumber++;
////        }
////    }
////    self.pageControl.numberOfPages = _nNumShownPage; //需要更行panelCtrl以及scrollView属性
//    [self.pageControl setNeedsLayout];
//    [self bringSubviewToFront:_statsView];
//
//}

//- (void)updateSubViewLocal:(RTCLocalVideoView *)remoteView{
//    if (self.shownMeetingMode) {
//
//        _nNumShownPage = 1;
//
//        _currentRtcSubview = [[RTCScrollSubView alloc] initWithFrame:CGRectMake(0, 0, CGRectGetWidth(self.viewScrollView.frame), CGRectGetHeight(self.viewScrollView.frame))];
//        _currentRtcSubview.tag = _nNumShownPage;
//        [self.viewScrollView  addSubview:_currentRtcSubview];
//        CGSize sizeOfLocalView = CGSizeMake([[RTCSettingsModel sharedInstance] currentVideoResolutionWidthFromStore], [[RTCSettingsModel sharedInstance] currentVideoResolutionHeightFromStore]);
//
//        [_currentRtcSubview addRTCsubView:@"8888" local:YES view:self.localVideoView.videoView size:sizeOfLocalView];
//
//    } else {
//        [self addSubview:self.localVideoView.videoView];
//    }
//}

- (void)updateSubView:(RTCRemoteVideoView*)remoteView
                  uid:(NSInteger)userID
                  add:(BOOL)boAdd {
//    remoteView.rtcVideoViewMode = RTCVideoViewScaleAspectFit;
    NSUInteger countViews = [[UserRemoteManager instance] remoteSubscribeNumers];
    if (self.is1v1) {
        if (boAdd) {
            self.twoPersonCallView.remoteView = remoteView;
//           if (countViews == 1 ) { //2人
                [self.twoPersonCallView addRTCsubView:[NSString stringWithFormat:@"%ld",(long)userID] 
                                                local:NO 
                                                 view:remoteView.videoView
                                                 size:remoteView.videoResolution];
//            }
        } else {
            self.twoPersonCallView.remoteView = nil;
            [self.twoPersonCallView removeRTCsubView:[NSString stringWithFormat:@"%ld",(long)userID]];
        }
        
    } else {
        if (boAdd) {
           
           [self.siglePageCallView addRTCsubView:[NSString stringWithFormat:@"%ld",(long)userID] 
                                           local:NO
                                            view:remoteView.videoView
                                            size:remoteView.videoResolution
                                            show:(countViews < BDSiglePageNumber) ? YES: NO];
           
        } else {
            [self.siglePageCallView removeRTCsubView:[NSString stringWithFormat:@"%ld",(long)userID]];
        }
    }
    
//    int countViews = [[UserRemoteManager instance] remoteSubscribeNumers];
//    if (self.shownMeetingMode) {
//        if (boAdd) {
//            if ((0 == (countViews + 1)%4) && (countViews > 0)) {
//                _currentRtcSubview = [[RTCScrollSubView alloc] initWithFrame:CGRectMake(CGRectGetWidth(self.viewScrollView.frame) * _nNumShownPage, 0, CGRectGetWidth(self.viewScrollView.frame), CGRectGetHeight(self.viewScrollView.frame))];
//                [self.viewScrollView  addSubview:_currentRtcSubview];
//                _nNumShownPage++;
//                _currentRtcSubview.tag = _nNumShownPage;
//                self.pageControl.numberOfPages = _nNumShownPage > 0 ? _nNumShownPage : 1; //需要更行panelCtrl以及scrollView属性
//                [self.pageControl setNeedsLayout];
//            }
//            [_currentRtcSubview addRTCsubView: [NSString stringWithFormat:@"%ld",(long)userID] local:NO view:remoteView.videoView size:remoteView.videoResolution];
//        }
//    }else{
//        if (boAdd) {
//            [self addSubview:remoteView.videoView];
//            if (countViews == 0) {
//                //全屏幕显示
//                [self bringSubviewToFront:_localVideoView.videoView];
//                [self bringSubviewToFront:_statsView];
//            } else {
//                [self __updateVideoShownPatternMode:!self.shownMeetingMode];
//            }
//        }
//    }
    
//    if (countViews > 2){
//        _showVideoPattern.userInteractionEnabled = NO;
//    } else {
//        _showVideoPattern.userInteractionEnabled = YES;
//    }
    
//    NSLog(@"_nNumCountRemoteSubView:%d",countViews);
//    [self changedNeedLayoutView];
    
    NSArray *remoteAllUsers = [[UserRemoteManager instance] remoteAllUsers];
    if (!self.is1v1 && ![[RTCSettingsModel sharedInstance] currentIsMockSdpFromStore]) {
        for (int i = 0; i < remoteAllUsers.count; i++) {
            RTCRemoteVideoViewInfo *userInfo = remoteAllUsers[i];
            NSString *userId = [NSString stringWithFormat:@"%ld", userInfo.userId];
            if ([self.siglePageCallView.remoteUids containsObject:userId]) {
                NSLog(@"vocs view appear for userId:%@", userId);
                [_delegate videoCallViewDidRemoteviewDisappear:NO remoteUid:userId];
            } else {
                if ([self.siglePageCallView.allAddedUids containsObject:userId]) {
                    NSLog(@"vocs view disappear for userId:%@", userId);
                    [_delegate videoCallViewDidRemoteviewDisappear:YES remoteUid:userId];
                    [self.siglePageCallView.allAddedUids removeObject:userId];
                }
            }
        }
    }
}

static BOOL _storedShowMeetingMode = YES;
static int kShareScreenViewTag = 10011;

- (void)updateShareScreenView:(RTCRemoteVideoView *)remoteView
                          uid:(NSInteger)userID
                          add:(BOOL)boAdd {
    
    _storedShowMeetingMode = self.shownMeetingMode;
    if (boAdd) {
//        [self __updateVideoShownPatternMode:YES];
        
        remoteView.videoView.tag = kShareScreenViewTag;
        [self addSubview:remoteView.videoView];
        [self sendSubviewToBack:remoteView.videoView];
        [self layoutShareScreenViewWithBounds:self.bounds];
    } else {
//        [self __updateVideoShownPatternMode:_storedShowMeetingMode];
    }
}

- (void)flushScrollView:(UIScrollView*) scrollView {
    for (UIView *subView in scrollView.subviews)
    {
        [subView.subviews makeObjectsPerformSelector:@selector(removeFromSuperview)];
        [subView removeFromSuperview];
    }
}

- (void)enableShareScreenBtn:(BOOL)enable {
    _shareScreenBtn.enabled = enable;
}

#pragma mark  RTCCCallingSettingPannelView event
- (void)settingPanelSnapshot:(NSInteger)userId {
    if ([self.delegate respondsToSelector:@selector(videoCallSnapShotStart:)]) {
        [self.delegate videoCallSnapShotStart:userId];
    }
}

//called when room relay start
- (void) roomDelayRoomStart:(NSString*)newRoom user:(NSInteger)userId relay:(RelayOperateType)rot {
    if ([self.delegate
         respondsToSelector:@selector(videoCallViewRoomDelayRoomStart:userRelay:relay:)]) {
        [self.delegate videoCallViewRoomDelayRoomStart:newRoom userRelay:userId relay:rot];
    }
}

//called when room relay  end
- (void) roomDelayRoomEnd:(NSString*)newRoom {
    if ([self.delegate
         respondsToSelector:@selector(videoCallViewRoomDelayRoomEnd:)]) {
        [self.delegate videoCallViewRoomDelayRoomEnd:newRoom];
    }
}

//是否禁言
- (void)shutUpUserWithId:(NSString *)userId isDisable:(BOOL)isDisable {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewShutUpUserWithId:isDisable:)]) {
        [self.delegate videoCallViewShutUpUserWithId:userId isDisable:isDisable];
    }
}

//移出某人
- (void)kickOffUserWithId:(NSString *)userId {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewKickOffUserWithId:)]) {
        [self.delegate videoCallViewKickOffUserWithId:userId];
    }
}

//全部禁言
- (void)shutupAllUser {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewShutupAllUser)]) {
        [self.delegate videoCallViewShutupAllUser];
    }
}

//解散房间
- (void)disbandRoom {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewDisbandRoom)]) {
        [self.delegate videoCallViewDisbandRoom];
    }
}

- (void)showSpeakerStatus {
    if ([self.delegate respondsToSelector:@selector(videoCallViewShowSpeakerStatus)]) {
        [self.delegate videoCallViewShowSpeakerStatus];
    }
}

- (void)switchRole {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewSwitchRole)]) {
        [self.delegate videoCallViewSwitchRole];
    }
}


//发送消息给某人
- (void)sendMessage:(NSString *)message toUser:(NSString *)userId {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewSendMessage:toUser:)]) {
        [self.delegate videoCallViewSendMessage:message toUser:userId];
    }
}

//发送消息
- (void)sendMessage:(NSString *)message {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewSendMessage:)]) {
        [self.delegate videoCallViewSendMessage:message];
    }
}

- (void)sendStressDataChannel:(BOOL)isStart frequency:(int)frequency bps:(int)bps reliable:(BOOL)reliable {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewSendStressDataChannel:frequency:bps:reliable:)]) {
        [self.delegate videoCallViewSendStressDataChannel:isStart frequency:frequency bps:bps reliable:reliable];
    }
}

- (void)subribeStream:(NSString *)streamId {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewSubribeStream:)]) {
        [self.delegate videoCallViewSubribeStream:streamId];
    }
}

- (void)updateSubribeStream:(NSString *)streamId {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewSubribeStream:)]) {
        [self.delegate videoCallViewUpdateSubribeStream:streamId];
    }
}

- (void)cancelSubribeStream:(NSString *)streamId {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewCancelSubribeStream:)]) {
        [self.delegate videoCallViewCancelSubribeStream:streamId];
    }
}

- (void)settingPanelScreenParamsUpdated:(BRTCScreenShareParams *)params {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewScreenParamsUpdated:)]) {
        [self.delegate videoCallViewScreenParamsUpdated:params];
    }
}

- (void)settingPanelScreenSnapshot {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewScreenSnapshot)]) {
        [self.delegate videoCallViewScreenSnapshot];
    }
}

- (void)enableWatermark:(BOOL)enable {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewEnableWatermark:)]) {
        [self.delegate videoCallViewEnableWatermark:enable];
    }
}

- (void)lockCameraOrient:(BOOL)lock {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewLockCameraOrient:)]) {
        [self.delegate videoCallViewLockCameraOrient:lock];
    }
}
- (void)enableSuperResolution:(BOOL)enable {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewEnableSuperResolution:)]) {
        [self.delegate videoCallViewEnableSuperResolution:enable];
    }
}
- (void)enableManualPushStream:(BOOL)enable {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewEnableManualPushStream:)]) {
        [self.delegate videoCallViewEnableManualPushStream:enable];
    }
}


- (void)enableAudioVolumeIndication:(BOOL)enable interval:(int)interval {
    if ([self.delegate respondsToSelector:@selector(videoCallViewEnableAudioVolumeIndication:interval:)]) {
        [self.delegate videoCallViewEnableAudioVolumeIndication:enable interval:interval];
    }
}

- (void)settingViewRecordTypeDidChange:(int)type {
    if ([self.delegate respondsToSelector:@selector(videoCallViewRecordTypeDidChange:)]) {
        [self.delegate videoCallViewRecordTypeDidChange:type];
    }
}

- (void)settingViewRecordMixLayoutDidChange:(int)layout {
    if ([self.delegate respondsToSelector:@selector(videoCallViewRecordMixLayoutDidChange:)]) {
        [self.delegate videoCallViewRecordMixLayoutDidChange:layout];
    }
}

- (void)startRecorderMedia {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewStartRecorderMedia)]) {
        [self.delegate videoCallViewStartRecorderMedia];
    }
}

- (void)stopRecorderMedia {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewStopRecorderMedia)]) {
        [self.delegate videoCallViewStopRecorderMedia];
    }
}

- (void)startPlayerMediaWithLoopback:(BOOL)loopback cycle:(NSUInteger)cycle {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewStartPlayerMediaWithLoopback:cycle:)]) {
        [self.delegate videoCallViewStartPlayerMediaWithLoopback:loopback cycle:cycle];
    }
}

- (void)pausePlayerMedia {
    if ([self.delegate respondsToSelector:@selector(videoCallViewPausePlayerMedia)]) {
        [self.delegate videoCallViewPausePlayerMedia];
    }
}

- (void)resumePlayerMedia {
    if ([self.delegate respondsToSelector:@selector(videoCallViewResumePlayerMedia)]) {
        [self.delegate videoCallViewResumePlayerMedia];
    }
}

- (void)stopPlayerMedia {
    if (self.delegate && [self.delegate respondsToSelector:@selector(videoCallViewStopPlayerMedia)]) {
        [self.delegate videoCallViewStopPlayerMedia];
    }
}



- (void)displayLogMessage:(NSString *)message {
  dispatch_async(dispatch_get_main_queue(), ^{
      self.receiveMessageView.text =
      [NSString stringWithFormat:@"%@%@\n", self.receiveMessageView.text, message];
      NSRange range = NSMakeRange(self.receiveMessageView.text.length, 0);
      [self.receiveMessageView scrollRangeToVisible:range];
  });
}

//- (void)displayTipView:(NSString *)tipString {
//    self.tipView.hidden = NO;
//    self.tipLabel.text = tipString;
//}

- (void)recall {
    self.beautyFaceOperator.beautyManager = self.beautyManager;
    [self.beautyFaceOperator restoreOperations];
    // others
}


//截图功能

-(UIImage *)captureImageFromView:(UIView *)view{

    UIGraphicsBeginImageContextWithOptions(view.frame.size,NO, 0);
    [[UIColor clearColor] setFill];
    [[UIBezierPath bezierPathWithRect:view.bounds] fill];
    CGContextRef ctx = UIGraphicsGetCurrentContext();
    [view.layer renderInContext:ctx];
    UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return image;
    
}

@end
///////////
