//
//  RTCVideoCallView.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef RTCVideoCallView_h
#define RTCVideoCallView_h

#import <UIKit/UIKit.h>
#import "RTCStatsView.h"
#import "BDCloudRTCBaseDefine.pch"
#import "UserRemoteManager.h"
#import "RTCCallingSettingsPanelView.h"

@class RTCVideoCallView;
@class RTCVideoUserInfoView;
@protocol BaiduRtcBeautyManager;

@interface RtcViewLayoutInfo : NSObject
@property (nonatomic, assign) BOOL isRemoved;
@property (nonatomic, assign) BOOL isUesed;
@property (nonatomic, assign) CGRect viewFrame;

@property (nonatomic, strong) RTCRemoteVideoView *remoteVideoView;
@end

@protocol RTCVideoCallViewDelegate <NSObject>
//Called when the micphone switch button is pressed.
- (void)videoCallViewDidMuteMicphone:(RTCVideoCallView *)view;

// Called when the camera switch button is pressed.
- (void)videoCallViewDidSwitchCamera:(RTCVideoCallView *)view;

// Called when closing or openning camera.
- (void)videoCallViewDidMuteCamera:(RTCVideoCallView *)view mute:(BOOL)mute;

// Called when the route change button is pressed.
- (void)videoCallViewDidChangeRoute:(RTCVideoCallView *)view;

// Called when the hangup button is pressed.
- (void)videoCallViewDidHangup:(RTCVideoCallView *)view;

// Called when stats are enabled by triple tapping.
- (void)videoCallViewDidEnableStats:(RTCVideoCallView *)view show:(BOOL)show;

//Called when gesture are captured by triple tapping.
- (void)videoCallViewDidTapScreen:(CGPoint)point andPlaneSize:(CGSize)size;

//Called when the share screen button is pressed.
- (void)videoCallViewDidShareScreenClicked:(RTCVideoCallView *)view;

//called when view disappear or  appear
- (void)videoCallViewDidRemoteviewDisappear:(BOOL)disappear remoteUid:(NSString*)userId;

//called when view disappear or  appear
- (void)videoCallAudoDidRemoteviewDisappear:(BOOL)disappear remoteUid:(NSString*)userId;

//called when room relay
- (void) videoCallViewRoomDelayRoomStart:(NSString*)newRoom userRelay:(NSInteger)userId relay:(RelayOperateType) rot;

//called when room relay
- (void) videoCallViewRoomDelayRoomEnd:(NSString*)newRoom;

//called when snapshot comming
- (void)videoCallSnapShotStart:(NSInteger)userId;

//禁言某人
- (void)videoCallViewShutUpUserWithId:(NSString *)userId isDisable:(BOOL)isDisable;

//移出某人
- (void)videoCallViewKickOffUserWithId:(NSString *)userId;

//全部禁言
- (void)videoCallViewShutupAllUser;

//解散房间
- (void)videoCallViewDisbandRoom;
- (void)videoCallViewShowSpeakerStatus;

// 角色切换
- (void)videoCallViewSwitchRole;

//发送消息给某人
- (void)videoCallViewSendMessage:(NSString *)message toUser:(NSString *)userId;

//发送消息
- (void)videoCallViewSendMessage:(NSString *)message;

//DataChannel压力测试
- (void)videoCallViewSendStressDataChannel:(BOOL)isStart frequency:(int)frequency bps:(int)bps reliable:(BOOL)reliable;

//订阅流
- (void)videoCallViewSubribeStream:(NSString *)streamId;
//更新订阅流位置
- (void)videoCallViewUpdateSubribeStream:(NSString *)streamId;
//取消订阅流
- (void)videoCallViewCancelSubribeStream:(NSString *)streamId;

- (void)videoCallViewNotifyShutup:(BOOL)isShutuped;

- (void)videocallViewNotifyKickoff;

//ui 用户列表触发
- (void) userListInvoke;

// 变声效果变化
- (void)videoCallViewDidSelectVoiceChangeType:(int)type;

// 屏幕分享参数更新
- (void)videoCallViewScreenParamsUpdated:(BRTCScreenShareParams *)params;
- (void)videoCallViewScreenSnapshot;

// 启动白板
- (void)whiteBoardInvoke;

// 超分开启以及回调
- (void)videoCallViewEnableSuperResolution:(BOOL)enableSR;
- (void)videoCallViewSuperResolutionEnabled:(BOOL)enabled reason:(SrEnabledReason)reason;
- (void)videoCallViewEnableManualPushStream:(BOOL)enable;

- (void)videoCallViewEnableWatermark:(BOOL)enableWatermark;
- (void)videoCallViewLockCameraOrient:(BOOL)lock;

- (void)videoCallViewRecordTypeDidChange:(int)type; // BRTCMediaRecorderType
- (void)videoCallViewRecordMixLayoutDidChange:(int)layout; // BRTCMediaMixType
- (void)videoCallViewStartRecorderMedia;
- (void)videoCallViewStopRecorderMedia;

- (void)videoCallViewStartPlayerMediaWithLoopback:(BOOL)loopback cycle:(NSUInteger)cycle;
- (void)videoCallViewPausePlayerMedia;
- (void)videoCallViewResumePlayerMedia;
- (void)videoCallViewStopPlayerMedia;
- (void)videoCallViewEnableAudioVolumeIndication:(BOOL)enable interval:(int)interval;

@end


// Video call view that shows local and remote video, provides a label to
// display status, and also a hangup button.
@interface RTCVideoCallView : UIView

@property(nonatomic, readonly) UILabel *statusLabel;
//add new parameters for local and remote video view
@property(nonatomic, strong) RTCLocalVideoView *localVideoView;
@property(nonatomic, strong) RTCRemoteVideoView *remoteVideoView;
@property(nonatomic, strong) NSMutableArray<RtcViewLayoutInfo *> *remoteVideoViewLayoutRecord;
//@property(nonatomic, strong) NSMutableArray<RTCRemoteVideoViewInfo *> *remoteVideoViewGroup;
@property(nonatomic, readonly) RTCStatsView *statsView;
@property(nonatomic, weak) id<RTCVideoCallViewDelegate> delegate;
@property(nonatomic, weak) id<BaiduRtcBeautyManager> beautyManager;
@property(nonatomic, strong) UIView*  localShownView;
@property (nonatomic, strong, readonly) RTCCallingSettingsPanelView* settingPanel;

- (instancetype)initWithFrame:(CGRect)frame
                          uid:(NSInteger)uid
                   sdkVersion:(NSString*)sdkVersion;

- (void)updateSubView:(RTCRemoteVideoView*)remoteView
                  uid:(NSInteger)userID
                  add:(BOOL)boAdd;

- (void)updateShareScreenView:(RTCRemoteVideoView *)remoteView
                          uid:(NSInteger)userID
                          add:(BOOL)boAdd;

- (void)enableShareScreenBtn:(BOOL)enable;

- (void)updateRouteChangeStatus:(BOOL)isLoundSpeaker;

- (void)displayLogMessage:(NSString *)message;

/// 重连 rtc，用于实例重建场景恢复会话配置及状态
- (void)recall;

@end

#endif /* RTCVideoCallView_h */
