//
//  RTCSiglePageCallView.m
//  rtc_sdk_ios
//
//  Created by v_liyingna on 11/30/22.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCSiglePageCallView.h"
#import "RTCScrollSubView.h"
#import <AVFoundation/AVFoundation.h>
#import "BDCloudRTCBaseDefine.pch"

@interface RTCSiglePageCallView ()
@property (nonatomic, strong) NSMutableDictionary *shownVideoViews;
@property (nonatomic, strong) NSMutableDictionary *noShownVideoViews;
@end

@implementation RTCSiglePageCallView
@synthesize  remoteUids = _remoteUids;
@synthesize  allAddedUids = _allAddedUids;
- (instancetype)initWithFrame:(CGRect)frame {
    
    if (self = [super initWithFrame:frame]) {
        _shownVideoViews = [NSMutableDictionary dictionary];
        _noShownVideoViews = [NSMutableDictionary dictionary];
    }
    self.autoresizingMask = UIViewAutoresizingFlexibleLeftMargin|
                            UIViewAutoresizingFlexibleWidth|
                            UIViewAutoresizingFlexibleRightMargin|
                            UIViewAutoresizingFlexibleTopMargin|
                            UIViewAutoresizingFlexibleHeight|
                            UIViewAutoresizingFlexibleBottomMargin;
    return self;
}

- (NSMutableArray *)remoteUids {
    if(!_remoteUids) {
        _remoteUids = [NSMutableArray array];
    }
    return _remoteUids;
}

- (NSMutableArray *)allAddedUids {
    if(!_allAddedUids) {
        _allAddedUids = [NSMutableArray array];
    }
    return _allAddedUids;
}

- (void)addRTCsubView:(NSString *)uId local:(BOOL)isLocal view:(UIView*)subview size:(CGSize)videoRelution show:(BOOL)isShow {
    NSLog(@"addRTCsubView: uId:%@, show:%@, self : %@,  view : %@, size : %f, %f", uId, (isShow ? @"yes" : @"no"), self, subview, videoRelution.width, videoRelution.height);
    if (subview) {
        RTCsubviewInfo* rtcSubviewInfo = [[RTCsubviewInfo alloc] initWithParams:isLocal uid:uId view:subview size:videoRelution];
        if (isShow) {
            [_shownVideoViews setObject:rtcSubviewInfo forKey:uId];
            [self addSubview:subview];
            [self setNeedsLayout];
        } else {
            [_noShownVideoViews setObject:rtcSubviewInfo forKey:uId];
        }
        
    }
    if (!isLocal && isShow) {
        [self.remoteUids addObject:uId];
        if (![self.allAddedUids containsObject:uId]) {
            [self.allAddedUids addObject:uId];
        }
    }
}

- (void)removeRTCsubView:(NSString *)uId {
    NSLog(@"removeRTCsubView: uId:%@, showVideoView:%@, remoteUids:%@", uId, _shownVideoViews, _remoteUids);

    if ([_noShownVideoViews.allKeys containsObject:uId]) {
        [_noShownVideoViews removeObjectForKey:uId];
        return;
    }
    RTCsubviewInfo* subviewInfo = [_shownVideoViews objectForKey:uId];
    if (subviewInfo.showView != nil) {
        [subviewInfo.showView removeFromSuperview];
        subviewInfo.showView = nil;
        [_shownVideoViews removeObjectForKey:uId];
        [_remoteUids removeObject:uId];
        NSLog(@"removeRTCsubView: uId:%@, remove uid", uId);

        if (_noShownVideoViews.allKeys.count > 0) {
            NSArray *noShowArray = _noShownVideoViews.allValues;
            RTCsubviewInfo *tempInfo = noShowArray.firstObject;
            [self addSubview:tempInfo.showView];
            [_shownVideoViews setObject:tempInfo forKey:tempInfo.userId];
            [self.remoteUids addObject:tempInfo.userId];
            [_noShownVideoViews removeObjectForKey:tempInfo.userId];
        }
        [self setNeedsLayout];
    }
}
- (void)layoutSubviews {
    [super layoutSubviews];
 
    NSMutableArray *videoViews = [NSMutableArray array];
    NSMutableArray *tempVideoViews = [NSMutableArray array];
//    [videoViews addObjectsFromArray:[_shownVideoViews allValues]];
    NSArray *array = [_shownVideoViews allValues];
    for (int i = 0; i < array.count; i ++) {
        RTCsubviewInfo *tempInfo = array[i];
        if (tempInfo.isLocal) {
            [videoViews addObject:tempInfo];
        } else {
            [tempVideoViews addObject:tempInfo];
        }
    }
    [videoViews addObjectsFromArray:tempVideoViews];
    if (videoViews.count == 1) {
        if(((RTCsubviewInfo *)videoViews[0]).isLocal) {
            CGRect rectMid = CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height);
            ((RTCsubviewInfo *)videoViews[0]).showView.frame = rectMid;
        } else {
            CGRect rectMid = CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height);
            ((RTCsubviewInfo *)videoViews[0]).showView.frame = rectMid;
//            ((RTCsubviewInfo *)videoViews[0]).showView.frame = [self tranctOriginRectToRealRect:((RTCsubviewInfo *)videoViews[0]).videoResolution physicRect:rectMid];
        }
        
    } else if (videoViews.count == 2) {
        if (((RTCsubviewInfo *)videoViews[0]).isLocal) {
            CGRect rectMid = CGRectMake(self.bounds.size.width*2/3, 0, self.bounds.size.width/3, self.bounds.size.height/3);
            ((RTCsubviewInfo*)videoViews[0]).showView.frame = rectMid;
            [self bringSubviewToFront:((RTCsubviewInfo*)videoViews[0]).showView];
        } else {
            CGRect rectMid = CGRectMake(0, self.bounds.size.height/4, self.bounds.size.width/2, self.bounds.size.height/2);
            ((RTCsubviewInfo *)videoViews[0]).showView.frame = rectMid;
//            ((RTCsubviewInfo *)videoViews[0]).showView.frame = [self tranctOriginRectToRealRect:((RTCsubviewInfo *)videoViews[0]).videoResolution physicRect:rectMid];
        }

        if (((RTCsubviewInfo*)videoViews[1]).isLocal) {
            CGRect rectMidOther = CGRectMake(self.bounds.size.width*2/3, 0, self.bounds.size.width/3, self.bounds.size.height/3);
            ((RTCsubviewInfo*)videoViews[1]).showView.frame = rectMidOther;
        } else {
            CGRect rectMidOther = CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height);
            ((RTCsubviewInfo *)videoViews[1]).showView.frame = rectMidOther;
//            ((RTCsubviewInfo *)videoViews[1]).showView.frame = [self tranctOriginRectToRealRect:((RTCsubviewInfo *)videoViews[1]).videoResolution physicRect:rectMidOther];
        }
    }
    else if (videoViews.count > 2 && videoViews.count <= 4) {
        for (int i=0; i < videoViews.count; i++) {
            RTCsubviewInfo *tempInfo = videoViews[i];
            CGRect rectMidOther = CGRectMake(i%2 * self.bounds.size.width / 2.0, i/2 * self.bounds.size.height / 2.0 , self.bounds.size.width / 2.0, self.bounds.size.height / 2.0);

//            tempInfo.showView.frame = [self tranctOriginRectToRealRect:tempInfo.videoResolution physicRect:rectMidOther];
            tempInfo.showView.frame = rectMidOther;
        }
    }
    else if (videoViews.count > 4 ) {
        for (int i=0; i < (videoViews.count > BDSiglePageNumber ? BDSiglePageNumber : videoViews.count); i++) {
            RTCsubviewInfo *tempInfo = videoViews[i];
            CGRect rectMidOther = CGRectMake(i%3 * self.bounds.size.width / 3.0, i/3 * self.bounds.size.width / 3.0 , self.bounds.size.width / 3.0, self.bounds.size.width / 3.0);
//            tempInfo.showView.frame = [self tranctOriginRectToRealRect:tempInfo.videoResolution physicRect:rectMidOther];
            tempInfo.showView.frame = rectMidOther;
        }
    }
}

//- (CGRect)tranctOriginRectToRealRect:(CGSize)videoResolution physicRect:(CGRect)rectMidOther  {
//    if (videoResolution.width > 0 && videoResolution.height > 0) {
//        CGRect videoViewFrame = AVMakeRectWithAspectRatioInsideRect(videoResolution, rectMidOther);
//        return videoViewFrame;
//    } else {
//        return rectMidOther;
//    }
//}

@end
