//
//  BDCloudSnapShot.m
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/10/18.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BDCloudSnapShot.h"

#import "BDCloudEnhanceVideo.h"
#import <BDCloudMediaFilter/BDCloudVideoEnhanceFilter.h>
#import "BaiduRtcRoom/BaiduRtcRoom.h"
#import <CoreMedia/CoreMedia.h>
#import <CoreMedia/CMSampleBuffer.h>

@interface BDCloudSnapShot ()
@property (nonatomic, assign) BOOL reSetFilter;
@property (nonatomic, strong) BDSnapShotCompleteBlock bdSnapShotBlock;

@end

@implementation BDCloudSnapShot {
    BOOL _snapshotBegin;
}
- (instancetype)initWithMediaType:(NSString *)mediaType {
    if (self = [super initWithMediaType:mediaType]) {
    }
    return self;
}

- (void)startSnapShot:(BDSnapShotCompleteBlock)complete {
    _snapshotBegin = YES;
    _bdSnapShotBlock = complete;
}

- (void)frame:(CMSampleBufferRef)frame type:(NSString *)type {
    if ([type isEqualToString:AVMediaTypeVideo]) {
        
//        @autoreleasepool {
            BDCloudAVCMSampleBuffer *buffer = [BDCloudAVCMSampleBuffer fromCMSampleBuffer:frame];
            if (!buffer) {
                return;
            }
            if (_snapshotBegin) {
                _snapshotBegin = NO;
                if (_bdSnapShotBlock) {
                    //snapshot 截图
                    UIImage *pImage = [self imageFromSampleBuffer:frame];
                    _bdSnapShotBlock([pImage CGImage]);
                }
            }
            [self raiseFrame:frame];

//        }
    }
}

- (UIImage *) imageFromSampleBuffer:(CMSampleBufferRef) sampleBuffer {
    // 为媒体数据设置一个CMSampleBuffer的Core Video图像缓存对象
    CVImageBufferRef imageBuffer = CMSampleBufferGetImageBuffer(sampleBuffer);
    // 锁定pixel buffer的基地址
    CVPixelBufferLockBaseAddress(imageBuffer, 0);
    
    // 得到pixel buffer的基地址
    void *baseAddress = CVPixelBufferGetBaseAddress(imageBuffer);
    
    // 得到pixel buffer的行字节数
    size_t bytesPerRow = CVPixelBufferGetBytesPerRow(imageBuffer);
    // 得到pixel buffer的宽和高
    size_t width = CVPixelBufferGetWidth(imageBuffer);
    size_t height = CVPixelBufferGetHeight(imageBuffer);
    
    // 创建一个依赖于设备的RGB颜色空间
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();
    
    // 用抽样缓存的数据创建一个位图格式的图形上下文（graphics context）对象
    CGContextRef context = CGBitmapContextCreate(baseAddress, width, height, 8,
                                                 bytesPerRow, colorSpace, kCGBitmapByteOrder32Little | kCGImageAlphaPremultipliedFirst);
    // 根据这个位图context中的像素数据创建一个Quartz image对象
    CGImageRef quartzImage = CGBitmapContextCreateImage(context);
    // 解锁pixel buffer
    CVPixelBufferUnlockBaseAddress(imageBuffer, 0);
    
    // 释放context和颜色空间
    CGContextRelease(context);
    CGColorSpaceRelease(colorSpace);
    
    // 用Quartz image创建一个UIImage对象image
    UIImage *image = [UIImage imageWithCGImage:quartzImage];
    
    // 释放Quartz image对象
    CGImageRelease(quartzImage);
    
    return (image);
}
@end
