//
//  BDCloudEnhanceVideo.m
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/9/4.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import "BDCloudEnhanceVideo.h"
//#import <BDCloudMediaFilter/BDCloudVideoEnhanceFilter.h>
#import "BaiduRtcRoom/BaiduRtcRoom.h"
#import <CoreMedia/CoreMedia.h>
#import <CoreMedia/CMSampleBuffer.h>
#import <Accelerate/Accelerate.h>
#import <CoreVideo/CVPixelBuffer.h>




@interface BDCloudEnhanceVideo()
//@property (nonatomic, strong) BDCloudVideoEnhanceFilter *bdCloudeVideoEnhance;
@property (nonatomic, assign) size_t frameWidth;
@property (nonatomic, assign) size_t frameHeight;
@property (nonatomic, assign) BOOL reSetFilter;
@property (nonatomic, strong) BDSnapShotCompleteBlock bdSnapShotBlock;

@end

@implementation BDCloudEnhanceVideo {
    BOOL _snapshotBegin;
    CGFloat _videoContrast;
    CGFloat _videoSaturation;
    CGFloat _videoBrightness;
}

- (instancetype)initWithMediaType:(NSString *)mediaType {
    if (self = [super initWithMediaType:mediaType]) {
//        _filters = [NSMutableArray array];
//        _videoOutput = [[BDCloudAVOutput alloc] initWithMediaType:AVMediaTypeVideo];
    }
    return self;
}
- (void)setVideoEnhanceEX:(CGFloat)brightness contrast:(CGFloat)videoContrast saturation:(CGFloat)statration {
    _videoContrast = videoContrast;
    _videoSaturation = statration;
    _videoBrightness = brightness;
}

- (void)resetVideoEnhanceEX:(BOOL)enable{
    
}
- (void)startSnapShot:(BDSnapShotCompleteBlock)complete {
    _snapshotBegin = YES;
    _bdSnapShotBlock = complete;
}
//- (BDCloudVideoEnhanceFilter *) bdCloudeVideoEnhance {
//    if(!_bdCloudeVideoEnhance || _reSetFilter) {
//        _bdCloudeVideoEnhance = [[BDCloudVideoEnhanceFilter alloc] initContextWithWidth:_frameWidth withHeight:_frameHeight];
//    }
//    return  _bdCloudeVideoEnhance;
//}
- (void)frame:(CMSampleBufferRef)frame type:(NSString *)type {
    if ([type isEqualToString:AVMediaTypeVideo]) {
        
        @autoreleasepool {
        BDCloudAVCMSampleBuffer *buffer = [BDCloudAVCMSampleBuffer fromCMSampleBuffer:frame];
        if (!buffer) {
            return;
        }
        if (_snapshotBegin) {
            _snapshotBegin = NO;
            if (_bdSnapShotBlock) {
               //snapshot 截图
                UIImage *pImage = [self imageFromSampleBuffer:frame];
                _bdSnapShotBlock([pImage CGImage]);
            }
        }
            
        [self raiseFrame:frame];
        
//        if ( [[RTCSettingsModel sharedInstance] currentVideoEnhanceFromStore]) {
//            if ((self.frameWidth == 0) && (self.frameHeight == 0)) {
//                self.frameWidth = buffer.pixelBuffer.width;
//                self.frameHeight = buffer.pixelBuffer.height;
//                [self.bdCloudeVideoEnhance setBrightnessSwitch:YES];
//                NSLog(@"ClarityValue:%f SaturationValue:%f", [self.bdCloudeVideoEnhance getClarityValue], [self.bdCloudeVideoEnhance getSaturationValue]);
//                [self.bdCloudeVideoEnhance setClarityValue:3.0];
//                [self.bdCloudeVideoEnhance setSaturationValue:1.2];
//            }
////            OSType format_type = CVPixelBufferGetPixelFormatType(buffer.pixelBuffer.buffer);
////            OSType aa_type = kCVPixelFormatType_420YpCbCr8BiPlanarVideoRange;
////            OSType rgb_a = kCVPixelFormatType_32RGBA;
////            if (format_type != kCVPixelFormatType_420YpCbCr8BiPlanarVideoRange) {
////            }
//            //NSLog(@"zhangyafei video type:%u, nv12:%u",format_type,kCVPixelFormatType_32BGRA);
//                CVImageBufferRef pixelBuffer = [self.bdCloudeVideoEnhance imgEnhanceWithNV12Buffer:buffer.pixelBuffer.buffer
//                                                                                            width:buffer.pixelBuffer.width
//                                                                                            height:buffer.pixelBuffer.height];
//                CMVideoFormatDescriptionRef videoInfo = NULL;
//                CMVideoFormatDescriptionCreateForImageBuffer(NULL, pixelBuffer, &videoInfo);
//                CMSampleBufferRef sampleBuffer = NULL;
//                CMSampleTimingInfo time = {buffer.duration, buffer.pts, kCMTimeInvalid};
//                OSStatus status =  CMSampleBufferCreateForImageBuffer(kCFAllocatorDefault,
//                                                                      pixelBuffer,
//                                                                  true,
//                                                                  NULL,
//                                                                  NULL,
//                                                                  videoInfo,
//                                                                  &time, &sampleBuffer);
//
//                if(status == noErr ) {
//                    CFRelease(pixelBuffer);
//                    pixelBuffer = NULL;
//                    [self raiseFrame:sampleBuffer];
//
//                    if (sampleBuffer) {
//                        CFRelease(sampleBuffer);
//                        sampleBuffer = NULL;
//                    }
//                }else{
//                    if (sampleBuffer) {
//                        CFRelease(sampleBuffer);
//                        buffer = NULL;
//                    }
//                }
//
//                if (videoInfo) {
//                    CFRelease(videoInfo);
//                    videoInfo = NULL;
//                }
//            } else {
//                // nv12--->rgb
//
//                CVImageBufferRef imageBuffer = CMSampleBufferGetImageBuffer(frame);
//                CVPixelBufferLockBaseAddress(imageBuffer,0);
//                size_t bytesPerRow = CVPixelBufferGetBytesPerRow(imageBuffer);
//                size_t width = CVPixelBufferGetWidth(imageBuffer);
//                size_t height = CVPixelBufferGetHeight(imageBuffer);
//                uint8_t *yBuffer = (uint8_t *)CVPixelBufferGetBaseAddressOfPlane(imageBuffer, 0);
//                size_t yPitch = CVPixelBufferGetBytesPerRowOfPlane(imageBuffer, 0);
//                uint8_t *cbCrBuffer = (uint8_t *)CVPixelBufferGetBaseAddressOfPlane(imageBuffer, 1);
//                size_t cbCrPitch = CVPixelBufferGetBytesPerRowOfPlane(imageBuffer, 1);
//                void *srcYpData = malloc(height *yPitch);
//                memcpy(srcYpData, yBuffer, height *yPitch);
//                void *srcCbCrData = malloc(height *cbCrPitch);
//                memcpy(srcCbCrData, cbCrBuffer, height *cbCrPitch);
//                size_t aRgbPitch = width *  4;
//                uint8_t *aRgbBuffer = (uint8_t *)malloc(height *aRgbPitch);
//                memset(aRgbBuffer, 0, height *aRgbPitch);
//                vImage_Buffer srcYp = {srcYpData,height,width,yPitch};
//                vImage_Buffer srcCbCr = {srcCbCrData,height,width,cbCrPitch};
//                vImage_Buffer dest = {aRgbBuffer,height,width,aRgbPitch};
//                vImage_YpCbCrPixelRange pixelRange = {16,128,235,240,235,16,240,16};
//                vImage_YpCbCrToARGB infoYpCbCrToARGB = {};
//                vImage_Error error = vImageConvert_YpCbCrToARGB_GenerateConversion(kvImage_YpCbCrToARGBMatrix_ITU_R_601_4, &pixelRange, &infoYpCbCrToARGB, kvImage420Yp8_CbCr8, kvImageARGB8888, kvImageNoFlags);
//                uint8_t permuteMap[4] = {0, 1, 2, 3};
//                error = vImageConvert_420Yp8_CbCr8ToARGB8888(&srcYp, &srcCbCr, &dest, &infoYpCbCrToARGB, permuteMap, 255, kvImageNoFlags);
//                //处理dest中的ARGB数据/*code...*/
//
//                // 构造pixbuf 1
//                CVPixelBufferRef pixelBuffer;
//                NSDictionary *options = [NSDictionary dictionaryWithObjectsAndKeys:
//                                             [NSNumber numberWithBool : YES],           kCVPixelBufferCGImageCompatibilityKey,
//                                             [NSNumber numberWithBool : YES],           kCVPixelBufferCGBitmapContextCompatibilityKey,
//                                             [NSNumber numberWithInt  : width],  kCVPixelBufferWidthKey,
//                                             [NSNumber numberWithInt  : height], kCVPixelBufferHeightKey,
//                                             nil];

//                CVPixelBufferCreateWithBytes(kCFAllocatorDefault, width, height, kCMPixelFormat_32BGRA, dest, bytesPerRow, NULL, NULL, options, &pixelBuffer);
                
                
//                CVReturn status = CVPixelBufferCreateWithBytes(kCFAllocatorDefault, width, height, kCVPixelFormatType_32BGRA, dest, bytesPerRow, NULL, NULL, (__bridge CFDictionaryRef)options, &pixelBuffer);
//                if(status == noErr ) {
//                    
//                }
                // 构造pixbuf 2
                
//                CVPixelBufferRef pixelBuffer;
//                CVPixelBufferCreate(kCFAllocatorSystemDefault, width, height, kCVPixelFormatType_32BGRA, NULL, &pixelBuffer);
//
//                CVPixelBufferLockBaseAddress(pixelBuffer, 0);
//
//                vImage_CGImageFormat format = {
//                    .bitsPerComponent = 8,
//                    .bitsPerPixel = 32,
//                    .bitmapInfo = kCGBitmapByteOrder32Little | kCGImageAlphaNoneSkipFirst,  //BGRX8888
//                    .colorSpace = NULL,  //sRGB
//                };
//
//                vImageBuffer_CopyToCVPixelBuffer(&dest,
//                                                 &format,
//                                                 pixelBuffer,
//                                                 NULL,
//                                                 NULL,
//                                                 kvImageNoFlags);  // Here is the crash!
//
//                CVPixelBufferUnlockBaseAddress(pixelBuffer, 0);
             
                //构造sample
//                CMVideoFormatDescriptionRef videoInfo = NULL;
//                CMVideoFormatDescriptionCreateForImageBuffer(NULL, pixelBuffer, &videoInfo);
//                CMSampleBufferRef sampleBuffer = NULL;
//                CMSampleTimingInfo time = {buffer.duration, buffer.pts, kCMTimeInvalid};
//                OSStatus status1 =  CMSampleBufferCreateForImageBuffer(kCFAllocatorDefault,
//                                                                      pixelBuffer,
//                                                                  true,
//                                                                  NULL,
//                                                                  NULL,
//                                                                  videoInfo,
//                                                                  &time, &sampleBuffer);
//
//
//                if(status1 == noErr ) {
//                    CFRelease(pixelBuffer);
//                    pixelBuffer = NULL;
//                    [self raiseFrame:sampleBuffer];
//
//                    if (sampleBuffer) {
//                        CFRelease(sampleBuffer);
//                        sampleBuffer = NULL;
//                    }
//                }
//                free(srcYpData);
//                free(srcCbCrData);
//                free(aRgbBuffer);
//            }
        }
        
    }
}

- (UIImage *) imageFromSampleBuffer:(CMSampleBufferRef) sampleBuffer {
    // 为媒体数据设置一个CMSampleBuffer的Core Video图像缓存对象
    CVImageBufferRef imageBuffer = CMSampleBufferGetImageBuffer(sampleBuffer);
    // 锁定pixel buffer的基地址
    CVPixelBufferLockBaseAddress(imageBuffer, 0);
    
    // 得到pixel buffer的基地址
    void *baseAddress = CVPixelBufferGetBaseAddress(imageBuffer);
    
    // 得到pixel buffer的行字节数
    size_t bytesPerRow = CVPixelBufferGetBytesPerRow(imageBuffer);
    // 得到pixel buffer的宽和高
    size_t width = CVPixelBufferGetWidth(imageBuffer);
    size_t height = CVPixelBufferGetHeight(imageBuffer);
    
    // 创建一个依赖于设备的RGB颜色空间
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();
    
    // 用抽样缓存的数据创建一个位图格式的图形上下文（graphics context）对象
    CGContextRef context = CGBitmapContextCreate(baseAddress, width, height, 8,
                                                 bytesPerRow, colorSpace, kCGBitmapByteOrder32Little | kCGImageAlphaPremultipliedFirst);
    // 根据这个位图context中的像素数据创建一个Quartz image对象
    CGImageRef quartzImage = CGBitmapContextCreateImage(context);
    // 解锁pixel buffer
    CVPixelBufferUnlockBaseAddress(imageBuffer, 0);
    
    // 释放context和颜色空间
    CGContextRelease(context);
    CGColorSpaceRelease(colorSpace);
    
    // 用Quartz image创建一个UIImage对象image
    UIImage *image = [UIImage imageWithCGImage:quartzImage];
    
    // 释放Quartz image对象
    CGImageRelease(quartzImage);
    
    return (image);
}


@end
