//
//  BDCloudAVRTCRoomVideoCaptureSessionKit.m
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/8/10.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import "BDCloudAVRTCRoomVideoCaptureSessionKit.h"
#import "BDCloudAVRTCRoomAudioDeviceFactory.h"
#import "BDCloudAVRTCRoomSession.h"

@class BaiduRtcRoomDelegate;

@interface BDCloudAVRTCRoomVideoCaptureSessionKit()<BDCloudAVRTCRoomAudioPlayerDeviceSource>

@property (nonatomic,assign) BOOL isRunning;
@property (nonatomic, strong) BDCloudAVStreamSettings *avstreamConfig;
@property(nonatomic, strong, readonly) BDCloudRTCRoomAVCaptureSettings *config;

@property (nonatomic, strong) BDCloudAVRTCRoomSession *roomSession;
@end


@implementation BDCloudAVRTCRoomVideoCaptureSessionKit {
    BOOL _usingFrontCamera;
}

//@synthesize captureDelegate = _captureDelegate;
@synthesize preView = _preView;
@synthesize avstreamConfig = _avstreamConfig;
@synthesize avcaptureSession = _avcaptureSession;

- (instancetype)initWithConfig:(BDCloudRTCRoomAVCaptureSettings *)roomSetting
                      delegate:(id<BaiduRtcRoomDelegate>) roomDelegate {
    
    if (self = [super init]) {
        _config = roomSetting;
        if (!_roomSession) {
            _roomSession = [[BDCloudAVRTCRoomSession alloc] initWithAppID:_config.rtcAppId
                                                                 tokenStr:_config.rtcToken
                                                                 delegate:roomDelegate
                                                             playerSource:self];
            
//            [self.avcaptureSession.session addBufferListener:_roomSession.videoCapture];
            [self.avcaptureSession.session addBufferListener:self.avcaptureSession.enHanceVideo];
            
            [self.avcaptureSession.enHanceVideo addTarget:_roomSession.videoCapture];

            
            [self.avcaptureSession.session addBufferListener:_roomSession.audioDevice];
            _usingFrontCamera = YES;
        }
    }
    return  self;
}


- (BDCloudAVStreamSettings *)avstreamConfig {
    if (!_avstreamConfig) {
        _avstreamConfig = [BDCloudAVStreamSettings defaultSettings];
    
        _avstreamConfig.videoFrameRate = _config.frameRate;
        _avstreamConfig.dimensions = _config.caputreDimension;
        _avstreamConfig.enableLive = NO;
        _avstreamConfig.stabilizationMode =  AVCaptureVideoStabilizationModeStandard;
//        _avstreamConfig.dimensions        = _config.caputreDimension;
        _avstreamConfig.enableFramerateChange = NO;
        
        _avstreamConfig.audioSampleRate = _config.audioSampleRate;
        [_avstreamConfig updateMediaTypeHasVideo:_config.hasVideo hasAudio:_config.hasAudio];
    }
    return _avstreamConfig;
}

- (BDCloudAVARCaptureSession *)avcaptureSession {
    if (!_avcaptureSession) {
        _avcaptureSession = [[BDCloudAVARCaptureSession alloc] initWithCaptureConfig:self.avstreamConfig];
    }
    return _avcaptureSession;
}


- (UIView *)preView {
    return _preView;
}

#pragma  protocol BDCloudAVCaptureProtocol ---

- (void)autoPauseAudioBackground:(BOOL)pause {
    [self.avcaptureSession autoPauseAudioBackground:pause];
}

- (void)setCameraContinuousAutofocus:(BOOL)autoFocus {
    [self.avcaptureSession setCameraContinuousAutofocus:autoFocus];
}

- (void)setCameraExposurePointOfInterest:(CGPoint)point {
    [self.avcaptureSession setCameraExposurePointOfInterest:point];
}

- (void)setCameraFocusPointOfInterest:(CGPoint)point {
    [self.avcaptureSession setCameraFocusPointOfInterest:point];
}

- (void)setCameraZoomFactor:(CGFloat)zoomFactor {
    [self.avcaptureSession setCameraZoomFactor:zoomFactor];
}

- (BOOL)setImageOutput:(nullable UIImage *)image {
    return  [self.avcaptureSession setImageOutput:image];
    //return  [self.avcaptureSession setBufferListenerImageOutput:image];
}

- (void)startAudioPlay:(nonnull const AudioStreamBasicDescription *)playDes playerCallback:(nonnull BDCloudCaputureAudioPlayerCallback)playerCallback {
    
    __block BOOL playSuccess = NO;
    [self.avcaptureSession startAudioPlay:playDes playerCallback:^OSStatus(AudioUnitRenderActionFlags * _Nonnull ioActionFlags, const AudioTimeStamp * _Nonnull inTimeStamp, UInt32 inBusNumber, UInt32 inNumberFrames, AudioBufferList * _Nullable ioData) {
        playSuccess = YES;
        return playerCallback(ioActionFlags,
                              inTimeStamp,
                              inBusNumber,
                              inNumberFrames,
                              ioData);
    }];
    
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        if (!playSuccess) {
            [self.avcaptureSession startAudioPlay:playDes playerCallback:^OSStatus(AudioUnitRenderActionFlags * _Nonnull ioActionFlags, const AudioTimeStamp * _Nonnull inTimeStamp, UInt32 inBusNumber, UInt32 inNumberFrames, AudioBufferList * _Nullable ioData) {
                playSuccess = YES;
                return playerCallback(ioActionFlags,
                                      inTimeStamp,
                                      inBusNumber,
                                      inNumberFrames,
                                      ioData);
            }];
        }
     });
    
}
- (BOOL)startPreview {
    if (self.isRunning){
        return NO;
    }
    [self.avcaptureSession startPreview];
    _preView = self.avcaptureSession.preView;
    self.isRunning = YES;
    return YES;
}

//- (BOOL)startPreviewWithView:(UIView*)preview {
//    if (self.isRunning){
//        return NO;
//    }
//    self.avcaptureSession.delegate = self.captureDelegate;
//
//    if (self.avstreamConfig.enablelandscapeLeftRecord) {
//        self.avcaptureSession.view.transform = CGAffineTransformMakeRotation(-M_PI_2);
//    }
//
//    if (!_preView) {
//        _preView  = preview;
//        _preView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
//    }
//
//    self.avcaptureSession.preView.frame = self.preView.bounds;
//    self.avcaptureSession.view.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
//    self.isRunning = YES;
//    [self.preView insertSubview:self.avcaptureSession.view atIndex:0];
//
////    [self.avcaptureSession startPreview];
//
//
//    return YES;
//}

- (void)dealloc {

    _avcaptureSession.captureDelegate = nil;
    _avcaptureSession = nil;
}
- (void)stopAudioPlay {
    if (_avcaptureSession) {
        [_avcaptureSession stopAudioPlay];
    }
}

- (BOOL)stopPreview {
    if (!self.isRunning){
        return  NO;
    }
    [self setWatermark:nil];
    [self.avcaptureSession.preView removeFromSuperview];
    [self.avcaptureSession.session removeAllBufferListener];

    [self.avcaptureSession stopPreview];
    self.isRunning = NO;
    return YES;
}

- (void)switchCamera {
    _usingFrontCamera = !_usingFrontCamera;
    AVCaptureDevicePosition position =
        _usingFrontCamera ? AVCaptureDevicePositionFront : AVCaptureDevicePositionBack;
    [self.avcaptureSession switchCameraPosition:position];
}

- (void)toggleFlash:(AVCaptureFlashMode)mode {
    [self.avcaptureSession toggleFlash:mode];
}

- (void)toggleTorch:(BOOL)torchOn {
    [self.avcaptureSession toggleTorch:torchOn];
}

- (void)togglelocalMirror {
    [self.avcaptureSession togglelocalMirror];
}

- (void)toggleRemoteMirror {
    [self.avcaptureSession toggleRemoteMirror];

}
#pragma  protocol BDCloudAVVideoEffectProtocol


- (void)adjustBeautyBlurLevel:(CGFloat)level {
    [self.avcaptureSession adjustBeautyBlurLevel:level];
}

- (void)adjustBeautyBrowlengthLevel:(CGFloat)level {
    [self.avcaptureSession adjustBeautyBrowlengthLevel:level];
}

- (void)adjustBeautyChin:(CGFloat)level {
    [self.avcaptureSession adjustBeautyChin:level];
}

- (void)adjustBeautyEnlargingLevel:(CGFloat)level {
    [self.avcaptureSession adjustBeautyEnlargingLevel:level];
}

- (void)adjustBeautyEyeangleLevel:(CGFloat)level {
    [self.avcaptureSession adjustBeautyEyeangleLevel:level];
}

- (void)adjustBeautyEyelengthLevel:(CGFloat)level {
    [self.avcaptureSession adjustBeautyEyelengthLevel:level];
}

- (void)adjustBeautyFaceLengthLevel:(CGFloat)level {
    [self.avcaptureSession adjustBeautyFaceLengthLevel:level];
}

- (void)adjustBeautyFilter:(nonnull BDMVComplexFilterModel *)filterModel {
    [self.avcaptureSession adjustBeautyFilter:filterModel];
}

- (void)adjustBeautyMakeup:(nonnull BDMVMakeupModel *)makeupModel {
    [self.avcaptureSession adjustBeautyMakeup:makeupModel];
}

- (void)adjustBeautyMouthwidthLevel:(CGFloat)level {
    [self.avcaptureSession adjustBeautyMouthwidthLevel:level];
}

- (void)adjustBeautyNosebridgewidthLevel:(CGFloat)level {
    [self.avcaptureSession adjustBeautyNosebridgewidthLevel:level];
}

- (void)adjustBeautyThinningLevel:(CGFloat)level {
    [self.avcaptureSession adjustBeautyThinningLevel:level];
}

- (void)adjustBeautyWhiteLevel:(CGFloat)level {
    [self.avcaptureSession adjustBeautyWhiteLevel:level];
}

- (BDMVARFliterAdjustEnableState)adjustEnableState {
    return [self.avcaptureSession adjustEnableState];
}

- (void)adjustFeatures:(nonnull BDMVFeaturesModelType)featuresType value:(nonnull NSObject *)value {
    [self.avcaptureSession adjustFeatures:featuresType value:value];

}

- (void)applyBeautyBaseVideoFx {
    [self.avcaptureSession applyBeautyBaseVideoFx];

}

- (BOOL)applyEffectWithPath:(nonnull NSString *)path {
    return [self.avcaptureSession applyEffectWithPath:path];
}

- (BOOL)applyLocalStickerVideoFx:(nonnull NSString *)stickerPath
                stickerModelPath:(nonnull NSString *)stickerModelPath stickerType:(nonnull NSString *)stickerType stickerIdentify:(nonnull NSString *)stickerIdentify upportGesture:(BOOL)gesture {
    if (!self.avcaptureSession) {
        return  NO;
    }
    return [self.avcaptureSession applyLocalStickerVideoFx:stickerPath
                                 stickerModelPath:stickerModelPath
                                      stickerType:stickerType
                                  stickerIdentify:stickerIdentify
                                    upportGesture:gesture];
}

- (void)disabledBeautyBaseVideoFx {
    if (self.avcaptureSession) {
        [self.avcaptureSession disabledBeautyBaseVideoFx];
    }
}

- (void)disabledStickerVideoFx {
    if (self.avcaptureSession) {
        [self.avcaptureSession disabledStickerVideoFx];
    }
}

- (void)setWatermark:(nullable UIImage *)watermark {
    if (self.avcaptureSession) {
        [self.avcaptureSession setWatermark:watermark];
    }
}

- (void)setWatermarkMixturePercent:(float)watermarkMixurePercent {
    if (self.avcaptureSession) {
        [self.avcaptureSession setWatermarkMixturePercent:watermarkMixurePercent];
    }
}

- (void)setWatermarkPosition:(BDCloudAVMetalWatermarkPosition)watermarkPosition {
    if (self.avcaptureSession) {
        [self.avcaptureSession setWatermarkPosition:watermarkPosition];
    }
}

- (void)setWatermarkScale:(float)watermarkScale {
    if (self.avcaptureSession) {
        [self.avcaptureSession setWatermarkScale:watermarkScale];
    }
}

- (void)setVideoEnhanceEX:(CGFloat)brightness contrast:(CGFloat)videoContrast saturation:(CGFloat)statration {
    [self.avcaptureSession setVideoEnhanceEX:brightness contrast:videoContrast saturation:statration];
}

- (void)resetVideoEnhanceEX:(BOOL)enble {
    [self.avcaptureSession resetVideoEnhanceEX:enble];
}





#pragma BDCloudAVRTCRoomProtocol

- (void)configLiveServerWithUrl:(nonnull NSString *)url isMix:(BOOL)isMix isRecording:(BOOL)isRecording mixTemplate:(nonnull NSString *)mixTmplt transferMode:(RtcLiveTransferMode)mode avParam:(nonnull RtcLiveAuidoVideoParameters *)avParam {
    [self.roomSession configLiveServerWithUrl:url
                                        isMix:isMix
                                  isRecording:isRecording
                                  mixTemplate:mixTmplt
                                 transferMode:mode
                                      avParam:avParam];
}

- (void)disbandRoom {
    [self.roomSession disbandRoom];
}

- (void)enableErrorInfoReprot:(BOOL)enableErrorInfoReport {
    [self.roomSession enableErrorInfoReprot:enableErrorInfoReport];
}

- (void)enableStatsToServer:(BOOL)isEnable qualityMonitorEnv:(nonnull NSString *)qualityMonitorEnv {
    [self.roomSession enableStatsToServer:isEnable qualityMonitorEnv:qualityMonitorEnv];
}

- (nonnull RtcParameterSettings *)getParamSettings {
    return [self.roomSession getParamSettings];
}

- (nonnull NSArray<RtcRoomAudioLevel *> *)getRemoteAudioLevels {
    return [self.roomSession getRemoteAudioLevels];
}

- (int)getUserAttribute:(nonnull NSNumber *)userID {
    return [self.roomSession getUserAttribute:userID];
}

- (void)kickOffUserWithId:(NSInteger)userId {
    [self.roomSession kickOffUserWithId:userId];
}

- (BOOL)loginRtcRoomWithRoomName:(nonnull NSString *)roomName userID:(NSInteger)userId displayName:(nonnull NSString *)displayName {
    return [self.roomSession loginRtcRoomWithRoomName:roomName
                                               userID:userId
                                          displayName:displayName];
}

- (BOOL)loginRtcRoomWithRoomName:(nonnull NSString *)roomName userID:(NSInteger)userId displayName:(nonnull NSString *)displayName isCompulsive:(BOOL)isCompulsive {
    return [self.roomSession loginRtcRoomWithRoomName:roomName
                                               userID:userId
                                          displayName:displayName
                                         isCompulsive:isCompulsive];
}

- (bool)logoutRtcRoom {
    return [self.roomSession logoutRtcRoom];
}

- (void)muteCamera {
    [self.roomSession muteCamera];
}

- (void)muteMicphone {
    [self.roomSession muteMicphone];
}

- (void)muteMicphone:(BOOL)isMute {
    [self.roomSession muteMicphone:isMute];
}

- (void)switchLoundSpeaker {
    [self.roomSession switchLoundSpeaker];
}

- (void)switchAudioCategaryWithSpeaker:(BOOL)isSpeaker {
    [self.roomSession switchAudioCategaryWithSpeaker:isSpeaker];
}

/**
 预置听筒/扬声器  ---- 已废弃，外部采集下使用相机模块实现该功能
 @param isPresetLoudSpeaker   true:扬声器   false:听筒    默认听筒
 @discussion 在initSDKWithAppID之后，loginRoom之前调用，预置听筒/扬声器播放语音
 */
- (void)presetLoudSpeaker:(BOOL)isPresetLoudSpeaker {
    [self.roomSession presetLoudSpeaker:isPresetLoudSpeaker];
}


- (void)publishStreaming {
    [self.roomSession publishStreaming];
}

- (nonnull NSArray *)queryEngineStatisticsInfo {
    return [self.roomSession queryEngineStatisticsInfo];
}

- (nonnull NSArray *)queryMessageUserListOfRoom {
    return [self.roomSession queryMessageUserListOfRoom];
}

- (nonnull NSArray *)queryUserListOfRoom {
    return [self.roomSession queryUserListOfRoom];
}

- (int)sendMessage2:(nonnull NSString *)message {
    return [self.roomSession sendMessage2:message];
}

- (int)sendMessage2WithUserId:(nonnull NSString *)message userId:(nonnull NSNumber *)userId {
    return [self.roomSession sendMessage2WithUserId:message
                                             userId:userId];
}

- (int)sendMessage:(nonnull NSString *)message {
    return [self.roomSession sendMessage:message];
}

- (void)setEngineStateStatistics:(BOOL)bOnStatistics {
    [self.roomSession setEngineStateStatistics:bOnStatistics];
}

- (void)setLocalDisplay:(nonnull RTCLocalVideoView *)localVideoView {
    [self.roomSession setLocalDisplay:localVideoView];
}

- (void)setLocalDisplay:(RTCLocalVideoView *)localVideoView mediaTarget:(RtcMediaTarget)mediaTarget {
    [self.roomSession setLocalDisplay:localVideoView mediaTarget:mediaTarget];
}

- (void)setMediaServerIp:(nonnull NSString *)serverIp {
    [self.roomSession setMediaServerIp:serverIp];
}
- (void)setAudioSessionMode:(AVAudioSessionMode)audioSessionMode {
    [self.roomSession setAudioSessionMode:audioSessionMode];
}

- (BOOL)setMixLayoutPositionIndex:(nonnull NSString *)idx {
    return [self.roomSession setMixLayoutPositionIndex:idx];
}

/**
 启动跨房间连麦  -----未实现
 
 @param destRoomName 目标房间
 @param userId 加入目标房间时使用的userId，必须在加入房间中是唯一的
 @param token app server 派发的token字符串
 @discussion  启动跨房间连麦
 */
- (void)startRoomMediaRelay:(NSString *)destRoomName
                     userId:(NSInteger)userId
                      token:(NSString *)token {
    [self.roomSession startRoomMediaRelay:destRoomName userId:userId token:token];
}
/**
 停止跨房间连麦  -----未实现
 
 @param destRoomName 目标房间
 @param userId 加入目标房间时使用的userId，必须在加入房间中是唯一的
 @discussion 停止跨房间连麦
 */
- (void)stopRoomMediaRelay:(NSString *)destRoomName
                    userId:(NSInteger)userId {
    [self.roomSession stopRoomMediaRelay:destRoomName userId:userId];
}

/**
 停止所有跨房间连麦  -----未实现
 
 @discussion 停止所有启动的跨房间连麦
 */
- (void)stopRoomMediaRelayAll {
    [self.roomSession stopRoomMediaRelayAll];
}

- (void)setParamSettings:(nonnull RtcParameterSettings *)paramSettings paramType:(RtcParamSettingType)paramType {
    [self.roomSession setParamSettings:paramSettings paramType:paramType];
}


- (void)setRemoteDisplay:(nonnull RTCRemoteVideoView *)remoteVideoView {
    [self.roomSession setRemoteDisplay:remoteVideoView];
}

- (void)setRemoteDisplay:(RTCRemoteVideoView *)remoteVideoView userId:(NSInteger)userId {
    [self.roomSession setRemoteDisplay:remoteVideoView userId:userId];
}

- (void)setRemoteDisplay:(RTCRemoteVideoView *)remoteVideoView userId:(NSInteger)userId mediaTarget:(RtcMediaTarget)mediaTarget {
    [self.roomSession setRemoteDisplay:remoteVideoView userId:userId mediaTarget:mediaTarget];
}

- (void)setRemoteVideoPlayState:(BOOL)stats userId:(NSInteger)userId {
    [self.roomSession setRemoteVideoPlayState:stats userId:userId];
}
-(void)setRemoteAudioPlayState:(BOOL)stats userId:(NSInteger)user {
    [self.roomSession setRemoteAudioPlayState:stats userId:user];
}

- (void)setSignalServerUrlWithSSL:(nonnull NSString *)serverUrl port:(nonnull NSString *)port enableSSL:(BOOL)enableSSL {
    [self.roomSession setSignalServerUrlWithSSL:serverUrl
                                           port:port
                                      enableSSL:enableSSL];
}

- (void)setSignalServerWithUrl:(nonnull NSString *)serverUrl port:(nonnull NSString *)port {
    [self.roomSession setSignalServerWithUrl:serverUrl port:port];

}

+ (void)setUseTestEnv:(BOOL)isUseTestEnv {
//    [BaiduRtcRoomApi setUseTestEnv:isUseTestEnv];
}

- (int)setUserAttribute:(nonnull NSString *)attribute {
//    return [self.roomSession setUserAttribute:attribute];
    return 1;
}

+ (void)setVerbose:(BOOL)bOnVerbose {
    [BaiduRtcRoomApi setVerbose:bOnVerbose];
}

- (void)shutUpUserWithId:(NSInteger)userId isDisable:(BOOL)isDisable {
    [self.roomSession shutUpUserWithId:userId isDisable:isDisable];
}

- (void)startLiveServerStreaming:(nonnull NSString *)url isMix:(BOOL)isMix isRecording:(BOOL)isRecording mixTemplate:(nonnull NSString *)mixTmplt transferMode:(RtcLiveTransferMode)mode {
//    [self.roomSession startLiveServerStreaming:url
//                                         isMix:isMix
//                                   isRecording:isRecording
//                                   mixTemplate:mixTmplt
//                                  transferMode:mode];
}

- (void)stopLiveServerStreaming:(RtcLiveTransferMode)transferMode {
    [self.roomSession stopLiveServerStreaming:transferMode];
}

- (void)stopPublishStreaming:(BOOL)isLeaving {
    [self.roomSession stopPublishStreaming:isLeaving];
}

- (void)stopSubscribeStreaming:(nonnull NSArray<NSNumber *> *)streamingIds {
    [self.roomSession stopSubscribeStreaming:streamingIds];
}

- (void)subsribeStreaming:(nonnull NSArray<NSNumber *> *)streamingIds {
    [self.roomSession subsribeStreaming:streamingIds];
}

- (void)subsribeStreaming:(NSArray<NSNumber *> *)streamingIds hori_angle:(float)hori_angle vert_angle:(float)vert_angle distance:(float)distance near_vol:(int)near_vol mixer_vol:(int)mixer_vol {
    [self.roomSession subsribeStreaming:streamingIds hori_angle:hori_angle vert_angle:vert_angle distance:distance near_vol:near_vol mixer_vol:mixer_vol];
}

- (void)updateSubsribeStreaming:(NSArray<NSNumber *> *)streamingIds hori_angle:(float)hori_angle vert_angle:(float)vert_angle distance:(float)distance near_vol:(int)near_vol mixer_vol:(int)mixer_vol {
    [self.roomSession updateSubsribeStreaming:streamingIds hori_angle:hori_angle vert_angle:vert_angle distance:distance near_vol:near_vol mixer_vol:mixer_vol];
}

- (void)updateDisplay:(nonnull RTCRemoteVideoView *)remoteVideoView userId:(NSInteger)userId {
    //[self.roomSession updateDisplay:remoteVideoView userId:userId];
}

- (void)startShareAppScreen {
    if (@available(iOS 11.0, *)) {
        [self.roomSession startShareAppScreen];
    }
}

- (void)startShareSystemScreenWithAppGroup:(NSString *)appGroup {
    if (@available(iOS 11.0, *)) {
        [self.roomSession startShareSystemScreenWithAppGroup:appGroup];
    }
}

- (void)stopShareScreen {
    [self.roomSession stopShareScreen];
}

#pragma BDCloudAVRTCRoomAudioPlayerDeviceSource

- (void)onAudioPlayerStart:(nonnull AudioStreamBasicDescription *)adsc client:(nonnull id<BDCloudAVRTCRoomAudioPlayerDeviceDourceClient>)client {
    [self startAudioPlay:adsc playerCallback:^OSStatus(AudioUnitRenderActionFlags * _Nonnull ioActionFlags,
                                                       const AudioTimeStamp * _Nonnull inTimeStamp,
                                                       UInt32 inBusNumber,
                                                       UInt32 inNumberFrames,
                                                       AudioBufferList * _Nullable ioData) {
        return [client onRequestPlayoutData:ioActionFlags
                                  timeStamp:inTimeStamp
                                  busNumber:inBusNumber
                                  numFrames:inNumberFrames
                                       data:ioData];
    }];
}

- (void)onAudioPlayerStop {
    [self stopAudioPlay];

}

@end
