//
//  BDCloudAVRTCRoomVideoCaptureSessionKit.h
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/8/10.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>

#import <BaiduRtcRoom/BaiduRtcRoom.h>
#if __has_include(<BDCloudAVCore/BDCloudAVCore.h>)
#import <BDCloudAVCore/BDCloudAVCore.h>
#else
#import <BDCloudAVContext/BDCloudAVCore.h>
#endif

#if __has_include(<BDCloudAVRecord/BDCloudAVRecord.h>)
#import <BDCloudAVRecord/BDCloudAVRecord.h>
#else
#import <BDCloudAVContext/BDCloudAVRecord.h>
#endif

#import "BDCloudAVCaptureProtocol.h"
#import "BDCloudAVVideoEffectProtocol.h"
#import "BDCloudRTCRoomAVCaptureSettings.h"
#import "BDCloudAVRTCRoomProtocol.h"
#import "BDCloudAVARCaptureSession.h"


NS_ASSUME_NONNULL_BEGIN

@interface BDCloudAVRTCRoomVideoCaptureSessionKit : NSObject<BDCloudAVRTCRoomProtocol,BDCloudAVCaptureProtocol,BDCloudAVVideoEffectProtocol>
@property(nonatomic, strong) BDCloudAVARCaptureSession *avcaptureSession;
//@property(nonatomic, weak) id<BDCloudAVStreamContextDelegate> captureDelegate;

- (instancetype)initWithConfig:(BDCloudRTCRoomAVCaptureSettings *) roomSetting
                      delegate:(id<BaiduRtcRoomDelegate>) roomDelegate;

//- (instancetype)initRoomParamsWithCaptureParams:(BDCloudAVStreamSettings *)captureSetting;

@end

NS_ASSUME_NONNULL_END
