//
//  BDCloudAVAudioEffectProtocol.h
//  svlapp
//
//  Created by Fu,Sheng(ACG VCP) on 20.3.21.
//  Copyright © 2021 fusheng. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol BDCloudAVAudioEffectProtocol <NSObject>

/// Start play music with file path.
/// @param file file path.
- (void)setMusic:(nullable NSString *)file;

/// Start play music with file path and loop count.
/// @param file file path.
/// @param loop loop count.
- (void)setMusic:(nullable NSString *)file loop:(int)loop;

/// Set music play range.
/// @param range play range.
- (void)setMusicRange:(CMTimeRange)range;

/// Set music volume.
/// @param value music volume.
- (void)setMusicVolume:(float)value;

/// Get music volume.
- (float)getMusicVolume;

/// Set background music play tempo.
/// @param tempo tempo, 1/32 -> 32.0, 1.0.
- (void)setMusicTempo:(float)tempo;

/// Get  background music play tempo.
- (float)getMusicTempo;

/// Set background music play pitch.
/// @param pitch pitch Cents, -2400 -> 2400, 1.0.
- (void)setMusicPitch:(float)pitch;

/// Get background music play pitch.
- (float)getMusicPitch;

/// Set mic volume.
/// @param value mic volume.
- (void)setMasterVolume:(float)value;

/// Get mic voulme.
- (float)getMasterVolume;

/// Set micphone record tempo.
/// @param tempo tempo, 1/32 -> 32.0, 1.0.
- (void)setMasterTempo:(float)tempo;

/// Get micphone recordtempo.
- (float)getMasterTempo;

/// Set micphone record pitch.
/// @param pitch pitch Cents, -2400 -> 2400, 1.0.
- (void)setMasterPitch:(float)pitch;

/// Get micphone record pitch.
- (float)getMasterPitch;

/// Set output volume.
/// @param value output voulme.
- (void)setMixOutputVolume:(float)value;

/// Get output volume.
- (float)getMixOutputVolume;

/// Set music enable.
/// @param enable music enable.
- (void)setMusicEnable:(BOOL)enable;

/// Set  mic preview enable.
/// @param enable preview enable.
- (void)setMicPreviewEnable:(BOOL)enable;

/// Restart play music.
- (void)restartMusic;
@end

NS_ASSUME_NONNULL_END
