//
//  BDCloudAVCaptureSession.m
//  svlapp
//
//  Created by Fu,Sheng(ACG VCP) on 9.11.20.
//  Copyright © 2020 fusheng. All rights reserved.
//

#import "BDCloudAVARCaptureSession.h"

@interface BDCloudAVARCaptureSession ()
@property (nonatomic, assign) BOOL isRunning;

@property (nonatomic, strong)BDCloudAVMetalRender* bdCloudAVmMetalRender;
@end

@implementation BDCloudAVARCaptureSession

@synthesize captureDelegate = _captureDelegate;
@synthesize preView = _preView;
@synthesize session = _session;

- (void)setDelegate:(id<BDCloudAVStreamContextDelegate>)delegate {
    _captureDelegate = delegate;
}



- (BDCloudAVRecordSession *)session {
    if (!_session) {
        _session = [[BDCloudAVRecordSession sharedInstance] initWithCaptureConfig:self.config];
        _bdCloudAVmMetalRender = [[BDCloudAVMetalRender alloc] init];

    }
    return  _session;
}

- (BDCloudEnhanceVideo *) enHanceVideo {
    if (!_enHanceVideo) {
        _enHanceVideo = [[BDCloudEnhanceVideo alloc]
                            initWithMediaType:AVMediaTypeVideo];
    }
    return  _enHanceVideo;
}

- (UIView *)preView {
    return _preView;
}

- (void)dealloc {
    
}

- (instancetype)initWithCaptureConfig:(BDCloudAVStreamSettings *)config {
    if (self = [super init]) {
        _config = config;
        _preView = [[UIView alloc] initWithFrame:[UIScreen mainScreen].bounds];
        _preView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    }
    return self;
}

- (BOOL)startPreview {
    if (self.isRunning) {
        return NO;
    }
//    [self.session addBufferListener:_bdCloudAVmMetalRender];
    
    [self.session addBufferListener:self.enHanceVideo];
    
    [self.enHanceVideo addTarget:_bdCloudAVmMetalRender];
    
    self.session.delegate = self.captureDelegate;
//    if (self.config.enablelandscapeLeftRecord) {
//        self.session.view.transform = CGAffineTransformMakeRotation(-M_PI_2);
//    }
//    self.session.view.frame = self.preView.bounds;
//    self.session.view.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
//    self.isRunning = YES;
//    [self.preView insertSubview:self.session.view atIndex:0];
    
    if (self.config.enablelandscapeLeftRecord) {
        _bdCloudAVmMetalRender.renderView.transform = CGAffineTransformMakeRotation(-M_PI_2);
    }
    _bdCloudAVmMetalRender.renderView.frame = self.preView.bounds;
    _bdCloudAVmMetalRender.renderView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    self.isRunning = YES;
    [self.preView insertSubview:_bdCloudAVmMetalRender.renderView atIndex:0];
    
    return YES;
}

- (BOOL)stopPreview {
    if (!self.isRunning) {
        return NO;
    }
    [_session removeBufferListener:_bdCloudAVmMetalRender];

    [self setWatermark:nil];
    [_session.view removeFromSuperview];
    [_session stopPreview];
    [_session destroyInstance];
    _session = nil;
    _bdCloudAVmMetalRender = nil;
    self.isRunning = NO;
    return YES;
}
- (void)startSnapShot:(BDSnapShotCompleteBlock)complete {
    if (_enHanceVideo) {
        [_enHanceVideo startSnapShot:complete];
    }
}

#pragma mark ---BDCloudAVCaptureProtocol
- (void)autoPauseAudioBackground:(BOOL)pause {
    if (_session) {
        [_session autoPauseAudioBackground:pause];
    }
}

- (void)togglelocalMirror {
    if (_session) {
        [_session togglelocalMirror];
    }
}

- (void)toggleRemoteMirror {
    if (_session) {
        [_session toggleRemoteMirror];
    }
}

- (void)startAudioPlay:(const AudioStreamBasicDescription *)playDes
        playerCallback:(BDCloudCaputureAudioPlayerCallback)playerCallback {
    __block BOOL playSuccess = NO;
    
    [self->_session startAudioPlay:playDes
                          render:^int(AudioUnitRenderActionFlags * _Nonnull flags, const AudioTimeStamp * _Nonnull time, UInt32 bus_number, UInt32 num_frames, AudioBufferList * _Nonnull data) {
        playSuccess = YES;
        return playerCallback(flags,
                              time,
                              bus_number,
                              num_frames,
                              data);
    }];
    
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        if (!playSuccess) {
            [self->_session startAudioPlay:playDes
                                  render:^int(AudioUnitRenderActionFlags * _Nonnull flags, const AudioTimeStamp * _Nonnull time, UInt32 bus_number, UInt32 num_frames, AudioBufferList * _Nonnull data) {
                return playerCallback(flags,
                                      time,
                                      bus_number,
                                      num_frames,
                                      data);
            }];
        }
        
     });
    
}

- (void)stopAudioPlay {
    if (_session) {
        [_session stopAudioPlay];
    }
}

#pragma mark --BDCloudAVVideoEffectProtocol
- (BDMVARFliterAdjustEnableState)adjustEnableState {
  
    return _session.adjustEnableState;
}

- (void)applyBeautyBaseVideoFx {
    [_session applyBeautyBaseVideoFx];
}

- (void)disabledBeautyBaseVideoFx {
    [_session disabledBeautyBaseVideoFx];
}

- (void)adjustBeautyWhiteLevel:(CGFloat)level {
    [_session adjustBeautyWhiteLevel:level];
}

- (void)adjustBeautyBlurLevel:(CGFloat)level {
    [_session adjustBeautyBlurLevel:level];
}

- (void)adjustBeautyEnlargingLevel:(CGFloat)level {
    [_session adjustBeautyEnlargingLevel:level];
}

- (void)adjustBeautyThinningLevel:(CGFloat)level {
    [_session adjustBeautyThinningLevel:level];
}

- (void)adjustBeautyFilter:(BDMVComplexFilterModel *)filterModel {
    [_session adjustBeautyFilter:filterModel];
}

- (void)adjustBeautyMakeup:(BDMVMakeupModel *)makeupModel {
    [_session adjustBeautyMakeup:makeupModel];
}

- (void)adjustFeatures:(BDMVFeaturesModelType)featuresType value:(NSObject *)value {
    [_session adjustFeatures:featuresType value:value];
}

- (void)adjustBeautyFaceLengthLevel:(CGFloat)level {
    [_session adjustBeautyFaceLengthLevel:level];
}

- (void)adjustBeautyChin:(CGFloat)level {
    [_session adjustBeautyChin:level];
}

- (void)adjustBeautyEyelengthLevel:(CGFloat)level {
    [_session adjustBeautyEyelengthLevel:level];
}

- (void)adjustBeautyNosebridgewidthLevel:(CGFloat)level {
    [_session adjustBeautyNosebridgewidthLevel:level];
}

- (void)adjustBeautyBrowlengthLevel:(CGFloat)level {
    [_session adjustBeautyBrowlengthLevel:level];
}

- (void)adjustBeautyMouthwidthLevel:(CGFloat)level {
    [_session adjustBeautyMouthwidthLevel:level];
}

- (void)adjustBeautyEyeangleLevel:(CGFloat)level {
    [_session adjustBeautyEyeangleLevel:level];
}

- (BOOL)applyLocalStickerVideoFx:(NSString *)stickerPath
           stickerModelPath:(NSString *)stickerModelPath
                stickerType:(NSString *)stickerType
            stickerIdentify:(NSString *)stickerIdentify
                   upportGesture:(BOOL)gesture {
    return [_session applyLocalStickerVideoFx:stickerPath
                                 stickerModelPath:stickerModelPath
                                      stickerType:stickerType
                                  stickerIdentify:stickerIdentify
                                    upportGesture:gesture];
}

/// 卸载贴纸特效
- (void)disabledStickerVideoFx {
    [_session disabledStickerVideoFx];
}

- (BOOL)applyEffectWithPath:(NSString *)path {
    return [_session applyEffectWithPath:path];
}

-(void)toggleTorch:(BOOL)torchOn {
    [_session toggleTorch:torchOn];
}

- (void)toggleFlash:(AVCaptureFlashMode)mode {
    [_session toggleFlash:mode];
}

- (void)switchCameraPosition:(AVCaptureDevicePosition)position {
    [_session switchCameraPosition:position];
}

- (void)setCameraContinuousAutofocus:(BOOL)autoFocus {
    [_session setCameraContinuousAutofocus:autoFocus];
}

- (void)setCameraFocusPointOfInterest:(CGPoint)point {
    [_session setCameraFocusPointOfInterest:point];
}

- (void)setCameraExposurePointOfInterest:(CGPoint)point {
    [_session setCameraExposurePointOfInterest:point];
}

- (void)setCameraZoomFactor:(CGFloat)zoomFactor {
    [_session setCameraZoomFactor:zoomFactor];
}

- (void)setWatermark:(nullable UIImage *)watermark {
    [_session setBufferListenerWatermark:watermark];
}

- (void)setWatermarkScale:(float)watermarkScale {
    [_session setBufferListenerWatermarkScale:watermarkScale];
}

- (void)setWatermarkPosition:(BDCloudAVMetalWatermarkPosition)watermarkPosition {
    [_session setBufferListenerWatermarkPosition:watermarkPosition];
}

- (void)setWatermarkMixturePercent:(float)watermarkMixurePercent {
    [_session setBufferListenerWatermarkMixturePercent:watermarkMixurePercent];
}

- (void)setVideoEnhanceEX:(CGFloat)brightness contrast:(CGFloat)videoContrast saturation:(CGFloat)statration {
    [_session setVideoEnhance:brightness contrast:videoContrast saturation:statration];
}
- (void)resetVideoEnhanceEX:(BOOL)enable {
    [_session resetVideoEnhance:enable];
}

- (BOOL)setImageOutput:(nullable UIImage *)image {
    return [_session setBufferListenerImageOutput:image];
}

- (void)setMusic:(nullable NSString *)file {
    [_session setMusic:file];
}

- (void)setMusic:(nullable NSString *)file loop:(int)loop {
    [_session setMusic:file loop:loop];
}

- (void)setMusicRange:(CMTimeRange)range {
    [_session setMusicRange:range];
}

- (void)setMusicVolume:(float)value {
    [_session setMusicVolume:value];
}

- (float)getMusicVolume {
    return [_session getMusicVolume];
}

- (void)setMusicTempo:(float)tempo {
    [_session setMusicTempo:tempo];
}

- (float)getMusicTempo {
    return [_session getMusicTempo];
}

- (void)setMusicPitch:(float)pitch {
    [_session setMusicPitch:pitch];
}

- (float)getMusicPitch {
    return [_session getMusicPitch];
}

- (void)setMasterVolume:(float)value {
    [_session setMasterVolume:value];
}

- (float)getMasterVolume {
    return [_session getMasterVolume];
}

- (void)setMasterTempo:(float)tempo {
    [_session setMasterTempo:tempo];
}

- (float)getMasterTempo {
    return [_session getMasterTempo];
}

- (void)setMasterPitch:(float)pitch {
    [_session setMasterPitch:pitch];
}

- (float)getMasterPitch {
    return [_session getMasterPitch];
}

- (void)setMixOutputVolume:(float)value {
    [self.session setMixOutputVolume:value];
}

- (float)getMixOutputVolume {
    return [_session getMixOutputVolume];
}

- (void)setMusicEnable:(BOOL)enable {
    [_session setMusicEnable:enable];
}

- (void)setMicPreviewEnable:(BOOL)enable {
    [_session setMicPreviewEnable:enable];
}

- (void)restartMusic {
    [_session restartMusic];
}

@end


@interface BDCloudAVCaptureOutput ()
@property (nonatomic, strong) BDCloudAVOutput *videoInput;
@property (nonatomic, strong) BDCloudAVOutput *audioInput;
@property (nonatomic, assign) NSInteger current;
@end

@implementation BDCloudAVCaptureOutput

- (instancetype)init {
    if (self = [super init]) {
        self.videoDropCount = 15;
        self.videoInput = [[BDCloudAVOutput alloc] initWithMediaType:AVMediaTypeVideo];
        self.audioInput = [[BDCloudAVOutput alloc] initWithMediaType:AVMediaTypeAudio];
    }
    return self;
}

- (void)resetCurrentDropCount {
    self.current = 0;
}

- (void)frame:(CMSampleBufferRef)frame type:(NSString *)type {
    if ([type isEqualToString:AVMediaTypeVideo]) {
        if (self.current < self.videoDropCount) {
            self.current ++;
            return;
        }
        [self.videoInput raiseFrame:frame];
    } else {
        [self.audioInput raiseFrame:frame];
    }
}

- (void)addBufferListener:(id<BDCloudAVInput>)listener {
    [self.videoInput addTarget:listener];
    [self.audioInput addTarget:listener];
}

- (void)removeBufferListener:(id<BDCloudAVInput>)listener {
    [self.videoInput removeTarget:listener];
    [self.audioInput removeTarget:listener];
}

- (void)removeAllBufferListener {
    [self.videoInput removeAllTargets];
    [self.audioInput removeAllTargets];
}
@end
