//
//  BDCloudAVARCaptureSession.h
//  svlapp
//
//  Created by Fu,Sheng(ACG VCP) on 9.11.20.
//  Copyright © 2020 fusheng. All rights reserved.
//

#import "BDCloudAVCaptureProtocol.h"
#import "BDCloudAVVideoEffectProtocol.h"
#import "BDCloudAVAudioEffectProtocol.h"
#import "BDCloudEnhanceVideo.h"
#if __has_include(<BDCloudAVRecord/BDCloudAVRecord.h>)
#import <BDCloudAVRecord/BDCloudAVRecord.h>
#else
#import <BDCloudAVContext/BDCloudAVRecord.h>
#endif

NS_ASSUME_NONNULL_BEGIN

@interface BDCloudAVARCaptureSession : NSObject<BDCloudAVCaptureProtocol, BDCloudAVVideoEffectProtocol, BDCloudAVAudioEffectProtocol>

@property(nonatomic, strong, readonly) BDCloudAVRecordSession *session;

@property(nonatomic, strong) BDCloudEnhanceVideo *enHanceVideo;

@property(nonatomic, weak) id<BDCloudAVStreamContextDelegate> captureDelegate;

@property(nonatomic, strong, readonly) BDCloudAVStreamSettings *config;

- (instancetype)initWithCaptureConfig:(BDCloudAVStreamSettings *)config;
@end


@interface BDCloudAVCaptureOutput : NSObject<BDCloudAVInput>

/// Video drop count. Default is 15.
@property(nonatomic, assign) NSInteger videoDropCount;

- (void)addBufferListener:(id<BDCloudAVInput>)listener;

- (void)removeBufferListener:(id<BDCloudAVInput>)listener;

- (void)removeAllBufferListener;

- (void)resetCurrentDropCount;
@end

NS_ASSUME_NONNULL_END
