//
//  RTCMainViewController.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCMainViewController.h"
#import <BaiduRtcRoom/BaiduRtcRoom.h>
#import "RTCMainView.h"
#import "RTCSettingsModel.h"
#import "RTCSettingsViewController.h"
#import "RTCVideoCallViewController.h"
#import "RTCViewLayoutMacro.h"
#include "BDCloudRTCBaseDefine.pch"


@interface RTCMainViewController () <
RTCMainViewDelegate,
RTCVideoCallViewControllerDelegate>
@end

@implementation RTCMainViewController {
    UIButton* _settingBtn;
    RTCMainView *_mainView;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    if (@available(iOS 13.0, *)) {
        self.navigationController.navigationBar.backgroundColor = [UIColor systemBackgroundColor];
    }
}

- (void)loadView {
    //self.title = @"RTC Demo";
    _mainView = [[RTCMainView alloc] initWithFrame:CGRectZero version:[BaiduRtcRoomApi version]];
    _mainView.delegate = self;
    self.view = _mainView;
    [self addSettingsBarButton];
}

- (void)addSettingsBarButton {
    CGFloat btnWidth = SCREEN_WIDTH*74*kLayoutWidthScale;
    CGFloat btnHeight = btnWidth*53/74;
    UIView* containerView = [[UIView alloc] init];
    containerView.frame = (CGRect){.size = CGSizeMake(btnWidth, btnHeight)};
    _settingBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    _settingBtn.frame = containerView.bounds;

    UIImage *img = [UIImage imageNamed:@"setting_btn.png"];
    [_settingBtn setImage:img forState:UIControlStateNormal];
    [_settingBtn addTarget:self
            action:@selector(showSettings:)
            forControlEvents:UIControlEventTouchUpInside];
    _settingBtn.backgroundColor = [UIColor greenColor];
    [containerView addSubview:_settingBtn];
    UIBarButtonItem *btnItm = [[UIBarButtonItem alloc] initWithCustomView:containerView];

    //hidden underline of navigation bar.
    UINavigationBar *navigationBar = self.navigationController.navigationBar;
    [navigationBar setBackgroundImage:[UIImage imageNamed:@"whitea.png"]
                       forBarPosition:UIBarPositionAny
                           barMetrics:UIBarMetricsDefault];
    [navigationBar setShadowImage:[UIImage new]];
    self.navigationItem.rightBarButtonItem = btnItm;
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    //disable rest screen
    [[UIApplication sharedApplication] setIdleTimerDisabled:NO];
}

#pragma mark - RTCMainViewDelegate

- (void)mainView:(RTCMainView *)mainView
    didInputRoom:(NSString *)room
          userId:(NSString *)userId {
    if (!room.length) {
        [self showAlertWithMessage:@"房间号不能为空!!!"];
        return;
    }
    if (!userId.length) {
        [self showAlertWithMessage:@"用户ID不能为空!!!"];
        return;
    }
    // Trim whitespaces.
    NSCharacterSet *whitespaceSet = [NSCharacterSet whitespaceCharacterSet];
    NSString *trimmedRoom = [room stringByTrimmingCharactersInSet:whitespaceSet];
    

    RTCVideoCallViewController *videoCallViewController =
    [[RTCVideoCallViewController alloc] initForRoom:trimmedRoom
                                             userId:userId
                                           delegate:self];
    videoCallViewController.modalPresentationStyle = UIModalPresentationFullScreen;
    [self presentViewController:videoCallViewController
                       animated:YES
                     completion:nil];
}

- (void)mainViewAlertMessage:(NSString *)message {
    [self showAlertWithMessage:message];
}

#pragma mark - RTCVideoCallViewControllerDelegate

- (void)viewControllerDidFinish:(RTCVideoCallViewController *)viewController {
    if (![viewController isBeingDismissed]) {
        NSLog(@"Dismissing VC");
        [self dismissViewControllerAnimated:YES completion:^{
        }];
    }
}

#pragma mark - Private
- (void)showSettings:(id)sender {
    RTCSettingsViewController *settingsController =
    [[RTCSettingsViewController alloc] initWithStyle:UITableViewStyleGrouped
                                       settingsModel:[RTCSettingsModel sharedInstance]];
    
    UINavigationController *navigationController =
    [[UINavigationController alloc] initWithRootViewController:settingsController];
    [self presentViewControllerAsModal:navigationController];
}

- (void)presentViewControllerAsModal:(UIViewController *)viewController {
    [self presentViewController:viewController animated:YES completion:nil];
}

- (void)showAlertWithMessage:(NSString*)message {
    UIAlertController *alert =
    [UIAlertController alertControllerWithTitle:nil
                                        message:message
                                 preferredStyle:UIAlertControllerStyleAlert];
    
    UIAlertAction *defaultAction = [UIAlertAction actionWithTitle:@"OK"
                                                            style:UIAlertActionStyleDefault
                                                          handler:^(UIAlertAction *action){
                                                          }];
    
    [alert addAction:defaultAction];
    [self presentViewController:alert animated:YES completion:nil];
}

@end
