//
//  RTCMainView.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//


#import "RTCMainView.h"
#import "RTCViewLayoutMacro.h"
#import "UIImage+RTCUtilities.h"
#import <sys/utsname.h>
#import "UserRemoteManager.h"
#include "BDCloudRTCBaseDefine.pch"
#import "RTCSettingsModel.h"
#import "RTCTextField.h"


@interface RTCMainView () <UITextFieldDelegate, BaiduRtcLastmileDelegate>
@property (nonatomic, strong) BaiduRtcLastmile *mRtcLastmile;
@property(nonatomic, strong) NSString *sdkVersion;
@end

@implementation RTCMainView {
    UILabel *_roomNameLabel;
    RTCTextField *_roomText;
    UILabel *_userIdLabel;
    RTCTextField *_userId;
    UILabel *_appIdLabel;
    UITextField *_appId;
    UILabel *_tokenStrLabel;
    UITextField *_tokenStr;
    UILabel *_callOptionsLabel;
    UISwitch *_loopbackSwitch;
    UILabel *_loopbackLabel;
    UIButton *_startCallButton;
    UIButton *_audioLoopButton;
    UILabel *_lastmileTestLabel;
    UIButton *_lastmileTestButton;
    
    UISwitch *_multiPersonsSwitch;
    UILabel *_multiPersonsLabel;

    UIImage *_image;
    UIImageView *_logoImageView;
    UILabel *_welcomLabel;
    UILabel *_entryRoomLabel;
    UILabel *_serviceProviderLabel;
    UILabel *_versionLabel;
    
    UIButton *_playerButton;
}

@synthesize delegate = _delegate;
@synthesize isAudioLoopPlaying = _isAudioLoopPlaying;

- (instancetype)initWithFrame:(CGRect)frame version:(NSString *)version {
    if (self = [super initWithFrame:frame]) {
        self.sdkVersion = version;
        _logoImageView = [[UIImageView alloc] init];
        [self addSubview:_logoImageView];

        _welcomLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _welcomLabel.textAlignment = NSTextAlignmentCenter;
        _welcomLabel.text = @"欢迎来到百度云RTC";
        _welcomLabel.font = [UIFont fontWithName:@"PingFangSC-Medium" size:30];
        _welcomLabel.textColor = BDCloudBaseColorRGB(68, 73, 90);
        [self addSubview:_welcomLabel];


        _entryRoomLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _entryRoomLabel.textAlignment = NSTextAlignmentCenter;
        _entryRoomLabel.text = @"进入房间后开始你的旅程";
        _entryRoomLabel.font = [UIFont fontWithName:@"PingFangSC-Regular" size:15];
        _entryRoomLabel.textColor = BDCloudBaseColorRGB(68, 73, 90);
        [self addSubview:_entryRoomLabel];

        _serviceProviderLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _serviceProviderLabel.text = @"百度云提供计算服务";
        _serviceProviderLabel.font = [UIFont fontWithName:@"PingFangSC-Regular" size:16];
        _serviceProviderLabel.textColor = BDCloudBaseColorRGB(210, 211, 219);
        [self addSubview:_serviceProviderLabel];

        if (version && [version length] > 0) {
            NSString *prefixToRemove = @"BRTC.iOS.SDK";
            if ([version hasPrefix:@"BRTC.iOS.SDK"]) {
                self.sdkVersion = [version substringFromIndex:[prefixToRemove length]];
            }
            _versionLabel = [[UILabel alloc] initWithFrame:CGRectZero];
            _versionLabel.text = self.sdkVersion;
            _versionLabel.font = [UIFont fontWithName:@"PingFangSC-Regular" size:14];
            _versionLabel.textColor = BDCloudBaseColorRGB(210, 211, 219);
            [self addSubview:_versionLabel];
        }

//        UIFont *controlFont = [UIFont fontWithName:@"Roboto" size:20];
//        UIColor *controlFontColor = [UIColor colorWithWhite:0 alpha:.6];
//        _roomNameLabel = [[UILabel alloc] initWithFrame:CGRectZero];
//        _roomNameLabel.text = @"房间号：";
//        _roomNameLabel.font = controlFont;
//        _roomNameLabel.textColor = controlFontColor;
//        [_roomNameLabel sizeToFit];
//        [self addSubview:_roomNameLabel];
        _roomText = [[RTCTextField alloc] initWithFrame:CGRectZero];
        [self addSubview:_roomText];
        NSString* roomName = [[RTCSettingsModel sharedInstance] currentRoomNameSettingFromStore];
        if (roomName && [roomName length] > 0) {
            _roomText.roomText = roomName;
        } else {
            _roomText.roomText = @"654";
        }

//        _userIdLabel = [[UILabel alloc] initWithFrame:CGRectZero];
//        _userIdLabel.text = @"用户ID：";
//        _userIdLabel.font = controlFont;
//        _userIdLabel.textColor = controlFontColor;
//        [_userIdLabel sizeToFit];
//        [self addSubview:_userIdLabel];
//        _userId = [[RTCTextField alloc] initWithFrame:CGRectZero];
//        [_userId setPlaceHolder:@"输入用户ID，同一房间ID须唯一"];
//        [self addSubview:_userId];
//        [_userId setTextFieldEnable:NO];
//        //_userId.roomText = @"889988";
//
//        _appIdLabel = [[UILabel alloc] initWithFrame:CGRectZero];
//        _appIdLabel.text = @"APP ID：";
//        _appIdLabel.font = controlFont;
//        _appIdLabel.textColor = controlFontColor;
//        [_appIdLabel sizeToFit];
//        [self addSubview:_appIdLabel];
//        _appId = [[UITextField alloc] initWithFrame:CGRectZero];
//        _appId.placeholder = @"App id, 联系百度技术支持获取";
//        _appId.delegate = self;
//        _appId.enabled = NO;
//        [self addSubview:_appId];
//
//        _tokenStrLabel = [[UILabel alloc] initWithFrame:CGRectZero];
//        _tokenStrLabel.text = @"Token：";
//        _tokenStrLabel.font = controlFont;
//        _tokenStrLabel.textColor = controlFontColor;
//        [_tokenStrLabel sizeToFit];
//        [self addSubview:_tokenStrLabel];
//        _tokenStr = [[UITextField alloc] initWithFrame:CGRectZero];
//        _tokenStr.placeholder = @"token串, 联系百度技术支持获取";
//        _tokenStr.delegate = self;
//        _tokenStr.enabled = NO;
//        [self addSubview:_tokenStr];
//
//        _callOptionsLabel = [[UILabel alloc] initWithFrame:CGRectZero];
//        _callOptionsLabel.text = @"选  项：";
//        _callOptionsLabel.font = controlFont;
//        _callOptionsLabel.textColor = controlFontColor;
//        [_callOptionsLabel sizeToFit];
//        [self addSubview:_callOptionsLabel];
//
//        _loopbackSwitch = [[UISwitch alloc] initWithFrame:CGRectZero];
//        [_loopbackSwitch sizeToFit];
//        [self addSubview:_loopbackSwitch];
//
//        _loopbackLabel = [[UILabel alloc] initWithFrame:CGRectZero];
//        _loopbackLabel.text = @"回环模式";
//        _loopbackLabel.font = controlFont;
//        _loopbackLabel.textColor = controlFontColor;
//        [_loopbackLabel sizeToFit];
//        [self addSubview:_loopbackLabel];
//
//        _multiPersonsSwitch = [[UISwitch alloc] initWithFrame:CGRectZero];
//        [_multiPersonsSwitch sizeToFit];
//        [self addSubview:_multiPersonsSwitch];
//
//        _multiPersonsLabel = [[UILabel alloc] initWithFrame:CGRectZero];
//        _multiPersonsLabel.text = @"多人模式";
//        _multiPersonsLabel.font = controlFont;
//        _multiPersonsLabel.textColor = controlFontColor;
//        [_multiPersonsLabel sizeToFit];
//        [self addSubview:_multiPersonsLabel];
//
        _startCallButton = [UIButton buttonWithType:UIButtonTypeCustom];
        _startCallButton.layer.cornerRadius = 20.0;
        _startCallButton.layer.masksToBounds = YES;
        _startCallButton.titleLabel.adjustsFontSizeToFitWidth = YES;
        [_startCallButton setTitle:@"开始通话" forState:UIControlStateNormal];
        [_startCallButton addTarget:self
                             action:@selector(onStartCall:)
                   forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_startCallButton];
        

       UIFont *lastmileFont = [UIFont fontWithName:@"Roboto" size:12];
       _lastmileTestLabel = [[UILabel alloc] initWithFrame:CGRectZero];
       _lastmileTestLabel.text = @"";
       _lastmileTestLabel.font = lastmileFont;
        _lastmileTestLabel.textColor = BDCloudBaseColorRGBA(204, 0, 0, 0.8);
       [_lastmileTestLabel sizeToFit];
       [self addSubview:_lastmileTestLabel];

        _lastmileTestButton = [UIButton buttonWithType:UIButtonTypeSystem];
        _lastmileTestButton.titleLabel.font = lastmileFont;
        [self updateLastmileTestButton];
        [_lastmileTestButton addTarget:self
                            action:@selector(onToggleLastmileTest:)
                    forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_lastmileTestButton];

        if (@available(iOS 13.0, *)) {
            self.backgroundColor = [UIColor systemBackgroundColor];
        } else {
            self.backgroundColor = [UIColor whiteColor];
        }
    }
    self.mRtcLastmile = NULL;
    return self;
}

- (void)setIsAudioLoopPlaying:(BOOL)isAudioLoopPlaying {
    if (_isAudioLoopPlaying == isAudioLoopPlaying) {
        return;
    }
    _isAudioLoopPlaying = isAudioLoopPlaying;
    [self updateAudioLoopButton];
}

- (void)layoutSubviews {
    CGRect bounds = self.bounds;
    CGSize bdsSize = bounds.size;
    CGFloat logImageViewX = bdsSize.width*523/kLayoutWidth;
    CGFloat logImageViewY = bdsSize.height*291.7/kLayoutHeight;
    CGFloat logImageViewW = bdsSize.width*196/kLayoutWidth;
    CGFloat logImageViewH = logImageViewW*222/196;
    _logoImageView.frame = CGRectMake(logImageViewX, logImageViewY, logImageViewW, logImageViewH);
    _image = [UIImage imageNamed:@"first_page_logo.png"];
    [_logoImageView setImage:_image];

    CGFloat welcomLabelX = bdsSize.width*165/kLayoutWidth;
    CGFloat welcomLabelY = bdsSize.height*643/kLayoutHeight;
    CGFloat welcomLabelW = bdsSize.width*912/kLayoutWidth;
    CGFloat welcomLabelH = welcomLabelW*140/912;
    _welcomLabel.frame = CGRectMake(welcomLabelX, welcomLabelY, welcomLabelW, welcomLabelH);

    CGFloat entryLabelX = bdsSize.width*343/kLayoutWidth;
    CGFloat entryLabelY = bdsSize.height*798/kLayoutHeight;
    CGFloat entryLabelW = bdsSize.width*556/kLayoutWidth;
    CGFloat entryLabelH = welcomLabelW*70/556;
    _entryRoomLabel.frame = CGRectMake(entryLabelX, entryLabelY, entryLabelW, entryLabelH);

    CGFloat roomTextX = bdsSize.width*97/kLayoutWidth;
    CGFloat roomTexMarginH = bdsSize.height*300*kLayoutHeightScale;
    CGFloat roomTextY = CGRectGetMaxY(_entryRoomLabel.frame) + roomTexMarginH;
    CGFloat roomTextW = bdsSize.width*1070/kLayoutWidth;
    CGFloat roomTextH = 50;
    _roomText.frame = CGRectMake(roomTextX, roomTextY, roomTextW, roomTextH);
//    _roomText.roomText = @"66";
//    UIView *roomTextUnderLine =
//        [[UIView alloc]initWithFrame:CGRectMake(0,
//                                                _roomText.frame.size.height - 2,
//                                                _roomText.frame.size.width, 1)];
//    roomTextUnderLine.backgroundColor = [UIColor grayColor];
//    [_roomText addSubview:roomTextUnderLine];

//    CGFloat labelWitdth = (bounds.size.width - 2 * kRoomTextFieldMargin)/5;
//    CGFloat roomTextWidth = (bounds.size.width - 3 * kRoomTextFieldMargin - labelWitdth);
//    CGFloat roomTextHeight = [_roomText sizeThatFits:bounds.size].height;
//
//    _roomNameLabel.frame =
//    CGRectMake(kRoomTextFieldMargin, kRoomTextFieldMargin, labelWitdth, roomTextHeight);
//    CGFloat roomTextX = CGRectGetMaxX(_roomNameLabel.frame) + kTextLabelMargin;
//    _roomText.frame =
//    CGRectMake(roomTextX, kRoomTextFieldMargin, roomTextWidth, roomTextHeight);
//
//    CGFloat userIdTop =
//    CGRectGetMaxY(_roomText.frame) + kCallControlMargin * 4;
//    _userIdLabel.frame =
//    CGRectMake(kRoomTextFieldMargin, userIdTop, labelWitdth, roomTextHeight);
//    CGFloat userIdX = CGRectGetMaxX(_roomNameLabel.frame) + kTextLabelMargin;
//    _userId.frame =
//    CGRectMake(userIdX, userIdTop, roomTextWidth, roomTextHeight);
//
//    CGFloat appIdTop =
//    CGRectGetMaxY(_userId.frame) + kCallControlMargin * 4;
//    _appIdLabel.frame =
//    CGRectMake(kRoomTextFieldMargin, appIdTop, labelWitdth, roomTextHeight);
//    CGFloat appIdX = CGRectGetMaxX(_roomNameLabel.frame) + kTextLabelMargin;
//    _appId.frame =
//    CGRectMake(appIdX, appIdTop, roomTextWidth, roomTextHeight);
//    UIView *appIdUnderLine =
//    [[UIView alloc]initWithFrame:CGRectMake(0, _appId.frame.size.height - 2, _appId.frame.size.width, 1)];
//    appIdUnderLine.backgroundColor = [UIColor blackColor];
//    [_appId addSubview:appIdUnderLine];
//
//    CGFloat tokenStrTop =
//    CGRectGetMaxY(_appId.frame) + kCallControlMargin * 4;
//    _tokenStrLabel.frame =
//    CGRectMake(kRoomTextFieldMargin, tokenStrTop, labelWitdth, roomTextHeight);
//    CGFloat tokenStrX = CGRectGetMaxX(_roomNameLabel.frame) + kTextLabelMargin;
//    _tokenStr.frame =
//    CGRectMake(tokenStrX, tokenStrTop, roomTextWidth, roomTextHeight);
//    UIView * underLine =
//    [[UIView alloc]initWithFrame:CGRectMake(0, _tokenStr.frame.size.height - 2, _tokenStr.frame.size.width, 1)];
//    underLine.backgroundColor = [UIColor blackColor];
//    [_tokenStr addSubview:underLine];
//
//    CGFloat callOptionsLabelTop =
//    CGRectGetMaxY(_tokenStr.frame) + kCallControlMargin * 4;
//    _callOptionsLabel.frame = CGRectMake(kCallControlMargin,
//                                         callOptionsLabelTop,
//                                         _callOptionsLabel.frame.size.width,
//                                         _callOptionsLabel.frame.size.height);
//
//    CGFloat loopbackModeTop = CGRectGetMaxY(_callOptionsLabel.frame) + kCallControlMargin * 2;
//    CGRect loopbackModeRect = CGRectMake(kCallControlMargin * 3,
//                                         loopbackModeTop,
//                                         _loopbackSwitch.frame.size.width,
//                                         _loopbackSwitch.frame.size.height);
//    _loopbackSwitch.frame = loopbackModeRect;
//    CGFloat loopbackModeLabelCenterX = CGRectGetMaxX(loopbackModeRect) +
//    kCallControlMargin + _loopbackLabel.frame.size.width / 2;
//    _loopbackLabel.center = CGPointMake(loopbackModeLabelCenterX,
//                                        CGRectGetMidY(loopbackModeRect));
//
//
//    CGFloat multiPersonsModeTop = CGRectGetMaxY(_loopbackSwitch.frame) + kCallControlMargin * 2;
//    CGRect multiPersonsModeRect = CGRectMake(kCallControlMargin * 3,
//                                             multiPersonsModeTop,
//                                             _multiPersonsSwitch.frame.size.width,
//                                             _multiPersonsSwitch.frame.size.height);
//    _multiPersonsSwitch.frame = multiPersonsModeRect;
//    CGFloat multiPersonsModeLabelCenterX = CGRectGetMaxX(loopbackModeRect) +
//    kCallControlMargin + _multiPersonsLabel.frame.size.width / 2;
//    _multiPersonsLabel.center = CGPointMake(multiPersonsModeLabelCenterX,
//                                            CGRectGetMidY(multiPersonsModeRect));
//
//    CGFloat audioLoopTop = CGRectGetMaxY(multiPersonsModeRect) + kCallControlMargin * 3;
//    _audioLoopButton.frame = CGRectMake(kCallControlMargin,
//                                        audioLoopTop,
//                                        _audioLoopButton.frame.size.width,
//                                        _audioLoopButton.frame.size.height);
//
//    CGFloat startCallTop =
//    CGRectGetMaxY(_audioLoopButton.frame) + kCallControlMargin * 3;
    CGFloat _startCallBtnX = CGRectGetMinX(_roomText.frame);
    CGFloat _startCallBtnY = CGRectGetMaxY(_roomText.frame) + bdsSize.height*149*kLayoutHeightScale;
    CGFloat _startCallBtnW = _roomText.frame.size.width;
    CGFloat _startCallBtnH = SCREEN_HEIGHT*140*kLayoutHeightScale;
    _startCallButton.frame = CGRectMake(_startCallBtnX,
                                        _startCallBtnY,
                                        _startCallBtnW,
                                        _startCallBtnH);
    [_startCallButton setBackgroundColor:BDCloudBaseColorRGB(77, 102, 254)];
    [_startCallButton setTitleColor:[UIColor lightGrayColor] forState:UIControlStateHighlighted];
    
    _playerButton.frame = CGRectMake(_startCallBtnX, _startCallBtnY + _startCallBtnH + 10.f,
                                     _startCallBtnW, _startCallBtnH);
    [_playerButton setBackgroundColor:[UIColor grayColor]];
    [_playerButton setTitleColor:[UIColor lightGrayColor] forState:UIControlStateHighlighted];

    CGFloat serviceProviderLabelX = bdsSize.width*383/kLayoutWidth;
    CGFloat serviceProviderLabelY = bdsSize.height*1990/kLayoutHeight;
    CGFloat serviceProviderLabelW = bdsSize.width*477/kLayoutWidth;
    CGFloat serviceProviderLabelH = welcomLabelW*69/477;
    _serviceProviderLabel.frame = CGRectMake(serviceProviderLabelX,
                                             serviceProviderLabelY,
                                             serviceProviderLabelW,
                                             serviceProviderLabelH);
    if (_versionLabel) {
        CGFloat posX = bdsSize.width*363/kLayoutWidth;
        CGFloat posY = bdsSize.height*2070/kLayoutHeight;
        CGFloat width = bdsSize.width*570/kLayoutWidth;
        CGFloat height = welcomLabelW*69/477;
        _versionLabel.frame = CGRectMake(posX, posY, width, height);
    }
    
    CGFloat lastmileLabelX = 10;
    CGFloat lastmileLabelY = 30;
    CGFloat lastmileLabelW = 120;
    CGFloat lastmileLabelH = 30;
    _lastmileTestLabel.frame = CGRectMake(lastmileLabelX,
                                             lastmileLabelY,
                                             lastmileLabelW,
                                             lastmileLabelH);
}

#pragma mark - Private

- (void)updateAudioLoopButton {
    if (_isAudioLoopPlaying) {
        [_audioLoopButton setTitle:@"停止播放"
                          forState:UIControlStateNormal];
        [_audioLoopButton sizeToFit];
    } else {
        [_audioLoopButton setTitle:@"播放音乐"
                          forState:UIControlStateNormal];
        [_audioLoopButton sizeToFit];
    }
}

- (void)updateLastmileTestButton {
    NSLog(@"lastmile init istesting:%@", self.isLastmileTesting ? @"yes" : @"no");
    if (self.isLastmileTesting) {
        [_lastmileTestButton setTitle:@"Stop Testing"
                          forState:UIControlStateNormal];
        [_lastmileTestButton sizeToFit];
    } else {
        [_lastmileTestButton setTitle:@"Last Mile Test"
                          forState:UIControlStateNormal];
        [_lastmileTestButton sizeToFit];
        [_lastmileTestLabel setText:@""];
    }
}

- (void)rtcLastmile:(BaiduRtcLastmile *)lastmile
    lastmileProbeTestResult:(RtcLastmileResult *)result {
    NSLog(@"[lastmile] ###################################");
    NSLog(@"[lastmile] ## state:%lu", result.state);
    NSLog(@"[lastmile] ## quality:%lu", result.quality);
    NSLog(@"[lastmile] ## rtt:%lu", result.rtt);
    NSLog(@"[lastmile] ## uplink:");
    NSLog(@"[lastmile] ##    lostrate:%lu", result.uplinkReport.lossRate);
    NSLog(@"[lastmile] ##    jitter:%lu", result.uplinkReport.jitter);
    NSLog(@"[lastmile] ##    bwe:%lu", result.uplinkReport.bandwidth);
    NSLog(@"[lastmile] ## downlink:");
    NSLog(@"[lastmile] ##    lostrate:%lu", result.downlinkReport.lossRate);
    NSLog(@"[lastmile] ##    jitter:%lu", result.downlinkReport.jitter);
    NSLog(@"[lastmile] ##    bwe:%lu", result.downlinkReport.bandwidth);
    NSLog(@"[lastmile] ###################################");

    [_lastmileTestLabel setText:[NSString stringWithFormat:@"%lu", result.quality]];

    if (self.mRtcLastmile) {
        [self.mRtcLastmile stopProbeTest];
        self.mRtcLastmile = NULL;
    }
}

- (void)onToggleLastmileTest:(id)sender {
    _isLastmileTesting = !_isLastmileTesting;
    if (_isLastmileTesting) {
        if (self.mRtcLastmile == NULL) {
            NSString *strUplinkKbps = [[RTCSettingsModel sharedInstance] currentProbeUplinkKbpsSettingFromStore];
            NSString *strDownlinkKbps = [[RTCSettingsModel sharedInstance] currentProbeDownlinkKbpsSettingFromStore];
            NSString *strServerUrl = [[RTCSettingsModel sharedInstance] currentProbeServerUrlSettingFromStore];
            NSString *strAppId = @"";
            NSString *strToken = @"";
            if ([[RTCSettingsModel sharedInstance] currentServerAppIdSettingFromStore].length > 0) {
                strAppId = [[RTCSettingsModel sharedInstance] currentServerAppIdSettingFromStore];
            } else {
                strAppId = BDCloudDefaultRTCAppID;
            }
            if ([[RTCSettingsModel sharedInstance] currentServerTokenSettingFromStore].length > 0 ) {
                strToken = [[RTCSettingsModel sharedInstance] currentServerTokenSettingFromStore];
            } else {
                strToken = BDCloudDefaultRTCAppToken;
            }

            if ([strServerUrl length] > 0) {
                [BaiduRtcLastmile setServerUrl:strServerUrl];
            }
            NSLog(@"lastmile uplink:%@, downlink:%@, appid:%@, token:%@",
                            strUplinkKbps, strDownlinkKbps, strAppId, strToken);
            self.mRtcLastmile = [[BaiduRtcLastmile alloc] initProbeTest:strAppId
                                                               tokenStr:strToken
                                                          uplinkBitrate:([strUplinkKbps intValue] * 1000)
                                                        downlinkBitrate:([strDownlinkKbps intValue] * 1000)
                                                               delegate:self];
            [_lastmileTestLabel setText:@"Testing"];
        }
    } else {
        if (self.mRtcLastmile) {
            [self.mRtcLastmile stopProbeTest];
            self.mRtcLastmile = NULL;
        }
    }
    [self updateLastmileTestButton];
}

- (void)onStartCall:(id)sender {
    if ([BDCloudDefaultRTCAppID length] <= 0 || [BDCloudDefaultRTCAppToken length] <= 0) {
        
        if (self.delegate && [self.delegate respondsToSelector:@selector(mainViewAlertMessage:)]) {
            [self.delegate mainViewAlertMessage:@"请检查 AppID & Token"];
        }
        NSLog(@"Error 请检查 AppID & Token !!!");
        return;
    }
    if (self.mRtcLastmile) {
        [self.mRtcLastmile stopProbeTest];
        self.mRtcLastmile = NULL;
    }
    NSString *uid = _userId.roomText;
    if ([uid length] == 0) {
        uint32_t uid32 = [self getRandomNumber:1000 to:9000];
        uid = [NSString stringWithFormat:@"%u", uid32];
    }
    [_delegate mainView:self
           didInputRoom:_roomText.roomText
                 userId:uid];
    
    if (_roomText.roomText && [_roomText.roomText length] > 0) {
        [[RTCSettingsModel sharedInstance] storeRoomNameSetting:_roomText.roomText];
    }
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    // There is no other control that can take focus, so manually resign focus
    // when return (Join) is pressed to trigger |textFieldDidEndEditing|.
    [textField resignFirstResponder];
    return YES;
}

- (int)getRandomNumber:(int)from to:(int)to {
    return (int)(from + (arc4random() % (to - from + 1)));
}

@end

