//
//  BDCloudRTCRoomCaptureSettings.h
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/8/11.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import <AVFoundation/AVFoundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface BDCloudRTCRoomAVCaptureSettings : NSObject
// app 名称
@property(nonatomic, copy) NSString *appName;
// 房间/流 名称
@property(nonatomic, copy) NSString *roomName;

// 实时通讯RTC AppID
@property(nonatomic, copy) NSString *rtcAppId;
// 实时通讯RTC Token
@property(nonatomic, copy) NSString *rtcToken;
// 实时通讯RTC 用户ID
@property(nonatomic, copy) NSString *userId;
// 实时通讯RTC 用户昵称
@property(nonatomic, copy) NSString *userName;


// 相机码率
@property (nonatomic, assign) int32_t bitRate;
// 相机帧率
@property (nonatomic, assign) int32_t frameRate;
// 相机采集分辨率
@property (nonatomic, assign) CMVideoDimensions caputreDimension;


@property (nonatomic, assign) BOOL  captureExternal;

@property (nonatomic, assign) BOOL  hasVideo;

@property (nonatomic, assign) BOOL  hasAudio;

@property (nonatomic, assign) int  audioSampleRate;


// 推流默认配置
+ (BDCloudRTCRoomAVCaptureSettings *) defaultSetting;

@end

NS_ASSUME_NONNULL_END
