//
//  BDCloudAVEffectProtocol.h
//  svlapp
//
//  Created by Fu,Sheng(ACG VCP) on 19.3.21.
//  Copyright © 2021 fusheng. All rights reserved.
//

#import <Foundation/Foundation.h>

#if __has_include(<BDCloudAVLicense/BDCloudAVLicense.h>)
#import <BDCloudAVLicense/BDCloudAVLicense.h>
#else
//#import <BDCloudAVContext/BDCloudAVLicense.h>
#import <BDCloudAVLicense.h>
#endif

#import <AVFoundation/AVFoundation.h>
#if __has_include(<BDCloudAVCore/BDCloudAVCore.h>)
#import <BDCloudAVCore/BDCloudAVCore.h>
#else
#import <BDCloudAVCore.h>
#endif

#if __has_include(<BDCloudAVEffect/BDCloudAVEffect.h>)
#import <BDCloudAVEffect/BDCloudAVEffect.h>
#else
#import <BDCloudAVEffect.h>
#endif

NS_ASSUME_NONNULL_BEGIN

@protocol BDCloudAVVideoEffectProtocol <NSObject>

/// 美化、美颜、滤镜、美妆某项能力是否被禁用
- (BDMVARFliterAdjustEnableState)adjustEnableState;

/// 切换远端镜像
- (void)toggleRemoteMirror;

/// 启用流媒体基础美颜特效，包括磨皮、美白
- (void)applyBeautyBaseVideoFx;

/// 关闭流媒体基础美颜特效，包括磨皮、美白
- (void)disabledBeautyBaseVideoFx;

/// 调整基础美颜美白效果
/// @param level 美白效果
- (void)adjustBeautyWhiteLevel:(CGFloat)level;

/// 调整基础美颜磨皮效果
/// @param level 磨皮效果
- (void)adjustBeautyBlurLevel:(CGFloat)level;

/// 调整高级美颜大眼效果，请先确认是否开通对应权限
/// @param level 大眼效果
- (void)adjustBeautyEnlargingLevel:(CGFloat)level;

/// 调整高级美颜磨皮效果，请先确认是否开通对应权限。
/// @param level 磨皮效果
- (void)adjustBeautyThinningLevel:(CGFloat)level;

/// 滤镜统一接口
/// @param filterModel 滤镜模型
- (void)adjustBeautyFilter:(BDMVComplexFilterModel *)filterModel;

/// 美妆统一接口
/// @param makeupModel 美妆模型
- (void)adjustBeautyMakeup:(BDMVMakeupModel *)makeupModel;

/// 五官塑形统一接口
/// @param featuresType 五官枚举
/// @param value 五官塑形调整对象
- (void)adjustFeatures:(BDMVFeaturesModelType)featuresType value:(NSObject *)value;

/// 调整高级美颜l脸长效果，请先确认是否开通对应权限
/// @param level 脸长效果。
- (void)adjustBeautyFaceLengthLevel:(CGFloat)level;

/// 调整下巴
/// @param level 下巴长，下巴宽合并调节
- (void)adjustBeautyChin:(CGFloat)level;

/// 调整高级美颜眼睛长度效果，请先确认是否开通对应权限
/// @param level 眼睛长度效果。
- (void)adjustBeautyEyelengthLevel:(CGFloat)level;

/// 调整高级美颜鼻子宽度效果，请先确认是否开通对应权限
/// @param level 鼻子宽度效果
- (void)adjustBeautyNosebridgewidthLevel:(CGFloat)level;

/// 调整高级美颜眉头长度效果，请先确认是否开通对应权限
/// @param level 眉头长度效果
- (void)adjustBeautyBrowlengthLevel:(CGFloat)level;

/// 调整高级美颜嘴巴长度效果，请先确认是否开通对应权限
/// @param level 嘴巴长度效果
- (void)adjustBeautyMouthwidthLevel:(CGFloat)level;

/// 调整高级美颜眼距效果，请先确认是否开通对应权限
/// @param level 眼距效果
- (void)adjustBeautyEyeangleLevel:(CGFloat)level;

/// 加载本地贴纸特效，请先确认是否开通对应权限
/// @param stickerPath 贴纸地址
/// @param stickerModelPath 贴纸博兴地址
/// @param stickerType 贴纸类型
/// @param stickerIdentify 贴纸id
/// @param gesture 是否支持手式
- (BOOL)applyLocalStickerVideoFx:(NSString *)stickerPath
           stickerModelPath:(NSString *)stickerModelPath
                stickerType:(NSString *)stickerType
            stickerIdentify:(NSString *)stickerIdentify
                   upportGesture:(BOOL)gesture;

/// 加载滤镜
/// @param path 滤镜地址
- (BOOL)applyEffectWithPath:(NSString *)path;

/// 卸载贴纸特效
- (void)disabledStickerVideoFx;

/// 设置输出的水印图片。
/// @param watermark 水印1x
- (void)setWatermark:(nullable UIImage *)watermark;

/// 设置输出的水印图片的伸缩比。
/// @param watermarkScale 伸缩比。范围(0, 1]。  默认0.25。
- (void)setWatermarkScale:(float)watermarkScale;

/// 设置输出的水印图片的位置。
/// @param watermarkPosition 位置。默认 BDCloudAVMetalWatermarkPositionTopLeft。
- (void)setWatermarkPosition:(BDCloudAVMetalWatermarkPosition)watermarkPosition;

/// 设置输出的水印图片的透明度。
/// @param watermarkMixurePercent 透明度。范围 (0,1]。  默认 1。
- (void)setWatermarkMixturePercent:(float)watermarkMixurePercent;

/*  Set brightness scale。Range is (-1, 1].
* Set contrast scale。Range is (0, 4].
*  Set saturation scale。 Range is (0, 1].
*/
- (void)setVideoEnhanceEX:(CGFloat)brightness contrast:(CGFloat)videoContrast saturation:(CGFloat)statration;

- (void)resetVideoEnhanceEX:(BOOL)enble;

@end

NS_ASSUME_NONNULL_END
