//
//  BDCloudAVRTCRoomVideoCapture.m
//  svlapp
//
//  Created by Fu,Sheng(ACG VCP) on 2021/7/9.
//  Copyright © 2021 fusheng. All rights reserved.
//

#import "BDCloudAVRTCRoomVideoCaptureFactory.h"
#import <BDCloudMediaFilter/BDCloudVideoEnhanceFilter.h>
#import "BaiduRtcRoom/BaiduRtcRoom.h"


@interface BDCloudAVRTCRoomVideoCapture : NSObject<BaiduVideoCaptureDevice>
@property (nonatomic,strong) id<BaiduVideoCaptureClientDelegate> client;
//@property (nonatomic,strong) BDCloudVideoEnhanceFilter* bdCloudeVideoEnhance;
//@property (nonatomic,assign) size_t frameWidth;
//@property (nonatomic,assign) size_t frameHeight;
//@property (nonatomic,assign) BOOL reSetFilter;
- (void)onIncommingBuffer:(CMSampleBufferRef)frame;
@end

@implementation BDCloudAVRTCRoomVideoCapture

- (void)onIncommingBuffer:(CMSampleBufferRef)frame {
    @synchronized (self) {
        BDCloudAVCMSampleBuffer *buffer = [BDCloudAVCMSampleBuffer fromCMSampleBuffer:frame];
        if (!self.client || !buffer) {
            return;
        }
        
//        @autoreleasepool {

//        if ([[RTCSettingsModel sharedInstance] currentVideoEnhanceFromStore]) {
//                if ((self.frameWidth == 0) && (self.frameHeight == 0)) {
//
//                    self.frameWidth = buffer.pixelBuffer.width;
//                    self.frameHeight = buffer.pixelBuffer.height;
//
//                    [self.bdCloudeVideoEnhance setBrightnessSwitch:YES];
//
//                    NSLog(@"ClarityValue:%f SaturationValue:%f",[self.bdCloudeVideoEnhance getClarityValue], [self.bdCloudeVideoEnhance getSaturationValue]);
//                    [self.bdCloudeVideoEnhance setClarityValue:3.0];
//                    [self.bdCloudeVideoEnhance setSaturationValue:1.2];
//                }
//                CVImageBufferRef pixelBuffer = [self.bdCloudeVideoEnhance imgEnhanceWithNV12Buffer:buffer.pixelBuffer.buffer
//                                                                                            width:buffer.pixelBuffer.width
//                                                                                            height:buffer.pixelBuffer.height];
//
//                [self.client onIncomingCapturedData:pixelBuffer
//                        withPresentationTimeStamp:buffer.pts];
//            } else {
//                [self.client onIncomingCapturedData:buffer.pixelBuffer.buffer
//                        withPresentationTimeStamp:buffer.pts];
//            }
//        }
        
        [self.client onIncomingCapturedData:buffer.pixelBuffer.buffer
                withPresentationTimeStamp:buffer.pts];
        
    }
}


//- (BDCloudVideoEnhanceFilter *) bdCloudeVideoEnhance {
//    if(!_bdCloudeVideoEnhance || _reSetFilter) {
//        _bdCloudeVideoEnhance = [[BDCloudVideoEnhanceFilter alloc] initContextWithWidth:_frameWidth
//                                                                             withHeight:_frameHeight];
//    }
//    return  _bdCloudeVideoEnhance;
//}

#pragma mark -BaiduVideoCaptureDevice
- (void)baidu_allocateAndStart:(nonnull id<BaiduVideoCaptureClientDelegate>)client {
    @synchronized (self) {
        self.client = client;
    }
}

- (void)baidu_stopAndDeAllocate {
    @synchronized (self) {
        [self.client destroy];
        self.client = nil;
    }
}

- (int)baidu_startCapture {
    return 0;
}

- (int)baidu_stopCapture {
    return 0;
}
@end

@interface BDCloudAVRTCRoomVideoCaptureFactory ()
@property (nonatomic, strong) BDCloudAVRTCRoomVideoCapture *caputre;
@end

@implementation BDCloudAVRTCRoomVideoCaptureFactory

- (void)frame:(CMSampleBufferRef)frame type:(NSString *)type {
    if ([type isEqualToString:AVMediaTypeVideo] && self.caputre) {
        [self.caputre onIncommingBuffer:frame];
    }
}

- (nonnull id<BaiduVideoCaptureDevice>)baidu_create:(nonnull NSString*)deviceId {
    self.caputre = [[BDCloudAVRTCRoomVideoCapture alloc] init];
    return self.caputre;
}

- (void)baidu_destroy:(nonnull id<BaiduVideoCaptureDevice>)device {
}
@end
