//
//  BDCloudAVRTCRoomSession.m
//  svlapp
//
//  Created by Fu,Sheng(ACG VCP) on 2021/7/8.
//  Copyright © 2021 fusheng. All rights reserved.
//

#import "BDCloudAVRTCRoomSession.h"

@interface BDCloudAVRTCRoomSession()
@property (nonatomic, strong) BaiduRtcRoomApi *rtcRoom;
@end

@implementation BDCloudAVRTCRoomSession

- (instancetype)initWithAppID:(NSString *)appId
                     tokenStr:(NSString *)tokenStr
                     delegate:(id<BaiduRtcRoomDelegate>)delegate
                 playerSource:(id<BDCloudAVRTCRoomAudioPlayerDeviceSource>)playerSource {
    if (self = [super init]) {
        _rtcRoom = [[BaiduRtcRoomApi alloc] initSDKWithAppID:appId
                                                    tokenStr:tokenStr
                                                    delegate:delegate];
        
        _videoCapture = [[BDCloudAVRTCRoomVideoCaptureFactory alloc] init];
        _audioDevice = [[BDCloudAVRTCRoomAudioDeviceFactory alloc] initWithPlayerDeviceSource:playerSource];
        
        RtcParameterSettings *rps = [[RtcParameterSettings alloc] init];
        // video capture source
        rps.isEnableExternalCapturer = YES;
        [_rtcRoom setParamSettings:rps paramType:RTC_VIDEO_PARAM_SETTINGS_CAPTURE_MODE];
        [_rtcRoom setVideoCaptureFactory:self.videoCapture];
        
        // audio capture sourece
        rps.isEnableExternalAudioDevice = YES;
        [_rtcRoom setParamSettings:rps paramType:RTC_AUDIO_PARAM_SETTINGS_DEVICE_MODE];
        [_rtcRoom setAudioExternalDeviceDelegate:self.audioDevice];
        
        
//        // 自动发布
//        rps.isAutoPublish = YES;
//        [_rtcRoom setParamSettings:rps paramType:RTC_PARAM_SETTINGS_AUTO_PUBLISH];
//
//        // 自动订阅
//        rps.isAutoSubscribe = YES;
//        [_rtcRoom setParamSettings:rps paramType:RTC_PARAM_SETTINGS_AUTO_SUBSCRIBE];
        
        // 多人会议模式
//        rps.isMultiPlayerModel = YES;
//        [_rtcRoom setParamSettings:rps paramType:RTC_VIDEO_PARAM_SETTINGS_SESSION_MODE];
    }
    return self;
}
+ (void)setUseTestEnv:(BOOL)isUseTestEnv {
    [BaiduRtcRoomApi setUseTestEnv:isUseTestEnv];
}

+ (void)setVerbose:(BOOL)bOnVerbose {
    [BaiduRtcRoomApi setVerbose:bOnVerbose];
}

//+ (void)upLoadLog {}
//+ (void)shareLog {}
//+ (void)setBaiduRtcAppID:(NSString *)appId andToken:(NSString *)tokenStr {}
//- (instancetype)initSDKWithAppID:(NSString *)appId
//                        tokenStr:(NSString *)tokenStr
//                        delegate:(id<BaiduRtcRoomDelegate>)delegate {}
//- (bool)setBaiduRtcRoomDelegate:(id<BaiduRtcRoomDelegate>)baiduRtcRoomDelegate {}

- (void)setParamSettings:(RtcParameterSettings *)paramSettings paramType:(RtcParamSettingType)paramType {
    [self.rtcRoom setParamSettings:paramSettings paramType:paramType];
}

- (RtcParameterSettings *)getParamSettings {
    return [self.rtcRoom getParamSettings];
}

- (void)setEngineStateStatistics:(BOOL)bOnStatistics {
    [self.rtcRoom setEngineStateStatistics:bOnStatistics];
}

- (void)enableStatsToServer:(BOOL)isEnable qualityMonitorEnv:(NSString *)qualityMonitorEnv {
    [self.rtcRoom enableStatsToServer:isEnable qualityMonitorEnv:qualityMonitorEnv];
}

- (void)enableErrorInfoReprot:(BOOL)enableErrorInfoReport {
    [self.rtcRoom enableErrorInfoReprot:enableErrorInfoReport];
}

- (BOOL)loginRtcRoomWithRoomName:(NSString *)roomName
                          userID:(NSInteger)userId
                     displayName:(NSString *)displayName {
    return [self.rtcRoom loginRtcRoomWithRoomName:roomName
                                           userID:userId
                                      displayName:displayName];
}

- (BOOL)loginRtcRoomWithRoomName:(NSString *)roomName
                          userID:(NSInteger)userId
                     displayName:(NSString *)displayName
                    isCompulsive:(BOOL)isCompulsive {
    return [self.rtcRoom loginRtcRoomWithRoomName:roomName
                                           userID:userId
                                      displayName:displayName
                                     isCompulsive:isCompulsive];
}

- (bool)logoutRtcRoom {
    return [self.rtcRoom logoutRtcRoom];
}

- (void)publishStreaming {
    [self.rtcRoom publishStreaming];
}

- (void)stopPublishStreaming:(BOOL)isLeaving {
    [self.rtcRoom stopPublishStreaming:isLeaving];
}

- (void)subsribeStreaming:(NSArray<NSNumber *> *)streamingIds {
    [self.rtcRoom subsribeStreaming:streamingIds];
}

- (void)stopSubscribeStreaming:(NSArray<NSNumber *> *)streamingIds {
    [self.rtcRoom stopSubscribeStreaming:streamingIds];
}

- (void)startShareAppScreen {
    if (@available(iOS 11.0, *)) {
        [self.rtcRoom startShareAppScreen];
    }
}

- (void)startShareSystemScreenWithAppGroup:(NSString *)appGroup {
    if (@available(iOS 11.0, *)) {
        [self.rtcRoom startShareSystemScreenWithAppGroup:appGroup];
    }
}

- (void)stopShareScreen {
    [self.rtcRoom stopShareScreen];
}

- (void)kickOffUserWithId:(NSInteger)userId {
    [self.rtcRoom kickOffUserWithId:userId];
}

- (void)shutUpUserWithId:(NSInteger)userId isDisable:(BOOL)isDisable {
    [self.rtcRoom shutUpUserWithId:userId isDisable:isDisable];
}

- (void)disbandRoom {
    [self.rtcRoom disbandRoom];
}

//- (void)setVideoCaptureFactory:(id<BaiduVideoCaptureFactory>)factory;
//- (void)setRenderDelegate:(id<BaiduRtcApiRenderDelegate>)renderDelegate;
//- (void)startPreview;
//- (void)stopPreview;
//- (void)switchCamera;
//- (void)muteCamera;
-(void)muteCamera {
    [self.rtcRoom muteCamera];
}
- (void)switchAudioCategaryWithSpeaker:(BOOL)isSpeaker {
    [self.rtcRoom switchAudioCategaryWithSpeaker:isSpeaker];
}
//-(void)setCameraFace:(BOOL)front;
//- (void)cameraFocusWithPoint:(CGPoint)point andPlaneSize:(CGSize)size;
//- (void)setAudioRecordDelegate:(id<BaiduRtcApiAudioRecordDelegate>)audioRecordDelegate;
//- (void)setAudioSessionDelegate:(id<BaiduRtcRoomApiAudioSessionDelegate>)audioSessionDelegate;
//- (void)setAudioExternalDeviceDelegate:(id<BaiduRtcRoomApiAudioExternalDeviceDelegate>)audioExternalDelegate;
//- (void)muteMicphone;
//- (void)muteSpeaker:(BOOL) isMute;
- (void)muteMicphone:(BOOL)isMute {
    [self.rtcRoom muteMicphone:isMute];
}
- (void)switchLoundSpeaker {
    [self.rtcRoom switchLoundSpeaker];
}
-(void)presetLoudSpeaker:(BOOL)isPresetLoudSpeaker {
    [self.rtcRoom presetLoudSpeaker:isPresetLoudSpeaker];
}

- (NSArray<RtcRoomAudioLevel *> *)getRemoteAudioLevels {
    return [self.rtcRoom getRemoteAudioLevels];
}

//- (void)setAudioSessionMode:(AVAudioSessionMode)audioSessionMode;
//- (void)enableAgc:(BOOL)enable;
//- (void)enableAns:(BOOL)enable;
//- (void)setSoundMode:(RtcSoundMode)mode;
- (void)setRemoteAudioPlayState:(BOOL)stats userId:(NSInteger)userId {
    [self.rtcRoom setRemoteAudioPlayState:stats userId:userId];
}
//- (void)setRemoteAudioPlayVolume:(float)volume userId:(NSInteger)userId {}

- (void)setLocalDisplay:(RTCLocalVideoView *)localVideoView {
    [self.rtcRoom setLocalDisplay:localVideoView];
}

- (void)setLocalDisplay:(RTCLocalVideoView *)localVideoView mediaTarget:(RtcMediaTarget)mediaTarget {
    [self.rtcRoom setLocalDisplay:localVideoView mediaTarget:mediaTarget];
}

- (void)setRemoteDisplay:(RTCRemoteVideoView *)remoteVideoView {
    [self.rtcRoom setRemoteDisplay:remoteVideoView];
}

- (void)setRemoteDisplay:(RTCRemoteVideoView *)remoteVideoView userId:(NSInteger)userId {
    [self.rtcRoom setRemoteDisplay:remoteVideoView userId:userId];
}

- (void)setRemoteDisplay:(RTCRemoteVideoView *)remoteVideoView userId:(NSInteger)userId mediaTarget:(RtcMediaTarget)mediaTarget {
    [self.rtcRoom setRemoteDisplay:remoteVideoView userId:userId mediaTarget:mediaTarget];
}

- (void)updateDisplay:(RTCRemoteVideoView *)remoteVideoView userId:(NSInteger)userId {
    [self.rtcRoom updateDisplay:remoteVideoView userId:userId];
}

//- (void)setRemoteDisplayGroup:(NSArray<RTCRemoteVideoView *> *)remoteVideoViewGroup __deprecated {}

-(void)setRemoteVideoPlayState:(BOOL)stats userId:(NSInteger)userId {
    [self.rtcRoom setRemoteVideoPlayState:stats userId:userId];
}

//- (void)setWhitenFactor:(float)factor;
//- (void)setRedenFactor:(float)factor;
//- (void)setBuffingFactor:(float)factor;

- (NSArray *)queryUserListOfRoom {
    return [self.rtcRoom queryUserListOfRoom];
}

- (NSArray *)queryMessageUserListOfRoom {
    return [self.rtcRoom queryMessageUserListOfRoom];
}

- (NSArray *)queryEngineStatisticsInfo {
    return [self.rtcRoom queryEngineStatisticsInfo];
}

- (int)sendMessage:(NSString *)message {
    return [self.rtcRoom sendMessage:message];
}

- (int)sendMessage2:(NSString *)message {
    return [self.rtcRoom sendMessage2:message];
}

- (int)sendMessage2WithUserId:(NSString *)message
                       userId:(NSNumber *)userId {
    return [self.rtcRoom sendMessage2WithUserId:message
                                         userId:userId];
}

- (int)setUserAttribute:(NSString *)attribute {
    return [self.rtcRoom setUserAttribute:attribute];
}

- (int)getUserAttribute:(NSNumber *)userID {
    return [self.rtcRoom getUserAttribute:userID];
}

- (void)configLiveServerWithUrl:(NSString *)url
                          isMix:(BOOL)isMix
                        isRecording:(BOOL)isRecording
                    mixTemplate:(NSString *)mixTmplt
                   transferMode:(RtcLiveTransferMode)mode
                        avParam:(RtcLiveAuidoVideoParameters*)avParam {
    [self.rtcRoom configLiveServerWithUrl:url
                                    isMix:isMix
                              isRecording:isRecording
                              mixTemplate:mixTmplt
                             transferMode:mode
                                  avParam:avParam];
}

- (void)startLiveServerStreaming:(NSString *)url
                          isMix:(BOOL)isMix
                    isRecording:(BOOL)isRecording
                    mixTemplate:(NSString *)mixTmplt
                    transferMode:(RtcLiveTransferMode)mode {
    [self.rtcRoom startLiveServerStreaming:url
                                     isMix:isMix
                               isRecording:isRecording
                               mixTemplate:mixTmplt
                              transferMode:mode];
}

- (void)stopLiveServerStreaming:(RtcLiveTransferMode)transferMode {
    [self.rtcRoom stopLiveServerStreaming:transferMode];
}

- (BOOL)setMixLayoutPositionIndex:(NSString *)idx {
    return [self.rtcRoom setMixLayoutPositionIndex:idx];
}

- (void)startRoomMediaRelay:(NSString *)destRoomName
                     userId:(NSInteger)userId
                      token:(NSString *)token {
    [self.rtcRoom startRoomMediaRelay:destRoomName userId:userId token:token];
}
- (void)stopRoomMediaRelay:(NSString *)destRoomName
                    userId:(NSInteger)userId {
    [self.rtcRoom stopRoomMediaRelay:destRoomName userId:userId];
}
- (void)stopRoomMediaRelayAll {
    [self.rtcRoom stopRoomMediaRelayAll];
}

- (void)setSignalServerWithUrl:(NSString *)serverUrl port:(NSString *)port {
    [self.rtcRoom setSignalServerWithUrl:serverUrl port:port];
}

- (void)setSignalServerUrlWithSSL:(NSString *)serverUrl port:(NSString *)port enableSSL:(BOOL)enableSSL {
    [self.rtcRoom setSignalServerUrlWithSSL:serverUrl
                                       port:port
                                  enableSSL:enableSSL];
}

- (void)setMediaServerIp:(NSString *)serverIp {
    [self.rtcRoom setMediaServerIp:serverIp];
}

- (void)setAudioSessionMode:(AVAudioSessionMode)audioSessionMode {
    [self.rtcRoom setAudioSessionMode:audioSessionMode];
}
@end
