//
//  BDCloudAVRTCRoomSession.h
//  svlapp
//
//  Created by Fu,Sheng(ACG VCP) on 2021/7/8.
//  Copyright © 2021 fusheng. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <BaiduRtcRoom/BaiduRtcRoom.h>
#import "BDCloudAVRTCRoomVideoCaptureFactory.h"
#import "BDCloudAVRTCRoomAudioDeviceFactory.h"
#import "BDCloudAVRTCRoomProtocol.h"

NS_ASSUME_NONNULL_BEGIN

@interface BDCloudAVRTCRoomSession : NSObject<BDCloudAVRTCRoomProtocol>

@property (nonatomic, strong, readonly) BDCloudAVRTCRoomVideoCaptureFactory *videoCapture;
@property (nonatomic, strong, readonly) BDCloudAVRTCRoomAudioDeviceFactory *audioDevice;

- (instancetype)initWithAppID:(NSString *)appId
                     tokenStr:(NSString *)tokenStr
                     delegate:(id<BaiduRtcRoomDelegate>)delegate
                 playerSource:(id<BDCloudAVRTCRoomAudioPlayerDeviceSource>)playerSource;

@end

NS_ASSUME_NONNULL_END
