//
//  BDCloudAVRTCRoomExternalCaputreSession.m
//  svlapp
//
//  Created by Fu,Sheng(ACG VCP) on 2021/7/9.
//  Copyright © 2021 fusheng. All rights reserved.
//

#import "BDCloudAVRTCRoomExternalCaputreSession.h"
#import "BDCloudAVRTCRoomSession.h"

@interface BDCloudAVRTCRoomExternalCaputreSession ()<BDCloudAVRTCRoomAudioPlayerDeviceSource>
@property (nonatomic, strong) BDCloudAVRTCRoomSession *roomSession;
@property (nonatomic, strong) BDCloudARVideoFilter *filter;

@end

@implementation BDCloudAVRTCRoomExternalCaputreSession

- (instancetype)initWithPreset:(AVCaptureSessionPreset)sessionPreset
                     frameRate:(NSInteger)frameRate
                         appID:(NSString *)appId
                      tokenStr:(NSString *)tokenStr
                      delegate:(id<BaiduRtcRoomDelegate>)delegate {
    if (self = [super initWithPreset:sessionPreset
                           frameRate:frameRate]) {
        _roomSession = [[BDCloudAVRTCRoomSession alloc] initWithAppID:appId
                                                             tokenStr:tokenStr
                                                             delegate:delegate
                                                         playerSource:self];
        
        [self.videoInput addTarget:_roomSession.videoCapture];
        [self.audioInput addTarget:_roomSession.audioDevice];
    }
    return self;
}


// 重写audiosession 操作
- (void)setAudioSession:(BOOL)active {
    if (active) {
        [[AVAudioSession sharedInstance] setCategory:AVAudioSessionCategoryPlayAndRecord
                                         withOptions:AVAudioSessionCategoryOptionAllowBluetooth
                                               error:nil];
        [[AVAudioSession sharedInstance] setActive:YES error:nil];
    } else {
        [[AVAudioSession sharedInstance] setActive:NO error:nil];
    }
}

#pragma mark --BDCloudAVRTCRoomProtocol
//+ (NSString *)version {}

+ (void)setUseTestEnv:(BOOL)isUseTestEnv {
    [BaiduRtcRoomApi setUseTestEnv:isUseTestEnv];
}

+ (void)setVerbose:(BOOL)bOnVerbose {
    [BaiduRtcRoomApi setVerbose:bOnVerbose];
}

//+ (void)upLoadLog {}
//+ (void)shareLog {}
//+ (void)setBaiduRtcAppID:(NSString *)appId andToken:(NSString *)tokenStr {}
//- (instancetype)initSDKWithAppID:(NSString *)appId
//                        tokenStr:(NSString *)tokenStr
//                        delegate:(id<BaiduRtcRoomDelegate>)delegate {}
//- (bool)setBaiduRtcRoomDelegate:(id<BaiduRtcRoomDelegate>)baiduRtcRoomDelegate {}

- (void)setParamSettings:(RtcParameterSettings *)paramSettings paramType:(RtcParamSettingType)paramType {
    [self.roomSession setParamSettings:paramSettings paramType:paramType];
}

- (RtcParameterSettings *)getParamSettings {
    return [self.roomSession getParamSettings];
}

- (void)setEngineStateStatistics:(BOOL)bOnStatistics {
    [self.roomSession setEngineStateStatistics:bOnStatistics];
}

- (void)enableStatsToServer:(BOOL)isEnable qualityMonitorEnv:(NSString *)qualityMonitorEnv {
    [self.roomSession enableStatsToServer:isEnable qualityMonitorEnv:qualityMonitorEnv];
}

- (void)enableErrorInfoReprot:(BOOL)enableErrorInfoReport {
    [self.roomSession enableErrorInfoReprot:enableErrorInfoReport];
}

- (BOOL)loginRtcRoomWithRoomName:(NSString *)roomName
                          userID:(NSInteger)userId
                     displayName:(NSString *)displayName {
    return [self.roomSession loginRtcRoomWithRoomName:roomName
                                               userID:userId
                                          displayName:displayName];
}

- (BOOL)loginRtcRoomWithRoomName:(NSString *)roomName
                          userID:(NSInteger)userId
                     displayName:(NSString *)displayName
                    isCompulsive:(BOOL)isCompulsive {
    return [self.roomSession loginRtcRoomWithRoomName:roomName
                                               userID:userId
                                          displayName:displayName
                                         isCompulsive:isCompulsive];
}

- (bool)logoutRtcRoom {
    return [self.roomSession logoutRtcRoom];
}

- (void)publishStreaming {
    [self.roomSession publishStreaming];
}

- (void)stopPublishStreaming:(BOOL)isLeaving {
    [self.roomSession stopPublishStreaming:isLeaving];
}

- (void)subsribeStreaming:(NSArray<NSNumber *> *)streamingIds {
    [self.roomSession subsribeStreaming:streamingIds];
}

- (void)subsribeStreaming:(NSArray<NSNumber *> *)streamingIds hori_angle:(float)hori_angle vert_angle:(float)vert_angle distance:(float)distance near_vol:(int)near_vol mixer_vol:(int)mixer_vol {
    [self.roomSession subsribeStreaming:streamingIds hori_angle:hori_angle vert_angle:vert_angle distance:distance near_vol:near_vol mixer_vol:mixer_vol];
}

- (void)updateSubsribeStreaming:(NSArray<NSNumber *> *)streamingIds hori_angle:(float)hori_angle vert_angle:(float)vert_angle distance:(float)distance near_vol:(int)near_vol mixer_vol:(int)mixer_vol {
    [self.roomSession updateSubsribeStreaming:streamingIds hori_angle:hori_angle vert_angle:vert_angle distance:distance near_vol:near_vol mixer_vol:mixer_vol];
}

- (void)stopSubscribeStreaming:(NSArray<NSNumber *> *)streamingIds {
    [self.roomSession stopSubscribeStreaming:streamingIds];
}

- (void)startShareAppScreen {
    if (@available(iOS 11.0, *)) {
        [self.roomSession startShareAppScreen];
    }
}

- (void)startShareSystemScreenWithAppGroup:(NSString *)appGroup {
    if (@available(iOS 11.0, *)) {
        [self.roomSession startShareSystemScreenWithAppGroup:appGroup];
    }
}

- (void)stopShareScreen {
    [self.roomSession stopShareScreen];
}

- (void)kickOffUserWithId:(NSInteger)userId {
    [self.roomSession kickOffUserWithId:userId];
}

- (void)shutUpUserWithId:(NSInteger)userId isDisable:(BOOL)isDisable {
    [self.roomSession shutUpUserWithId:userId isDisable:isDisable];
}

- (void)disbandRoom {
    [self.roomSession disbandRoom];
}

//- (void)setVideoCaptureFactory:(id<BaiduVideoCaptureFactory>)factory;
//- (void)setRenderDelegate:(id<BaiduRtcApiRenderDelegate>)renderDelegate;
//- (void)startPreview;
//- (void)stopPreview;
//- (void)switchCamera;
- (void)muteCamera {
    [self.roomSession muteCamera];
}
//- (void)setCameraFace:(BOOL)front;
//- (void)cameraFocusWithPoint:(CGPoint)point andPlaneSize:(CGSize)size;
//- (void)setAudioRecordDelegate:(id<BaiduRtcApiAudioRecordDelegate>)audioRecordDelegate;
//- (void)setAudioSessionDelegate:(id<BaiduRtcRoomApiAudioSessionDelegate>)audioSessionDelegate;
//- (void)setAudioExternalDeviceDelegate:(id<BaiduRtcRoomApiAudioExternalDeviceDelegate>)audioExternalDelegate;
//- (void)muteMicphone;
//- (void)muteSpeaker:(BOOL) isMute;
- (void)muteMicphone:(BOOL)isMute {
    [self.roomSession muteMicphone:isMute];
}
//- (void)switchLoundSpeaker;
//-(void)presetLoudSpeaker:(BOOL)isPresetLoudSpeaker;

- (NSArray<RtcRoomAudioLevel *> *)getRemoteAudioLevels {
    return [self.roomSession getRemoteAudioLevels];
}

//- (void)setAudioSessionMode:(AVAudioSessionMode)audioSessionMode;
//- (void)enableAgc:(BOOL)enable;
//- (void)enableAns:(BOOL)enable;
//- (void)setSoundMode:(RtcSoundMode)mode;
//- (void)setRemoteAudioPlayState:(BOOL)stats userId:(NSInteger)userId;
//- (void)setRemoteAudioPlayVolume:(float)volume userId:(NSInteger)userId {}

- (void)setLocalDisplay:(RTCLocalVideoView *)localVideoView {
    [self.roomSession setLocalDisplay:localVideoView];
}

- (void)setLocalDisplay:(RTCLocalVideoView *)localVideoView mediaTarget:(RtcMediaTarget)mediaTarget {
    [self.roomSession setLocalDisplay:localVideoView mediaTarget:mediaTarget];
}

- (void)setRemoteDisplay:(RTCRemoteVideoView *)remoteVideoView {
    [self.roomSession setRemoteDisplay:remoteVideoView];
}

- (void)setRemoteDisplay:(RTCRemoteVideoView *)remoteVideoView userId:(NSInteger)userId {
    [self.roomSession setRemoteDisplay:remoteVideoView userId:userId];
}

- (void)setRemoteDisplay:(RTCRemoteVideoView *)remoteVideoView userId:(NSInteger)userId mediaTarget:(RtcMediaTarget)mediaTarget {
    [self.roomSession setRemoteDisplay:remoteVideoView userId:userId mediaTarget:mediaTarget];
}

- (void)updateDisplay:(RTCRemoteVideoView *)remoteVideoView userId:(NSInteger)userId {
    [self.roomSession updateDisplay:remoteVideoView userId:userId];
}

//- (void)setRemoteDisplayGroup:(NSArray<RTCRemoteVideoView *> *)remoteVideoViewGroup __deprecated {}

-(void)setRemoteVideoPlayState:(BOOL)stats userId:(NSInteger)userId {
    [self.roomSession setRemoteVideoPlayState:stats userId:userId];
}

//- (void)setWhitenFactor:(float)factor;
//- (void)setRedenFactor:(float)factor;
//- (void)setBuffingFactor:(float)factor;

- (NSArray *)queryUserListOfRoom {
    return [self.roomSession queryUserListOfRoom];
}

- (NSArray *)queryMessageUserListOfRoom {
    return [self.roomSession queryMessageUserListOfRoom];
}

- (NSArray *)queryEngineStatisticsInfo {
    return [self.roomSession queryEngineStatisticsInfo];
}

- (int)sendMessage:(NSString *)message {
    return [self.roomSession sendMessage:message];
}

- (int)sendMessage2:(NSString *)message {
    return [self.roomSession sendMessage2:message];
}

- (int)sendMessage2WithUserId:(NSString *)message
                       userId:(NSNumber *)userId {
    return [self.roomSession sendMessage2WithUserId:message
                                             userId:userId];
}

- (int)setUserAttribute:(NSString *)attribute {
    return [self.roomSession setUserAttribute:attribute];
}

- (int)getUserAttribute:(NSNumber *)userID {
    return [self.roomSession getUserAttribute:userID];
}

- (void)configLiveServerWithUrl:(NSString *)url
                          isMix:(BOOL)isMix
                    isRecording:(BOOL)isRecording
                    mixTemplate:(NSString *)mixTmplt
                   transferMode:(RtcLiveTransferMode)mode
                        avParam:(RtcLiveAuidoVideoParameters*)avParam {
    [self.roomSession configLiveServerWithUrl:url
                                        isMix:isMix
                                  isRecording:isRecording
                                  mixTemplate:mixTmplt
                                 transferMode:mode
                                      avParam:avParam];
}

- (void)startLiveServerStreaming:(NSString *)url
                           isMix:(BOOL)isMix
                     isRecording:(BOOL)isRecording
                     mixTemplate:(NSString *)mixTmplt
                    transferMode:(RtcLiveTransferMode)mode {
    [self.roomSession startLiveServerStreaming:url
                                         isMix:isMix
                                   isRecording:isRecording
                                   mixTemplate:mixTmplt
                                  transferMode:mode];
}

- (void)stopLiveServerStreaming:(RtcLiveTransferMode)transferMode {
    [self.roomSession stopLiveServerStreaming:transferMode];
}

- (BOOL)setMixLayoutPositionIndex:(NSString *)idx {
    return [self.roomSession setMixLayoutPositionIndex:idx];
}

- (void)startRoomMediaRelay:(NSString *)destRoomName
                     userId:(NSInteger)userId
                      token:(NSString *)token {
    [self.roomSession startRoomMediaRelay:destRoomName userId:userId token:token];
}

- (void)stopRoomMediaRelay:(NSString *)destRoomName
                    userId:(NSInteger)userId {
    [self.roomSession stopRoomMediaRelay:destRoomName userId:userId];
}

- (void)stopRoomMediaRelayAll {
    [self.roomSession stopRoomMediaRelayAll];
}

- (void)setSignalServerWithUrl:(NSString *)serverUrl port:(NSString *)port {
    [self.roomSession setSignalServerWithUrl:serverUrl port:port];
}

- (void)setSignalServerUrlWithSSL:(NSString *)serverUrl port:(NSString *)port enableSSL:(BOOL)enableSSL {
    [self.roomSession setSignalServerUrlWithSSL:serverUrl
                                           port:port
                                      enableSSL:enableSSL];
}

- (void)setMediaServerIp:(NSString *)serverIp {
    [self.roomSession setMediaServerIp:serverIp];
}

#pragma mark  --BDCloudAVRTCRoomAudioPlayerDeviceSource
- (void)onAudioPlayerStart:(AudioStreamBasicDescription *)adsc client:(id<BDCloudAVRTCRoomAudioPlayerDeviceDourceClient>)client {
    [self startAudioPlay:adsc playerCallback:^OSStatus(AudioUnitRenderActionFlags * _Nonnull ioActionFlags,
                                                       const AudioTimeStamp * _Nonnull inTimeStamp,
                                                       UInt32 inBusNumber,
                                                       UInt32 inNumberFrames,
                                                       AudioBufferList * _Nullable ioData) {
        return [client onRequestPlayoutData:ioActionFlags
                                  timeStamp:inTimeStamp
                                  busNumber:inBusNumber
                                  numFrames:inNumberFrames
                                       data:ioData];
    }];
}

- (void)onAudioPlayerStop {
    [self stopAudioPlay];
}


- (void)configARFilterConfig:(BDCloudARVideoFilterConfiguration *) config {
    self.filter = [[BDCloudARVideoFilter alloc] initWithConfig:config];
    
    //修改video link 链路
    //数据流程:capture --> render ===> capture---> fiter ---> render
    [self.videoInput removeTarget:self.enHanceVideo];
    [self. enHanceVideo removeTarget:self.render];
    
    [self.videoInput addTarget:self.enHanceVideo];
    [self.enHanceVideo addTarget:self.filter];
    [self.filter addTarget:self.snapShotVideo];
    [self.snapShotVideo addTarget:self.render];
    
    [self.videoInput removeTarget:_roomSession.videoCapture];
    [self.filter addTarget:_roomSession.videoCapture];
}

#pragma mark --BDCloudAVVideoEffectProtocol
- (BDMVARFliterAdjustEnableState)adjustEnableState {
    return [self.filter adjustEnableState];
}

- (void)toggleRemoteMirror {
    [self.filter toggleRemoteMirror];
}

    - (void)applyBeautyBaseVideoFx {
    [self.filter applyBeautyBaseVideoFx];
}

- (void)disabledBeautyBaseVideoFx {
    [self.filter disabledBeautyBaseVideoFx];
}

- (void)adjustBeautyWhiteLevel:(CGFloat)level {
    [self.filter adjustBeautyWhiteLevel:level];
}

- (void)adjustBeautyBlurLevel:(CGFloat)level {
    [self.filter adjustBeautyBlurLevel:level];
}

- (void)adjustBeautyEnlargingLevel:(CGFloat)level {
    [self.filter adjustBeautyEnlargingLevel:level];
}

- (void)adjustBeautyThinningLevel:(CGFloat)level {
    [self.filter adjustBeautyThinningLevel:level];
}

- (void)adjustBeautyFaceLengthLevel:(CGFloat)level {
    [self.filter adjustBeautyFaceLengthLevel:level];
}

- (void)adjustBeautyChin:(CGFloat)level {
    [self.filter adjustBeautyChin:level];
}

- (void)adjustBeautyEyelengthLevel:(CGFloat)level {
    [self.filter adjustBeautyEyelengthLevel:level];
}

- (void)adjustBeautyNosebridgewidthLevel:(CGFloat)level {
    [self.filter adjustBeautyNosebridgewidthLevel:level];
}

- (void)adjustBeautyBrowlengthLevel:(CGFloat)level {
    [self.filter adjustBeautyBrowlengthLevel:level];
}

- (void)adjustBeautyMouthwidthLevel:(CGFloat)level {
    [self.filter adjustBeautyMouthwidthLevel:level];
}

- (void)adjustBeautyEyeangleLevel:(CGFloat)level {
    [self.filter adjustBeautyEyeangleLevel:level];
}

- (void)adjustFeatures:(BDMVFeaturesModelType)featuresType value:(NSObject *)value {
    [self.filter adjustFeatures:featuresType value:value];
}

- (void)adjustBeautyFilter:(BDMVComplexFilterModel *)filterModel {
    [self.filter adjustBeautyFilter:filterModel];
}

- (void)adjustBeautyMakeup:(BDMVMakeupModel *)makeupModel {
    [self.filter adjustBeautyMakeup:makeupModel];
}

- (BOOL)applyLocalStickerVideoFx:(NSString *)stickerPath
           stickerModelPath:(NSString *)stickerModelPath
                stickerType:(NSString *)stickerType
            stickerIdentify:(NSString *)stickerIdentify
                   upportGesture:(BOOL)gesture {
    return [self.filter applyLocalStickerVideoFx:stickerPath
                                stickerModelPath:stickerModelPath
                                     stickerType:stickerType
                                 stickerIdentify:stickerIdentify
                                   upportGesture:gesture];
}

- (BOOL)applyEffectWithPath:(NSString *)path {
    return [self.filter applyEffectWithPath:path];
}

- (void)disabledStickerVideoFx {
    [self.filter disabledStickerVideoFx];
}

- (void)setWatermark:(nullable UIImage *)watermark {
    [self.filter setWatermark:watermark];
}

- (void)setWatermarkScale:(float)watermarkScale {
    [self.filter setWatermarkScale:watermarkScale];
}

- (void)setWatermarkPosition:(BDCloudAVMetalWatermarkPosition)watermarkPosition {
    [self.filter setWatermarkPosition:watermarkPosition];
}

- (void)setWatermarkMixturePercent:(float)watermarkMixurePercent {
    [self.filter setWatermarkMixturePercent:watermarkMixurePercent];
}

- (void)setVideoEnhanceEX:(CGFloat)brightness contrast:(CGFloat)videoContrast saturation:(CGFloat)statration {
    
}

- (void)resetVideoEnhanceEX:(BOOL)enble {
    
}
@end
