//
//  BDCloudAVRTCRoomAudioDevice.h
//  svlapp
//
//  Created by Fu,Sheng(ACG VCP) on 2021/7/9.
//  Copyright © 2021 fusheng. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>

#import <BaiduRtcRoom/BaiduRtcRoom.h>
#if __has_include(<BDCloudAVCore/BDCloudAVCore.h>)
#import <BDCloudAVCore/BDCloudAVCore.h>
#else
#import <BDCloudAVContext/BDCloudAVCore.h>
#endif

NS_ASSUME_NONNULL_BEGIN

@protocol BDCloudAVRTCRoomAudioPlayerDeviceDourceClient <NSObject>
- (OSStatus)onRequestPlayoutData:(AudioUnitRenderActionFlags *)flags
                       timeStamp:(const AudioTimeStamp *)timeStamp
                       busNumber:(UInt32)busNumber
                       numFrames:(UInt32)numFrames
                            data:(AudioBufferList *)data;
@end

@protocol BDCloudAVRTCRoomAudioPlayerDeviceSource <NSObject>
- (void)onAudioPlayerStart:(AudioStreamBasicDescription *)adsc
                    client:(id<BDCloudAVRTCRoomAudioPlayerDeviceDourceClient>)client;
- (void)onAudioPlayerStop;
@end

@interface BDCloudAVRTCRoomAudioDeviceFactory : NSObject <BDCloudAVInput, BaiduRtcRoomApiAudioExternalDeviceDelegate>
- (instancetype)initWithPlayerDeviceSource:(id<BDCloudAVRTCRoomAudioPlayerDeviceSource>)source;
@end

NS_ASSUME_NONNULL_END
