//
//  BDCloudAVExternalCaptureSession.h
//  svlapp
//
//  Created by Fu,Sheng(ACG VCP) on 9.11.20.
//  Copyright © 2020 fusheng. All rights reserved.
//

#import "BDCloudAVCaptureProtocol.h"
#if __has_include(<BDCloudAVCore/BDCloudAVCore.h>)
#import <BDCloudAVCore/BDCloudAVCore.h>
#else
#import <BDCloudAVContext/BDCloudAVCore.h>
#endif

#import "BDCloudEnhanceVideo.h"
#import "BDCloudSnapShot.h"

NS_ASSUME_NONNULL_BEGIN

@interface BDCloudAVExternalCaptureSession : NSObject<BDCloudAVCaptureProtocol>
 @property (nonatomic, strong, readonly) BDCloudEnhanceVideo    *enHanceVideo;
 @property (nonatomic, strong, readonly) BDCloudSnapShot    *snapShotVideo;

@property (nonatomic, strong, readonly) BDCloudAVMetalRender    *render;
@property (nonatomic, strong, readonly) BDCloudAVOutput         *videoInput;
@property (nonatomic, strong, readonly) BDCloudAVOutput         *audioInput;

- (instancetype)initWithPreset:(AVCaptureSessionPreset)sessionPreset
                     frameRate:(NSInteger)frameRate;
// 音频控制
- (void)setAudioSession:(BOOL)active;
// 扬声器控制
- (void)setOverrideOutputAudioPort:(AVAudioSessionPortOverride)portOverride;
@end

NS_ASSUME_NONNULL_END
