//
//  BDCloudAVCaptureProtocol.h
//  svlapp
//
//  Created by Fu,Sheng(ACG VCP) on 9.11.20.
//  Copyright © 2020 fusheng. All rights reserved.
//

#import <AVFoundation/AVFoundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef OSStatus (^BDCloudCaputureAudioPlayerCallback)(AudioUnitRenderActionFlags *ioActionFlags,
                                                       const AudioTimeStamp *inTimeStamp,
                                                       UInt32 inBusNumber,
                                                       UInt32 inNumberFrames,
                                                       AudioBufferList * __nullable ioData);

typedef void (^BDSnapShotCompleteBlock) (CGImage* image);

@protocol BDCloudAVCaptureProtocol <NSObject>

@property(nonatomic, strong, readonly) UIView *preView;

/// 开始预览
- (BOOL)startPreview;

///// 开始预览
//- (BOOL)startPreviewWithView:(UIView*)preview;

/// 结束预览
- (BOOL)stopPreview;

/// 切换本地预览镜像
- (void)togglelocalMirror;

/// 开启闪光灯
/// @param torchOn 开启
-(void)toggleTorch:(BOOL)torchOn;

/// 选择闪光灯模式
/// @param mode 模式
- (void)toggleFlash:(AVCaptureFlashMode)mode;

/// 切换摄像头
/// @param position 方向
- (void)switchCameraPosition:(AVCaptureDevicePosition)position;

/// 设置自动对焦
/// @param autoFocus 是否调焦
- (void)setCameraContinuousAutofocus:(BOOL)autoFocus;

/// 连续自动对焦时，设置兴趣点
/// @param point 兴趣点
- (void)setCameraFocusPointOfInterest:(CGPoint)point;

/// 连续自动曝光时的感兴趣曝光点
/// @param point 曝光点
- (void)setCameraExposurePointOfInterest:(CGPoint)point;

/// 设置拍摄器缩放系数
/// @param zoomFactor 缩放系数
- (void)setCameraZoomFactor:(CGFloat)zoomFactor;

/// 设置输出图像为固定图像（相机AR图像将不再产出）。
/// @param image 图像1x
- (BOOL)setImageOutput:(nullable UIImage *)image;

/// 后台自动暂停音频采集。
/// @param pause 暂停。默认暂停。
- (void)autoPauseAudioBackground:(BOOL)pause;

/// 开启音频播放
/// @param playDes 音频播放参数
/// @param playerCallback 播放回调。
- (void)startAudioPlay:(const AudioStreamBasicDescription *)playDes
        playerCallback:(BDCloudCaputureAudioPlayerCallback)playerCallback;

/// 结束音频播放
- (void)stopAudioPlay;

//// 视频截图
- (void)startSnapShot:(BDSnapShotCompleteBlock)complete;
@end

NS_ASSUME_NONNULL_END
