//
//  RTC1V1CallView.m
//  rtc_sdk_ios
//
//  Created by v_liyingna on 11/30/22.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTC1V1CallView.h"
#import "RTCScrollSubView.h"
#import <AVFoundation/AVFoundation.h>
#import <BaiduRtcRoom/BaiduRtcRoomApi.h>

@interface RTC1V1CallView ()
@property (nonatomic, strong) NSMutableDictionary *shownVideoViews;
@property (nonatomic, strong) UITapGestureRecognizer *tapGes;
@property (nonatomic, assign) BOOL isTopLocal;
@property(nonatomic, strong) NSMutableArray<NSString *> *remoteUids;
@end

@implementation RTC1V1CallView

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        _shownVideoViews = [NSMutableDictionary dictionary];
        self.isTopLocal = YES;
    }
    _remoteUids = [NSMutableArray array];

    self.autoresizingMask = UIViewAutoresizingFlexibleLeftMargin|
                            UIViewAutoresizingFlexibleWidth|
                            UIViewAutoresizingFlexibleRightMargin|
                            UIViewAutoresizingFlexibleTopMargin|
                            UIViewAutoresizingFlexibleHeight|
                            UIViewAutoresizingFlexibleBottomMargin;
    [self addGestureRecognizer:self.tapGes];
    return self;
}

- (UITapGestureRecognizer *)tapGes {
    if (!_tapGes) {
        _tapGes = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(switchView)];
        _tapGes.numberOfTapsRequired = 1;
    }
    return _tapGes;
}


- (void)switchView {
    self.isTopLocal = !self.isTopLocal;
    [self updateLayoutSubviews];
    if (self.isTopLocal) {
        self.localView.videoView.videoGravity = AVLayerVideoGravityResizeAspectFill;
        self.remoteView.rtcVideoViewMode = RTCVideoViewScaleAspectFill;
    } else {
        self.localView.videoView.videoGravity = AVLayerVideoGravityResizeAspect;
        self.remoteView.rtcVideoViewMode = RTCVideoViewScaleAspectFill;
    }
}

- (void)addRTCsubView:(NSString *)uId local:(BOOL)isLocal view:(UIView *)subview size:(CGSize)videoRelution {
//    if (self.remoteUids.count > 1) {
//        return;
//    }
    NSLog(@"addRTCsubView: self : %@, view : %@, size : %f, %f", self, subview, videoRelution.width, videoRelution.height);
    if (subview) {
        RTCsubviewInfo* rtcSubviewInfo = [[RTCsubviewInfo alloc] initWithParams:isLocal uid:uId view:subview size:videoRelution];
        [_shownVideoViews setObject:rtcSubviewInfo forKey:uId];
        [self addSubview:subview];
        
    }
    if (!isLocal) {
        [self.remoteUids addObject:uId];
    }
    [self updateLayoutSubviews];
}

- (void)removeRTCsubView:(NSString *)uId {
    RTCsubviewInfo* subviewInfo = [_shownVideoViews objectForKey:uId];
    if ( subviewInfo.showView != nil) {
        [subviewInfo.showView removeFromSuperview];
        subviewInfo.showView = nil;
        [_shownVideoViews removeObjectForKey:uId];
        [_remoteUids removeObject:uId];
        [self updateLayoutSubviews];
    }
}

- (void)updateLayoutSubviews {
//    [super layoutSubviews];
 
    NSMutableArray *videoViews = [NSMutableArray array];
    [videoViews addObjectsFromArray:[_shownVideoViews allValues]];
    
    if (videoViews.count == 1) {
        if(((RTCsubviewInfo*)videoViews[0]).isLocal) {
            CGRect rectMid = CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height);
            ((RTCsubviewInfo*)videoViews[0]).showView.frame = rectMid;
        }
    } else if (videoViews.count == 2) {
        if (self.isTopLocal) {
            for (RTCsubviewInfo *viewInfo in videoViews) {
                if (viewInfo.isLocal) {
                    CGRect rectMidOther = CGRectMake(self.bounds.size.width*2/3, 0, self.bounds.size.width/3, self.bounds.size.height/3);
                    viewInfo.showView.frame = rectMidOther;
//                    viewInfo.showView.frame = [self tranctOriginRectToRealRect:viewInfo.videoResolution physicRect:rectMidOther];
                    [self bringSubviewToFront:viewInfo.showView];
                } else {
                    CGRect rectMidOther = CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height);
                    viewInfo.showView.frame = rectMidOther;
//                    viewInfo.showView.frame = [self tranctOriginRectToRealRect:viewInfo.videoResolution physicRect:rectMidOther];
                }
            }
        } else {
            for (RTCsubviewInfo *viewInfo in videoViews) {
                if (!viewInfo.isLocal) {
                    CGRect rectMidOther = CGRectMake(self.bounds.size.width*2/3, 0, self.bounds.size.width/3, self.bounds.size.height/3);
//                    viewInfo.showView.frame = [self tranctOriginRectToRealRect:viewInfo.videoResolution physicRect:rectMidOther];
                    viewInfo.showView.frame = rectMidOther;
                    [self bringSubviewToFront:viewInfo.showView];
                } else {
                    CGRect rectMidOther = CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height);
                    viewInfo.showView.frame = rectMidOther;
//                    viewInfo.showView.frame = [self tranctOriginRectToRealRect:viewInfo.videoResolution physicRect:rectMidOther];
                }
            }
        }
    } else if (videoViews.count == 3) {
        for (RTCsubviewInfo *viewInfo in videoViews) {
            if (viewInfo.isLocal) {
                CGRect rectMidOther = CGRectMake(20, self.bounds.size.height - 80*16/9, 80, 80*16/9);
                viewInfo.showView.frame = [self tranctOriginRectToRealRect:viewInfo.videoResolution physicRect:rectMidOther];
                
                
            } else if ([viewInfo.userId containsString:@"6666"]) {
                CGRect rectMidOther = CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height - 80*16/9);
                viewInfo.showView.frame = [self tranctOriginRectToRealRect:viewInfo.videoResolution physicRect:rectMidOther];
                
            } else {
                CGRect rectMidOther = CGRectMake(120, self.bounds.size.height - 80*16/9, 80, 80*16/9);
                viewInfo.showView.frame = [self tranctOriginRectToRealRect:viewInfo.videoResolution physicRect:rectMidOther];
            }
        }
    }
}

- (CGRect)tranctOriginRectToRealRect:(CGSize)videoResolution physicRect:(CGRect)rectMidOther  {
    if (videoResolution.width > 0 && videoResolution.height > 0) {
        CGRect videoViewFrame = AVMakeRectWithAspectRatioInsideRect(videoResolution, rectMidOther);
        return videoViewFrame;
    } else {
        return rectMidOther;
    }
}

@end
