//
//  UserRemoteManager.h
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/11/5.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>
#import <BaiduRtcRoom/BaiduRtcRoom.h>


NS_ASSUME_NONNULL_BEGIN
@class RTCVideoUserInfoView;

@interface RTCRemoteVideoViewInfo : NSObject
@property(nonatomic, strong) RTCRemoteVideoView *videoView;
@property(nonatomic, assign) BOOL isSubScribed;
@property(nonatomic, strong) RTCVideoUserInfoView *userInfoView;
@property(nonatomic, strong) UIImageView * defaultImageView;
@property(nonatomic, assign) NSInteger userId;
@end

@interface UserRemoteManager : NSObject

@property (nonatomic, weak) id <RTCRemoteVideoViewDelegate> videoViewDelegate;

/**
 * Returns single object.
 */
+ (instancetype) instance;

/**
 *  userAdd
 */
- (void) remoteUserJoin:(NSInteger)userId;

/**
 *  userRemove
 */
- (void) remoteUserLeave:(NSInteger)userId;

/**
 *  queryByUserId
 */
- (RTCRemoteVideoViewInfo *) remoteUserQuery:(NSInteger)userId;

/**
 *    updatePub/Scri status
 */
- (void) remoteUserSubStatus:(NSInteger)userId subscribe:(BOOL)boSub;

/**   reloadView
 */

- (void) remoteUserViewChangeed:(UIView *) remoteView  size:(CGSize)videoResolution;

/** query some users
 */
- (NSArray *) remoteAllUsers;

- (NSUInteger) remoteSubscribeNumers;

- (NSArray *) remoteSubScribedUsers;

/**
 *  remoteAllRemove
 */
- (void) remoteAllRemove;

#pragma mark - share screen video view

/// Record screen sharing status and manage the related video view
///
/// @param isArrive Whether the screen stream status is arrive or not
/// @param userId The user which the screen stream is from
///
/// @discussion Only one screen video stream can be recorded for now
- (void)remoteUserScreenVideoArrived:(BOOL)isArrive userId:(NSInteger)userId;

/// video view for the unique screen sharing stream in one room
- (RTCRemoteVideoViewInfo *)shareScreenVideoViewInfo;

@end

NS_ASSUME_NONNULL_END
