//
//  AppDelegate.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/11/23.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "AppDelegate.h"
#import "RTCMainViewController.h"
#import <BaiduRtcRoom/BaiduRtcRoom.h>
#import <Bugly/Bugly.h>
#if BRTC_ENABLE_VIDEO_AR
#import <BaiduRtcBeauty/BDCloudAVStreamContext.h>
#endif
@interface AppDelegate ()

@end

@implementation AppDelegate


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    // Override point for customization after application launch.
     //   RTCInitializeSSL();
    //    RTCSetupInternalTracer();

//    [Bugly startWithAppId:@"6512569b67"];
//    NSDictionary *fieldTrials = @{
//                                  kRTCFieldTrialH264HighProfileKey: kRTCFieldTrialEnabledValue,
//                                  };
//    RTCInitFieldTrialDictionary(fieldTrials);
//    RTCInitializeSSL();
    //RTCSetupInternalTracer();

    _window =  [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    [_window makeKeyAndVisible];
    RTCMainViewController *viewController = [[RTCMainViewController alloc] init];
    
    UINavigationController *root =
    [[UINavigationController alloc] initWithRootViewController:viewController];
    root.navigationBar.translucent = NO;
    _window.rootViewController = root;
#if BRTC_ENABLE_VIDEO_AR
    /*===============================短视频SDK从这里开始===========================================*/
    /*
     接入SDK说明
     接入前，请前往百度云短视频SDK(官网:https://cloud.baidu.com/products/video_creating.html)
     开通短视频服务，获取licenseID并下载对应license授权文件
     授权文件，请拖到项目工程中，并确保在Build Phases -> Copy Resource Bundle可以看到
     并替换下方licenseID。
     */
    NSString *licenseID = @"875028019907891200060";

    [[BDCloudAVStreamContext sharedInstance] verifySDKLicense:licenseID
                                            completionHandler:^(NSError * _Nonnull error)
    {
        if (!error) {
            NSLog(@"授权成功!");
            /** 获取用户贴纸信息 **/
            [[BDCloudAVStreamContext sharedInstance] downloadStickerList:^(NSArray * _Nonnull stickerList,
                                                                           NSError * _Nonnull error)
             {
                if (stickerList) {
                    [stickerList enumerateObjectsUsingBlock:^(id  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
                        
                    }];
                }
            }];
        } else {
            dispatch_async(dispatch_get_main_queue(), ^{
                NSLog(@"license failure %@", error.description);
                UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"授权结果"
                                                                message:[self alertMessageForError:error]
                                                               delegate:nil
                                                      cancelButtonTitle:@"取消"
                                                      otherButtonTitles:@"确认", nil];
                [alert show];
            });
        }
    }];
#endif

    return YES;
}

- (NSString *)alertMessageForError:(NSError *)error {
    NSString *msg = nil;
    if ([error.localizedDescription containsString:NSURLErrorDomain]) {
        msg = @"网络连接失败，请检查网络权限或环境后重启应用.";
    } else {
        msg = error.localizedDescription;
    }
    return msg;
}

- (NSString*) getBundleID {
    return [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleIdentifier"];
}

- (void)applicationWillResignActive:(UIApplication *)application {
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
}


- (void)applicationDidEnterBackground:(UIApplication *)application {
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}


- (void)applicationWillEnterForeground:(UIApplication *)application {
    // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
}


- (void)applicationDidBecomeActive:(UIApplication *)application {
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}


- (void)applicationWillTerminate:(UIApplication *)application {
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    // RTCShutdownInternalTracer();
    //RTCCleanupSSL();
}

@end

