//
//  BDCloudAVStreamContext.h
//  BDCloudAVContext
//
//  Created by baidu on 2019/7/16.
//  Copyright © 2019 baidu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreGraphics/CoreGraphics.h>
#import <AVFoundation/AVFoundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface BDCloudAVStreamContext : NSObject

/*! \if International
 * Create streaming context instance
 * return single instance
 * \else
 * 获取流媒体上下文的唯一实例
 * 返回流媒体上下文的对象实例
 * \endif
 * \since 1.0.0
 */
+ (instancetype)sharedInstance;

/*! \if International
 * Destroy streaming context instance
 * \else
 *  销毁流媒体上下文实例
 * \endif
 * \since 1.0.0
 */
- (void)destroyInstance;
    
/*! \if International
 *  Get the streaming SDK version
 * \else
 *  获取流媒体SDK版本
 *  返回三位版本号，如1.0.0
 * \endif
 * \since 1.0.0
 */
+ (NSString *)getSDKVersion;

/*! \if International
 *  Verify the SDK license. Note: This interface is a synchronous interface
 *  Appid App ID, this ID is assigned by Baidu Cloud Camera Product Console
 *  Returns the BOOL value. YES indicates that the authorization verification is successful, and NO indicates that the verification failed.
 *  \else
 *  验证SDK授权。注意：此接口是同步接口
 *  appid 应用ID，此ID由百度云拍摄器产品Console分配
 *  返回BOOL值。YES表示授权验证成功，NO则验证失败。
 *  \endif
 *  \since 1.0.0
 */
- (BOOL)verifySDKLicense:(NSString *)appid;

/** \if International
 *  Verify the SDK license. Note: This interface is a asynchronous interface
 *  Appid App ID, this ID is assigned by Baidu Cloud Camera Product Console
 *  Returns the BOOL value. YES indicates that the authorization verification is successful, and NO indicates that the verification failed.
 *  \else
 *  验证SDK授权。注意：此接口是异步接口
 *  appid 应用ID，此ID由百度云拍摄器产品Console分配
 *  返回BOOL值。YES表示授权验证成功，NO则验证失败。
 *  \endif
 *  \since 1.0.0
 */
- (void)verifySDKLicense:(NSString *)appid completionHandler:(void (^)(NSError *))completionHandler;

/*! \if International
 *  download remote Sticker，Please confirm whether to open the corresponding permission
 *  \else
 *  加载远端贴纸特效，请先确认是否购买对应贴纸
 *  注意:子线程获取数据，子线程回调
 *  \endif
 *  \since 3.0.0
 */
- (void)downloadStickerVideoFx:(NSString *)stickerId downloadCallBack:(void (^)(NSDictionary *stickerDic,NSError* error))downloadCallBack;

/*! \if International
 *  download remote Sticker，Please confirm whether to open the corresponding permission
 *  \else
 *  加载远端贴纸特效，请先确认是否购买对应贴纸
 *  注意:子线程获取数据，子线程回调
 *  \endif
 *  \since 3.0.0
 */
- (void)downloadStickerList:(void (^)(NSArray *stickerList,NSError* error))downloadCallBack;

/*! \if International
 *  download remote themeTemplate，Please confirm whether to open the corresponding permission
 *  \else
 *  加载远端主题模板列表，请先确认是否购买对应模板
 *  注意:子线程获取数据，子线程回调
 *  \endif
 *  \since 5.2.0
 */
- (void)downloadThemeTemplateList:(void (^)(NSArray *themeTemplateList, NSError* error))downloadCallBack;

/*! \if International
*  download remote filter，Please confirm whether to open the corresponding permission
*  \else
*  加载远端滤镜列表，请先确认是否购买对应滤镜
*  注意:子线程获取数据，子线程回调
*  \endif
*  \since 5.2.0
*/
- (void)downloadFilterList:(void (^)(NSArray *filterList, NSError* error))downloadCallBack;

/*! \if International
*  download remote transition，Please confirm whether to open the corresponding permission
*  \else
*  加载远端转场列表，请先确认是否购买对应转场
*  注意:子线程获取数据，子线程回调
*  \endif
*  \since 5.2.0
*/
- (void)downloadTransitionList:(void (^)(NSArray *transitionList, NSError* error))downloadCallBack;

/*! \if International
*  apply apply subtitle Upload Info
*  \else
*  获取字幕上传信息
*  注意:子线程获取数据，子线程回调
*  \endif
*  \since 5.6.0
*/
- (void)applySubtitleUploadInfo:(void (^)(NSDictionary *subtitleUploadInfo, NSError* error))callBack;

/*! \if International
 *  processIntelligentSubtitle
 *  \else
 *  处理智能字幕
 *  注意:子线程获取数据，子线程回调
 *  \endif
 *  \since 5.6.0
 */
- (void)processIntelligentSubtitle:(NSDictionary *)intelligentSubtitleInfo callback:(void (^)(NSDictionary *dic, NSError* error))callBack;

/*! \if International
 *  processIntelligentSubtitle
 *  \else
 *  获取智能字幕内容
 *  注意:子线程获取数据，子线程回调
 *  \endif
 *  \since 5.6.0
 */
- (void)getIntelligentSubtitleResult:(NSDictionary *)intelligentSubtitleInfo callback:(void (^)(NSDictionary *dic, NSError* error))callBack;

@end

NS_ASSUME_NONNULL_END
