//
//  RTCStatsBuilder.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef RTCStatsBuilder_h
#define RTCStatsBuilder_h
#import <Foundation/Foundation.h>
#import <BaiduRtcRoom/BaiduRtcRoomApiDefines.h>

/**
 * separate render first video frame in several steps
 */
typedef NS_ENUM(NSInteger, RtcRenderStepState) {
    RTC_RENDER_STEP_INIT = 0,
    RTC_RENDER_STEP_WEBSOCKET_OPENED,
    RTC_RENDER_STEP_USER_JOINED,
    RTC_RENDER_STEP_SUBSCRIBE,
    RTC_RENDER_STEP_SET_REMOTE_SDP,
    RTC_RENDER_STEP_SET_LOCAL_SDP,
    RTC_RENDER_STEP_BRTCUP,
    RTC_RENDER_STEP_FIRST_FRAME,
    RTC_RENDER_STEP_MAX
};

typedef void (^RTCNetworkDownStateHandler)(NSString *ssrc, NSInteger level);

@interface RTCStatsRecvVideo : NSObject
@property(nonatomic, copy) NSString *pVideoDecodeMs;
@property(nonatomic, copy) NSString *pVideoDecodedFps;
@property(nonatomic, copy) NSString *pVideoOutputFps;
@property(nonatomic, copy) NSString *pVideoRecvBitrate;
@property(nonatomic, copy) NSString *pVideoRecvFps;
@property(nonatomic, copy) NSString *pVideoRecvHeight;
@property(nonatomic, copy) NSString *pVideoRecvWidth;
@property(nonatomic, copy) NSString *pVideoRecvPacket;
@property(nonatomic, copy) NSString *pVideoRecvPacketLost;
@property(nonatomic, copy) NSString *pVideoRecvEndToEndDelay;
@property(nonatomic, copy) NSString *pVideoRecvFrameAssembleDelay;
@property(nonatomic, copy) NSString *pVideoRecvFrameRenderDelay;
@property(nonatomic, copy) NSString *pVideoRecvFrameInterDelay;
@property(nonatomic, copy) NSString *pVideoRecvFrameInterRelDelay;
@property(nonatomic, copy) NSString *pVideoRecvFrameFrozenPercent;

// remote video from watch
@property(nonatomic, copy) NSString *pWatchSource;
@property(nonatomic, copy) NSString *pWatchFfPlay;
@property(nonatomic, copy) NSString *pWatchJoinCost;
@property(nonatomic, copy) NSString *pWatchCpuPercent;
@property(nonatomic, copy) NSString *pWatchMemPercent;
@property(nonatomic, copy) NSString *pWatchEncodeCost;
@property(nonatomic, copy) NSString *pWatchEtoS1Rtt;
@property(nonatomic, copy) NSString *pWatchS1toS2Rtt;
@property(nonatomic, copy) NSString *pWatchS2toERtt;
@property(nonatomic, copy) NSString *pPhoneEncodeCost;
@property(nonatomic, copy) NSString *pPhoneEtoS1Rtt;
@property(nonatomic, copy) NSString *pPhoneS1toS2Rtt;
@property(nonatomic, copy) NSString *pPhoneS2toERtt;
@end

@interface RTCStatsRecvAudio : NSObject
@property(nonatomic, copy) NSString *pAudioRecvBitrate;
@property(nonatomic, copy) NSString *pAudioRecvExpandBitrate;
@property(nonatomic, copy) NSString *pAudioRecvCodec;
@property(nonatomic, copy) NSString *pAudioRecvFps;
@property(nonatomic, copy) NSString *pAudioRecvPacket;
@property(nonatomic, copy) NSString *pAudioRecvPacketLost;
@property(nonatomic, copy) NSString *pAudioRecvDelay;
@property(nonatomic, copy) NSString *pAudioRecvLevel;
@property(nonatomic, copy) NSString *pAudioRecvSsrc;

@end

@interface RTCStatsInfo : NSObject
// Connection stats.
@property(nonatomic, copy) NSString *pConnRecvBitrate;
@property(nonatomic, copy) NSString *pConnRtt;
@property(nonatomic, copy) NSString *pConnSendBitrate;
@property(nonatomic, copy) NSString *pLocalCandType;
@property(nonatomic, copy) NSString *pRemoteCandType;
@property(nonatomic, copy) NSString *pTransportType;
@property(nonatomic, copy) NSString *pLocalAddress;
@property(nonatomic, copy) NSString *pClientIp;
@property(nonatomic, copy) NSString *pServerIp;


// BWE stats.
@property(nonatomic, copy) NSString *pActualEncBitrate;
@property(nonatomic, copy) NSString *pAvailableRecvBw;
@property(nonatomic, copy) NSString *pAvailableSendBw;
@property(nonatomic, copy) NSString *pTargetEncBitrate;

// Video send stats.
@property(nonatomic, copy) NSString *pVideoEncodeMs;
@property(nonatomic, copy) NSString *pVideoInputFps;
@property(nonatomic, copy) NSString *pVideoInputHeight;
@property(nonatomic, copy) NSString *pVideoInputWidth;
@property(nonatomic, copy) NSString *pVideoSendCodec;
@property(nonatomic, copy) NSString *pVideoSendBitrate;
@property(nonatomic, copy) NSString *pVideoSendFps;
@property(nonatomic, copy) NSString *pVideoSendHeight;
@property(nonatomic, copy) NSString *pVideoSendWidth;
@property(nonatomic, copy) NSString *pVideoSendPacketsLost;
@property(nonatomic, copy) NSString *pVideoSendPacket;

// Video receive stats.
@property(nonatomic, strong) NSMutableDictionary *statsRecvVideoDic;

// QP stats.
@property(nonatomic, assign) int iVideoQPSum;
@property(nonatomic, assign) int iFramesEncoded;
@property(nonatomic, assign) int iOldVideoQPSum;
@property(nonatomic, assign) int iOldFramesEncoded;

// Audio send stats.
@property(nonatomic, copy) NSString *pAudioSendBitrate;
@property(nonatomic, copy) NSString *pAudioSendCodec;
@property(nonatomic, assign) int audioJitterMs;
@property(nonatomic, assign) int audioLevel;
@property(nonatomic, assign) int audioEnergy;
@property(nonatomic, assign) uint64_t audioPacketLost;


// Audio receive stats.
@property(nonatomic, copy) NSString *pAudioCurrentDelay;
@property(nonatomic, copy) NSString *pAudioExpandRate;
@property(nonatomic, copy) NSString *pAudioRecvBitrate;
@property(nonatomic, copy) NSString *pAudioRecvCodec;
@end

/** Class used to accumulate stats information into a single displayable string.
 */
@interface BRTC_TYPE(RTCStatsBuilder) : NSObject

/** String that represents the accumulated stats reports passed into this
 *  class.
 */
@property(nonatomic, readonly) NSString *statsString;

/* Struct that represents the accumulated stats reports passed into this class.
 */
@property(nonatomic, readonly) RTCStatsInfo* statsInfo;

+ (instancetype)initWithHandleId:(NSNumber *)handleId;
+ (instancetype)builderWithArray:(NSArray *)stats;

- (void)parseStatsArray:(NSArray *)statsArray;

- (void)parseNetworkDownState:(NSArray *)statsArray handler:(RTCNetworkDownStateHandler)handler;

/** Parses the information in the stats report into an appropriate internal
 *  format used to generate the stats string.
 */
- (void)parseStatsReport:(id)statsReport isPublisher:(BOOL)isPublisher;

- (void)setRenderStepTs:(int)state
                 result:(int)result
                   time:(uint64_t)time;

- (void)setNetworkDemoteState:(NSString *)state;

- (void)startRecvStats;
- (void)resetRecvStats;
// -(void)peerConnectionRemoteStat:(NSNumber*)handleId feedId:(NSNumber*)feedId ssrc:(NSString*)ssrc type:(NSString*)type {

- (void)subscribeStream:(NSString *)ssrc type:(NSString *)type feedId:(uint64_t) feedId;
- (void)ubSubscribeStream:(uint64_t) feedId;
- (NSMutableArray<NSDictionary *> *)getRecvStat;

/* Get the send video packet lost rate, * 100.
 */
- (int)getSendPacketsLostRate;

- (void)genSample;
- (void)updateStreamStuck:(NSNumber *)feedId
                 duration:(NSInteger)duration
                   vstuck:(NSArray *)vstuck
                   astuck:(NSArray *)astuck;

- (int)getVideoPacketsLostRate;
- (int)getAudioPacketsLostRate;

@end

#endif /* RTCStatsBuilder_h */
