//
//  BaiduRtcVideoSRManager.h
//  BaiduRtcRoom
//
//  Created by zhifan zhang on 2023/8/10.
//  Copyright © 2023 Baidu. All rights reserved.
//

#ifndef BaiduRtcVideoSRManager_h
#define BaiduRtcVideoSRManager_h


#import <CoreVideo/CoreVideo.h>

@protocol BaiduRtcVideoSRManager <NSObject>

/// 初始化Model
- (BOOL)create;

/// 超分内核是否初始化完成。超分内核异步初始化，所以初始的几帧画面可能并没有超分效果。
- (BOOL)isSrEngineInited;

/// 设置目标帧率，sdk会依据目标帧率、输入分辨率、设备性能自适应加载最合适的模型
- (void)setTargetFps:(float)fps;

/// 获取预期超分帧率，依据目标帧率、输入分辨率、设备性能返回预期的超分帧率，可以根据返回结果决定是否开启超分
- (float)probeExpectedFpsForWidth:(int)width Height:(int)height TargetFps:(float)fps;

/// 处理视频
/// @param inBuffer  输入PB yuv420
/// @Param outBuffer 输出PB yuv420
- (BOOL)videoSR:(CVPixelBufferRef)inBuffer renderTo:(CVPixelBufferRef)outBuffer;

/// 销毁
- (BOOL)destroy;
@end

#endif /* BaiduRtcVideoSRManager_h */
