//
//  BaiduRtcRoomDelegate.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2024/02/23.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//
#import <Foundation/Foundation.h>


#pragma mark -- 提供app的callback
@protocol BaiduRtcRoomDelegate <NSObject>

@optional
/**
 *  登录成功回调
 *  @param roomId 房间id
 *  @param uid 用户uid
 *  @param elapsed 登录耗时
 */
- (void)onLoginSuccess:(NSNumber *)roomId uid:(NSInteger)uid elapsed:(int)elapsed;

/**
 *  错误信息回调
 *  @param errCode 错误号码
 *  @param errMsg  错误消息提示
 *  @param extInfo 附加信息
 */
- (void)onError:(NSInteger)errCode errMsg:(NSString *)errMsg extInfo:(nullable NSDictionary*)extInfo;

/**
 *  警告信息回调
 *  @param warningCode 警告号码
 *  @param warnMsg  警告消息提示
 *  @param extInfo 附加信息
 */
- (void)onWarning:(NSInteger)warningCode warningMsg:(NSString *)warnMsg extInfo:(nullable NSDictionary*)extInfo;

/**
 *  视频首帧回调
 *  @param uid 远端用户uid
 *  @param width 视频宽
 *  @param height 视频高
 */
- (void)onFirstVideoFrame:(NSInteger)uid width:(int)width height:(int)height;

/**
 *  链接状态发生变化
 *  @param state  链接状态值    取值:  RtcConnectionState
 *  @param reason  状态变化原因 取值: RtcConnectionChange
 */
- (void)onConnectionStateChanged:(NSInteger)state reason:(NSInteger)reason;

/**
 *  远端用户加入
 *  @param uid 用户uid
 *  @param userName  用户昵称
 */
- (void)onRemoteUserJoinRoom:(NSInteger)uid userName:(NSString *)userName;

/**
 *  远端用户离开
 *  @param uid 用户uid
 *  @param userName  用户昵称
 */
- (void)onRemoteUserLeaveRoom:(NSInteger)uid userName:(NSString *)userName;

/**
 *  媒体通路状态变化
 *  @param uplink 上行 YES， 下行 NO
 *  @param state  状态 RtcMediaStreamState
 */
- (void)onMediaStreamStateChange:(BOOL)uplink state:(NSInteger)state;

/**
 *  远端视频流状态变化
 *  @param uid 用户uid
 *  @param userName  用户昵称
 *  @param desc  流描述
 *  @param state  远端流到来  RTC_STREAM_ADD (1) ， 远端流离开 RTC_STREAM_REMOVE (2),  RtcStreamChange
 */
- (void)onVideoStreamChangedState:(NSInteger)uid userName:(NSString *)userName desc:(NSString *)desc state:(NSInteger)state;
/**
 *  远端音频流状态变化
 *  @param uid 用户uid
 *  @param userName  用户昵称
 *  @param desc  流描述
 *  @param state  远端流到来  RTC_STREAM_ADD (1) ， 远端流离开 RTC_STREAM_REMOVE (2),  RtcStreamChange
 */
- (void)onAudioStreamChangedState:(NSInteger)uid userName:(NSString *)userName desc:(NSString *)desc state:(NSInteger)state;

/**
 * 用户被禁言
 */
- (void)onUserShutUp:(NSInteger)uid;

/**
 * 解除用户被禁言
 */
- (void)onUserDisShutUp:(NSInteger)uid;

/**
 * 用户房间解散
 */
- (void)onRoomDisbanded;

/**
 * 用户被踢出房间
 */
- (void)onUserKickOff:(NSInteger)uid;

/**
 * 远端用户开始推流，远端用户停止推流
 */
- (void)onRemoteUserVideoAvailable:(NSInteger)uid desc:(NSString *)desc available:(BOOL)available;

/**
 * 远端用户开始推流，远端用户停止推流
 */
- (void)onRemoteUserAudioAvailable:(NSInteger)uid desc:(NSString *)desc available:(BOOL)available;

/** 发送音视频状态
 * @param type 媒体类型
 * @param state 0 推流失败, 1推流成功
 */
- (void)onSendMediaState:(BRTCMediaType)type state:(int)state;

/** 视频下行降级
 * @param uid 用户uid
 * @param netState 网络质量状态
 * @param demoteState 降级状态 RtcDemoteType
 */
- (void)onPullRemoteState:(NSInteger)uid netState:(int)netState demoteState:(int)demoteState;

/** 发送音视频状态
 * @param mode 直播转推模式   RtcLiveTransferMode
 * @param url  推流地址
 * @param state  状态 RtcLiveTransferState
 */
- (void)onLivePublishState:(RtcLiveTransferMode)mode url:(NSString *)url state:(RtcLiveTransferState)state;


/** MediaRealy状态更新
 * @param type 类型  RtcMediaRealyType   START_MEDIA_RELAY:1  STOP_MEDIA_RELAY:2
 * @param state  状态 RtcMediaRealyState
 */
- (void)onMediaRelayState:(RtcMediaRealyType)type state:(RtcMediaRealyState)state;

/**
 RTC引擎状态信息统计
 
 @param statistics rtc引擎状态信息统计数组
 @discussion 该callback返回当前rtc engine的一些参数和性能信息，如传输fps,码率，网络状况,cpu等信息给app
 */
- (void)onEngineStatisticsInfo:(NSArray *)statistics;

/**
 网络质量实时统计回调
 
 @param uid 用户UID, 如果是自己, 则uid==0
 @param txQuality 指定用户的上行网络传输质量
 @param rxQuality 指定用户的下行网络传输质量
 @discussion 该回调2s调用一次, 多个用户调用多次
 */
- (void)onNetworkQuality:(NSUInteger)uid txQuality:(RtcNetworkQuality)txQuality rxQuality:(RtcNetworkQuality)rxQuality;

/// 用户音量提示回调
/// @param audioLevels 音量提示信息，包括自己和远端用户
/// @discussion 该回调默认不启用，需要通过 enableAudioVolume 开启，开启后会按配置间隔时间提示回调
- (void)onAudioVolumeIndication:(NSArray<RtcRoomAudioLevel *> *)audioLevels;

/**
 文本消息到达通知

 @param msg 消息结构体，具体消息在该结构体中
 @discussion 当房间的其他用户发消息时，该接口会被调用，并携带所发送的消息
 */
- (void)onTextMessageArrival:(RtcMessageInfo *)msg;

/**
 文本消息到达通知 与onTextMessageArrival区别为
 
 @param msg 消息结构体，具体消息在该结构体中
 @discussion 当房间的其他用户发消息时，该接口会被调用，并携带所发送的消息
 */
- (void)onTextMessageArrival2:(RtcMessageInfo *)msg;

/**
 用户attribute值获取通知
 
 @param attribute 用户attribute值
 @discussion 当调用getUserAttribute获取用户Attribute属性时，该接口会被调用，返回用户attribute属性
 */
- (void)onTextMessageAttribute:(NSNumber *)userID attribute:(NSString *)attribute;

/**
 开启屏幕分享的结果回调
 
 @param errCode 开启屏幕分享的结果，0: 开启成功; 1: rtc 当前不可用; 2: 系统录屏功能当前不可用; 3: 系统版本不支持;
 @discussion 当您通过 startShareAppScreen, startShareSystemScreen 等方法启动屏幕分享能力后，会回调该事件
 */
- (void)onShareScreenStartComplete:(int)errCode;

/**
 本地屏幕分享已停止
 
 @param reason 停止原因. 0: 用户调用接口主动停止; 1: 用户从系统控制主动停止
 */
- (void)onShareScreenStopped:(int)reason;


/**
 * 收到远端SEI消息
 */
- (void)onRecvSEIMsg:(NSInteger)uid message:(NSData *)message;

/**
 *  角色转换
 */
- (void)onSwitchRole:(NSInteger)errCode errMsg:(nullable NSString *)errMsg;


/// 视频卡顿开始
/// @param userId 卡顿用户
- (void)onVideoRenderStuckStart:(NSInteger)userId;

/// 视频卡顿结束
/// @param userId 卡顿用户
/// @param bufferDuration 卡顿时长毫秒数
- (void)onVideoRenderStuckEnd:(NSInteger)userId duration:(NSInteger)duration;

@end
