#import <Foundation/Foundation.h>
#import <WebKit/WebKit.h>

/**
 * @ingroup def
 * @brief whiteboard tools
*/
typedef NS_ENUM(NSInteger, RtcBoardToolType)
{
    RTC_BOARD_TOOL_TYPE_MOUSE              = 0,    ///< 鼠标 "selection"
    RTC_BOARD_TOOL_TYPE_PEN                = 1,    ///< 画笔 "freedraw"
    RTC_BOARD_TOOL_TYPE_ERASER             = 2,    ///< 橡皮擦 "eraser"
    RTC_BOARD_TOOL_TYPE_LASER              = 3,    ///< 激光笔 "laser"
    RTC_BOARD_TOOL_TYPE_LINE               = 4,    ///< 直线 "line"
    RTC_BOARD_TOOL_TYPE_ARROW              = 5,    ///< 箭头线 "arrow"
    RTC_BOARD_TOOL_TYPE_OVAL               = 6,    ///< 空心椭圆 "ellipse"
    RTC_BOARD_TOOL_TYPE_DIAMOND            = 7,    ///< 空心菱形 "diamond"
    RTC_BOARD_TOOL_TYPE_RECT               = 8,    ///< 空心矩形 "rectangle"
    RTC_BOARD_TOOL_TYPE_TEXT               = 9,    ///< 文本工具 "text"
    // to be removed...
    RTC_BOARD_TOOL_TYPE_UNDO               = 10,
    RTC_BOARD_TOOL_TYPE_REDO               = 11,
    RTC_BOARD_TOOL_TYPE_CLEAR              = 12,
};

@interface BoardRoomState : NSObject

// current page index, index start from 0 and less than total page count
@property (nonatomic, assign) NSUInteger pageIndex;

// total page count, page count at least is 1
@property (nonatomic, assign) NSUInteger totalPageCount;

@property (nonatomic, assign) BOOL undoCheck;

@property (nonatomic, assign) BOOL redoCheck;

@property (nonatomic, assign) BOOL clearCheck;

@end

@interface BoardLoginParam : NSObject

/// 房间名
@property (nonatomic, copy) NSString *channelName;

/// app key
@property (nonatomic, copy) NSString *appId;

/// app secret
@property (nonatomic, copy) NSString *token;

/// uid
@property (nonatomic, assign) NSUInteger uid;

/// 是否开启 web 调试日志
@property (nonatomic, assign) BOOL debug;

/// 是否开启观众模式
@property (nonatomic, assign) BOOL audience;

@end

@interface RTCBoardView : WKWebView

- (instancetype)initWithFrame:(CGRect)frame scriptMessageHandler:(id<WKScriptMessageHandler>)scriptMessageHandler;

- (void)captureRtcBoard:(void(^)(UIImage *capturedImage))completionHandler;

@end

@protocol BaiduRtcBoardDelegate <NSObject>

/**
 web页面加载完成
 */
- (void)onRTCBoardLoaded;

/**
 web创建白板房间成功,可以忽略
 */
- (void)onRTCBoardCreateSucceed;

/**
 web加入白板房间成功,可以忽略
 */
- (void)onRTCBoardJoinSucceed;

/**
 提示web加入白板房间的错误及原因
 
 @param code 错误码
 @param error 具体错误信息
 */
- (void)onRTCBoardJoinFailed:(NSInteger)code error:(NSString *)error;

/**
 提示web创建白板房间的错误及原因
 
 @param code 错误码
 @param error 具体错误信息
 */
- (void)onRTCBoardCreateFailed:(NSInteger)code error:(NSString *)error;

/**
 web离开白板房间
 */
- (void)onRTCBoardLeave;

/**
 web发生了网络异常
 
 @param code 错误码
 @param error 具体错误信息
 */
- (void)onRTCBoardError:(NSInteger)code error:(NSString *)error;

/**
 web抛出Js错误
 
 @param error 具体错误信息
 */
- (void)onWebJsError:(NSString *)error;

/**
 web需要鉴权信息
 */
- (void)onWebGetAuth;

/**
 白板房间状态更新
 */
- (void)onRTCBoardStateChanged:(BoardRoomState *)state;

@end

@protocol BaiduRtcBoardWKDelegate <NSObject>

@optional
/*! @abstract Decides whether to allow or cancel a navigation.
 @param navigationAction Descriptive information about the action
 triggering the navigation request.
 @param decisionHandler The decision handler to call to allow or cancel the
 navigation. The argument is one of the constants of the enumerated type WKNavigationActionPolicy.
 @discussion If you do not implement this method, the web view will load the request or, if appropriate, forward it to another application.
 */
- (void)onDecidePolicyForNavigationAction:(WKNavigationAction *)navigationAction decisionHandler:(void (^)(WKNavigationActionPolicy))decisionHandler;

/*! @abstract Decides whether to allow or cancel a navigation after its
 response is known.
 @param navigationResponse Descriptive information about the navigation
 response.
 @param decisionHandler The decision handler to call to allow or cancel the
 navigation. The argument is one of the constants of the enumerated type WKNavigationResponsePolicy.
 @discussion If you do not implement this method, the web view will allow the response, if the web view can show it.
 */
- (void)onDecidePolicyForNavigationResponse:(WKNavigationResponse *)navigationResponse decisionHandler:(void (^)(WKNavigationResponsePolicy))decisionHandler;

@end
