#import <Foundation/Foundation.h>
#import <WebKit/WebKit.h>
#import <BaiduRtcBoard/BaiduRtcBoardDef.h>

NS_ASSUME_NONNULL_BEGIN

@interface BaiduRtcBoardApi : NSObject

+ (instancetype)sharedManager;

- (void)setBaiduRtcBoardDelegate:(id<BaiduRtcBoardDelegate>)delegate;

- (void)setBaiduRtcBoardWKDelegate:(id<BaiduRtcBoardWKDelegate>)wkDelegate;

- (RTCBoardView *)createBoardViewWithFrame:(CGRect)frame;
- (void)destroyBoardView;

/// 调用web登录，在页面加载完成之后执行
/// @param param 登录参数
- (void)callWebLoginWithParam:(BoardLoginParam *)param;

/// 调用web登出
- (void)callWebLogout;

/// 设置白板是否可以绘制
/// @param enable 是否可以绘制
- (void)callWebEnableDraw:(BOOL)enable;

/// 给web发送鉴权信息
/// @param token token
- (void)callWebSendAuthWithAppSecret:(NSString *)token;

// 截图
- (void)captureBaiduRtcBoard:(void(^)(UIImage *capturedImage))completionHandler;

/**
 * @brief 撤销当前白板页上一次动作
*/
- (void)undo;

/**
 * @brief 重做当前白板页上一次撤销
*/
- (void)redo;

/**
 * @brief 清除涂鸦
 */
- (void)clear;

- (void)stats;

- (void)grid;

- (void)setBackgroundColor:(UIColor *)color transparency:(CGFloat)transparency;

- (void)setBrushColor:(UIColor *)color;

/**
 * @brief 设置要使用的白板工具
 * @param type    要设置的白板工具, `RtcBoardToolType`
*/
- (void)setToolType:(RtcBoardToolType)type;

/// @}

/// @name 白板页操作接口
/// @{

/**
 * @brief 增加一页白板
 */
- (void)addBoard;

/**
 * @brief 删除指定页面
 * @param index 目标页面索引
 */
- (void)deleteBoard:(NSInteger)index;

/**
 * @brief 跳转至第一页
 */
- (void)firstBoard;

/**
 * @brief 跳转至最后一页
 */
- (void)lastBoard;

/**
 * @brief 向前翻页
 *
 * 若当前白板页为当前文件的第一页，则该接口调用无效
*/
- (void)preBoard;

/**
 * @brief 向后翻页
 *
 * 若当前白板页为当前文件的最后一页，则该接口调用无效
*/
- (void)nextBoard;

/**
 * @brief 跳转到指定白板页
 * @param boardId            要跳转到的白板页 ID
 *
 * 允许跳转到任意文件的白板页
*/
- (void)gotoBoard:(NSInteger)boardId;

@end

NS_ASSUME_NONNULL_END
