// SPDX-FileCopyrightText: 2023 The Pion community <https://pion.ly>
// SPDX-License-Identifier: MIT

package codecs

import "errors"

var (
	errShortPacket          = errors.New("packet is not large enough")
	errNilPacket            = errors.New("invalid nil packet")
	errTooManyPDiff         = errors.New("too many PDiff")
	errTooManySpatialLayers = errors.New("too many spatial layers")
	errUnhandledNALUType    = errors.New("NALU Type is unhandled")

	// AV1 Errors
	errIsKeyframeAndFragment = errors.New("bits Z and N are set. Not possible to have OBU be tail fragment and be keyframe")
)

var (
	errNalCorrupted                  = errors.New("NAL could not be parsed to one of known types")
	errInvalidNalType                = errors.New("NAL types 28 and 29 are reserved for RTP streams")
	errPacketTooLarge                = errors.New("packet passed in is larger than 65535 bytes")
	errNotEnoughPackets              = errors.New("aggregation and fragmentation packets requires at least 2 packets")
	errFirstFragmentationUnitMissing = errors.New("expecting the first fragmentation packet")
	errLastFragmentationUnitMissing  = errors.New("expecting the last fragmentation packet")
)
