# rtc-go-sdk
接入BRTC的Go SDK, 需要先到百度智能云申请BRTC的AppID, 并设置环境变量APPID_GET_FROM_BAIDU, https://cloud.baidu.com/doc/RTC/index.html

## SDK 制作
```bash
zip -r BRTC.Go.SDK.Vx.zip baidurtc sdkdemo/res sdkdemo/src docs LICENSE README.md -x "*DS_Store" -x "*/dump*" -x "*/src/sdkdemo"
```

## 测试
进入baidurtc目录执行go test

cd baidurtc

推流测试， 视频使用H264格式，音频格式可配置， 对应的web需要配置一致的音频格式
```bash
go test -run TestPush
go test -run TestPush -ac=opus
go test -run TestPush -ac=pcmu
go test -run TestPush -ac=pcmu -af=raw
go test -run TestPush -ac=pcma
go test -run TestPush -ac=pcma -af=raw
go test -run TestPush -ac=g722
go test -run TestPush -ac=g722 -af=raw16k
```

拉流测试， 视频使用H264格式，音频格式可配置， -adump 支持dump为raw pcm， 对应的web需要配置一致的音频格式
```bash
go test -run TestPull
go test -run TestPull -ac=opus
go test -run TestPull -ac=g722
go test -run TestPull -ac=g722 -adump=raw
go test -run TestPull -ac=pcmu
go test -run TestPull -ac=pcmu -adump=raw
go test -run TestPull -ac=pcma
go test -run TestPull -ac=pcma -adump=raw
```

信令测试， 视频使用H264格式，音频格式可配置，对应的web需要配置一致的音频格式
```bash
go test -run TestSS
go test -run TestSS -ac=opus
go test -run TestSS -ac=g722
go test -run TestSS -ac=pcmu
go test -run TestSS -ac=pcma
```

## 把SDK添加到工作区
```bash
go work use `pwd`/baidurtc
go work use -r `pwd`/thirdparty/pion
```

## 或者, 安装SDK到系统目录
```bash
sudo ln -s `pwd`/baidurtc `go env GOROOT`/src/baidurtc
```

## 编译demo并测试
```bash
export APPID_GET_FROM_BAIDU=
cd sdkdemo/src
go build sdkdemo.go
./sdkdemo -appid=$APPID_GET_FROM_BAIDU
```