#include <dlfcn.h>
#include <stdio.h>
#include <stdlib.h>
#include <thread>
#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include <cstring>
#include <inttypes.h>

#include "include/BaiduRtcInterface.h"

#include "y4m.h"

const char* Help =
"\
sdkdemo\n\
Copyright 2021 Baidu.com, Inc. All Rights Reserved.\n\
\n\
Usage:\n\
    ./sdkdemo $(APPID_GET_FROM_BAIDU)\n\
\n\
";

#define  CLIENTS_NUM    10

#ifndef PRId64
#define PRId64 "lld"
#endif

#ifndef RTLD_DEEPBIND
#define RTLD_DEEPBIND 0
#endif

class myListener:public IRtcMessageListener,
                public IAudioFrameObserver,
                public IVideoFrameObserver,
                public IDataFrameObserver
 {
    void OnRtcMessage(RtcMessage &msg) override 
    {
        printf("========================myListener got Message: %d.==========================\n", msg.msgType);
        switch (msg.msgType)
        {
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_REMOTE_COMING:
            {
                printf("Feed Coming %" PRId64 ", Name: %s.\n",msg.data.feedId,msg.extra_info);
            }
            break;
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_REMOTE_LEAVING:
            {
                printf("Feed Leaving %" PRId64 ".\n",msg.data.feedId);
            }
            break;
        case RtcMessageType::RTC_MESSAGE_STATE_STREAM_UP:
            {
                firstVideoFrame = true;
                firstAudioFrame = true;
                printf("stream up, send/got video now.\n");
            }
            break;
        case RtcMessageType::RTC_ROOM_EVENT_ON_USER_MESSAGE:
            {
                printf("Got User Message id: %" PRId64 ", msg: %s.\n", msg.data.feedId, msg.extra_info);
            }
            break;
        case RtcMessageType::RTC_ROOM_EVENT_ON_USER_ATTRIBUTE:
            {
                printf("Got User Attribute id: %" PRId64 ", %s.\n", msg.data.feedId, msg.extra_info);
            }
        case RtcMessageType::RTC_ROOM_EVENT_ON_USER_JOINED_ROOM:
            {
                printf("User joined room id: %" PRId64 ", display: %s.\n", msg.data.feedId, msg.extra_info);
            }
            break;
        case RtcMessageType::RTC_ROOM_EVENT_ON_USER_LEAVING_ROOM:
            {
                printf("User leaving room id: %" PRId64 ".\n", msg.data.feedId);
            }
            break;
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_SERVER_ERROR:
            {
                printf("Error code: %" PRId64 ", error: %s.\n", msg.data.errorCode, msg.extra_info);
            }
            break;
        case RtcMessageType::RTC_STATE_STREAM_SLOW_LINK_NACKS:
            {
                printf("slowlink nacks: %" PRId64 ".\n", msg.data.errorCode);
            }
            break;
        default:
            break;
        }
    }
    void onFrame(int64_t feedid, const char *img,  int len,  RtcImageType imgtype, int width, int height) override 
    {
        if (firstVideoFrame) {
            printf("got VideoData feed %" PRId64 ", data len = %d.\n",feedid, len);
            firstVideoFrame = false;
        }
    }
    void onAudioData(int64_t feedid, const char *audio, int len, int samlplerate, int channels) override 
    {
        if (firstAudioFrame) {
            printf("got AudioData feed %" PRId64 ", data len = %d.\n",feedid, len);
            firstAudioFrame = false;
        }
    }
    void onTextData(int64_t feedid, const char *data, int len) override
    {
        std::string msg(data,len);
        printf("got TextData feed %" PRId64 ", data len = %d, text: %s.\n",feedid, len, msg.c_str());
    }

public:
    bool firstVideoFrame = true;
    bool firstAudioFrame = true;

} g_myListener, g_myListenerGroup[CLIENTS_NUM];

void setListener(baidurtc::BaiduRtcRoomClient *c,myListener &l)
{
    c->registerRtcMessageListener(&l);

    IVideoFrameObserver* iVfo[2];
    iVfo[0] = &l;
    c->registerVideoFrameObserver(iVfo,1);

    IAudioFrameObserver* iAfo[2];
    iAfo[0] = &l;
    c->registerAudioFrameObserver(iAfo,1);

    IDataFrameObserver* iDfo[2];
    iDfo[0] = &l;
    c->registerDataFrameObserver(iDfo,1);
}

#define FIND_AND_SET_ROOM_NULL \
        for (int i=0; i < CLIENTS_NUM; i++) { \
            if (g_BrtcClientGroup[i] == g_BrtcClient) { \
                g_BrtcClientGroup[i] = nullptr; \
                break; \
            } \
        }

typedef baidurtc::BaiduRtcRoomClient* f_createBaiduRtcRoomClient();
typedef const char* f_getVersion();
typedef void f_enableLog(int e);

int main_videoroom(int argc, char* argv[])
{
    if (argc < 2)
    {
        printf("%s", Help);
        return false;
    }

    void* handle = dlopen("libbaidurtc.so", RTLD_LAZY | RTLD_DEEPBIND);
    if (handle == NULL) {
        fprintf(stderr, "Could not open sdk: %s\n", dlerror());
        return 1;
    }
    f_createBaiduRtcRoomClient* createClient = (f_createBaiduRtcRoomClient *)dlsym(handle, "_ZN8baidurtc24createBaiduRtcRoomClientEv");
    if (createClient == NULL) {
        fprintf(stderr, "Could not find sdk_func: %s\n", dlerror());
        return 1;
    }
    f_getVersion *version = (f_getVersion*)dlsym(handle, "getBaiduRtcSdkVersion");
    f_enableLog *enableLog = (f_enableLog*)dlsym(handle, "enableBaiduRtcLog");
    f_enableLog *enableReviewer = (f_enableLog*)dlsym(handle, "setSDKAsReviewer");

    printf("BRTC SDK Version is: %s\n",version());

    if (enableLog) {
        enableLog(0); // set 0 to disable logs.
    }

    printf("Calling API\n");
    baidurtc::BaiduRtcRoomClient *g_BrtcClient = nullptr, *g_BrtcClientGroup[CLIENTS_NUM] = {nullptr};
    volatile bool g_StopFlag = false;
    RtcParameterSettings s;

	while (true) {
		printf("**********BaiDuRTC demo V0.0.7 *********\n");
		printf(" 0 create, 1 login, 2 logout, 3 destroy.\n");
		printf("Please input q to Quit.\n");
		char commandid[512];
        memset(commandid,0,sizeof(commandid));
		int ret = scanf("%s", commandid);
		printf("scanf %d.\n", ret);

		if (ret < 0) {
			std::this_thread::sleep_for(std::chrono::milliseconds(20000));
			continue;
		}

		if (commandid[0] == 'q') break;

        if (commandid[0] == '7') { //switch room to 7x

            int r_idx = atol(&commandid[1]);
            if(r_idx >= 0 && r_idx < CLIENTS_NUM) {
                if (g_BrtcClientGroup[r_idx] == nullptr) {
                    g_BrtcClientGroup[r_idx] = createClient();
                    setListener(g_BrtcClientGroup[r_idx], g_myListenerGroup[r_idx]);
                }
                g_BrtcClient = g_BrtcClientGroup[r_idx];
            }
        }

        switch (commandid[0])
        {
            case '0':
                g_BrtcClient = createClient();
                setListener(g_BrtcClient, g_myListener);
                break;
            case '4':                                     // manual publish,listen.
                s.AutoPublish   = false;
                s.AutoSubscribe = false;
            case '1':
                {
                    s.HasData = true;
                    s.HasVideo = true;
                    s.HasAudio = true;
                    if (commandid[0] == '1') {
                        s.AutoPublish   = true;
                        s.AutoSubscribe = true;
                    }
                    switch (commandid[1]) {
                        case 'd':
                            {                             //  1d,  only publish data.
                                s.HasVideo = false;
                                s.HasAudio = false;
                                s.AsPublisher = true;
                                s.AsListener = false;
                            }
                            break;
                        case 'w':
                            {
                                if (commandid[2] == 'a') { //  1wa,  publish & listen audio.
                                    s.HasVideo = false;
                                }
                                s.AudioINChannel = 1;
                                s.AudioINFrequency = 16000;
                                s.AudioOUTChannel = 1;
                                s.AudioOUTFrequency = 16000;
                                s.AsPublisher = true;
                                s.AsListener = true;
                            }
                            break;
                        case 'p':
                            {
                                if (commandid[2] == 'a') { //  1pa,  only publish audio.
                                    s.HasVideo = false;
                                }
                                s.AudioINChannel = 1;
                                s.AudioINFrequency = 16000;
                                s.AsPublisher = true;
                                s.AsListener = false;
                                if (commandid[2] == 'y' || commandid[2] == 'j') {
                                    s.ImageINType = (commandid[2] == 'y') ?
                                                RTC_IMAGE_TYPE_I420P : // 1py, for *.y4m video file.
                                                RTC_IMAGE_TYPE_JPEG; // 1pj, for jpeg files.
                                    if (commandid[3] == '8') {
                                        g_BrtcClient->setVideoCodec("vp8"); // 1py8 for vp8 videocodec.
                                    }
                                }
                            }
                            break;
                        case 'l':
                            {                              //  1l, listener for a/v.
                                s.HasVideo = true;
                                s.HasAudio = true;
                                s.AudioOUTChannel = 1;
                                s.AudioOUTFrequency = 16000;
                                s.AsPublisher = false;
                                s.AsListener = true;
                                g_BrtcClient->setFeedId("999999");

                                if (commandid[2] == '\0') {
                                } else if (commandid[2] == '0') { //  1l0,  set feedid to 0.
                                    g_BrtcClient->setFeedId("0");
                                } else {
                                    g_BrtcClient->setFeedId(&commandid[2]);
                                }
                                g_BrtcClient->setDumpAudioOutput("./dump_pcm.raw");
                                g_BrtcClient->setDumpVideoOutput("./dump_video.h264");
                            }
                            break;
                        default:
                            {                              //  1, for ue4 publish test.
                                s.AudioINChannel = 1;
                                s.AudioINFrequency = 16000;
                                s.HasAudio = true;
                                s.AsPublisher = true;
                                s.AsListener = false;
                                if (argc > 2) {
                                    g_BrtcClient->setUE4(argv[2]/*$(UE4_HOST)*/);
                                    g_BrtcClient->setUE4DRC("0:1600:1080x1440:15,10:1000:600x800:15,20:500:600x800:15");
                                }
                            }
                            break;
                    }

                    g_BrtcClient->setParamSettings(&s,s.RTC_PARAM_SETTINGS_ALL);
                    g_BrtcClient->setAppID(argv[1]/*$(APPID_GET_FROM_BAIDU)*/);
                    g_BrtcClient->setMediaServerURL("wss://rtc.exp.bcelive.com/janus");
                    g_BrtcClient->setCER("../bin/a.cer");

                    std::string uid;
                    std::ostringstream os;
                    os << 1234500000 + rand()/100000;
                    uid =  os.str();

                    g_BrtcClient->loginRoom("2131",uid.c_str(),"BRTC Linux SDK demo","token");
                }
                break;

            case '2':
                g_BrtcClient->logoutRoom();
                printf("logoutRoom OK.\n");
                break;
            case '3':
                g_StopFlag = true;
                std::this_thread::sleep_for(std::chrono::milliseconds(100));
                g_BrtcClient->Destory();
                FIND_AND_SET_ROOM_NULL;
                g_BrtcClient = nullptr;
                printf("Destory OK.\n");
                break;
            case '5':
                g_StopFlag = true;
                std::this_thread::sleep_for(std::chrono::milliseconds(100));
                g_BrtcClient->logoutRoom();
                printf("logoutRoom OK.\n");
                g_BrtcClient->Destory();
                FIND_AND_SET_ROOM_NULL;
                g_BrtcClient = nullptr;
                printf("Destory OK.\n");
                break;

            case '6':
                g_BrtcClient->sendMessageToUser("hello","0");
                g_BrtcClient->setUserAttribute("{'name':'red','tel':'1234567890'}");
                break;
            case '8':
                g_BrtcClient->sendData("88888",5);
                break;

            case '9':
                g_BrtcClient->getRtcServerFromPlatform("http://cpp.sh/","ws://127.0.0.1/janus");//http://10.112.25.182/internal/v1/nodeapply
                break;

            case 'h':
                g_BrtcClient->startHealthyServer("8999");//curl http://127.0.0.1:8999/health/v1
                break;

            case 'f':
            case 'g':
                g_BrtcClient->shutupUser("999999", (commandid[0] == 'f')? true : false);
                break;
            case 'k':
                g_BrtcClient->kickoutUser("999999");
                break;
            case 'd':
                g_BrtcClient->disbandRoom();
                break;

            case 'n':
                g_BrtcClient->subscribeStreaming("999999",nullptr,nullptr,nullptr);
                break;
            case 'o':
                g_BrtcClient->stopSubscribeStreaming("999999");
                break;
            case 'p':
                g_BrtcClient->startPublish();
                break;
            case 'u':
                g_BrtcClient->stopPublish();
                break;

            case 'j':
                {
                    g_StopFlag = false;
                    std::thread([g_BrtcClient,&g_StopFlag]()
                    {
                        std::fstream  fs("./my.jpg");//fs("./myvideo.h264");
                        std::stringstream  ss;

                        ss << fs.rdbuf();
                        std::cout << "ss.str().length(): "<< ss.str().length() << std::endl;

                        for (int i =0;i <200000;i++) { //need streaming control.
                            std::this_thread::sleep_for(std::chrono::milliseconds(50));
                            if (g_StopFlag) break;
                            g_BrtcClient->sendImage(ss.str().data(),ss.str().length());
                        }
                    }).detach();
                }
                break;
            case 'v':
                {
                    g_StopFlag = false;
                    std::thread([g_BrtcClient,&g_StopFlag]()
                    {
                        std::fstream  fs("./myvideo.h264");
                        std::stringstream  ss;

                        ss << fs.rdbuf();
                        std::cout << "h264.length(): "<< ss.str().length() << std::endl;
                        int t_len = ss.str().length();
                        int packet_len = 15000;
                        int j = 0;

                        auto pre_send_time = std::chrono::system_clock::now();
                        for (int i=0;i <2000000;i++) { //need streaming control.

                            g_BrtcClient->sendImage(&ss.str()[j],packet_len);
                            std::this_thread::sleep_until(pre_send_time + ((i+1) * std::chrono::milliseconds(100)));
                            if (g_StopFlag) break;

                            j += packet_len;
                            if (j + packet_len > t_len) j = 0;
                        }
                    }).detach();
                }
                break;
            case 'a':
                {
                    g_StopFlag = false;
                    std::thread([g_BrtcClient,&g_StopFlag]()
                    {
                        std::fstream  fs("./mypcm.raw");
                        std::stringstream  ss;

                        ss << fs.rdbuf();
                        std::cout << "pcm.length(): "<< ss.str().length() << std::endl;
                        int t_len = ss.str().length();
                        int packet_len = (16000/100) *2*4;
                        int j = 0;

                        auto pre_send_time = std::chrono::system_clock::now();
                        for (int i=0;i <2000000;i++) { //need streaming control.

                            g_BrtcClient->sendAudio(&ss.str()[j],packet_len);
                            std::this_thread::sleep_until(pre_send_time + ((i+1) * std::chrono::milliseconds(40)));
                            if (g_StopFlag) break;

                            j += packet_len;
                            if (j + packet_len > t_len) j = 0;
                        }
                    }).detach();
                }
                break;
            case 'm':
                {   // Proxy IP setting.
                    g_BrtcClient->setMediaServerIP("182.61.0.35");
                    g_BrtcClient->setCandidateIP("182.61.0.35");
                }
                break;
            case 's':
                {
                    g_StopFlag = true;
                }
                break;
            case 'y':
                {
                    g_StopFlag = false;

                    std::thread([g_BrtcClient,&g_StopFlag,&s,commandid]()
                    {
                        y4m_input_t *h;
                        std::string buf;
                        // std::string NV12_uv_buf;

                        printf("open y4m file: %s\n.",&commandid[1]);

                        if (commandid[1] == '\0') { //  default path.
                            // https://brtc-sdk.cdn.bcebos.com/x86_64-linux/video_res/reference_video_640x360_30fps.y4m
                            open_file_y4m((char *)"/home/shaohongsheng/linux/tmp/reference_video_640x360_30fps.y4m",&h);
                        } else {
                            open_file_y4m((char *)&commandid[1],&h);
                        }

                        printf("image : %dx%d.\n",h->width, h->height);
                        printf("resize buffer: %d\n.",h->width*h->height*3/2);
                        buf.resize(h->width*h->height*3/2);
                        // NV12_uv_buf.resize(h->width*h->height/2);

                        s.VideoWidth = h->width;
                        s.VideoHeight = h->height;

                        g_BrtcClient->setParamSettings(&s,s.RTC_VIDEO_PARAM_SETTINGS_RESOLUTION);

                        printf("read_frame_y4m:.\n");

                        int j = 0;
                        auto pre_send_time = std::chrono::system_clock::now();
                        for (int i =0;i <2000000;i++) {
                            int r = read_frame_y4m(h,j,(unsigned char *)buf.data(),h->width*h->height*3/2);
                            if(r <0) {
                                j = 0;
                                continue;
                            }
                            j++;

                            // memcpy(NV12_uv_buf.data(), (unsigned char *)buf.data() + h->width * h->height, h->width*h->height/2);
                            // unsigned char *dst_u, *dst_v, *src_uv;
                            // dst_u = (unsigned char *)buf.data() + h->width * h->height;
                            // dst_v = (unsigned char *)buf.data() + h->width * h->height + h->width*h->height/4;
                            // src_uv = (unsigned char *)NV12_uv_buf.data();

                            // for (int i = 0; i < (h->width*h->height/4); ++i) {
                            //     dst_u[i] = src_uv[2 * i];
                            //     dst_v[i] = src_uv[2 * i +1];
                            // }

                            std::this_thread::sleep_until(pre_send_time + ((i+1) * std::chrono::milliseconds(100)));
                            if (g_StopFlag) break;
                            g_BrtcClient->sendImage(buf.data(),h->width*h->height*3/2);
                        }

                        close_file_y4m(h);
                    }).detach();
                }
                break;
            case 'b':
                {
                    typedef int main_f(int argc, char* argv[]);
                    main_f* b = (main_f *)dlsym(handle, "main_brtc");
                    b(argc,argv);
                }
                break;
            case 'z':
                {
                    typedef char * d_f();
                    printf("Please input function name:\n");
                    int ret = scanf("%s", commandid);
                    d_f* d = (d_f *)dlsym(handle, commandid);
                    d();
                }
                break;

            default:
                break;
        }
    }

    printf("API returned %d\n", 123);
    if (dlclose(handle) != 0) {
        fprintf(stderr, "Could not close plugin: %s\n", dlerror());
        return 1;
    }
    return 0;
}

int main(int argc, char* argv[]) 
{
    int res = 0;

    res = main_videoroom(argc, argv);

    return res;
}