#include <dlfcn.h>
#include <stdio.h>
#include <thread>
#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include <cstring>
#include <inttypes.h>

#include "include/BaiduRtcInterface.h"

#ifndef PRId64
#define PRId64 "lld"
#endif

#ifndef RTLD_DEEPBIND
#define RTLD_DEEPBIND 0
#endif

#include "ue4/UE4Connection.h"
#include "cmdline.h"

#include <signal.h>

const char* Help =
"\
BRTCProxy\n\
Copyright 2022 Baidu.com, Inc. All Rights Reserved.\n\
\n\
Parameters:\n\
\n\
-help\n\
Shows this help\n\
\n\
-RTC=wss://hostname:port/janus\n\
RTC server to use.\n\
\n\
\n\
";

std::string PARAM_RTC = "wss://rtc.exp.bcelive.com/janus";
std::string PARAM_UID = "";
std::string PARAM_ROOMNAME = "";
std::string PARAM_APPID = "";
std::string PARAM_TOKEN = "";
std::string PARAM_CER = "../bin/a.cer";
std::string PARAM_FEEDID = "0";
std::string PARAM_DHA = "localhost:50051";
std::string PARAM_DEBUG_DUMP_AUDIO_OUTPUT = "";
std::string PARAM_DEBUG_DUMP_VIDEO_OUTPUT = "";
std::string PARAM_RTC_PLATFORM = "";
int g_param_audio_in_sample_rate = 16000;
int g_param_audio_in_channel_num = 1;
std::string g_param_mediaserverip = "";

bool PARAM_KillSelf_When_Others_Leaving = false;
bool PARAM_Has_DHA = false;
bool PARAM_Has_DHA_WITH_VIDEO = false;
bool PARAM_Has_DATACHANNEL = false;

std::pair<std::string, uint16_t> PARAM_UE4{ "127.0.0.1", 8124 };
bool PARAM_Has_UE4 = false;
std::string PARAM_UE4_DRC = "0:1500:1080x1440:15";

baidurtc::BaiduRtcRoomClient *g_BrtcClient = nullptr;
RtcParameterSettings s;

bool ParseParameters(int argc, char* argv[])
{
	FCmdLine Params;
	if (!Params.Parse(argc, argv))
	{
		printf("%s",Help);
		return false;
	}

	if (Params.Has("Help"))
	{
		printf("%s",Help);
		return false;
	}

	PARAM_RTC = Params.Get("RTC");
	PARAM_UID = Params.Get("UID");
	PARAM_ROOMNAME = Params.Get("ROOMNAME");
	PARAM_APPID = Params.Get("APPID");
	PARAM_TOKEN = Params.Get("TOKEN");

	if (Params.Has("CER"))
	{
		PARAM_CER = Params.Get("CER");
	}

	if (Params.Has("FEEDID"))
	{
		PARAM_FEEDID = Params.Get("FEEDID");
	}

    if (Params.Has("AUDIO_IN_SAMPLE_RATE"))
    {
        g_param_audio_in_sample_rate = Params.GetAsInt("AUDIO_IN_SAMPLE_RATE", g_param_audio_in_sample_rate).second;
    }

    if (Params.Has("AUDIO_IN_CHANNEL_NUM"))
    {
        g_param_audio_in_channel_num = Params.GetAsInt("AUDIO_IN_CHANNEL_NUM", g_param_audio_in_channel_num).second;
    }

	if (Params.Has("RTC_PLATFORM"))
	{
		PARAM_RTC_PLATFORM = Params.Get("RTC_PLATFORM");
	}

	if (Params.Has("DEBUG_DUMP_AUDIO_OUTPUT"))
	{
		PARAM_DEBUG_DUMP_AUDIO_OUTPUT = Params.Get("DEBUG_DUMP_AUDIO_OUTPUT");
	}

	if (Params.Has("DHA_WITH_VIDEO"))
	{
		PARAM_Has_DHA_WITH_VIDEO = true;
	}

	if (Params.Has("DEBUG_DUMP_VIDEO_OUTPUT"))
	{
		PARAM_DEBUG_DUMP_VIDEO_OUTPUT = Params.Get("DEBUG_DUMP_VIDEO_OUTPUT");
	}

	if (Params.Has("DATACHANNEL"))
	{
		PARAM_Has_DATACHANNEL = true;
	}

    if (Params.Has("MEDIASERVERIP"))
    {
        g_param_mediaserverip = Params.Get("MEDIASERVERIP");
    }

	PARAM_KillSelf_When_Others_Leaving = Params.Has("KILLSELF_WHEN_OTHERS_LEAVING");

	// Splits a string in the form of "XXXX:NNN" into a pair
	auto ProcessAddressParameter = [&Params](const char* Name, std::pair<std::string, uint16_t>& OutAddr) -> bool
	{
		if (!Params.Has(Name))
		{
			return true;
		}

		const char* const Param = Params.Get(Name).c_str();
		const char* Ptr = Param;
		// Find separator
		while (!(*Ptr==0 || *Ptr == ':' || *Ptr == '|'))
		{
			Ptr++;
		}

		OutAddr.first = std::string(Param, Ptr);
		// If at the end of the string, then no separator was found (and no port specified)
		if (*Ptr && OutAddr.first!="")
		{
			int Port = std::atoi(Ptr + 1);
			if (Port < 1 || Port>65535)
			{
				std::cout << "Invalid port number for parameter " << Name;
				return false;
			}
			OutAddr.second = static_cast<uint16_t>(Port);
		}
		else
		{
			std::cout <<  "Invalid format for parameter " << Name;
			OutAddr.second = 0;
			return false;
		}

		return true;
	};

    if (Params.Has("UE4"))
	{
		PARAM_Has_UE4 = true;

        if (!ProcessAddressParameter("UE4", PARAM_UE4))
        {

        }
	}

    if (Params.Has("UE4_DRC"))
	{
		PARAM_UE4_DRC = Params.Get("UE4_DRC");
	}

	return true;
}

void brtc_sighandler(int sig)
{
	printf("Received Signal:%d, Quit.",sig);
    if (g_BrtcClient != nullptr) {
        g_BrtcClient->logoutRoom();
        exit(0);
    }
}

class myListener:public IRtcMessageListener,
                public IAudioFrameObserver,
                public IVideoFrameObserver,
                public IDataFrameObserver
 {
    void OnRtcMessage(RtcMessage &msg) override 
    {
        printf("========================myListener got Message: %d.==========================\n", msg.msgType);
        switch (msg.msgType)
        {
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_REMOTE_COMING:
            {
                printf("Feed Coming %" PRId64 ", Name: %s.\n",msg.data.feedId,msg.extra_info);
            }
            break;
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_REMOTE_LEAVING:
            {
                printf("Feed Leaving %" PRId64 ".\n",msg.data.feedId);
                if (PARAM_KillSelf_When_Others_Leaving) {
                    printf("Could killself now.\n");
                    if (g_BrtcClient != nullptr) {
                        g_BrtcClient->logoutRoom();
                        exit(0);
                    }
                }
            }
            break;
        case RtcMessageType::RTC_MESSAGE_STATE_STREAM_UP:
            {
                printf("stream up, send/got video now.\n");
            }
            break;
        default:
            break;
        }
    }
    void onFrame(int64_t feedid, const char *img,  int len,  RtcImageType imgtype, int width, int height) override 
    {

    }
    void onAudioData(int64_t feedid, const char *audio, int len, int samlplerate, int channels) override 
    {

    }
    void onTextData(int64_t feedid, const char *data, int len) override
    {
        std::string msg(data,len);
        // printf("got TextData feed %ld, data len = %d, text: %s.\n",feedid, len, msg.c_str());
    }
} g_myListener;

void setListener(baidurtc::BaiduRtcRoomClient *c,myListener &l)
{
    c->registerRtcMessageListener(&l);

    IVideoFrameObserver* iVfo[2];
    iVfo[0] = &l;
    c->registerVideoFrameObserver(iVfo,1);

    IAudioFrameObserver* iAfo[2];
    iAfo[0] = &l;
    c->registerAudioFrameObserver(iAfo,1);

    IDataFrameObserver* iDfo[2];
    iDfo[0] = &l;
    c->registerDataFrameObserver(iDfo,1);
}

class myUE4Observer:public IUE4ConnectionObserver
 {
public:
	myUE4Observer() {
        
    }
	~myUE4Observer() {

    }
	// IUE4ConnectionObserver implementation
	void OnUE4Connected() override
    {

    }
	void OnUE4Disconnected() override
    {

    }
	void OnUE4ConnecttingTimeOut() override
    {

    }
	void OnUE4Packet(PixelStreamingProtocol::EToProxyMsg PktType, const void* Pkt, int Size) override
    {
        if (_BrtcClient != nullptr) {
            if (PktType == PixelStreamingProtocol::EToProxyMsg::AudioPCM)
            {
                _BrtcClient->sendAudio((const char*)Pkt,Size);
            }
            else if (PktType == PixelStreamingProtocol::EToProxyMsg::ClientConfig)
            {
            }
            else if (PktType == PixelStreamingProtocol::EToProxyMsg::Response)
            {
            }
            else {
                _BrtcClient->sendImage((const char*)Pkt,Size);
            }
            return ;
        }
    }
public:
    baidurtc::BaiduRtcRoomClient *_BrtcClient = nullptr;
 } g_myUE4Observer;

 FUE4Connection *g_UE4Connection = nullptr;

typedef baidurtc::BaiduRtcRoomClient* f_createBaiduRtcRoomClient();
typedef const char* f_getVersion();

static void* gBRTCHandle = NULL;

int BRTC_Start(const char* appid, const char* roomname, const char* uid, const char* displayname,
               const char* token, const char* feedid, const char* brtcserverURL, const char* cerfile,
               bool hasdatachannel, int input_channels, int input_sample_rate) {

    if (gBRTCHandle == NULL) {
        gBRTCHandle = dlopen("libbaidurtc.so", RTLD_LAZY | RTLD_DEEPBIND);
        if (gBRTCHandle == NULL) {
            fprintf(stderr, "Could not open sdk: %s\n", dlerror());
            return 1;
        }
    }

    f_createBaiduRtcRoomClient* createClient = (f_createBaiduRtcRoomClient *)dlsym(gBRTCHandle, "_ZN8baidurtc24createBaiduRtcRoomClientEv");
    if (createClient == NULL) {
        fprintf(stderr, "Could not find sdk_func: %s\n", dlerror());
        return 1;
    }
    f_getVersion *version = (f_getVersion*)dlsym(gBRTCHandle, "getBaiduRtcSdkVersion");

    printf("BRTC.Linux.SDK Version is: %s\n",version());

    g_BrtcClient = createClient();
    setListener(g_BrtcClient, g_myListener);

    s.HasData = false;
    s.HasVideo = true;
    s.HasAudio = true;
    s.AudioINChannel = input_channels;
    s.AudioINFrequency = input_sample_rate;
    s.AsPublisher = true;
    s.AsListener = false;
    s.AutoPublish= true;

    g_BrtcClient->setParamSettings(&s,s.RTC_PARAM_SETTINGS_ALL);
    g_BrtcClient->setAppID(appid);
    g_BrtcClient->setMediaServerURL(brtcserverURL);
    g_BrtcClient->setCER(cerfile);
    g_BrtcClient->setMediaServerIP(g_param_mediaserverip.c_str());
    g_BrtcClient->loginRoom(roomname,uid,displayname,token);

    return 0;
}

int BRTC_Stop() {
    g_BrtcClient->logoutRoom();
    printf("logoutRoom OK.\n");
    g_BrtcClient->Destory();
    g_BrtcClient = nullptr;
    printf("Destory OK.\n");
}

int main_brtcproxy_demo(int argc, char* argv[])
{
	printf("BRTCProxy: Version: V2.0.4\n");
	{
		std::string Str;
		for (int i = 0; i < argc; i++)
		{
			Str += std::string(argv[i]) + " ";
		}
		printf("CmdLine: %s \n", Str.c_str());
	}

	signal(SIGTERM, brtc_sighandler);
	signal(SIGINT,  brtc_sighandler);

    ParseParameters(argc,argv);

    BRTC_Start(PARAM_APPID.c_str(), PARAM_ROOMNAME.c_str(), PARAM_UID.c_str(), "BRTC Linux SDK brtcproxy demo",
               PARAM_TOKEN.c_str(), PARAM_FEEDID.c_str(), PARAM_RTC.c_str(), PARAM_CER.c_str(),
               PARAM_Has_DATACHANNEL, g_param_audio_in_channel_num, g_param_audio_in_sample_rate);

    g_myUE4Observer._BrtcClient = g_BrtcClient;
    g_UE4Connection  = new FUE4Connection(g_myUE4Observer, PARAM_UE4_DRC);

    g_UE4Connection->Connect(PARAM_UE4.first, PARAM_UE4.second);

	while (true) {
		printf("**********BaiDuRTC brtcproxy demo V0.0.1 *********\n");
		printf("Please input q to Quit.\n");
		char commandid[512];
        memset(commandid,0,sizeof(commandid));
		int ret = scanf("%s", commandid);
		printf("scanf %d.\n", ret);

		if (ret < 0) {
			std::this_thread::sleep_for(std::chrono::milliseconds(20000));
			continue;
		}

		if (commandid[0] == 'q') break;
    }

    g_UE4Connection->cleanupConnection();

    BRTC_Stop();
    return 0;
}

int main(int argc, char* argv[]) 
{
    int res = 0;

    res = main_brtcproxy_demo(argc, argv);

    return res;
}