#include <dlfcn.h>
#include <stdio.h>
#include <thread>
#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include <cstring>

#include "include/BaiduRtcInterface.h"

#include "brtcdha/brtcdha_client.h"
#include "cmdline.h"

#include <signal.h>

const char* Help =
"\
BRTCProxy\n\
Copyright 2020 Baidu.com, Inc. All Rights Reserved.\n\
\n\
Parameters:\n\
\n\
-help\n\
Shows this help\n\
\n\
-RTC=wss://hostname:port/janus\n\
RTC server to use.\n\
\n\
\n\
";

std::string PARAM_RTC = "wss://rtc.exp.bcelive.com/janus";
std::string PARAM_UID = "";
std::string PARAM_ROOMNAME = "";
std::string PARAM_APPID = "";
std::string PARAM_TOKEN = "";
std::string PARAM_CER = "../bin/a.cer";
std::string PARAM_FEEDID = "0";
std::string PARAM_DHA = "localhost:50051";
std::string PARAM_DEBUG_DUMP_AUDIO_OUTPUT = "";
std::string PARAM_DEBUG_DUMP_VIDEO_OUTPUT = "";
std::string PARAM_RTC_PLATFORM = "";
int PARAM_DHA_AUDIO_OUT_SAMPLE_RATE = 16000;

bool PARAM_KillSelf_When_Others_Leaving = false;
bool PARAM_Has_DHA = false;
bool PARAM_Has_DHA_WITH_VIDEO = false;
bool PARAM_Has_DATACHANNEL = false;

baidurtc::BaiduRtcRoomClient *g_BrtcClient = nullptr;
RtcParameterSettings s;

bool ParseParameters(int argc, char* argv[])
{
	FCmdLine Params;
	if (!Params.Parse(argc, argv))
	{
		printf("%s",Help);
		return false;
	}

	if (Params.Has("Help"))
	{
		printf("%s",Help);
		return false;
	}

	PARAM_RTC = Params.Get("RTC");
	PARAM_UID = Params.Get("UID");
	PARAM_ROOMNAME = Params.Get("ROOMNAME");
	PARAM_APPID = Params.Get("APPID");
	PARAM_TOKEN = Params.Get("TOKEN");

	if (Params.Has("CER"))
	{
		PARAM_CER = Params.Get("CER");
	}

	if (Params.Has("FEEDID"))
	{
		PARAM_FEEDID = Params.Get("FEEDID");
	}

	if (Params.Has("DHA")) 
	{
		PARAM_Has_DHA = true;
		PARAM_DHA = Params.Get("DHA");
		if (Params.Has("DHA_AUDIO_OUT_SAMPLE_RATE"))
		{
			PARAM_DHA_AUDIO_OUT_SAMPLE_RATE = Params.GetAsInt("DHA_AUDIO_OUT_SAMPLE_RATE",16000).second;
		}
	}

	if (Params.Has("RTC_PLATFORM"))
	{
		PARAM_RTC_PLATFORM = Params.Get("RTC_PLATFORM");
	}

	if (Params.Has("DEBUG_DUMP_AUDIO_OUTPUT"))
	{
		PARAM_DEBUG_DUMP_AUDIO_OUTPUT = Params.Get("DEBUG_DUMP_AUDIO_OUTPUT");
	}

	if (Params.Has("DHA_WITH_VIDEO"))
	{
		PARAM_Has_DHA_WITH_VIDEO = true;
	}

	if (Params.Has("DEBUG_DUMP_VIDEO_OUTPUT"))
	{
		PARAM_DEBUG_DUMP_VIDEO_OUTPUT = Params.Get("DEBUG_DUMP_VIDEO_OUTPUT");
	}

	if (Params.Has("DATACHANNEL"))
	{
		PARAM_Has_DATACHANNEL = true;
	}

	PARAM_KillSelf_When_Others_Leaving = Params.Has("KILLSELF_WHEN_OTHERS_LEAVING");

	return true;
}

void brtcdha_sighandler(int sig)
{
	printf("Received Signal:%d, Quit.",sig);
    if (g_BrtcClient != nullptr) {
        g_BrtcClient->logoutRoom();
        exit(0);
    }
}

class myListener:public IRtcMessageListener,
                public IAudioFrameObserver,
                public IVideoFrameObserver,
                public IDataFrameObserver
 {
    void OnRtcMessage(RtcMessage &msg) override 
    {
        printf("========================myListener got Message: %d.==========================\n", msg.msgType);
        switch (msg.msgType)
        {
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_REMOTE_COMING:
            {
                printf("Feed Coming %ld, Name: %s.\n",msg.data.feedId,msg.extra_info);
            }
            break;
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_REMOTE_LEAVING:
            {
                printf("Feed Leaving %ld.\n",msg.data.feedId);
                if (PARAM_KillSelf_When_Others_Leaving) {
                    printf("Could killself now.\n");
                    if (g_BrtcClient != nullptr) {
                        g_BrtcClient->logoutRoom();
                        exit(0);
                    }
                }
            }
            break;
        case RtcMessageType::RTC_MESSAGE_STATE_STREAM_UP:
            {
                printf("stream up, send/got video now.\n");
            }
            break;
        default:
            break;
        }
    }
    void onFrame(int64_t feedid, const char *img,  int len,  RtcImageType imgtype, int width, int height) override 
    {
        // printf("got VideoData feed %ld, data len = %d.\n",feedid, len);

        if(!PARAM_DEBUG_DUMP_VIDEO_OUTPUT.empty() && (dump_h264_fd == NULL)) {
            dump_h264_fd = fopen(PARAM_DEBUG_DUMP_VIDEO_OUTPUT.c_str(), "wb");
            printf("Dump video to file: %s\n",PARAM_DEBUG_DUMP_VIDEO_OUTPUT.c_str());
        }

        if (dump_h264_fd != NULL) {
            fwrite((char*)img, 1, len, dump_h264_fd);
        }

        if (dha != NULL) {
            std::string h264((char*)img,len);
            dha->send_image(h264);
        }
    }
    void onAudioData(int64_t feedid, const char *audio, int len, int samlplerate, int channels) override 
    {
        // printf("got AudioData feed %ld, data len = %d.\n",feedid, len);

        if (!PARAM_DEBUG_DUMP_AUDIO_OUTPUT.empty() && (dump_pcm_fd == NULL)) {
            dump_pcm_fd = fopen(PARAM_DEBUG_DUMP_AUDIO_OUTPUT.c_str(), "wb");
            printf("Dump audio to file: %s\n",PARAM_DEBUG_DUMP_AUDIO_OUTPUT.c_str());
        }

        if (dump_pcm_fd != NULL) fwrite(audio, 1, len, dump_pcm_fd);

        if (dha != NULL) {
            std::string pcm((char*)audio,len);
            dha->send_audio(pcm);
        }
    }
    void onTextData(int64_t feedid, const char *data, int len) override
    {
        std::string msg(data,len);
        // printf("got TextData feed %ld, data len = %d, text: %s.\n",feedid, len, msg.c_str());
    }

public:
    BRTCDHAClient *dha = NULL;
    FILE* dump_pcm_fd  = NULL;
	FILE* dump_h264_fd = NULL;
} g_myListener;

void setListener(baidurtc::BaiduRtcRoomClient *c,myListener &l)
{
    c->registerRtcMessageListener(&l);

    IVideoFrameObserver* iVfo[2];
    iVfo[0] = &l;
    c->registerVideoFrameObserver(iVfo,1);

    IAudioFrameObserver* iAfo[2];
    iAfo[0] = &l;
    c->registerAudioFrameObserver(iAfo,1);

    IDataFrameObserver* iDfo[2];
    iDfo[0] = &l;
    c->registerDataFrameObserver(iDfo,1);
}

typedef baidurtc::BaiduRtcRoomClient* f_createBaiduRtcRoomClient();
typedef const char* f_getVersion();

static void* gBRTCHandle = NULL;

int BRTC_Start(const char* appid, const char* roomname, const char* uid, const char* displayname,
               const char* token, const char* feedid, const char* brtcserverURL, const char* cerfile,
               bool hasdatachannel, bool dha_withvideo, int output_sample_rate) {

    if (gBRTCHandle == NULL) {
        gBRTCHandle = dlopen("libbaidurtc.so", RTLD_LAZY | RTLD_DEEPBIND);
        if (gBRTCHandle == NULL) {
            fprintf(stderr, "Could not open sdk: %s\n", dlerror());
            return 1;
        }
    }

    f_createBaiduRtcRoomClient* createClient = (f_createBaiduRtcRoomClient *)dlsym(gBRTCHandle, "_ZN8baidurtc24createBaiduRtcRoomClientEv");
    if (createClient == NULL) {
        fprintf(stderr, "Could not find sdk_func: %s\n", dlerror());
        return 1;
    }
    f_getVersion *version = (f_getVersion*)dlsym(gBRTCHandle, "getBaiduRtcSdkVersion");

    printf("BRTC.Linux.SDK Version is: %s\n",version());

    g_BrtcClient = createClient();
    setListener(g_BrtcClient, g_myListener);

    s.HasData = hasdatachannel;
    s.HasVideo = dha_withvideo;
    s.HasAudio = true;
    s.AudioOUTChannel = 1;
    s.AudioOUTFrequency = output_sample_rate;
    s.AsPublisher = false;
    s.AsListener = true;
    s.AutoSubscribe = true;

    g_BrtcClient->setParamSettings(&s,s.RTC_PARAM_SETTINGS_ALL);
    g_BrtcClient->setAppID(appid);
    g_BrtcClient->setMediaServerURL(brtcserverURL);
    g_BrtcClient->setCER(cerfile);
    g_BrtcClient->setFeedId(feedid);
    g_BrtcClient->loginRoom(roomname,uid,displayname,token);
    return 0;
}

int BRTC_Stop() {
    g_BrtcClient->logoutRoom();
    printf("logoutRoom OK.\n");
    g_BrtcClient->Destory();
    g_BrtcClient = nullptr;
    printf("Destory OK.\n");
}

int main_brtcdha(int argc, char* argv[])
{
	printf("BRTCDHA: Version: V2.0.3\n");
	{
		std::string Str;
		for (int i = 0; i < argc; i++)
		{
			Str += std::string(argv[i]) + " ";
		}
		printf("CmdLine: %s \n", Str.c_str());
	}

	signal(SIGTERM, brtcdha_sighandler);
	signal(SIGINT,  brtcdha_sighandler);

    ParseParameters(argc,argv);

    if (PARAM_DHA != "NULL") {
        g_myListener.dha = BRTCDHAClient::getNewBRTCDHAClient(PARAM_DHA,PARAM_ROOMNAME);
    }

    BRTC_Start(PARAM_APPID.c_str(), PARAM_ROOMNAME.c_str(), PARAM_UID.c_str(), "BRTC Linux SDK brtcdha demo",
               PARAM_TOKEN.c_str(), PARAM_FEEDID.c_str(), PARAM_RTC.c_str(), PARAM_CER.c_str(),
               PARAM_Has_DATACHANNEL, PARAM_Has_DHA_WITH_VIDEO, PARAM_DHA_AUDIO_OUT_SAMPLE_RATE);

	while (true) {
		printf("**********BaiDuRTC brtcdha demo V0.0.3 *********\n");
		printf("Please input q to Quit.\n");
		char commandid[512];
        memset(commandid,0,sizeof(commandid));
		int ret = scanf("%s", commandid);
		printf("scanf %d.\n", ret);

		if (ret < 0) {
			std::this_thread::sleep_for(std::chrono::milliseconds(20000));
			continue;
		}

		if (commandid[0] == 'q') break;
    }

    BRTC_Stop();
    return 0;
}

int main(int argc, char* argv[]) 
{
    int res = 0;

    res = main_brtcdha(argc, argv);

    return res;
}