/*
 *
 * Copyright 2015 gRPC authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include <iostream>
#include <memory>
#include <string>

#include <grpc++/grpc++.h>

#include "brtcdha.grpc.pb.h"

#define __SHOW_MEMBERS__
using grpc::ClientContext;
#include "brtcdha_client.h"

using grpc::Channel;
using grpc::ClientContext;
using grpc::Status;

BRTCDHAClient::BRTCDHAClient(const std::string& DHAURL, const std::string& RoomName)
{
			std::cout << "BRTCDHAClient 1: " << std::endl;
  stub_ = DigitalHumanAgentService::NewStub(grpc::CreateChannel(
    DHAURL, grpc::InsecureChannelCredentials()));
			std::cout << "BRTCDHAClient 2: " << std::endl;

  mContext.AddMetadata("room_name", RoomName);
  mImageContext.AddMetadata("room_name", RoomName);
  mDataContext.AddMetadata("room_name", RoomName);

  // The actual RPC.
  stream_ = stub_->audio(&mContext);
  			std::cout << "BRTCDHAClient 3: " << std::endl;
  // The actual RPC.
  image_stream_ = stub_->image(&mImageContext);
  			std::cout << "BRTCDHAClient 4: " << std::endl;

  data_stream_ = stub_->data(&mDataContext);
  			std::cout << "BRTCDHAClient 5: " << std::endl;
}

  // Assembles the client's payload, sends it and presents the response back
  // from the server.
std::string BRTCDHAClient::send_audio(const std::string& audio_data){

  // Context for the client. It could be used to convey extra information to
  // the server and/or tweak certain RPC behaviors.
  // ClientContext context;

    mBuffer10Count += audio_data;

    if(mBuffer10Count.length() >= 2* audio_data.length()) {
      mAudio.set_audio(mBuffer10Count);
      stream_->Write(mAudio);
      mBuffer10Count="";
    }

    return "OK";
}

std::string BRTCDHAClient::send_image(const std::string& video_data)
{ 
  mImage.set_image(video_data);
  image_stream_->Write(mImage);
  return "OK";
}

std::string BRTCDHAClient::send_data(const std::string& text_data)
{ 
  if (data_stream_.get() != nullptr) {
    mData.set_data(text_data);
    data_stream_->Write(mData);
  } else {
    std::cout << "BRTCDHAClient send_data error: data_stream == nullptr." << std::endl;
  }
  return "OK";
}

BRTCDHAClient *BRTCDHAClient::getNewBRTCDHAClient(const std::string& DHAURL, const std::string& RoomName)
{
   gGlobalBRTCDHAClient = new BRTCDHAClient(DHAURL,RoomName);
   return gGlobalBRTCDHAClient;
}

BRTCDHAClient *BRTCDHAClient::gGlobalBRTCDHAClient = NULL;

BRTCDHAClient *BRTCDHAClient::getGlobalBRTCDHAClient()
{
   return gGlobalBRTCDHAClient;
}

void BRTCDHAClient::Detete()
{
   gGlobalBRTCDHAClient = NULL;
   std::cout << "BRTCDHAClient Detete 1: " << std::endl;
   stream_->WritesDone();
   image_stream_->WritesDone();

   if (data_stream_.get() != nullptr) {
     data_stream_->WritesDone();
   }
   std::cout << "BRTCDHAClient Detete 2: WritesDone end." << std::endl;
   //  stream_->Finish();
   std::cout << "BRTCDHAClient Detete 3: Finish will be blocked, so skip it." << std::endl;
   delete this;
}