#include <dlfcn.h>
#include <stdio.h>
#include <stdlib.h>
#include <thread>
#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include <cstring>
#include <inttypes.h>

#include "include/BaiduRtcInterface.h"

#ifndef PRId64
#define PRId64 "lld"
#endif

#ifndef RTLD_DEEPBIND
#define RTLD_DEEPBIND 0
#endif

const char* Help =
"\
videocall_demo\n\
Copyright 2021 Baidu.com, Inc. All Rights Reserved.\n\
\n\
Usage:\n\
    ./videocall_demo $(APPID_GET_FROM_BAIDU)\n\
\n\
";

baidurtc::BaiduRtcRoomClient *g_brtc_client = nullptr;
volatile bool g_stop_flag = false;

int64_t CurrentTimeMillis()
{
    int64_t timems = std::chrono::duration_cast<std::chrono::milliseconds>(
            std::chrono::system_clock::now().time_since_epoch()
        ).count();
    return timems;
}

class MyListener :public IRtcMessageListener,
                public IAudioFrameObserver,
                public IVideoFrameObserver,
                public IDataFrameObserver
 {
    void OnRtcMessage(RtcMessage &msg) override 
    {
        printf("========================myListener got Message: %d.==========================\n", msg.msgType);
        switch (msg.msgType)
        {
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_REMOTE_COMING:
            {
                printf("Feed Coming %" PRId64 ", Name: %s.\n",msg.data.feedId,msg.extra_info);
            }
            break;
        case RtcMessageType::RTC_MESSAGE_ROOM_EVENT_REMOTE_LEAVING:
            {
                printf("Feed Leaving %" PRId64 ".\n",msg.data.feedId);
            }
            break;
        case RtcMessageType::RTC_MESSAGE_STATE_STREAM_UP:
            {
                printf("stream up, feedid/id : %" PRId64 " send video/audio now.\n", msg.data.feedId);
            }
            break;
        default:
            break;
        }
    }

    void onFrame(int64_t feedid, const char *img,  int len,  RtcImageType imgtype, int width, int height) override 
    {
        printf("got VideoData feed %" PRId64 ", data len = %d.\n",feedid, len);
    }
    void onAudioData(int64_t feedid, const char *audio, int len, int samlplerate, int channels) override 
    {
        printf("got AudioData feed %" PRId64 ", data len = %d.\n",feedid, len);
    }
    void onTextData(int64_t feedid, const char *data, int len) override
    {
        std::string msg(data,len);
        printf("got TextData feed %" PRId64 ", data len = %d, text: %s.\n",feedid, len, msg.c_str());
    }
} g_myListener;

void setListener(baidurtc::BaiduRtcRoomClient *c,MyListener &l)
{
    c->registerRtcMessageListener(&l);

    IVideoFrameObserver* iVfo[2];
    iVfo[0] = &l;
    c->registerVideoFrameObserver(iVfo,1);

    IAudioFrameObserver* iAfo[2];
    iAfo[0] = &l;
    c->registerAudioFrameObserver(iAfo,1);

    IDataFrameObserver* iDfo[2];
    iDfo[0] = &l;
    c->registerDataFrameObserver(iDfo,1);
}

typedef baidurtc::BaiduRtcRoomClient* f_createBaiduRtcRoomClient();
typedef const char* f_getVersion();
typedef void f_enableLog(int e);

int main_videocall(int argc, char* argv[])
{
    if (argc < 2)
    {
        printf("%s", Help);
        return false;
    }

    void* handle = dlopen("libbaidurtc.so", RTLD_LAZY | RTLD_DEEPBIND);
    if (handle == NULL) {
        fprintf(stderr, "Could not open sdk: %s\n", dlerror());
        return 1;
    }
    f_createBaiduRtcRoomClient* createClient = (f_createBaiduRtcRoomClient *)dlsym(handle, "_ZN8baidurtc24createBaiduRtcRoomClientEv");
    if (createClient == NULL) {
        fprintf(stderr, "Could not find sdk_func: %s\n", dlerror());
        return 1;
    }
    f_getVersion *version = (f_getVersion*)dlsym(handle, "getBaiduRtcSdkVersion");
    f_enableLog *enableLog = (f_enableLog*)dlsym(handle, "enableBaiduRtcLog");
    if (enableLog) {
        enableLog(0); // set 0 to disable logs.
    }

    printf("BRTC SDK Version is: %s\n",version());

    printf("Calling API\n");

    RtcParameterSettings s;

    g_brtc_client = createClient();
    setListener(g_brtc_client, g_myListener);

    s.HasData = false;
    s.HasVideo = true;
    s.HasAudio = true;
    s.AudioINChannel = 1;
    s.AudioINFrequency = 16000;
    s.ImageINType = RTC_IMAGE_TYPE_H264;
    s.AsPublisher = true;
    s.AsListener = true;
    s.AutoPublish = true;

    g_brtc_client->setParamSettings(&s,s.RTC_PARAM_SETTINGS_ALL);
    g_brtc_client->setAppID(argv[1]/*$(APPID_GET_FROM_BAIDU)*/);
    g_brtc_client->setMediaServerURL(argc > 2 ? argv[2] : "wss://rtc.exp.bcelive.com/janus");
    g_brtc_client->setCER("../bin/a.cer");
    // g_BrtcClient->setVideoCodec("h264");

    std::string uid;
    std::ostringstream os;
    os << 1234500000 + rand()/100000;
    uid =  os.str();

    g_brtc_client->loginRoom("2131",uid.c_str(),"BRTC SDK videocall demo","token");

    while (true) {
        printf("**********BaiDuRTC videocall demo V0.0.1 *********\n");
        printf("Please input s to start push video;\n");
        printf("Please input q to Quit.\n\n");
        char commandid[512];
        memset(commandid,0,sizeof(commandid));
        int ret = scanf("%s", commandid);
        printf("scanf %d.\n", ret);

        if (ret < 0) {
            std::this_thread::sleep_for(std::chrono::milliseconds(20000));
            continue;
        }

        switch (commandid[0])
        {
            case 's':
                g_stop_flag = false;
                std::thread([]()
                {
                    std::fstream  fs("./myvideo.h264");
                    std::stringstream  ss;

                    ss << fs.rdbuf();
                    printf("h264.length(): %ld\n", ss.str().length());
                    int t_len = ss.str().length();
                    unsigned char* buf = new unsigned char[t_len];
                    unsigned char* frame = new unsigned char[1024 * 64];
                    memcpy(buf, ss.str().data(), t_len);
                    int packet_len = 1400;
                    int j = 0;
                    int cur = 0;
                    int nal_len = 0;

                    auto get_next_nalu = [&]() {
                        if (cur == t_len) {
                            cur = 0;
                        }
                        int i = cur;
                        if (buf[cur] == 0x00 && buf[cur + 1] == 0x00 && buf[cur + 2] == 0x00 && buf[cur + 3] == 0x01) {
                            i = cur + 4;
                            // printf("found 0x0000 0001, cur = %d, i = %d\n", cur, i);
                        }
                        else if (buf[cur] == 0x00 && buf[cur + 1] == 0x00 && buf[cur + 2] == 0x01) {
                            i = cur + 3;
                            // printf("found 0x0000 01, cur = %d, i = %d\n", cur, i);
                        }
                        bool found_hd = false;
                        while (i < t_len - 4) {
                            if (buf[i] == 0x00 && buf[i + 1] == 0x00 &&
                                ((buf[i + 2] == 0x00 && buf[i + 3] == 0x01) || buf[i + 2] == 0x01) ) {
                                if (i - cur < 40 ) { // SPS, PPS should send with I frame.
                                    i++;
                                    continue;
                                }
                                found_hd = true;
                                nal_len = i - cur;
                                // printf("found nexe header, cur = %d, i = %d, len = %d\n", cur, i, nal_len);
                                // printf("next-h: %d, %2X %2X %2X %2X %2X %2X %2X\n", i, buf[i-4], buf[i-3], buf[i-2], buf[i-1], buf[i+3], buf[i+4], buf[i+5]);
                                break;
                            }
                            ++i;
                        }
                        if (!found_hd) {
                            nal_len = t_len - cur;
                            // printf("not found nexe header, cur = %d, i = %d, len = %d\n", cur, i, nal_len);
                        }
                    };

                    auto pre_send_time = std::chrono::system_clock::now();
                    for (int i=0; i < 2000000; i++) { //need streaming control.
                        get_next_nalu();
                        if (cur == 0 ) {
                            // printf("shs video loop time %lld----------> pushing h264 index: %d , cur: %d,  nal_len: %d\n", CurrentTimeMillis(), i, cur, nal_len);
                        }

                        g_brtc_client->sendImage((const char *)buf + cur,nal_len);

                        cur += nal_len;
                        std::this_thread::sleep_until(pre_send_time + ((i+1) * std::chrono::milliseconds(40)));
                        if (g_stop_flag) break;
                    }
                    delete[] buf;
                    delete[] frame;
                }).detach();

                std::thread([]()
                {
                    std::fstream  fs("./mypcm.raw");
                    std::stringstream  ss;

                    ss << fs.rdbuf();
                    std::cout << "pcm.length(): "<< ss.str().length() << std::endl;
                    int t_len = ss.str().length();
                    int packet_len = (16000/100) *2*4;
                    int j = 0;

                    auto pre_send_time = std::chrono::system_clock::now();
                    for (int i=0; i < 2000000; i++) { //need streaming control.

                        g_brtc_client->sendAudio(&ss.str()[j],packet_len);
                        std::this_thread::sleep_until(pre_send_time + ((i+1) * std::chrono::milliseconds(40)));
                        if (g_stop_flag) break;

                        j += packet_len;
                        if (j + packet_len > t_len)
                        {
                            j = 0;
                            // printf("loop audio time %lld. \n", CurrentTimeMillis());
                        }
                    }
                }).detach();
                break;
        }

        if (commandid[0] == 'q') break;
    }

    g_stop_flag = true;
    std::this_thread::sleep_for(std::chrono::milliseconds(100));
    g_brtc_client->logoutRoom();
    printf("logoutRoom OK.\n");
    g_brtc_client->Destory();
    g_brtc_client = nullptr;
    printf("Destory OK.\n");

    printf("API returned %d\n", 123);
    if (dlclose(handle) != 0) {
        fprintf(stderr, "Could not close plugin: %s\n", dlerror());
        return 1;
    }
    return 0;
}

int main(int argc, char* argv[]) 
{
    int res = 0;

    res = main_videocall(argc, argv);

    return res;
}